/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.api;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0004H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Ltech/carpentum/sdk/payment/internal/api/ApiUtils;", "", "()V", "basicLogger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "bodyLogger", "enableBasic", "", "enableBody", "enableHeaders", "headersLogger", "loggerName", "loggingInterceptor", "Lokhttp3/logging/HttpLoggingInterceptor;", "noneLogger", "getClient", "Lokhttp3/OkHttpClient;", "callTimeout", "Ljava/time/Duration;", "getLevel", "Lokhttp3/logging/HttpLoggingInterceptor$Level;", "getLogger", "HttpLogger", "payment-client-v2"})
public final class ApiUtils {
    @NotNull
    public static final ApiUtils INSTANCE = new ApiUtils();
    @NotNull
    private static final String loggerName = "tech.carpentum.sdk.payment.api";
    private static final Logger noneLogger = LoggerFactory.getLogger((String)"tech.carpentum.sdk.payment.api");
    @NotNull
    private static final String enableBasic = "tech.carpentum.sdk.payment.api.basic";
    private static final Logger basicLogger = LoggerFactory.getLogger((String)"tech.carpentum.sdk.payment.api.basic");
    @NotNull
    private static final String enableHeaders = "tech.carpentum.sdk.payment.api.headers";
    private static final Logger headersLogger = LoggerFactory.getLogger((String)"tech.carpentum.sdk.payment.api.headers");
    @NotNull
    private static final String enableBody = "tech.carpentum.sdk.payment.api.body";
    private static final Logger bodyLogger = LoggerFactory.getLogger((String)"tech.carpentum.sdk.payment.api.body");
    @NotNull
    private static final HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor((HttpLoggingInterceptor.Logger)new HttpLogger(INSTANCE.getLogger()));

    private ApiUtils() {
    }

    @NotNull
    public final OkHttpClient getClient(@NotNull Duration callTimeout) {
        Intrinsics.checkNotNullParameter((Object)callTimeout, (String)"callTimeout");
        OkHttpClient.Builder builder = new OkHttpClient.Builder().addInterceptor((Interceptor)loggingInterceptor).connectTimeout(callTimeout).readTimeout(callTimeout).writeTimeout(callTimeout).callTimeout(callTimeout);
        return builder.build();
    }

    private final Logger getLogger() {
        Logger logger;
        if (bodyLogger.isTraceEnabled()) {
            Logger logger2 = bodyLogger;
            logger = logger2;
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"bodyLogger");
        } else if (headersLogger.isTraceEnabled()) {
            Logger logger3 = headersLogger;
            logger = logger3;
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"headersLogger");
        } else if (basicLogger.isTraceEnabled()) {
            Logger logger4 = basicLogger;
            logger = logger4;
            Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"basicLogger");
        } else {
            Logger logger5 = noneLogger;
            logger = logger5;
            Intrinsics.checkNotNullExpressionValue((Object)logger5, (String)"noneLogger");
        }
        return logger;
    }

    private final HttpLoggingInterceptor.Level getLevel() {
        return bodyLogger.isTraceEnabled() ? HttpLoggingInterceptor.Level.BODY : (headersLogger.isTraceEnabled() ? HttpLoggingInterceptor.Level.HEADERS : (basicLogger.isTraceEnabled() ? HttpLoggingInterceptor.Level.BASIC : HttpLoggingInterceptor.Level.NONE));
    }

    static {
        loggingInterceptor.setLevel(INSTANCE.getLevel());
        loggingInterceptor.redactHeader("Authorization");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ltech/carpentum/sdk/payment/internal/api/ApiUtils$HttpLogger;", "Lokhttp3/logging/HttpLoggingInterceptor$Logger;", "logger", "Lorg/slf4j/Logger;", "(Lorg/slf4j/Logger;)V", "log", "", "message", "", "payment-client-v2"})
    public static final class HttpLogger
    implements HttpLoggingInterceptor.Logger {
        @NotNull
        private final Logger logger;

        public HttpLogger(@NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.logger = logger;
        }

        public void log(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.logger.trace(message);
        }
    }
}

