/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.OfflineMethodResponseImpl;
import tech.carpentum.sdk.payment.model.AccountResponseOffline;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.MoneyRequired;
import tech.carpentum.sdk.payment.model.MoneyVat;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.PaymentOperatorIncoming;
import tech.carpentum.sdk.payment.model.PaymentProcessor;

@JsonClass(generateAdapter=false)
public interface OfflineMethodResponse
extends PayinMethodResponse {
    public static final PayinMethodResponse.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethodResponse.PaymentMethodCode.OFFLINE;

    @NotNull
    public IdPayin getIdPayin();

    @NotNull
    public IdPayment getIdPayment();

    @NotNull
    public AccountResponseOffline getAccount();

    @NotNull
    public Money getMoney();

    @NotNull
    public Optional<MoneyRequired> getMoneyRequired();

    @NotNull
    public Optional<MoneyVat> getVat();

    @NotNull
    public String getReference();

    @NotNull
    public Optional<PaymentProcessor> getProcessor();

    @NotNull
    public Optional<String> getQrName();

    @NotNull
    public Optional<String> getQrCode();

    @NotNull
    public String getReturnUrl();

    @NotNull
    public Optional<PaymentOperatorIncoming> getPaymentOperator();

    @NotNull
    public OffsetDateTime getAcceptedAt();

    @NotNull
    public OffsetDateTime getExpireAt();

    @NotNull
    public static Builder builder(OfflineMethodResponse copyOf) {
        Builder builder = OfflineMethodResponse.builder();
        builder.idPayin(copyOf.getIdPayin());
        builder.idPayment(copyOf.getIdPayment());
        builder.account(copyOf.getAccount());
        builder.money(copyOf.getMoney());
        builder.moneyRequired(copyOf.getMoneyRequired().orElse(null));
        builder.vat(copyOf.getVat().orElse(null));
        builder.reference(copyOf.getReference());
        builder.processor(copyOf.getProcessor().orElse(null));
        builder.qrName(copyOf.getQrName().orElse(null));
        builder.qrCode(copyOf.getQrCode().orElse(null));
        builder.returnUrl(copyOf.getReturnUrl());
        builder.paymentOperator(copyOf.getPaymentOperator().orElse(null));
        builder.acceptedAt(copyOf.getAcceptedAt());
        builder.expireAt(copyOf.getExpireAt());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new OfflineMethodResponseImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder idPayin(IdPayin var1);

        @NotNull
        public Builder idPayment(IdPayment var1);

        @NotNull
        public Builder account(AccountResponseOffline var1);

        @NotNull
        public Builder money(Money var1);

        @NotNull
        public Builder moneyRequired(MoneyRequired var1);

        @NotNull
        public Builder vat(MoneyVat var1);

        @NotNull
        public Builder reference(String var1);

        @NotNull
        public Builder processor(PaymentProcessor var1);

        @NotNull
        public Builder qrName(String var1);

        @NotNull
        public Builder qrCode(String var1);

        @NotNull
        public Builder returnUrl(String var1);

        @NotNull
        public Builder paymentOperator(PaymentOperatorIncoming var1);

        @NotNull
        public Builder acceptedAt(OffsetDateTime var1);

        @NotNull
        public Builder expireAt(OffsetDateTime var1);

        @NotNull
        public OfflineMethodResponse build();
    }
}

