/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.hivemind.impl.MessageFormatter;
import org.apache.hivemind.service.ClassFabUtils;

class AnnotationMessages {
    private static final MessageFormatter _formatter = new MessageFormatter(AnnotationMessages.class);

    AnnotationMessages() {
    }

    static String noParametersExpected(Method m) {
        return _formatter.format("no-parameters-expected", (Object)m);
    }

    static String notAccessor(Method method) {
        return _formatter.format("no-accessor", (Object)method);
    }

    static String voidAccessor(Method method) {
        return _formatter.format("void-accessor", (Object)method);
    }

    static String nonVoidMutator(Method method) {
        return _formatter.format("non-void-mutator", (Object)method);
    }

    static String wrongParameterCount(Method method) {
        return _formatter.format("wrong-parameter-count", (Object)method);
    }

    static String failureProcessingAnnotation(Annotation annotation, Method method, Throwable cause) {
        return _formatter.format("failure-processing-annotation", (Object)annotation, (Object)method, (Object)cause);
    }

    static String failureProcessingClassAnnotation(Annotation annotation, Class clazz, Throwable cause) {
        return _formatter.format("failure-processing-class-annotation", (Object)annotation, (Object)clazz.getName(), (Object)cause);
    }

    static String returnStringOnly(Class returnType) {
        return _formatter.format("return-string-only", (Object)ClassFabUtils.getJavaClassName((Class)returnType));
    }

    static String bindingWrongFormat(String binding) {
        return _formatter.format("binding-wrong-format", (Object)binding);
    }

    static String methodAnnotation(Annotation annotation, Method method) {
        return _formatter.format("method-annotation", (Object)annotation, (Object)method);
    }

    static String classAnnotation(Annotation annotation, Class clazz) {
        return _formatter.format("class-annotation", (Object)annotation, (Object)clazz.getName());
    }
}

