/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.measure.format.UnitFormat;
import javax.measure.spi.UnitFormatService;
import systems.uom.ucum.format.UCUMFormat;

final class UCUMFormatService
implements UnitFormatService {
    private static final String DEFAULT_FORMAT = UCUMFormat.Variant.CASE_SENSITIVE.name();
    private final Map<String, UnitFormat> formats = new HashMap<String, UnitFormat>();
    private final Map<String, String> aliases = new HashMap<String, String>();

    UCUMFormatService() {
        this.formats.put(DEFAULT_FORMAT, (UnitFormat)UCUMFormat.getInstance(UCUMFormat.Variant.CASE_SENSITIVE));
        this.formats.put(UCUMFormat.Variant.CASE_INSENSITIVE.name(), (UnitFormat)UCUMFormat.getInstance(UCUMFormat.Variant.CASE_INSENSITIVE));
        this.formats.put(UCUMFormat.Variant.PRINT.name(), (UnitFormat)UCUMFormat.getInstance(UCUMFormat.Variant.PRINT));
        this.aliases.put("UCUM", DEFAULT_FORMAT);
        this.aliases.put("CS", DEFAULT_FORMAT);
        this.aliases.put("C/S", DEFAULT_FORMAT);
        this.aliases.put("CASE SENSITIVE", DEFAULT_FORMAT);
        this.aliases.put("CI", UCUMFormat.Variant.CASE_INSENSITIVE.name());
        this.aliases.put("C/I", UCUMFormat.Variant.CASE_INSENSITIVE.name());
        this.aliases.put("CASE INSENSITIVE", DEFAULT_FORMAT);
    }

    public UnitFormat getUnitFormat(String key) {
        Objects.requireNonNull(key, "Format name or alias required");
        String alias = this.aliases.get(key.toUpperCase());
        if (alias != null && alias.length() > 0) {
            return this.formats.get(alias);
        }
        return this.formats.get(key.toUpperCase());
    }

    public UnitFormat getUnitFormat() {
        return this.getUnitFormat(DEFAULT_FORMAT);
    }

    public Set<String> getAvailableFormatNames() {
        return this.formats.keySet();
    }
}

