/*
 * Decompiled with CFR 0.152.
 */
package systems.uom.ucum.internal.format;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import systems.uom.ucum.internal.format.Token;
import systems.uom.ucum.internal.format.TokenException;
import systems.uom.ucum.internal.format.UCUMCharStream;
import systems.uom.ucum.internal.format.UnitTokenConstants;
import systems.uom.ucum.internal.format.UnitTokenManager;
import tec.uom.se.AbstractUnit;
import tec.uom.se.format.SymbolMap;
import tec.uom.se.function.LogConverter;
import tec.uom.se.unit.MetricPrefix;

public final class UnitFormatParser {
    private SymbolMap symbols;
    public UnitTokenManager tokenSource;
    UCUMCharStream inputStream;
    public Token token;
    public Token nextToken;
    private int nextTokenIndex;
    private Token scanpos;
    private Token lastpos;
    private int laInt;
    private int genInt;
    private final int[] laA = new int[19];
    private static int[] laB;
    private final JJCalls[] rtns = new JJCalls[2];
    private boolean rescan = false;
    private int gcInt = 0;
    private List<int[]> expentries = new ArrayList<int[]>();
    private int[] expentry;
    private int kind = -1;
    private int[] lastTokens = new int[100];
    private int endpos;

    static {
        UnitFormatParser.init();
    }

    public UnitFormatParser(SymbolMap symbols, Reader in) {
        this(in);
        this.symbols = symbols;
    }

    public final Unit parseUnit() throws TokenException {
        Unit result = this.CompoundExpr();
        this.consumeToken(0);
        return result;
    }

    public final Unit CompoundExpr() throws TokenException {
        throw new UnsupportedOperationException("Compound units not supported");
    }

    public final Unit AddExpr() throws TokenException {
        Unit result = AbstractUnit.ONE;
        Number n1 = null;
        Token sign1 = null;
        Number n2 = null;
        Token sign2 = null;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            n1 = this.NumberExpr();
            sign1 = this.Sign();
        }
        result = this.MulExpr();
        switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
            case 5: 
            case 6: {
                sign2 = this.Sign();
                n2 = this.NumberExpr();
                break;
            }
            default: {
                this.laA[1] = this.genInt;
            }
        }
        if (n1 != null) {
            if (sign1.image.equals("-")) {
                result = result.multiply(-1.0);
            }
            result = result.shift(n1.doubleValue());
        }
        if (n2 != null) {
            double offset = n2.doubleValue();
            if (sign2.image.equals("-")) {
                offset = -offset;
            }
            result = result.shift(offset);
        }
        return result;
    }

    public final Unit MulExpr() throws TokenException {
        Unit result;
        block12: {
            result = AbstractUnit.ONE;
            Unit temp = AbstractUnit.ONE;
            result = this.ExponentExpr();
            block11: while (true) {
                switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                    case 7: 
                    case 8: 
                    case 9: {
                        break;
                    }
                    default: {
                        this.laA[2] = this.genInt;
                        break block12;
                    }
                }
                switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                    case 7: 
                    case 8: {
                        switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                            case 7: {
                                this.consumeToken(7);
                                break;
                            }
                            case 8: {
                                this.consumeToken(8);
                                break;
                            }
                            default: {
                                this.laA[3] = this.genInt;
                                this.consumeToken(-1);
                                throw new TokenException();
                            }
                        }
                        temp = this.ExponentExpr();
                        result = result.multiply(temp);
                        continue block11;
                    }
                    case 9: {
                        this.consumeToken(9);
                        temp = this.ExponentExpr();
                        result = result.divide(temp);
                        continue block11;
                    }
                }
                break;
            }
            this.laA[4] = this.genInt;
            this.consumeToken(-1);
            throw new TokenException();
        }
        return result;
    }

    public final Unit ExponentExpr() throws TokenException {
        Unit result = AbstractUnit.ONE;
        Exponent exponent = null;
        Token token = null;
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                case 14: {
                    token = this.consumeToken(14);
                    break;
                }
                case 19: {
                    token = this.consumeToken(19);
                    break;
                }
                default: {
                    this.laA[5] = this.genInt;
                    this.consumeToken(-1);
                    throw new TokenException();
                }
            }
            this.consumeToken(10);
            result = this.AtomicExpr();
            double base = token.kind == 14 ? (double)Integer.parseInt(token.image) : Math.E;
            return result.transform((UnitConverter)new LogConverter(base).inverse());
        }
        switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
            case 12: 
            case 14: 
            case 16: 
            case 20: {
                result = this.AtomicExpr();
                switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                    case 10: 
                    case 15: {
                        exponent = this.Exp();
                        break;
                    }
                    default: {
                        this.laA[6] = this.genInt;
                    }
                }
                if (exponent != null) {
                    if (exponent.pow != 1) {
                        result = result.pow(exponent.pow);
                    }
                    if (exponent.root != 1) {
                        result = result.root(exponent.root);
                    }
                }
                return result;
            }
            case 17: 
            case 18: {
                block11 : switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                    case 17: {
                        this.consumeToken(17);
                        switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                            case 14: {
                                token = this.consumeToken(14);
                                break block11;
                            }
                        }
                        this.laA[7] = this.genInt;
                        break;
                    }
                    case 18: {
                        token = this.consumeToken(18);
                        break;
                    }
                    default: {
                        this.laA[8] = this.genInt;
                        this.consumeToken(-1);
                        throw new TokenException();
                    }
                }
                this.consumeToken(12);
                result = this.AddExpr();
                this.consumeToken(13);
                double base = 10.0;
                if (token != null) {
                    if (token.kind == 14) {
                        base = Integer.parseInt(token.image);
                    } else if (token.kind == 18) {
                        base = Math.E;
                    }
                }
                return result.transform((UnitConverter)new LogConverter(base));
            }
        }
        this.laA[9] = this.genInt;
        this.consumeToken(-1);
        throw new TokenException();
    }

    public final Unit AtomicExpr() throws TokenException {
        Unit result = AbstractUnit.ONE;
        Number n = null;
        Token token = null;
        switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
            case 14: 
            case 16: {
                n = this.NumberExpr();
                if (n instanceof Integer) {
                    return result.multiply((double)n.intValue());
                }
                return result.multiply(n.doubleValue());
            }
            case 20: {
                token = this.consumeToken(20);
                Unit unit = this.symbols.getUnit(token.image);
                if (unit == null) {
                    String prefixSymbol;
                    MetricPrefix prefix = this.symbols.getPrefix(token.image);
                    if (prefix != null && (unit = this.symbols.getUnit(token.image.substring((prefixSymbol = this.symbols.getSymbol(prefix)).length()))) != null) {
                        return unit.transform(prefix.getConverter());
                    }
                    throw new TokenException();
                }
                return unit;
            }
            case 12: {
                this.consumeToken(12);
                result = this.AddExpr();
                this.consumeToken(13);
                return result;
            }
        }
        this.laA[10] = this.genInt;
        this.consumeToken(-1);
        throw new TokenException();
    }

    public final Token Sign() throws TokenException {
        Token result = null;
        switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
            case 5: {
                result = this.consumeToken(5);
                break;
            }
            case 6: {
                result = this.consumeToken(6);
                break;
            }
            default: {
                this.laA[11] = this.genInt;
                this.consumeToken(-1);
                throw new TokenException();
            }
        }
        return result;
    }

    public final Number NumberExpr() throws TokenException {
        Token token = null;
        switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
            case 14: {
                token = this.consumeToken(14);
                return Long.valueOf(token.image);
            }
            case 16: {
                token = this.consumeToken(16);
                return Double.valueOf(token.image);
            }
        }
        this.laA[12] = this.genInt;
        this.consumeToken(-1);
        throw new TokenException();
    }

    public final Exponent Exp() throws TokenException {
        Token powSign = null;
        Token powToken = null;
        Token rootSign = null;
        Token rootToken = null;
        switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
            case 10: {
                this.consumeToken(10);
                switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                    case 5: 
                    case 6: 
                    case 14: {
                        switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                            case 5: 
                            case 6: {
                                powSign = this.Sign();
                                break;
                            }
                            default: {
                                this.laA[13] = this.genInt;
                            }
                        }
                        powToken = this.consumeToken(14);
                        int pow = Integer.parseInt(powToken.image);
                        if (powSign != null && powSign.image.equals("-")) {
                            pow = -pow;
                        }
                        return new Exponent(pow, 1);
                    }
                    case 12: {
                        this.consumeToken(12);
                        switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                            case 5: 
                            case 6: {
                                powSign = this.Sign();
                                break;
                            }
                            default: {
                                this.laA[14] = this.genInt;
                            }
                        }
                        powToken = this.consumeToken(14);
                        switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                            case 9: {
                                this.consumeToken(9);
                                switch (this.nextTokenIndex == -1 ? this.jj_ntk() : this.nextTokenIndex) {
                                    case 5: 
                                    case 6: {
                                        rootSign = this.Sign();
                                        break;
                                    }
                                    default: {
                                        this.laA[15] = this.genInt;
                                    }
                                }
                                rootToken = this.consumeToken(14);
                                break;
                            }
                            default: {
                                this.laA[16] = this.genInt;
                            }
                        }
                        this.consumeToken(13);
                        int pow = Integer.parseInt(powToken.image);
                        if (powSign != null && powSign.image.equals("-")) {
                            pow = -pow;
                        }
                        int root = 1;
                        if (rootToken != null) {
                            root = Integer.parseInt(rootToken.image);
                            if (rootSign != null && rootSign.image.equals("-")) {
                                root = -root;
                            }
                        }
                        return new Exponent(pow, root);
                    }
                }
                this.laA[17] = this.genInt;
                this.consumeToken(-1);
                throw new TokenException();
            }
            case 15: {
                powToken = this.consumeToken(15);
                int pow = 0;
                int i = 0;
                while (i < powToken.image.length()) {
                    pow *= 10;
                    switch (powToken.image.charAt(i)) {
                        case '\u00b9': {
                            ++pow;
                            break;
                        }
                        case '\u00b2': {
                            pow += 2;
                            break;
                        }
                        case '\u00b3': {
                            pow += 3;
                            break;
                        }
                        case '\u2074': {
                            pow += 4;
                            break;
                        }
                        case '\u2075': {
                            pow += 5;
                            break;
                        }
                        case '\u2076': {
                            pow += 6;
                            break;
                        }
                        case '\u2077': {
                            pow += 7;
                            break;
                        }
                        case '\u2078': {
                            pow += 8;
                            break;
                        }
                        case '\u2079': {
                            pow += 9;
                        }
                    }
                    ++i;
                }
                return new Exponent(pow, 1);
            }
        }
        this.laA[18] = this.genInt;
        this.consumeToken(-1);
        throw new TokenException();
    }

    private boolean jj_2_1(int xla) {
        this.laInt = xla;
        this.lastpos = this.scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private boolean jj_2_2(int xla) {
        this.laInt = xla;
        this.lastpos = this.scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    private boolean jj_3R_3() {
        Token xsp = this.scanpos;
        if (this.jj_3R_5()) {
            this.scanpos = xsp;
            if (this.jj_3R_6()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_6() {
        return this.scanToken(16);
    }

    private boolean jj_3_2() {
        Token xsp = this.scanpos;
        if (this.scanToken(14)) {
            this.scanpos = xsp;
            if (this.scanToken(19)) {
                return true;
            }
        }
        return this.scanToken(10);
    }

    private boolean jj_3_1() {
        return this.jj_3R_3() || this.jj_3R_4();
    }

    private boolean jj_3R_4() {
        Token xsp = this.scanpos;
        if (this.scanToken(5)) {
            this.scanpos = xsp;
            if (this.scanToken(6)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_5() {
        return this.scanToken(14);
    }

    private static void init() {
        laB = new int[]{2048, 96, 896, 384, 896, 540672, 33792, 16384, 393216, 1527808, 0x115000, 96, 81920, 96, 96, 96, 512, 20576, 33792};
    }

    public UnitFormatParser(InputStream stream) {
        this(stream, null);
    }

    public UnitFormatParser(InputStream stream, String encoding) {
        try {
            this.inputStream = new UCUMCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.tokenSource = new UnitTokenManager(this.inputStream);
        this.token = new Token();
        this.nextTokenIndex = -1;
        this.genInt = 0;
        int i = 0;
        while (i < 19) {
            this.laA[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.rtns.length) {
            this.rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.inputStream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.tokenSource.ReInit(this.inputStream);
        this.token = new Token();
        this.nextTokenIndex = -1;
        this.genInt = 0;
        int i = 0;
        while (i < 19) {
            this.laA[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.rtns.length) {
            this.rtns[i] = new JJCalls();
            ++i;
        }
    }

    public UnitFormatParser(Reader stream) {
        this.inputStream = new UCUMCharStream(stream, 1, 1);
        this.tokenSource = new UnitTokenManager(this.inputStream);
        this.token = new Token();
        this.nextTokenIndex = -1;
        this.genInt = 0;
        int i = 0;
        while (i < 19) {
            this.laA[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.rtns.length) {
            this.rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.inputStream.ReInit(stream, 1, 1);
        this.tokenSource.ReInit(this.inputStream);
        this.token = new Token();
        this.nextTokenIndex = -1;
        this.genInt = 0;
        int i = 0;
        while (i < 19) {
            this.laA[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.rtns.length) {
            this.rtns[i] = new JJCalls();
            ++i;
        }
    }

    public UnitFormatParser(UnitTokenManager tm) {
        this.tokenSource = tm;
        this.token = new Token();
        this.nextTokenIndex = -1;
        this.genInt = 0;
        int i = 0;
        while (i < 19) {
            this.laA[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.rtns.length) {
            this.rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(UnitTokenManager tm) {
        this.tokenSource = tm;
        this.token = new Token();
        this.nextTokenIndex = -1;
        this.genInt = 0;
        int i = 0;
        while (i < 19) {
            this.laA[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.rtns.length) {
            this.rtns[i] = new JJCalls();
            ++i;
        }
    }

    private Token consumeToken(int kind) throws TokenException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.tokenSource.getNextToken());
        this.nextTokenIndex = -1;
        if (this.token.kind == kind) {
            ++this.genInt;
            if (++this.gcInt > 100) {
                this.gcInt = 0;
                JJCalls[] jJCallsArray = this.rtns;
                int n = this.rtns.length;
                int n2 = 0;
                while (n2 < n) {
                    JJCalls jj_2_rtn;
                    JJCalls c = jj_2_rtn = jJCallsArray[n2];
                    while (c != null) {
                        if (c.gen < this.genInt) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                    ++n2;
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.kind = kind;
        throw this.raiseTokenException();
    }

    private boolean scanToken(int kind) {
        if (this.scanpos == this.lastpos) {
            --this.laInt;
            if (this.scanpos.next == null) {
                this.scanpos = this.scanpos.next = this.tokenSource.getNextToken();
                this.lastpos = this.scanpos.next;
            } else {
                this.lastpos = this.scanpos = this.scanpos.next;
            }
        } else {
            this.scanpos = this.scanpos.next;
        }
        if (this.rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.scanpos.kind != kind) {
            return true;
        }
        if (this.laInt == 0 && this.scanpos == this.lastpos) {
            throw new LookaheadSuccess();
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.tokenSource.getNextToken());
        this.nextTokenIndex = -1;
        ++this.genInt;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.tokenSource.getNextToken());
            ++i;
        }
        return t;
    }

    private int jj_ntk() {
        this.nextToken = this.token.next;
        if (this.nextToken == null) {
            this.token.next = this.tokenSource.getNextToken();
            this.nextTokenIndex = this.token.next.kind;
            return this.nextTokenIndex;
        }
        this.nextTokenIndex = this.nextToken.kind;
        return this.nextTokenIndex;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.endpos + 1) {
            this.lastTokens[this.endpos++] = kind;
        } else if (this.endpos != 0) {
            this.expentry = new int[this.endpos];
            System.arraycopy(this.lastTokens, 0, this.expentry, 0, this.endpos);
            block0: for (int[] jj_expentry1 : this.expentries) {
                if (jj_expentry1.length != this.expentry.length) continue;
                int i = 0;
                while (i < this.expentry.length) {
                    if (jj_expentry1[i] != this.expentry[i]) continue block0;
                    ++i;
                }
                this.expentries.add(this.expentry);
                break;
            }
            if (pos != 0) {
                this.endpos = pos;
                this.lastTokens[this.endpos - 1] = kind;
            }
        }
    }

    TokenException raiseTokenException() {
        this.expentries.clear();
        boolean[] la1tokens = new boolean[21];
        if (this.kind >= 0) {
            la1tokens[this.kind] = true;
            this.kind = -1;
        }
        int i = 0;
        while (i < 19) {
            if (this.laA[i] == this.genInt) {
                int j = 0;
                while (j < 32) {
                    if ((laB[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 21) {
            if (la1tokens[i]) {
                this.expentry = new int[1];
                this.expentry[0] = i;
                this.expentries.add(this.expentry);
            }
            ++i;
        }
        this.endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.expentries.size()][];
        int i2 = 0;
        while (i2 < this.expentries.size()) {
            exptokseq[i2] = this.expentries.get(i2);
            ++i2;
        }
        return new TokenException(this.token, exptokseq, UnitTokenConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.rescan = true;
        int i = 0;
        while (i < 2) {
            try {
                JJCalls p = this.rtns[i];
                do {
                    if (p.gen <= this.genInt) continue;
                    this.laInt = p.arg;
                    this.lastpos = this.scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                        }
                    }
                } while ((p = p.next) != null);
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
            ++i;
        }
        this.rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.rtns[index];
        while (p.gen > this.genInt) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.genInt + xla - this.laInt;
        p.first = this.token;
        p.arg = xla;
    }

    private static class Exponent {
        public final int pow;
        public final int root;

        public Exponent(int pow, int root) {
            this.pow = pow;
            this.root = root;
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends RuntimeException {
        private static final long serialVersionUID = 2205332054119123041L;

        private LookaheadSuccess() {
        }
    }
}

