/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.workflowelement.localbackend;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.std.server.SynchronizationProviderCfg;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.api.SynchronizationProvider;
import org.opends.server.controls.LDAPAssertionRequestControl;
import org.opends.server.controls.LDAPPostReadRequestControl;
import org.opends.server.controls.LDAPPostReadResponseControl;
import org.opends.server.controls.LDAPPreReadRequestControl;
import org.opends.server.controls.LDAPPreReadResponseControl;
import org.opends.server.controls.PasswordPolicyErrorType;
import org.opends.server.controls.ProxiedAuthV1Control;
import org.opends.server.controls.ProxiedAuthV2Control;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.ModifyOperationWrapper;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.schema.BooleanSyntax;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.AcceptRejectWarn;
import org.opends.server.types.AccountStatusNotification;
import org.opends.server.types.AccountStatusNotificationType;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeBuilder;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.Privilege;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SynchronizationProviderResult;
import org.opends.server.types.operation.PostOperationModifyOperation;
import org.opends.server.types.operation.PostResponseModifyOperation;
import org.opends.server.types.operation.PostSynchronizationModifyOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;
import org.opends.server.workflowelement.localbackend.LocalBackendWorkflowElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalBackendModifyOperation
extends ModifyOperationWrapper
implements PreOperationModifyOperation,
PostOperationModifyOperation,
PostResponseModifyOperation,
PostSynchronizationModifyOperation {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    protected Backend backend;
    private boolean currentPasswordProvided;
    protected boolean enabledStateChanged;
    private boolean isEnabled;
    protected boolean noOp;
    protected boolean passwordChanged;
    protected boolean pwPolicyControlRequested;
    protected boolean selfChange;
    protected boolean wasLocked;
    protected ClientConnection clientConnection;
    protected DN entryDN;
    protected Entry currentEntry = null;
    protected Entry modifiedEntry = null;
    private int numPasswords;
    private LDAPPostReadRequestControl postReadRequest;
    private LDAPPreReadRequestControl preReadRequest;
    private List<AttributeValue> currentPasswords = null;
    private List<AttributeValue> newPasswords = null;
    protected List<Modification> modifications;
    protected PasswordPolicyErrorType pwpErrorType;
    protected PasswordPolicyState pwPolicyState;

    public LocalBackendModifyOperation(ModifyOperation modify) {
        super(modify);
        LocalBackendWorkflowElement.attachLocalOperation(modify, this);
    }

    @Override
    public final Entry getCurrentEntry() {
        return this.currentEntry;
    }

    @Override
    public final List<AttributeValue> getCurrentPasswords() {
        return this.currentPasswords;
    }

    @Override
    public final Entry getModifiedEntry() {
        return this.modifiedEntry;
    }

    @Override
    public final List<AttributeValue> getNewPasswords() {
        return this.newPasswords;
    }

    @Override
    public void addModification(Modification modification) throws DirectoryException {
        this.modifiedEntry.applyModification(modification);
        super.addModification(modification);
    }

    /*
     * Exception decompiling
     */
    public void processLocalModify(LocalBackendWorkflowElement wfe) throws CanceledOperationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[TRYBLOCK]], but top level block is 24[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void processRequestControls() throws DirectoryException {
        List<Control> requestControls = this.getRequestControls();
        if (requestControls != null && !requestControls.isEmpty()) {
            for (int i = 0; i < requestControls.size(); ++i) {
                Entry authorizationEntry;
                Control proxyControl;
                Control c = requestControls.get(i);
                String oid = c.getOID();
                if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this.entryDN, this, c)) {
                    throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, CoreMessages.ERR_CONTROL_INSUFFICIENT_ACCESS_RIGHTS.get(oid));
                }
                if (oid.equals("1.3.6.1.1.12")) {
                    SearchFilter filter;
                    LDAPAssertionRequestControl assertControl = this.getRequestControl(LDAPAssertionRequestControl.DECODER);
                    try {
                        filter = assertControl.getSearchFilter();
                    }
                    catch (DirectoryException de) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        throw new DirectoryException(de.getResultCode(), CoreMessages.ERR_MODIFY_CANNOT_PROCESS_ASSERTION_FILTER.get(String.valueOf(this.entryDN), de.getMessageObject()));
                    }
                    if (!AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this, this.currentEntry, filter)) {
                        throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, CoreMessages.ERR_CONTROL_INSUFFICIENT_ACCESS_RIGHTS.get(oid));
                    }
                    try {
                        if (filter.matchesEntry(this.currentEntry)) continue;
                        throw new DirectoryException(ResultCode.ASSERTION_FAILED, CoreMessages.ERR_MODIFY_ASSERTION_FAILED.get(String.valueOf(this.entryDN)));
                    }
                    catch (DirectoryException de) {
                        if (de.getResultCode() == ResultCode.ASSERTION_FAILED) {
                            throw de;
                        }
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, de);
                        }
                        throw new DirectoryException(de.getResultCode(), CoreMessages.ERR_MODIFY_CANNOT_PROCESS_ASSERTION_FILTER.get(String.valueOf(this.entryDN), de.getMessageObject()));
                    }
                }
                if (oid.equals("1.3.6.1.4.1.4203.1.10.2")) {
                    this.noOp = true;
                    continue;
                }
                if (oid.equals("1.3.6.1.1.13.1")) {
                    this.preReadRequest = this.getRequestControl(LDAPPreReadRequestControl.DECODER);
                    continue;
                }
                if (oid.equals("1.3.6.1.1.13.2")) {
                    if (c instanceof LDAPPostReadRequestControl) {
                        this.postReadRequest = (LDAPPostReadRequestControl)c;
                        continue;
                    }
                    this.postReadRequest = this.getRequestControl(LDAPPostReadRequestControl.DECODER);
                    requestControls.set(i, this.postReadRequest);
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.12")) {
                    if (!this.clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, this)) {
                        throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, CoreMessages.ERR_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                    }
                    proxyControl = this.getRequestControl(ProxiedAuthV1Control.DECODER);
                    authorizationEntry = ((ProxiedAuthV1Control)proxyControl).getAuthorizationEntry();
                    this.setAuthorizationEntry(authorizationEntry);
                    if (authorizationEntry == null) {
                        this.setProxiedAuthorizationDN(DN.nullDN());
                        continue;
                    }
                    this.setProxiedAuthorizationDN(authorizationEntry.getDN());
                    continue;
                }
                if (oid.equals("2.16.840.1.113730.3.4.18")) {
                    if (!this.clientConnection.hasPrivilege(Privilege.PROXIED_AUTH, this)) {
                        throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, CoreMessages.ERR_PROXYAUTH_INSUFFICIENT_PRIVILEGES.get());
                    }
                    proxyControl = this.getRequestControl(ProxiedAuthV2Control.DECODER);
                    authorizationEntry = ((ProxiedAuthV2Control)proxyControl).getAuthorizationEntry();
                    this.setAuthorizationEntry(authorizationEntry);
                    if (authorizationEntry == null) {
                        this.setProxiedAuthorizationDN(DN.nullDN());
                        continue;
                    }
                    this.setProxiedAuthorizationDN(authorizationEntry.getDN());
                    continue;
                }
                if (oid.equals("1.3.6.1.4.1.42.2.27.8.5.1")) {
                    this.pwPolicyControlRequested = true;
                    continue;
                }
                if (!c.isCritical() || this.backend != null && this.backend.supportsControl(oid)) continue;
                throw new DirectoryException(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION, CoreMessages.ERR_MODIFY_UNSUPPORTED_CRITICAL_CONTROL.get(String.valueOf(this.entryDN), oid));
            }
        }
    }

    protected void handleSchemaProcessing() throws DirectoryException {
        for (Modification m : this.modifications) {
            Attribute a = m.getAttribute();
            AttributeType t = a.getAttributeType();
            if (t.isNoUserModification() && !this.isInternalOperation() && !this.isSynchronizationOperation() && !m.isInternal()) {
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_ATTR_IS_NO_USER_MOD.get(String.valueOf(this.entryDN), a.getName()));
            }
            if (!(!t.isObsolete() || a.isEmpty() || m.getModificationType() == ModificationType.DELETE || this.isInternalOperation() || this.isSynchronizationOperation() || m.isInternal())) {
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_ATTR_IS_OBSOLETE.get(String.valueOf(this.entryDN), a.getName()));
            }
            if (t.hasName("ds-privilege-name") && !this.clientConnection.hasPrivilege(Privilege.PRIVILEGE_CHANGE, this)) {
                throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, CoreMessages.ERR_MODIFY_CHANGE_PRIVILEGE_INSUFFICIENT_PRIVILEGES.get());
            }
            boolean isPassword = t.equals(this.pwPolicyState.getPolicy().getPasswordAttribute());
            if (isPassword) continue;
            AttributeType disabledAttr = DirectoryServer.getAttributeType("ds-pwp-account-disabled", true);
            if (t.equals(disabledAttr)) {
                this.enabledStateChanged = true;
                for (AttributeValue v : a) {
                    try {
                        this.isEnabled = BooleanSyntax.DECODER.decode(v) == false;
                    }
                    catch (DirectoryException de) {
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, CoreMessages.ERR_MODIFY_INVALID_DISABLED_VALUE.get("ds-pwp-account-disabled", String.valueOf(de.getMessageObject())), de);
                    }
                }
            }
            switch (m.getModificationType()) {
                case ADD: {
                    this.processInitialAddSchema(a);
                    break;
                }
                case DELETE: {
                    this.processInitialDeleteSchema(a);
                    break;
                }
                case REPLACE: {
                    this.processInitialReplaceSchema(a);
                    break;
                }
                case INCREMENT: {
                    this.processInitialIncrementSchema(a);
                }
            }
        }
    }

    protected void handleInitialPasswordPolicyProcessing() throws DirectoryException {
        this.currentPasswordProvided = false;
        this.isEnabled = true;
        this.enabledStateChanged = false;
        this.numPasswords = this.currentEntry.hasAttribute(this.pwPolicyState.getPolicy().getPasswordAttribute()) ? 1 : 0;
        if (!this.isInternalOperation() && !this.isSynchronizationOperation()) {
            for (Modification m : this.modifications) {
                AttributeType t = m.getAttribute().getAttributeType();
                boolean isPassword = t.equals(this.pwPolicyState.getPolicy().getPasswordAttribute());
                if (!isPassword) continue;
                this.passwordChanged = true;
                if (this.selfChange || this.clientConnection.hasPrivilege(Privilege.PASSWORD_RESET, this)) break;
                this.pwpErrorType = PasswordPolicyErrorType.PASSWORD_MOD_NOT_ALLOWED;
                throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, CoreMessages.ERR_MODIFY_PWRESET_INSUFFICIENT_PRIVILEGES.get());
            }
        }
        for (Modification m : this.modifications) {
            Attribute a = m.getAttribute();
            AttributeType t = a.getAttributeType();
            boolean isPassword = t.equals(this.pwPolicyState.getPolicy().getPasswordAttribute());
            if (!isPassword) continue;
            if (!this.isSynchronizationOperation()) {
                if (!this.isInternalOperation()) {
                    if (a.hasOptions()) {
                        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_PASSWORDS_CANNOT_HAVE_OPTIONS.get());
                    }
                    if (this.selfChange && !this.pwPolicyState.getPolicy().allowUserPasswordChanges()) {
                        this.pwpErrorType = PasswordPolicyErrorType.PASSWORD_MOD_NOT_ALLOWED;
                        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_NO_USER_PW_CHANGES.get());
                    }
                    if (this.pwPolicyState.getPolicy().requireSecurePasswordChanges() && !this.clientConnection.isSecure()) {
                        this.pwpErrorType = PasswordPolicyErrorType.PASSWORD_MOD_NOT_ALLOWED;
                        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_REQUIRE_SECURE_CHANGES.get());
                    }
                    if (this.selfChange && this.pwPolicyState.isWithinMinimumAge()) {
                        this.pwpErrorType = PasswordPolicyErrorType.PASSWORD_TOO_YOUNG;
                        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_WITHIN_MINIMUM_AGE.get());
                    }
                }
                switch (m.getModificationType()) {
                    case ADD: 
                    case REPLACE: {
                        this.processInitialAddOrReplacePW(m);
                        break;
                    }
                    case DELETE: {
                        this.processInitialDeletePW(m);
                        break;
                    }
                    default: {
                        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_INVALID_MOD_TYPE_FOR_PASSWORD.get(String.valueOf((Object)m.getModificationType()), a.getName()));
                    }
                }
                a = m.getAttribute();
            }
            switch (m.getModificationType()) {
                case ADD: {
                    this.processInitialAddSchema(a);
                    break;
                }
                case DELETE: {
                    this.processInitialDeleteSchema(a);
                    break;
                }
                case REPLACE: {
                    this.processInitialReplaceSchema(a);
                    break;
                }
                case INCREMENT: {
                    this.processInitialIncrementSchema(a);
                }
            }
        }
    }

    private void processInitialAddOrReplacePW(Modification m) throws DirectoryException {
        Attribute pwAttr = m.getAttribute();
        int passwordsToAdd = pwAttr.size();
        this.numPasswords = m.getModificationType() == ModificationType.ADD ? (this.numPasswords += passwordsToAdd) : passwordsToAdd;
        if (!this.isInternalOperation() && !this.pwPolicyState.getPolicy().allowMultiplePasswordValues() && passwordsToAdd > 1) {
            this.pwpErrorType = PasswordPolicyErrorType.PASSWORD_MOD_NOT_ALLOWED;
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_MULTIPLE_VALUES_NOT_ALLOWED.get());
        }
        AttributeBuilder builder = new AttributeBuilder(pwAttr, true);
        for (AttributeValue v : pwAttr) {
            if (this.pwPolicyState.passwordIsPreEncoded(v.getValue())) {
                if (!this.isInternalOperation() && !this.pwPolicyState.getPolicy().allowPreEncodedPasswords()) {
                    this.pwpErrorType = PasswordPolicyErrorType.INSUFFICIENT_PASSWORD_QUALITY;
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_NO_PREENCODED_PASSWORDS.get());
                }
                builder.add(v);
                continue;
            }
            if (m.getModificationType() == ModificationType.ADD && this.pwPolicyState.passwordMatches(v.getValue())) {
                this.pwpErrorType = PasswordPolicyErrorType.PASSWORD_IN_HISTORY;
                throw new DirectoryException(ResultCode.ATTRIBUTE_OR_VALUE_EXISTS, CoreMessages.ERR_MODIFY_PASSWORD_EXISTS.get());
            }
            if (this.newPasswords == null) {
                this.newPasswords = new LinkedList<AttributeValue>();
            }
            this.newPasswords.add(v);
            for (ByteString s : this.pwPolicyState.encodePassword(v.getValue())) {
                builder.add(AttributeValues.create(pwAttr.getAttributeType(), s));
            }
        }
        m.setAttribute(builder.toAttribute());
    }

    private void processInitialDeletePW(Modification m) throws DirectoryException {
        Attribute pwAttr = m.getAttribute();
        AttributeBuilder builder = new AttributeBuilder(pwAttr, true);
        for (AttributeValue v : pwAttr) {
            if (this.pwPolicyState.passwordIsPreEncoded(v.getValue())) {
                if (!this.isInternalOperation() && this.selfChange) {
                    this.pwpErrorType = PasswordPolicyErrorType.INSUFFICIENT_PASSWORD_QUALITY;
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_NO_PREENCODED_PASSWORDS.get());
                }
                builder.add(v);
                continue;
            }
            List<Attribute> attrList = this.currentEntry.getAttribute(pwAttr.getAttributeType());
            if (attrList == null || attrList.isEmpty()) {
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_NO_EXISTING_VALUES.get());
            }
            boolean found = false;
            for (Attribute attr : attrList) {
                for (AttributeValue av : attr) {
                    PasswordStorageScheme scheme;
                    CharSequence[] components;
                    if (this.pwPolicyState.getPolicy().usesAuthPasswordSyntax()) {
                        if (AuthPasswordSyntax.isEncoded(av.getValue())) {
                            components = AuthPasswordSyntax.decodeAuthPassword(av.getValue().toString());
                            scheme = DirectoryServer.getAuthPasswordStorageScheme(((StringBuilder)components[0]).toString());
                            if (scheme == null || !scheme.authPasswordMatches(v.getValue(), ((StringBuilder)components[1]).toString(), ((StringBuilder)components[2]).toString())) continue;
                            builder.add(av);
                            found = true;
                            continue;
                        }
                        if (!((Object)av).equals(v)) continue;
                        builder.add(v);
                        found = true;
                        continue;
                    }
                    if (UserPasswordSyntax.isEncoded(av.getValue())) {
                        components = UserPasswordSyntax.decodeUserPassword(av.getValue().toString());
                        scheme = DirectoryServer.getPasswordStorageScheme(StaticUtils.toLowerCase((String)components[0]));
                        if (scheme == null || !scheme.passwordMatches(v.getValue(), ByteString.valueOf((String)components[1]))) continue;
                        builder.add(av);
                        found = true;
                        continue;
                    }
                    if (!((Object)av).equals(v)) continue;
                    builder.add(v);
                    found = true;
                }
            }
            if (found) {
                if (this.currentPasswords == null) {
                    this.currentPasswords = new LinkedList<AttributeValue>();
                }
                this.currentPasswords.add(v);
                --this.numPasswords;
            } else {
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_INVALID_PASSWORD.get());
            }
            this.currentPasswordProvided = true;
        }
        m.setAttribute(builder.toAttribute());
    }

    private void processInitialAddSchema(Attribute attr) throws DirectoryException {
        if (attr.isEmpty()) {
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, CoreMessages.ERR_MODIFY_ADD_NO_VALUES.get(String.valueOf(this.entryDN), attr.getName()));
        }
        if (DirectoryServer.checkSchema() && !this.isSynchronizationOperation()) {
            MessageBuilder invalidReason;
            AcceptRejectWarn syntaxPolicy = DirectoryServer.getSyntaxEnforcementPolicy();
            AttributeSyntax syntax = attr.getAttributeType().getSyntax();
            if (syntaxPolicy == AcceptRejectWarn.REJECT) {
                invalidReason = new MessageBuilder();
                for (AttributeValue v : attr) {
                    if (syntax.valueIsAcceptable(v.getValue(), invalidReason)) continue;
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, CoreMessages.ERR_MODIFY_ADD_INVALID_SYNTAX.get(String.valueOf(this.entryDN), attr.getName(), v.getValue().toString(), invalidReason));
                }
            } else if (syntaxPolicy == AcceptRejectWarn.WARN) {
                invalidReason = new MessageBuilder();
                for (AttributeValue v : attr) {
                    if (syntax.valueIsAcceptable(v.getValue(), invalidReason)) continue;
                    this.setResultCode(ResultCode.INVALID_ATTRIBUTE_SYNTAX);
                    ErrorLogger.logError(CoreMessages.ERR_MODIFY_ADD_INVALID_SYNTAX.get(String.valueOf(this.entryDN), attr.getName(), v.getValue().toString(), invalidReason));
                    invalidReason = new MessageBuilder();
                }
            }
        }
        if (attr.getAttributeType().isObjectClassType()) {
            this.validateObjectClasses(attr);
        }
        LinkedList<AttributeValue> duplicateValues = new LinkedList<AttributeValue>();
        this.modifiedEntry.addAttribute(attr, duplicateValues);
        if (!duplicateValues.isEmpty()) {
            StringBuilder buffer = new StringBuilder();
            Iterator iterator = duplicateValues.iterator();
            buffer.append(((AttributeValue)iterator.next()).getValue().toString());
            while (iterator.hasNext()) {
                buffer.append(", ");
                buffer.append(((AttributeValue)iterator.next()).getValue().toString());
            }
            throw new DirectoryException(ResultCode.ATTRIBUTE_OR_VALUE_EXISTS, CoreMessages.ERR_MODIFY_ADD_DUPLICATE_VALUE.get(String.valueOf(this.entryDN), attr.getName(), buffer));
        }
    }

    private void validateObjectClasses(Attribute attr) throws DirectoryException {
        Validator.ensureTrue(attr.getAttributeType().isObjectClassType());
        for (AttributeValue v : attr) {
            String lowerName;
            String name = v.getValue().toString();
            try {
                lowerName = v.getNormalizedValue().toString();
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                lowerName = StaticUtils.toLowerCase(v.getValue().toString());
            }
            ObjectClass oc = DirectoryServer.getObjectClass(lowerName);
            if (oc == null) {
                Message message = CoreMessages.ERR_ENTRY_ADD_UNKNOWN_OC.get(name, String.valueOf(this.entryDN));
                throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message);
            }
            if (!oc.isObsolete()) continue;
            Message message = CoreMessages.ERR_ENTRY_ADD_OBSOLETE_OC.get(name, String.valueOf(this.entryDN));
            throw new DirectoryException(ResultCode.OBJECTCLASS_VIOLATION, message);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processInitialDeleteSchema(Attribute attr) throws DirectoryException {
        LinkedList<AttributeValue> missingValues = new LinkedList<AttributeValue>();
        boolean attrExists = this.modifiedEntry.removeAttribute(attr, missingValues);
        if (!attrExists) throw new DirectoryException(ResultCode.NO_SUCH_ATTRIBUTE, CoreMessages.ERR_MODIFY_DELETE_NO_SUCH_ATTR.get(String.valueOf(this.entryDN), attr.getName()));
        if (missingValues.isEmpty()) {
            AttributeType t = attr.getAttributeType();
            RDN rdn = this.modifiedEntry.getDN().getRDN();
            if (rdn == null || !rdn.hasAttributeType(t) || this.modifiedEntry.hasValue(t, attr.getOptions(), rdn.getAttributeValue(t))) return;
            throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_RDN, CoreMessages.ERR_MODIFY_DELETE_RDN_ATTR.get(String.valueOf(this.entryDN), attr.getName()));
        }
        StringBuilder buffer = new StringBuilder();
        Iterator iterator = missingValues.iterator();
        buffer.append(((AttributeValue)iterator.next()).getValue().toString());
        while (iterator.hasNext()) {
            buffer.append(", ");
            buffer.append(((AttributeValue)iterator.next()).getValue().toString());
        }
        throw new DirectoryException(ResultCode.NO_SUCH_ATTRIBUTE, CoreMessages.ERR_MODIFY_DELETE_MISSING_VALUES.get(String.valueOf(this.entryDN), attr.getName(), buffer));
    }

    private void processInitialReplaceSchema(Attribute attr) throws DirectoryException {
        if (DirectoryServer.checkSchema() && !this.isSynchronizationOperation()) {
            AcceptRejectWarn syntaxPolicy = DirectoryServer.getSyntaxEnforcementPolicy();
            AttributeSyntax syntax = attr.getAttributeType().getSyntax();
            if (syntaxPolicy == AcceptRejectWarn.REJECT) {
                MessageBuilder invalidReason = new MessageBuilder();
                for (AttributeValue v : attr) {
                    if (syntax.valueIsAcceptable(v.getValue(), invalidReason)) continue;
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, CoreMessages.ERR_MODIFY_REPLACE_INVALID_SYNTAX.get(String.valueOf(this.entryDN), attr.getName(), v.getValue().toString(), invalidReason));
                }
            } else if (syntaxPolicy == AcceptRejectWarn.WARN) {
                MessageBuilder invalidReason = new MessageBuilder();
                for (AttributeValue v : attr) {
                    if (syntax.valueIsAcceptable(v.getValue(), invalidReason)) continue;
                    this.setResultCode(ResultCode.INVALID_ATTRIBUTE_SYNTAX);
                    ErrorLogger.logError(CoreMessages.ERR_MODIFY_REPLACE_INVALID_SYNTAX.get(String.valueOf(this.entryDN), attr.getName(), v.getValue().toString(), invalidReason));
                    invalidReason = new MessageBuilder();
                }
            }
        }
        if (attr.getAttributeType().isObjectClassType()) {
            this.validateObjectClasses(attr);
        }
        this.modifiedEntry.replaceAttribute(attr);
        AttributeType t = attr.getAttributeType();
        RDN rdn = this.modifiedEntry.getDN().getRDN();
        if (rdn != null && rdn.hasAttributeType(t) && !this.modifiedEntry.hasValue(t, attr.getOptions(), rdn.getAttributeValue(t))) {
            throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_RDN, CoreMessages.ERR_MODIFY_DELETE_RDN_ATTR.get(String.valueOf(this.entryDN), attr.getName()));
        }
    }

    private void processInitialIncrementSchema(Attribute attr) throws DirectoryException {
        long incrementValue;
        AttributeType t = attr.getAttributeType();
        RDN rdn = this.modifiedEntry.getDN().getRDN();
        if (rdn != null && rdn.hasAttributeType(t)) {
            throw new DirectoryException(ResultCode.NOT_ALLOWED_ON_RDN, CoreMessages.ERR_MODIFY_INCREMENT_RDN.get(String.valueOf(this.entryDN), attr.getName()));
        }
        if (attr.isEmpty()) {
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, CoreMessages.ERR_MODIFY_INCREMENT_REQUIRES_VALUE.get(String.valueOf(this.entryDN), attr.getName()));
        }
        if (attr.size() > 1) {
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, CoreMessages.ERR_MODIFY_INCREMENT_REQUIRES_SINGLE_VALUE.get(String.valueOf(this.entryDN), attr.getName()));
        }
        AttributeValue v = attr.iterator().next();
        try {
            incrementValue = Long.parseLong(v.getNormalizedValue().toString());
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, CoreMessages.ERR_MODIFY_INCREMENT_PROVIDED_VALUE_NOT_INTEGER.get(String.valueOf(this.entryDN), attr.getName(), v.getValue().toString()), e);
        }
        Attribute a = this.modifiedEntry.getExactAttribute(t, attr.getOptions());
        if (a == null) {
            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, CoreMessages.ERR_MODIFY_INCREMENT_REQUIRES_EXISTING_VALUE.get(String.valueOf(this.entryDN), attr.getName()));
        }
        AttributeBuilder builder = new AttributeBuilder(a, true);
        for (AttributeValue existingValue : a) {
            long currentValue;
            String s = existingValue.getValue().toString();
            try {
                currentValue = Long.parseLong(s);
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, CoreMessages.ERR_MODIFY_INCREMENT_REQUIRES_INTEGER_VALUE.get(String.valueOf(this.entryDN), a.getName(), existingValue.getValue().toString()), e);
            }
            long newValue = currentValue + incrementValue;
            builder.add(AttributeValues.create(t, String.valueOf(newValue)));
        }
        this.modifiedEntry.replaceAttribute(builder.toAttribute());
    }

    public void performAdditionalPasswordChangedProcessing() throws DirectoryException {
        if (this.selfChange && this.pwPolicyState.getPolicy().requireCurrentPassword() && !this.currentPasswordProvided) {
            this.pwpErrorType = PasswordPolicyErrorType.MUST_SUPPLY_OLD_PASSWORD;
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_PW_CHANGE_REQUIRES_CURRENT_PW.get());
        }
        if (this.numPasswords > 1 && !this.pwPolicyState.getPolicy().allowMultiplePasswordValues()) {
            this.pwpErrorType = PasswordPolicyErrorType.PASSWORD_MOD_NOT_ALLOWED;
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_MULTIPLE_PASSWORDS_NOT_ALLOWED.get());
        }
        if ((this.selfChange || !this.pwPolicyState.getPolicy().skipValidationForAdministrators()) && this.newPasswords != null) {
            HashSet<ByteString> clearPasswords = new HashSet<ByteString>();
            clearPasswords.addAll(this.pwPolicyState.getClearPasswords());
            if (this.currentPasswords != null) {
                if (clearPasswords.isEmpty()) {
                    for (AttributeValue v : this.currentPasswords) {
                        clearPasswords.add(v.getValue());
                    }
                } else {
                    for (AttributeValue v : this.currentPasswords) {
                        ByteString pw = v.getValue();
                        boolean found = false;
                        for (ByteString s : clearPasswords) {
                            if (!s.equals(pw)) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        clearPasswords.add(pw);
                    }
                }
            }
            for (AttributeValue v : this.newPasswords) {
                MessageBuilder invalidReason = new MessageBuilder();
                if (this.pwPolicyState.passwordIsAcceptable(this, this.modifiedEntry, v.getValue(), clearPasswords, invalidReason)) continue;
                this.pwpErrorType = PasswordPolicyErrorType.INSUFFICIENT_PASSWORD_QUALITY;
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_PW_VALIDATION_FAILED.get(invalidReason));
            }
        }
        if (this.pwPolicyState.maintainHistory() && this.newPasswords != null) {
            for (AttributeValue v : this.newPasswords) {
                if (!this.pwPolicyState.isPasswordInHistory(v.getValue()) || !this.selfChange && this.pwPolicyState.getPolicy().skipValidationForAdministrators()) continue;
                this.pwpErrorType = PasswordPolicyErrorType.PASSWORD_IN_HISTORY;
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_PW_IN_HISTORY.get());
            }
            this.pwPolicyState.updatePasswordHistory();
        }
        this.wasLocked = this.pwPolicyState.lockedDueToIdleInterval() || this.pwPolicyState.lockedDueToMaximumResetAge() || this.pwPolicyState.lockedDueToFailures();
        this.pwPolicyState.setPasswordChangedTime();
        this.pwPolicyState.clearFailureLockout();
        this.pwPolicyState.clearGraceLoginTimes();
        this.pwPolicyState.clearWarnedTime();
        if (this.pwPolicyState.getPolicy().forceChangeOnAdd() || this.pwPolicyState.getPolicy().forceChangeOnReset()) {
            if (this.selfChange) {
                this.pwPolicyState.setMustChangePassword(false);
            } else {
                if (this.pwpErrorType == null && this.pwPolicyState.getPolicy().forceChangeOnReset()) {
                    this.pwpErrorType = PasswordPolicyErrorType.CHANGE_AFTER_RESET;
                }
                this.pwPolicyState.setMustChangePassword(this.pwPolicyState.getPolicy().forceChangeOnReset());
            }
        }
        if (this.pwPolicyState.getPolicy().getRequireChangeByTime() > 0L) {
            this.pwPolicyState.setRequiredChangeTime();
        }
        this.modifications.addAll(this.pwPolicyState.getModifications());
        this.modifiedEntry.applyModifications(this.pwPolicyState.getModifications());
    }

    protected void checkWritability() throws DirectoryException {
        if (!this.backend.isPrivateBackend()) {
            switch (DirectoryServer.getWritabilityMode()) {
                case DISABLED: {
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_SERVER_READONLY.get(String.valueOf(this.entryDN)));
                }
                case INTERNAL_ONLY: {
                    if (this.isInternalOperation() || this.isSynchronizationOperation()) break;
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_SERVER_READONLY.get(String.valueOf(this.entryDN)));
                }
            }
            switch (this.backend.getWritabilityMode()) {
                case DISABLED: {
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_BACKEND_READONLY.get(String.valueOf(this.entryDN)));
                }
                case INTERNAL_ONLY: {
                    if (this.isInternalOperation() && !this.isSynchronizationOperation()) break;
                    throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, CoreMessages.ERR_MODIFY_BACKEND_READONLY.get(String.valueOf(this.entryDN)));
                }
            }
        }
    }

    protected void handleAccountStatusNotifications() {
        Message message;
        if (this.passwordChanged) {
            if (this.selfChange) {
                AuthenticationInfo authInfo = this.clientConnection.getAuthenticationInfo();
                if (authInfo.getAuthenticationDN().equals(this.modifiedEntry.getDN())) {
                    this.clientConnection.setMustChangePassword(false);
                }
                Message message2 = CoreMessages.INFO_MODIFY_PASSWORD_CHANGED.get();
                this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_CHANGED, this.modifiedEntry, message2, AccountStatusNotification.createProperties(this.pwPolicyState, false, -1, this.currentPasswords, this.newPasswords));
            } else {
                message = CoreMessages.INFO_MODIFY_PASSWORD_RESET.get();
                this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_RESET, this.modifiedEntry, message, AccountStatusNotification.createProperties(this.pwPolicyState, false, -1, this.currentPasswords, this.newPasswords));
            }
        }
        if (this.enabledStateChanged) {
            if (this.isEnabled) {
                message = CoreMessages.INFO_MODIFY_ACCOUNT_ENABLED.get();
                this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_ENABLED, this.modifiedEntry, message, AccountStatusNotification.createProperties(this.pwPolicyState, false, -1, null, null));
            } else {
                message = CoreMessages.INFO_MODIFY_ACCOUNT_DISABLED.get();
                this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_DISABLED, this.modifiedEntry, message, AccountStatusNotification.createProperties(this.pwPolicyState, false, -1, null, null));
            }
        }
        if (this.wasLocked) {
            message = CoreMessages.INFO_MODIFY_ACCOUNT_UNLOCKED.get();
            this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_UNLOCKED, this.modifiedEntry, message, AccountStatusNotification.createProperties(this.pwPolicyState, false, -1, null, null));
        }
    }

    protected void handleReadEntryProcessing() {
        Control responseControl;
        SearchResultEntry searchEntry;
        AttributeType attrType;
        Iterator<AttributeType> iterator;
        Entry entry;
        if (this.preReadRequest != null) {
            entry = this.currentEntry.duplicate(true);
            if (!this.preReadRequest.allowsAttribute(DirectoryServer.getObjectClassAttributeType())) {
                entry.removeAttribute(DirectoryServer.getObjectClassAttributeType());
            }
            if (!this.preReadRequest.returnAllUserAttributes()) {
                iterator = entry.getUserAttributes().keySet().iterator();
                while (iterator.hasNext()) {
                    attrType = iterator.next();
                    if (this.preReadRequest.allowsAttribute(attrType)) continue;
                    iterator.remove();
                }
            }
            if (!this.preReadRequest.returnAllOperationalAttributes()) {
                iterator = entry.getOperationalAttributes().keySet().iterator();
                while (iterator.hasNext()) {
                    attrType = iterator.next();
                    if (this.preReadRequest.allowsAttribute(attrType)) continue;
                    iterator.remove();
                }
            }
            searchEntry = AccessControlConfigManager.getInstance().getAccessControlHandler().filterEntry(this, entry);
            responseControl = new LDAPPreReadResponseControl(this.preReadRequest.isCritical(), searchEntry);
            this.getResponseControls().add(responseControl);
        }
        if (this.postReadRequest != null) {
            entry = this.modifiedEntry.duplicate(true);
            if (!this.postReadRequest.allowsAttribute(DirectoryServer.getObjectClassAttributeType())) {
                entry.removeAttribute(DirectoryServer.getObjectClassAttributeType());
            }
            if (!this.postReadRequest.returnAllUserAttributes()) {
                iterator = entry.getUserAttributes().keySet().iterator();
                while (iterator.hasNext()) {
                    attrType = iterator.next();
                    if (this.postReadRequest.allowsAttribute(attrType)) continue;
                    iterator.remove();
                }
            }
            if (!this.postReadRequest.returnAllOperationalAttributes()) {
                iterator = entry.getOperationalAttributes().keySet().iterator();
                while (iterator.hasNext()) {
                    attrType = iterator.next();
                    if (this.postReadRequest.allowsAttribute(attrType)) continue;
                    iterator.remove();
                }
            }
            searchEntry = AccessControlConfigManager.getInstance().getAccessControlHandler().filterEntry(this, entry);
            responseControl = new LDAPPostReadResponseControl(searchEntry);
            this.getResponseControls().add(responseControl);
        }
    }

    protected boolean handleConflictResolution() {
        boolean returnVal = true;
        for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
            try {
                SynchronizationProviderResult result = provider.handleConflictResolution(this);
                if (result.continueProcessing()) continue;
                this.setResultCode(result.getResultCode());
                this.appendErrorMessage(result.getErrorMessage());
                this.setMatchedDN(result.getMatchedDN());
                this.setReferralURLs(result.getReferralURLs());
                returnVal = false;
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                ErrorLogger.logError(CoreMessages.ERR_MODIFY_SYNCH_CONFLICT_RESOLUTION_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                this.setResponseData(de);
                returnVal = false;
            }
            break;
        }
        return returnVal;
    }

    protected boolean processPreOperation() {
        boolean returnVal = true;
        for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
            try {
                SynchronizationProviderResult result = provider.doPreOperation(this);
                if (result.continueProcessing()) continue;
                this.setResultCode(result.getResultCode());
                this.appendErrorMessage(result.getErrorMessage());
                this.setMatchedDN(result.getMatchedDN());
                this.setReferralURLs(result.getReferralURLs());
                returnVal = false;
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                ErrorLogger.logError(CoreMessages.ERR_MODIFY_SYNCH_PREOP_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                this.setResponseData(de);
                returnVal = false;
            }
            break;
        }
        return returnVal;
    }

    protected void processSynchPostOperationPlugins() {
        for (SynchronizationProvider<SynchronizationProviderCfg> provider : DirectoryServer.getSynchronizationProviders()) {
            try {
                provider.doPostOperation(this);
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                ErrorLogger.logError(CoreMessages.ERR_MODIFY_SYNCH_POSTOP_FAILED.get(this.getConnectionID(), this.getOperationID(), StaticUtils.getExceptionMessage(de)));
                this.setResponseData(de);
                break;
            }
        }
    }
}

