/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.workflowelement.externalchangelog;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.server.admin.std.server.WorkflowElementCfg;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PersistentSearch;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.types.CanceledOperationException;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Operation;
import org.opends.server.workflowelement.LeafWorkflowElement;
import org.opends.server.workflowelement.externalchangelog.ECLSearchOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ECLWorkflowElement
extends LeafWorkflowElement<WorkflowElementCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final List<PersistentSearch> persistentSearches = new CopyOnWriteArrayList<PersistentSearch>();
    public static final String ECL_WORKFLOW_ELEMENT = "EXTERNAL CHANGE LOG";
    private ReplicationServer replicationServer;

    public ECLWorkflowElement(ReplicationServer rs) throws DirectoryException {
        this.replicationServer = rs;
        super.initialize(ECL_WORKFLOW_ELEMENT, ECL_WORKFLOW_ELEMENT);
        DirectoryServer.registerWorkflowElement(this);
    }

    @Override
    public void finalizeWorkflowElement() {
        super.initialize(ECL_WORKFLOW_ELEMENT, null);
        for (PersistentSearch psearch : this.persistentSearches) {
            psearch.cancel();
        }
        this.persistentSearches.clear();
    }

    @Override
    public void execute(Operation operation) throws CanceledOperationException {
        switch (operation.getOperationType()) {
            case SEARCH: {
                ECLSearchOperation searchOperation = new ECLSearchOperation((SearchOperation)operation);
                searchOperation.processECLSearch(this);
                break;
            }
            case ABANDON: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Attempted to execute an invalid operation type:  " + (Object)((Object)operation.getOperationType()) + " (" + operation + ")"));
            }
        }
    }

    public static final <O extends Operation, L> void attachLocalOperation(O globalOperation, L currentLocalOperation) {
        List existingAttachment = (List)globalOperation.getAttachment("LocalBackendOperations");
        ArrayList<L> newAttachment = new ArrayList<L>();
        if (existingAttachment != null) {
            newAttachment.addAll(existingAttachment);
        }
        newAttachment.add(currentLocalOperation);
        globalOperation.setAttachment("LocalBackendOperations", newAttachment);
    }

    void registerPersistentSearch(PersistentSearch persistentSearch) {
        PersistentSearch.CancellationCallback callback = new PersistentSearch.CancellationCallback(){

            public void persistentSearchCancelled(PersistentSearch psearch) {
                psearch.getSearchOperation().cancel(null);
                ECLWorkflowElement.this.persistentSearches.remove(psearch);
            }
        };
        this.persistentSearches.add(persistentSearch);
        persistentSearch.registerCancellationCallback(callback);
    }

    public List<PersistentSearch> getPersistentSearches() {
        return this.persistentSearches;
    }

    public ReplicationServer getReplicationServer() {
        return this.replicationServer;
    }
}

