/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.workflowelement;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.WorkflowElementCfgDefn;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.admin.std.server.WorkflowElementCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.workflowelement.ObservableWorkflowElementState;
import org.opends.server.workflowelement.WorkflowElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowElementConfigManager
implements ConfigurationChangeListener<WorkflowElementCfg>,
ConfigurationAddListener<WorkflowElementCfg>,
ConfigurationDeleteListener<WorkflowElementCfg> {
    public void initializeWorkflowElements() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addWorkflowElementAddListener(this);
        rootConfiguration.addWorkflowElementDeleteListener(this);
        for (String workflowName : rootConfiguration.listWorkflowElements()) {
            this.loadAndRegisterWorkflowElement(workflowName);
        }
    }

    public WorkflowElement<?> loadAndRegisterWorkflowElement(String workflowName) throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        WorkflowElementCfg workflowConfiguration = rootConfiguration.getWorkflowElement(workflowName);
        workflowConfiguration.addChangeListener(this);
        if (workflowConfiguration.isEnabled()) {
            return this.loadAndRegisterWorkflowElement(workflowConfiguration);
        }
        return null;
    }

    @Override
    public boolean isConfigurationAddAcceptable(WorkflowElementCfg configuration, List<Message> unacceptableReasons) {
        boolean isAcceptable = true;
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadWorkflowElement(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                isAcceptable = false;
            }
        }
        return isAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(WorkflowElementCfg configuration) {
        ConfigChangeResult changeResult = new ConfigChangeResult(ResultCode.SUCCESS, false, new ArrayList<Message>());
        configuration.addChangeListener(this);
        if (configuration.isEnabled()) {
            try {
                WorkflowElement<?> we = this.loadAndRegisterWorkflowElement(configuration);
                WorkflowElement.notifyStateUpdate(we);
            }
            catch (InitializationException de) {
                if (changeResult.getResultCode() == ResultCode.SUCCESS) {
                    changeResult.setResultCode(DirectoryServer.getServerErrorResultCode());
                }
                changeResult.addMessage(de.getMessageObject());
            }
        }
        return changeResult;
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(WorkflowElementCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(WorkflowElementCfg configuration) {
        ConfigChangeResult changeResult = new ConfigChangeResult(ResultCode.SUCCESS, false, new ArrayList<Message>());
        WorkflowElement workflowElement = DirectoryServer.getWorkflowElement(configuration.getWorkflowElementId());
        if (workflowElement != null) {
            ObservableWorkflowElementState observableState = workflowElement.getObservableState();
            observableState.setWorkflowElementEnabled(false);
            observableState.notifyObservers();
            DirectoryServer.deregisterWorkflowElement(workflowElement);
            workflowElement.finalizeWorkflowElement();
        }
        return changeResult;
    }

    @Override
    public boolean isConfigurationChangeAcceptable(WorkflowElementCfg configuration, List<Message> unacceptableReasons) {
        boolean isAcceptable = true;
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadWorkflowElement(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                isAcceptable = false;
            }
        }
        return isAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(WorkflowElementCfg configuration) {
        ConfigChangeResult changeResult = new ConfigChangeResult(ResultCode.SUCCESS, false, new ArrayList<Message>());
        WorkflowElement existingWorkflowElement = DirectoryServer.getWorkflowElement(configuration.getWorkflowElementId());
        if (!configuration.isEnabled()) {
            if (existingWorkflowElement != null) {
                ObservableWorkflowElementState observableState = existingWorkflowElement.getObservableState();
                observableState.setWorkflowElementEnabled(false);
                observableState.notifyObservers();
                DirectoryServer.deregisterWorkflowElement(existingWorkflowElement);
                existingWorkflowElement.finalizeWorkflowElement();
            }
            return changeResult;
        }
        if (existingWorkflowElement == null) {
            try {
                WorkflowElement<?> we = this.loadAndRegisterWorkflowElement(configuration);
                WorkflowElement.notifyStateUpdate(we);
            }
            catch (InitializationException de) {
                if (changeResult.getResultCode() == ResultCode.SUCCESS) {
                    changeResult.setResultCode(DirectoryServer.getServerErrorResultCode());
                }
                changeResult.addMessage(de.getMessageObject());
            }
        }
        return changeResult;
    }

    WorkflowElement<?> loadAndRegisterWorkflowElement(WorkflowElementCfg workflowElementCfg) throws InitializationException {
        String className = workflowElementCfg.getJavaClass();
        WorkflowElement<?> workflowElement = this.loadWorkflowElement(className, workflowElementCfg, true);
        try {
            DirectoryServer.registerWorkflowElement(workflowElement);
        }
        catch (DirectoryException de) {
            throw new InitializationException(de.getMessageObject());
        }
        return workflowElement;
    }

    private WorkflowElement<?> loadWorkflowElement(String className, WorkflowElementCfg configuration, boolean initialize) throws InitializationException {
        try {
            WorkflowElementCfgDefn definition = WorkflowElementCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getJavaClassPropertyDefinition();
            Class<WorkflowElement> workflowElementClass = propertyDefinition.loadClass(className, WorkflowElement.class);
            WorkflowElement workflowElement = workflowElementClass.newInstance();
            if (initialize) {
                Method method = workflowElement.getClass().getMethod("initializeWorkflowElement", configuration.configurationClass());
                method.invoke((Object)workflowElement, configuration);
            } else {
                ArrayList unacceptableReasons;
                Method method = workflowElement.getClass().getMethod("isConfigurationAcceptable", WorkflowElementCfg.class, List.class);
                Boolean acceptable = (Boolean)method.invoke((Object)workflowElement, configuration, unacceptableReasons = new ArrayList());
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((String)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((String)iterator.next());
                        }
                    }
                    Message message = ConfigMessages.ERR_CONFIG_WORKFLOW_ELEMENT_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(message);
                }
            }
            return workflowElement;
        }
        catch (Exception e) {
            Throwable t = e;
            if (e instanceof InvocationTargetException && e.getCause() != null) {
                t = e.getCause();
            }
            Message message = ConfigMessages.ERR_CONFIG_WORKFLOW_ELEMENT_CANNOT_INITIALIZE.get(className, String.valueOf(configuration.dn()), t.getMessage());
            throw new InitializationException(message);
        }
    }
}

