/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public final class TimeThread {
    private static TimeThread INSTANCE = new TimeThread();
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new TimeThreadFactory());
    private final TimeInfo timeInfo = new TimeInfo();

    public static Calendar getCalendar() throws IllegalStateException {
        TimeThread.checkState();
        return TimeThread.INSTANCE.timeInfo.calendar;
    }

    public static Date getDate() throws IllegalStateException {
        TimeThread.checkState();
        return TimeThread.INSTANCE.timeInfo.date;
    }

    public static String getGeneralizedTime() throws IllegalStateException {
        TimeThread.checkState();
        return TimeThread.INSTANCE.timeInfo.generalizedTime;
    }

    public static String getGMTTime() throws IllegalStateException {
        TimeThread.checkState();
        return TimeThread.INSTANCE.timeInfo.gmtTimestamp;
    }

    public static int getHourAndMinute() throws IllegalStateException {
        TimeThread.checkState();
        return TimeThread.INSTANCE.timeInfo.hourAndMinute;
    }

    public static String getLocalTime() throws IllegalStateException {
        TimeThread.checkState();
        return TimeThread.INSTANCE.timeInfo.localTimestamp;
    }

    public static long getNanoTime() throws IllegalStateException {
        TimeThread.checkState();
        return TimeThread.INSTANCE.timeInfo.nanoTime;
    }

    public static long getTime() throws IllegalStateException {
        TimeThread.checkState();
        return TimeThread.INSTANCE.timeInfo.time;
    }

    public static String getUserDefinedTime(String formatString) throws IllegalArgumentException, IllegalStateException {
        TimeThread.checkState();
        String timeString = (String)TimeThread.INSTANCE.timeInfo.userDefinedTimeStrings.get(formatString);
        if (timeString == null) {
            SimpleDateFormat formatter = new SimpleDateFormat(formatString);
            timeString = formatter.format(TimeThread.INSTANCE.timeInfo.date);
            TimeThread.INSTANCE.timeInfo.userDefinedTimeStrings.put(formatString, timeString);
            TimeThread.INSTANCE.timeInfo.userDefinedFormatters.add(formatter);
        }
        return timeString;
    }

    public static void removeUserDefinedFormatter(String formatString) throws IllegalStateException {
        TimeThread.checkState();
        Iterator iterator = TimeThread.INSTANCE.timeInfo.userDefinedFormatters.iterator();
        while (iterator.hasNext()) {
            SimpleDateFormat format = (SimpleDateFormat)iterator.next();
            if (!format.toPattern().equals(formatString)) continue;
            iterator.remove();
        }
        TimeThread.INSTANCE.timeInfo.userDefinedTimeStrings.remove(formatString);
    }

    public static void start() {
        if (INSTANCE == null) {
            INSTANCE = new TimeThread();
        }
    }

    public static void stop() {
        if (INSTANCE != null) {
            TimeThread.INSTANCE.scheduler.shutdown();
            INSTANCE = null;
        }
    }

    private static void checkState() throws IllegalStateException {
        if (INSTANCE == null) {
            throw new IllegalStateException("Time service not started");
        }
    }

    private TimeThread() {
        this.scheduler.scheduleWithFixedDelay(this.timeInfo, 0L, 200L, TimeUnit.MILLISECONDS);
    }

    private static final class TimeThreadFactory
    implements ThreadFactory {
        private TimeThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            DirectoryThread t = new DirectoryThread(r, "Time Thread");
            t.setDaemon(true);
            return t;
        }
    }

    private static final class TimeInfo
    implements Runnable {
        private GregorianCalendar calendar;
        private Date date;
        private String generalizedTime;
        private String gmtTimestamp;
        private final SimpleDateFormat gmtTimestampFormatter;
        private int hourAndMinute;
        private String localTimestamp;
        private final SimpleDateFormat localTimestampFormatter;
        private volatile long nanoTime;
        private volatile long time;
        private final List<SimpleDateFormat> userDefinedFormatters = new CopyOnWriteArrayList<SimpleDateFormat>();
        private final Map<String, String> userDefinedTimeStrings = new ConcurrentHashMap<String, String>();

        public TimeInfo() {
            TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
            this.gmtTimestampFormatter = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            this.gmtTimestampFormatter.setTimeZone(utcTimeZone);
            this.localTimestampFormatter = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z");
            this.run();
        }

        public void run() {
            block3: {
                try {
                    this.calendar = new GregorianCalendar();
                    this.date = this.calendar.getTime();
                    this.time = this.date.getTime();
                    this.nanoTime = System.nanoTime();
                    this.generalizedTime = GeneralizedTimeSyntax.format(this.date);
                    this.localTimestamp = this.localTimestampFormatter.format(this.date);
                    this.gmtTimestamp = this.gmtTimestampFormatter.format(this.date);
                    this.hourAndMinute = this.calendar.get(11) * 100 + this.calendar.get(12);
                    for (SimpleDateFormat format : this.userDefinedFormatters) {
                        this.userDefinedTimeStrings.put(format.toPattern(), format.format(this.date));
                    }
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block3;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }
}

