/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opends.server.schema.LDAPSyntaxDescriptionSyntax;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.Schema;
import org.opends.server.types.SchemaFileElement;
import org.opends.server.types.StabilityLevel;
import org.opends.server.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public final class LDAPSyntaxDescription
implements SchemaFileElement {
    private final Map<String, List<String>> extraProperties;
    private final String definition;
    private final String description;
    private final String oid;
    private LDAPSyntaxDescriptionSyntax descriptionSyntax;

    public LDAPSyntaxDescription(String definition, LDAPSyntaxDescriptionSyntax descriptionSyntax, String description, Map<String, List<String>> extraProperties) {
        Validator.ensureNotNull(definition, descriptionSyntax);
        this.descriptionSyntax = descriptionSyntax;
        this.oid = descriptionSyntax.getOID();
        this.description = description;
        int schemaFilePos = definition.indexOf("X-SCHEMA-FILE");
        if (schemaFilePos > 0) {
            String defStr;
            try {
                int firstQuotePos = definition.indexOf(39, schemaFilePos);
                int secondQuotePos = definition.indexOf(39, firstQuotePos + 1);
                defStr = definition.substring(0, schemaFilePos).trim() + " " + definition.substring(secondQuotePos + 1).trim();
            }
            catch (Exception e) {
                defStr = definition;
            }
            this.definition = defStr;
        } else {
            this.definition = definition;
        }
        this.extraProperties = extraProperties == null || extraProperties.isEmpty() ? new LinkedHashMap<String, List<String>>(0) : new LinkedHashMap<String, List<String>>(extraProperties);
    }

    @Override
    public String getDefinition() {
        return this.definition;
    }

    public LDAPSyntaxDescriptionSyntax getLdapSyntaxDescriptionSyntax() {
        return this.descriptionSyntax;
    }

    @Override
    public LDAPSyntaxDescription recreateFromDefinition() throws DirectoryException {
        ByteString value = ByteString.valueOf(this.definition);
        Schema schema = DirectoryConfig.getSchema();
        LDAPSyntaxDescription ls = LDAPSyntaxDescriptionSyntax.decodeLDAPSyntax(value, schema, false);
        ls.setSchemaFile(this.getSchemaFile());
        return ls;
    }

    @Override
    public String getSchemaFile() {
        List<String> values = this.extraProperties.get("X-SCHEMA-FILE");
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    @Override
    public void setSchemaFile(String schemaFile) {
        this.setExtraProperty("X-SCHEMA-FILE", schemaFile);
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, List<String>> getExtraProperties() {
        return this.extraProperties;
    }

    public List<String> getExtraProperty(String propertyName) {
        return this.extraProperties.get(propertyName);
    }

    public void setExtraProperty(String name, String value) {
        Validator.ensureNotNull(name);
        if (value == null) {
            this.extraProperties.remove(name);
        } else {
            LinkedList<String> values = new LinkedList<String>();
            values.add(value);
            this.extraProperties.put(name, values);
        }
    }

    public void setExtraProperty(String name, List<String> values) {
        Validator.ensureNotNull(name);
        if (values == null || values.isEmpty()) {
            this.extraProperties.remove(name);
        } else {
            LinkedList<String> valuesCopy = new LinkedList<String>(values);
            this.extraProperties.put(name, valuesCopy);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof LDAPSyntaxDescription)) {
            return false;
        }
        return this.oid.equals(((LDAPSyntaxDescription)o).oid);
    }

    public int hashCode() {
        int oidLength = this.oid.length();
        int hashCode = 0;
        for (int i = 0; i < oidLength; ++i) {
            hashCode += this.oid.charAt(i);
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer, true);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer, boolean includeFileElement) {
        buffer.append("( ");
        buffer.append(this.oid);
        if (this.description != null && this.description.length() > 0) {
            buffer.append(" DESC '");
            buffer.append(this.description);
            buffer.append("'");
        }
        if (!this.extraProperties.isEmpty()) {
            for (String property : this.extraProperties.keySet()) {
                if (!includeFileElement && property.equals("X-SCHEMA-FILE")) continue;
                List<String> valueList = this.extraProperties.get(property);
                buffer.append(" ");
                buffer.append(property);
                if (valueList.size() == 1) {
                    buffer.append(" '");
                    buffer.append(valueList.get(0));
                    buffer.append("'");
                    continue;
                }
                buffer.append(" ( ");
                for (String value : valueList) {
                    buffer.append("'");
                    buffer.append(value);
                    buffer.append("' ");
                }
                buffer.append(")");
            }
        }
        buffer.append(" )");
    }
}

