/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.api.CompressedSchema;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.ByteSequenceReader;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class EntryEncodeConfig {
    private static final byte ENCODE_FLAG_EXCLUDE_DN = 1;
    private static final byte ENCODE_FLAG_COMPRESS_OCS = 2;
    private static final byte ENCODE_FLAG_COMPRESS_ADS = 4;
    public static final EntryEncodeConfig DEFAULT_CONFIG = new EntryEncodeConfig();
    private final boolean compressAttrDescriptions;
    private final boolean compressObjectClassSets;
    private final boolean excludeDN;
    private final byte encodedRepresentation;
    private final CompressedSchema compressedSchema;

    public EntryEncodeConfig() {
        this.excludeDN = false;
        this.compressAttrDescriptions = false;
        this.compressObjectClassSets = false;
        this.compressedSchema = DirectoryServer.getDefaultCompressedSchema();
        this.encodedRepresentation = 0;
    }

    public EntryEncodeConfig(boolean excludeDN, boolean compressAttrDescriptions, boolean compressObjectClassSets) {
        this.excludeDN = excludeDN;
        this.compressAttrDescriptions = compressAttrDescriptions;
        this.compressObjectClassSets = compressObjectClassSets;
        this.compressedSchema = DirectoryServer.getDefaultCompressedSchema();
        byte flagByte = 0;
        if (excludeDN) {
            flagByte = (byte)(flagByte | 1);
        }
        if (compressAttrDescriptions) {
            flagByte = (byte)(flagByte | 4);
        }
        if (compressObjectClassSets) {
            flagByte = (byte)(flagByte | 2);
        }
        this.encodedRepresentation = flagByte;
    }

    public EntryEncodeConfig(boolean excludeDN, boolean compressAttrDescriptions, boolean compressObjectClassSets, CompressedSchema compressedSchema) {
        this.excludeDN = excludeDN;
        this.compressAttrDescriptions = compressAttrDescriptions;
        this.compressObjectClassSets = compressObjectClassSets;
        this.compressedSchema = compressedSchema;
        byte flagByte = 0;
        if (excludeDN) {
            flagByte = (byte)(flagByte | 1);
        }
        if (compressAttrDescriptions) {
            flagByte = (byte)(flagByte | 4);
        }
        if (compressObjectClassSets) {
            flagByte = (byte)(flagByte | 2);
        }
        this.encodedRepresentation = flagByte;
    }

    public boolean excludeDN() {
        return this.excludeDN;
    }

    public boolean compressAttributeDescriptions() {
        return this.compressAttrDescriptions;
    }

    public boolean compressObjectClassSets() {
        return this.compressObjectClassSets;
    }

    public CompressedSchema getCompressedSchema() {
        return this.compressedSchema;
    }

    public void encode(ByteStringBuilder buffer) {
        buffer.appendBERLength(1);
        buffer.append(this.encodedRepresentation);
    }

    public static EntryEncodeConfig decode(ByteSequenceReader buffer, int length, CompressedSchema compressedSchema) throws DirectoryException {
        if (length != 1) {
            Message message = CoreMessages.ERR_ENTRYENCODECFG_INVALID_LENGTH.get();
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), message);
        }
        boolean excludeDN = false;
        byte b = buffer.get();
        if ((b & 1) == 1) {
            excludeDN = true;
        }
        boolean compressAttrDescriptions = false;
        if ((b & 4) == 4) {
            compressAttrDescriptions = true;
        }
        boolean compressObjectClassSets = false;
        if ((b & 2) == 2) {
            compressObjectClassSets = true;
        }
        return new EntryEncodeConfig(excludeDN, compressAttrDescriptions, compressObjectClassSets, compressedSchema);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("EntryEncodeConfig(excludeDN=");
        buffer.append(this.excludeDN);
        buffer.append(", compressAttrDescriptions=");
        buffer.append(this.compressAttrDescriptions);
        buffer.append(", compressObjectClassSets=");
        buffer.append(this.compressObjectClassSets);
        buffer.append(")");
    }
}

