/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.server.core.DirectoryServer;
import org.opends.server.tools.makeldif.EntryWriter;
import org.opends.server.tools.makeldif.MakeLDIFException;
import org.opends.server.tools.makeldif.StaticTextTag;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateLine;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Branch {
    private DN branchDN;
    private int[] numEntriesPerTemplate;
    private String[] subordinateTemplateNames;
    private Template[] subordinateTemplates;
    private TemplateLine[] rdnLines;
    private TemplateLine[] extraLines;

    public Branch(TemplateFile templateFile, DN branchDN) {
        this(templateFile, branchDN, new String[0], new int[0], new TemplateLine[0]);
    }

    public Branch(TemplateFile templateFile, DN branchDN, String[] subordinateTemplateNames, int[] numEntriesPerTemplate, TemplateLine[] extraLines) {
        Tag[] tags;
        String[] valueStrings;
        this.branchDN = branchDN;
        this.subordinateTemplateNames = subordinateTemplateNames;
        this.numEntriesPerTemplate = numEntriesPerTemplate;
        this.extraLines = extraLines;
        this.subordinateTemplates = null;
        Entry entry = StaticUtils.createEntry(branchDN);
        ArrayList<Message> warnings = new ArrayList<Message>();
        ArrayList<TemplateLine> lineList = new ArrayList<TemplateLine>();
        for (String string : entry.getObjectClasses().values()) {
            try {
                String[] valueStrings2 = new String[]{string};
                Tag[] tags2 = new Tag[]{new StaticTextTag()};
                tags2[0].initializeForBranch(templateFile, this, valueStrings2, 0, warnings);
                TemplateLine l = new TemplateLine(DirectoryServer.getObjectClassAttributeType(), 0, tags2);
                lineList.add(l);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (List list : entry.getUserAttributes().values()) {
            for (Attribute a : list) {
                for (AttributeValue v : a) {
                    try {
                        valueStrings = new String[]{v.getValue().toString()};
                        tags = new Tag[]{new StaticTextTag()};
                        tags[0].initializeForBranch(templateFile, this, valueStrings, 0, warnings);
                        lineList.add(new TemplateLine(a.getAttributeType(), 0, tags));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        for (List list : entry.getOperationalAttributes().values()) {
            for (Attribute a : list) {
                for (AttributeValue v : a) {
                    try {
                        valueStrings = new String[]{v.getValue().toString()};
                        tags = new Tag[]{new StaticTextTag()};
                        tags[0].initializeForBranch(templateFile, this, valueStrings, 0, warnings);
                        lineList.add(new TemplateLine(a.getAttributeType(), 0, tags));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.rdnLines = new TemplateLine[lineList.size()];
        lineList.toArray(this.rdnLines);
    }

    public void completeBranchInitialization(Map<String, Template> templates) throws MakeLDIFException {
        if (this.subordinateTemplateNames == null) {
            this.subordinateTemplateNames = new String[0];
            this.subordinateTemplates = new Template[0];
        } else {
            this.subordinateTemplates = new Template[this.subordinateTemplateNames.length];
            for (int i = 0; i < this.subordinateTemplates.length; ++i) {
                this.subordinateTemplates[i] = templates.get(StaticUtils.toLowerCase(this.subordinateTemplateNames[i]));
                if (this.subordinateTemplates[i] != null) continue;
                Message message = ToolMessages.ERR_MAKELDIF_UNDEFINED_BRANCH_SUBORDINATE.get(this.branchDN.toString(), this.subordinateTemplateNames[i]);
                throw new MakeLDIFException(message);
            }
        }
    }

    public DN getBranchDN() {
        return this.branchDN;
    }

    public String[] getSubordinateTemplateNames() {
        return this.subordinateTemplateNames;
    }

    public Template[] getSubordinateTemplates() {
        return this.subordinateTemplates;
    }

    public int[] getNumEntriesPerTemplate() {
        return this.numEntriesPerTemplate;
    }

    public void addSubordinateTemplate(String name, int numEntries) {
        String[] newNames = new String[this.subordinateTemplateNames.length + 1];
        int[] newCounts = new int[this.numEntriesPerTemplate.length + 1];
        System.arraycopy(this.subordinateTemplateNames, 0, newNames, 0, this.subordinateTemplateNames.length);
        System.arraycopy(this.numEntriesPerTemplate, 0, newCounts, 0, this.numEntriesPerTemplate.length);
        newNames[this.subordinateTemplateNames.length] = name;
        newCounts[this.numEntriesPerTemplate.length] = numEntries;
        this.subordinateTemplateNames = newNames;
        this.numEntriesPerTemplate = newCounts;
    }

    public TemplateLine[] getExtraLines() {
        return this.extraLines;
    }

    public void addExtraLine(TemplateLine line) {
        TemplateLine[] newExtraLines = new TemplateLine[this.extraLines.length + 1];
        System.arraycopy(this.extraLines, 0, newExtraLines, 0, this.extraLines.length);
        newExtraLines[this.extraLines.length] = line;
        this.extraLines = newExtraLines;
    }

    public boolean hasAttribute(AttributeType attributeType) {
        if (this.branchDN.getRDN().hasAttributeType(attributeType)) {
            return true;
        }
        for (TemplateLine l : this.extraLines) {
            if (!l.getAttributeType().equals(attributeType)) continue;
            return true;
        }
        return false;
    }

    public TagResult writeEntries(EntryWriter entryWriter) throws IOException, MakeLDIFException {
        TagResult r;
        TemplateEntry entry = new TemplateEntry(this);
        for (TemplateLine l : this.rdnLines) {
            r = l.generateLine(entry);
            if (r.keepProcessingEntry() && r.keepProcessingParent() && r.keepProcessingTemplateFile()) continue;
            return r;
        }
        for (TemplateLine l : this.extraLines) {
            r = l.generateLine(entry);
            if (r.keepProcessingEntry() && r.keepProcessingParent() && r.keepProcessingTemplateFile()) continue;
            return r;
        }
        if (!entryWriter.writeEntry(entry)) {
            return TagResult.STOP_PROCESSING;
        }
        for (int i = 0; i < this.subordinateTemplates.length; ++i) {
            TagResult r2 = this.subordinateTemplates[i].writeEntries(entryWriter, this.branchDN, this.numEntriesPerTemplate[i]);
            if (r2.keepProcessingParent() && r2.keepProcessingTemplateFile()) continue;
            if (r2.keepProcessingTemplateFile()) {
                return TagResult.SUCCESS_RESULT;
            }
            return r2;
        }
        return TagResult.SUCCESS_RESULT;
    }
}

