/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.messages.Message;
import org.opends.messages.ToolMessages;
import org.opends.quicksetup.Constants;
import org.opends.quicksetup.UserData;
import org.opends.quicksetup.util.Utils;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.tools.ToolConstants;
import org.opends.server.util.SetupUtils;
import org.opends.server.util.args.Argument;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.FileBasedArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallDSArgumentParser
extends ArgumentParser {
    BooleanArgument testOnlyArg;
    BooleanArgument cliArg;
    BooleanArgument addBaseEntryArg;
    BooleanArgument showUsageArg;
    BooleanArgument quietArg;
    BooleanArgument noPromptArg;
    BooleanArgument verboseArg;
    StringArgument propertiesFileArgument;
    BooleanArgument noPropertiesFileArgument;
    BooleanArgument skipPortCheckArg;
    BooleanArgument enableWindowsServiceArg;
    BooleanArgument doNotStartArg;
    BooleanArgument enableStartTLSArg;
    BooleanArgument generateSelfSignedCertificateArg;
    StringArgument hostNameArg;
    BooleanArgument usePkcs11Arg;
    FileBasedArgument directoryManagerPwdFileArg;
    FileBasedArgument keyStorePasswordFileArg;
    IntegerArgument ldapPortArg;
    IntegerArgument adminConnectorPortArg;
    IntegerArgument ldapsPortArg;
    IntegerArgument jmxPortArg;
    IntegerArgument sampleDataArg;
    StringArgument baseDNArg;
    StringArgument configClassArg;
    StringArgument configFileArg;
    StringArgument importLDIFArg;
    StringArgument rejectedImportFileArg;
    StringArgument skippedImportFileArg;
    StringArgument directoryManagerDNArg;
    StringArgument directoryManagerPwdStringArg;
    StringArgument useJavaKeyStoreArg;
    StringArgument useJCEKSArg;
    StringArgument usePkcs12Arg;
    StringArgument keyStorePasswordArg;
    StringArgument certNicknameArg;
    StringArgument progNameArg;
    private static final Logger LOG = Logger.getLogger(InstallDSArgumentParser.class.getName());

    public InstallDSArgumentParser(String mainClassName) {
        super(mainClassName, ToolMessages.INFO_INSTALLDS_TOOL_DESCRIPTION.get(), false);
    }

    public void initializeArguments() throws ArgumentException {
        this.testOnlyArg = new BooleanArgument("testOnly".toLowerCase(), Character.valueOf('t'), "testOnly", ToolMessages.INFO_INSTALLDS_DESCRIPTION_TESTONLY.get());
        this.testOnlyArg.setHidden(true);
        this.testOnlyArg.setPropertyName("testOnly");
        this.addArgument(this.testOnlyArg);
        this.cliArg = new BooleanArgument("cli".toLowerCase(), Character.valueOf('i'), "cli", ToolMessages.INFO_INSTALLDS_DESCRIPTION_CLI.get());
        this.cliArg.setPropertyName("cli");
        this.addArgument(this.cliArg);
        this.configFileArg = new StringArgument("configFile".toLowerCase(), Character.valueOf('c'), "configFile", false, false, true, ToolMessages.INFO_CONFIGFILE_PLACEHOLDER.get(), this.getDefaultConfigFile(), "configFile", ToolMessages.INFO_DESCRIPTION_CONFIG_FILE.get());
        this.configFileArg.setHidden(true);
        this.addArgument(this.configFileArg);
        this.configClassArg = new StringArgument("configClass".toLowerCase(), Character.valueOf('C'), "configClass", false, false, true, ToolMessages.INFO_CONFIGCLASS_PLACEHOLDER.get(), ConfigFileHandler.class.getName(), "configClass", ToolMessages.INFO_DESCRIPTION_CONFIG_CLASS.get());
        this.configClassArg.setHidden(true);
        this.addArgument(this.configClassArg);
        String defaultProgName = SetupUtils.isWindows() ? "setup.bat" : "setup";
        this.progNameArg = new StringArgument("programName".toLowerCase(), Character.valueOf('P'), "programName", false, false, true, ToolMessages.INFO_PROGRAM_NAME_PLACEHOLDER.get(), defaultProgName, "programName", ToolMessages.INFO_INSTALLDS_DESCRIPTION_PROGNAME.get());
        this.progNameArg.setHidden(true);
        this.addArgument(this.progNameArg);
        this.noPromptArg = new BooleanArgument("no-prompt".toLowerCase(), ToolConstants.OPTION_SHORT_NO_PROMPT, "no-prompt", ToolMessages.INFO_INSTALLDS_DESCRIPTION_NO_PROMPT.get());
        this.noPromptArg.setPropertyName("no-prompt");
        this.addArgument(this.noPromptArg);
        this.quietArg = new BooleanArgument("quiet".toLowerCase(), ToolConstants.OPTION_SHORT_QUIET, "quiet", ToolMessages.INFO_INSTALLDS_DESCRIPTION_SILENT.get());
        this.quietArg.setPropertyName("quiet");
        this.addArgument(this.quietArg);
        this.verboseArg = new BooleanArgument("verbose".toLowerCase(), ToolConstants.OPTION_SHORT_VERBOSE, "verbose", ToolMessages.INFO_DESCRIPTION_VERBOSE.get());
        this.addArgument(this.verboseArg);
        this.propertiesFileArgument = new StringArgument("propertiesFilePath".toLowerCase(), null, "propertiesFilePath", false, false, true, ToolMessages.INFO_PROP_FILE_PATH_PLACEHOLDER.get(), null, null, ToolMessages.INFO_DESCRIPTION_PROP_FILE_PATH.get());
        this.addArgument(this.propertiesFileArgument);
        this.setFilePropertiesArgument(this.propertiesFileArgument);
        this.noPropertiesFileArgument = new BooleanArgument("noPropertiesFile".toLowerCase(), null, "noPropertiesFile", ToolMessages.INFO_DESCRIPTION_NO_PROP_FILE.get());
        this.addArgument(this.noPropertiesFileArgument);
        this.setNoPropertiesFileArgument(this.noPropertiesFileArgument);
        this.baseDNArg = new StringArgument("baseDN".toLowerCase(), Character.valueOf('b'), "baseDN", false, true, true, ToolMessages.INFO_BASEDN_PLACEHOLDER.get(), "dc=example,dc=com", "baseDN", ToolMessages.INFO_INSTALLDS_DESCRIPTION_BASEDN.get());
        this.addArgument(this.baseDNArg);
        this.addBaseEntryArg = new BooleanArgument("addBaseEntry".toLowerCase(), Character.valueOf('a'), "addBaseEntry", ToolMessages.INFO_INSTALLDS_DESCRIPTION_ADDBASE.get());
        this.addBaseEntryArg.setPropertyName("addBaseEntry");
        this.addArgument(this.addBaseEntryArg);
        this.importLDIFArg = new StringArgument("ldifFile".toLowerCase(), Character.valueOf('l'), "ldifFile", false, true, true, ToolMessages.INFO_LDIFFILE_PLACEHOLDER.get(), null, "ldifFile", ToolMessages.INFO_INSTALLDS_DESCRIPTION_IMPORTLDIF.get());
        this.addArgument(this.importLDIFArg);
        this.rejectedImportFileArg = new StringArgument("rejectFile".toLowerCase(), Character.valueOf('R'), "rejectFile", false, false, true, ToolMessages.INFO_REJECT_FILE_PLACEHOLDER.get(), null, "rejectFile", ToolMessages.INFO_INSTALLDS_DESCRIPTION_REJECTED_FILE.get());
        this.addArgument(this.rejectedImportFileArg);
        this.skippedImportFileArg = new StringArgument("skipFile".toLowerCase(), null, "skipFile", false, false, true, ToolMessages.INFO_SKIP_FILE_PLACEHOLDER.get(), null, "skipFile", ToolMessages.INFO_INSTALLDS_DESCRIPTION_SKIPPED_FILE.get());
        this.addArgument(this.skippedImportFileArg);
        this.sampleDataArg = new IntegerArgument("sampleData".toLowerCase(), Character.valueOf('d'), "sampleData", false, false, true, ToolMessages.INFO_NUM_ENTRIES_PLACEHOLDER.get(), 0, "sampleData", true, 0, false, 0, ToolMessages.INFO_INSTALLDS_DESCRIPTION_SAMPLE_DATA.get());
        this.addArgument(this.sampleDataArg);
        int defaultLdapPort = UserData.getDefaultPort();
        if (defaultLdapPort == -1) {
            defaultLdapPort = 389;
        }
        this.ldapPortArg = new IntegerArgument("ldapPort".toLowerCase(), Character.valueOf('p'), "ldapPort", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), defaultLdapPort, "ldapPort", true, 1, true, 65535, ToolMessages.INFO_INSTALLDS_DESCRIPTION_LDAPPORT.get());
        this.addArgument(this.ldapPortArg);
        int defaultAdminPort = UserData.getDefaultAdminConnectorPort();
        if (defaultAdminPort == -1) {
            defaultAdminPort = 4444;
        }
        this.adminConnectorPortArg = new IntegerArgument("adminConnectorPort".toLowerCase(), null, "adminConnectorPort", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), defaultAdminPort, "adminConnectorPort", true, 1, true, 65535, ToolMessages.INFO_INSTALLDS_DESCRIPTION_ADMINCONNECTORPORT.get());
        this.addArgument(this.adminConnectorPortArg);
        this.jmxPortArg = new IntegerArgument("jmxPort".toLowerCase(), Character.valueOf('x'), "jmxPort", false, false, true, ToolMessages.INFO_JMXPORT_PLACEHOLDER.get(), SetupUtils.getDefaultJMXPort(), "jmxPort", true, 1, true, 65535, ToolMessages.INFO_INSTALLDS_DESCRIPTION_JMXPORT.get());
        this.addArgument(this.jmxPortArg);
        this.skipPortCheckArg = new BooleanArgument("skipPortCheck".toLowerCase(), Character.valueOf('S'), "skipPortCheck", ToolMessages.INFO_INSTALLDS_DESCRIPTION_SKIPPORT.get());
        this.skipPortCheckArg.setPropertyName("skipPortCheck");
        this.addArgument(this.skipPortCheckArg);
        this.directoryManagerDNArg = new StringArgument("rootUserDN".toLowerCase(), Character.valueOf('D'), "rootUserDN", false, false, true, ToolMessages.INFO_ROOT_USER_DN_PLACEHOLDER.get(), "cn=Directory Manager", "rootUserDN", ToolMessages.INFO_INSTALLDS_DESCRIPTION_ROOTDN.get());
        this.addArgument(this.directoryManagerDNArg);
        this.directoryManagerPwdStringArg = new StringArgument("rootUserPassword".toLowerCase(), Character.valueOf('w'), "rootUserPassword", false, false, true, ToolMessages.INFO_ROOT_USER_PWD_PLACEHOLDER.get(), null, "rootUserPassword", ToolMessages.INFO_INSTALLDS_DESCRIPTION_ROOTPW.get());
        this.addArgument(this.directoryManagerPwdStringArg);
        this.directoryManagerPwdFileArg = new FileBasedArgument("rootUserPasswordFile".toLowerCase(), Character.valueOf('j'), "rootUserPasswordFile", false, false, ToolMessages.INFO_ROOT_USER_PWD_FILE_PLACEHOLDER.get(), null, "rootUserPasswordFile", ToolMessages.INFO_INSTALLDS_DESCRIPTION_ROOTPWFILE.get());
        this.addArgument(this.directoryManagerPwdFileArg);
        this.enableWindowsServiceArg = new BooleanArgument("enableWindowsService".toLowerCase(), Character.valueOf('e'), "enableWindowsService", ToolMessages.INFO_INSTALLDS_DESCRIPTION_ENABLE_WINDOWS_SERVICE.get());
        this.enableWindowsServiceArg.setPropertyName("enableWindowsService");
        if (SetupUtils.isWindows()) {
            this.addArgument(this.enableWindowsServiceArg);
        }
        this.doNotStartArg = new BooleanArgument("doNotStart".toLowerCase(), Character.valueOf('O'), "doNotStart", ToolMessages.INFO_INSTALLDS_DESCRIPTION_DO_NOT_START.get());
        this.doNotStartArg.setPropertyName("doNotStart");
        this.addArgument(this.doNotStartArg);
        this.enableStartTLSArg = new BooleanArgument("enableStartTLS".toLowerCase(), Character.valueOf('q'), "enableStartTLS", ToolMessages.INFO_INSTALLDS_DESCRIPTION_ENABLE_STARTTLS.get());
        this.enableStartTLSArg.setPropertyName("enableStartTLS");
        this.addArgument(this.enableStartTLSArg);
        int defaultSecurePort = UserData.getDefaultSslPort(defaultLdapPort);
        if (defaultSecurePort == -1) {
            defaultSecurePort = 636;
        }
        this.ldapsPortArg = new IntegerArgument("ldapsPort".toLowerCase(), Character.valueOf('Z'), "ldapsPort", false, false, true, ToolMessages.INFO_PORT_PLACEHOLDER.get(), defaultSecurePort, "ldapsPort", true, 1, true, 65535, ToolMessages.INFO_INSTALLDS_DESCRIPTION_LDAPSPORT.get());
        this.addArgument(this.ldapsPortArg);
        this.generateSelfSignedCertificateArg = new BooleanArgument("generateSelfSignedCertificate".toLowerCase(), null, "generateSelfSignedCertificate", ToolMessages.INFO_INSTALLDS_DESCRIPTION_USE_SELF_SIGNED.get());
        this.generateSelfSignedCertificateArg.setPropertyName("generateSelfSignedCertificate");
        this.addArgument(this.generateSelfSignedCertificateArg);
        this.hostNameArg = new StringArgument("hostname".toLowerCase(), Character.valueOf('h'), "hostname", false, false, true, ToolMessages.INFO_HOST_PLACEHOLDER.get(), UserData.getDefaultHostName(), null, ToolMessages.INFO_INSTALLDS_DESCRIPTION_HOST_NAME.get(this.generateSelfSignedCertificateArg.getLongIdentifier()));
        this.hostNameArg.setPropertyName("hostname");
        this.addDefaultArgument(this.hostNameArg);
        this.usePkcs11Arg = new BooleanArgument("usePkcs11Keystore".toLowerCase(), null, "usePkcs11Keystore", ToolMessages.INFO_INSTALLDS_DESCRIPTION_USE_PKCS11.get());
        this.usePkcs11Arg.setPropertyName("usePkcs11Keystore");
        this.addArgument(this.usePkcs11Arg);
        this.useJavaKeyStoreArg = new StringArgument("useJavaKeystore".toLowerCase(), null, "useJavaKeystore", false, false, true, ToolMessages.INFO_KEYSTOREPATH_PLACEHOLDER.get(), null, "useJavaKeystore", ToolMessages.INFO_INSTALLDS_DESCRIPTION_USE_JAVAKEYSTORE.get());
        this.addArgument(this.useJavaKeyStoreArg);
        this.useJCEKSArg = new StringArgument("useJCEKS".toLowerCase(), null, "useJCEKS", false, false, true, ToolMessages.INFO_KEYSTOREPATH_PLACEHOLDER.get(), null, "useJCEKS", ToolMessages.INFO_INSTALLDS_DESCRIPTION_USE_JCEKS.get());
        this.addArgument(this.useJCEKSArg);
        this.usePkcs12Arg = new StringArgument("usePkcs12keyStore".toLowerCase(), null, "usePkcs12keyStore", false, false, true, ToolMessages.INFO_KEYSTOREPATH_PLACEHOLDER.get(), null, "usePkcs12keyStore", ToolMessages.INFO_INSTALLDS_DESCRIPTION_USE_PKCS12.get());
        this.addArgument(this.usePkcs12Arg);
        this.keyStorePasswordArg = new StringArgument("keyStorePassword".toLowerCase(), Character.valueOf('W'), "keyStorePassword", false, false, true, ToolMessages.INFO_KEYSTORE_PWD_PLACEHOLDER.get(), null, "keyStorePassword", ToolMessages.INFO_INSTALLDS_DESCRIPTION_KEYSTOREPASSWORD.get());
        this.addDefaultArgument(this.keyStorePasswordArg);
        this.keyStorePasswordFileArg = new FileBasedArgument("keyStorePasswordFile".toLowerCase(), Character.valueOf('u'), "keyStorePasswordFile", false, false, ToolMessages.INFO_KEYSTORE_PWD_FILE_PLACEHOLDER.get(), null, "keyStorePasswordFile", ToolMessages.INFO_INSTALLDS_DESCRIPTION_KEYSTOREPASSWORD_FILE.get());
        this.addDefaultArgument(this.keyStorePasswordFileArg);
        this.certNicknameArg = new StringArgument("certNickname".toLowerCase(), Character.valueOf('N'), "certNickname", false, false, true, ToolMessages.INFO_NICKNAME_PLACEHOLDER.get(), null, "certNickname", ToolMessages.INFO_INSTALLDS_DESCRIPTION_CERT_NICKNAME.get());
        this.addDefaultArgument(this.certNicknameArg);
        this.showUsageArg = new BooleanArgument("help".toLowerCase(), Character.valueOf('H'), "help", ToolMessages.INFO_INSTALLDS_DESCRIPTION_HELP.get());
        this.addArgument(this.showUsageArg);
        this.setUsageArgument(this.showUsageArg);
    }

    public boolean isCli() {
        return this.cliArg.isPresent();
    }

    @Override
    public void parseArguments(String[] args) throws ArgumentException {
        LinkedHashSet<Message> errorMessages = new LinkedHashSet<Message>();
        try {
            super.parseArguments(args);
        }
        catch (ArgumentException ae) {
            LOG.log(Level.SEVERE, "Error parsing arguments: " + ae, ae);
            errorMessages.add(ae.getMessageObject());
        }
        if (!this.isUsageArgumentPresent() && !this.isVersionArgumentPresent()) {
            this.checkConfigFileArg(errorMessages);
            this.checkServerPassword(errorMessages);
            this.checkProvidedPorts(errorMessages);
            this.checkImportDataArguments(errorMessages);
            this.checkSecurityArguments(errorMessages);
            if (errorMessages.size() > 0) {
                Message message = ToolMessages.ERR_CANNOT_INITIALIZE_ARGS.get(Utils.getMessageFromCollection(errorMessages, Constants.LINE_SEPARATOR));
                throw new ArgumentException(message);
            }
        }
    }

    public String getDirectoryManagerPassword() {
        String pwd = null;
        if (this.directoryManagerPwdStringArg.isPresent()) {
            pwd = this.directoryManagerPwdStringArg.getValue();
        } else if (this.directoryManagerPwdFileArg.isPresent()) {
            pwd = this.directoryManagerPwdFileArg.getValue();
        }
        return pwd;
    }

    public String getKeyStorePassword() {
        String pwd = null;
        if (this.keyStorePasswordArg.isPresent()) {
            pwd = this.keyStorePasswordArg.getValue();
        } else if (this.keyStorePasswordFileArg.isPresent()) {
            pwd = this.keyStorePasswordFileArg.getValue();
        }
        return pwd;
    }

    private void checkConfigFileArg(Collection<Message> errorMessages) {
        if (this.configFileArg.getValue() == null) {
            Message message = ToolMessages.ERR_INSTALLDS_NO_CONFIG_FILE.get(this.configFileArg.getLongIdentifier());
            errorMessages.add(message);
        }
    }

    private void checkServerPassword(Collection<Message> errorMessages) {
        Message message;
        if (this.directoryManagerPwdStringArg.isPresent() && this.directoryManagerPwdFileArg.isPresent()) {
            message = ToolMessages.ERR_INSTALLDS_TWO_CONFLICTING_ARGUMENTS.get(this.directoryManagerPwdStringArg.getLongIdentifier(), this.directoryManagerPwdFileArg.getLongIdentifier());
            errorMessages.add(message);
        }
        if (this.noPromptArg.isPresent() && !this.directoryManagerPwdStringArg.isPresent() && !this.directoryManagerPwdFileArg.isPresent()) {
            message = ToolMessages.ERR_INSTALLDS_NO_ROOT_PASSWORD.get(this.directoryManagerPwdStringArg.getLongIdentifier(), this.directoryManagerPwdFileArg.getLongIdentifier());
            errorMessages.add(message);
        }
    }

    private void checkProvidedPorts(Collection<Message> errorMessages) {
        try {
            Message message;
            HashSet<Integer> ports = new HashSet<Integer>();
            ports.add(this.ldapPortArg.getIntValue());
            if (ports.contains(this.adminConnectorPortArg.getIntValue())) {
                message = ToolMessages.ERR_CONFIGDS_PORT_ALREADY_SPECIFIED.get(String.valueOf(this.adminConnectorPortArg.getIntValue()));
                errorMessages.add(message);
            } else {
                ports.add(this.adminConnectorPortArg.getIntValue());
            }
            if (this.jmxPortArg.isPresent()) {
                if (ports.contains(this.jmxPortArg.getIntValue())) {
                    message = ToolMessages.ERR_CONFIGDS_PORT_ALREADY_SPECIFIED.get(String.valueOf(this.jmxPortArg.getIntValue()));
                    errorMessages.add(message);
                } else {
                    ports.add(this.jmxPortArg.getIntValue());
                }
            }
            if (this.ldapsPortArg.isPresent()) {
                if (ports.contains(this.ldapsPortArg.getIntValue())) {
                    message = ToolMessages.ERR_CONFIGDS_PORT_ALREADY_SPECIFIED.get(String.valueOf(this.ldapsPortArg.getIntValue()));
                    errorMessages.add(message);
                } else {
                    ports.add(this.ldapsPortArg.getIntValue());
                }
            }
        }
        catch (ArgumentException ae) {
            LOG.log(Level.SEVERE, "Unexpected error.  Assuming that it is caused by a previous parsing issue: " + ae, ae);
        }
    }

    private void checkImportDataArguments(Collection<Message> errorMessages) {
        Message message;
        if (this.addBaseEntryArg.isPresent()) {
            if (this.importLDIFArg.isPresent()) {
                message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.addBaseEntryArg.getLongIdentifier(), this.importLDIFArg.getLongIdentifier());
                errorMessages.add(message);
            } else if (this.sampleDataArg.isPresent()) {
                message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.addBaseEntryArg.getLongIdentifier(), this.sampleDataArg.getLongIdentifier());
                errorMessages.add(message);
            }
        } else if (this.importLDIFArg.isPresent() && this.sampleDataArg.isPresent()) {
            message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.importLDIFArg.getLongIdentifier(), this.sampleDataArg.getLongIdentifier());
            errorMessages.add(message);
        }
        if (this.rejectedImportFileArg.isPresent() && this.addBaseEntryArg.isPresent()) {
            message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.addBaseEntryArg.getLongIdentifier(), this.rejectedImportFileArg.getLongIdentifier());
            errorMessages.add(message);
        } else if (this.rejectedImportFileArg.isPresent() && this.sampleDataArg.isPresent()) {
            message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.rejectedImportFileArg.getLongIdentifier(), this.sampleDataArg.getLongIdentifier());
            errorMessages.add(message);
        }
        if (this.skippedImportFileArg.isPresent() && this.addBaseEntryArg.isPresent()) {
            message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.addBaseEntryArg.getLongIdentifier(), this.skippedImportFileArg.getLongIdentifier());
            errorMessages.add(message);
        } else if (this.skippedImportFileArg.isPresent() && this.sampleDataArg.isPresent()) {
            message = ToolMessages.ERR_TOOL_CONFLICTING_ARGS.get(this.skippedImportFileArg.getLongIdentifier(), this.sampleDataArg.getLongIdentifier());
            errorMessages.add(message);
        }
        if (this.noPromptArg.isPresent() && !this.baseDNArg.isPresent() && this.baseDNArg.getDefaultValue() == null) {
            Argument[] args;
            for (Argument arg : args = new Argument[]{this.importLDIFArg, this.addBaseEntryArg, this.sampleDataArg}) {
                if (!arg.isPresent()) continue;
                errorMessages.add(ToolMessages.ERR_INSTALLDS_NO_BASE_DN_AND_CONFLICTING_ARG.get("--" + arg.getLongIdentifier()));
            }
        }
    }

    private void checkSecurityArguments(Collection<Message> errorMessages) {
        boolean certificateRequired = this.ldapsPortArg.isPresent() || this.enableStartTLSArg.isPresent();
        int certificateType = 0;
        if (this.generateSelfSignedCertificateArg.isPresent()) {
            ++certificateType;
        }
        if (this.useJavaKeyStoreArg.isPresent()) {
            ++certificateType;
        }
        if (this.useJCEKSArg.isPresent()) {
            ++certificateType;
        }
        if (this.usePkcs11Arg.isPresent()) {
            ++certificateType;
        }
        if (this.usePkcs12Arg.isPresent()) {
            ++certificateType;
        }
        if (certificateType > 1) {
            errorMessages.add(ToolMessages.ERR_INSTALLDS_SEVERAL_CERTIFICATE_TYPE_SPECIFIED.get());
        }
        if (certificateRequired && this.noPromptArg.isPresent() && certificateType == 0) {
            errorMessages.add(ToolMessages.ERR_INSTALLDS_CERTIFICATE_REQUIRED_FOR_SSL_OR_STARTTLS.get());
        }
        if (certificateType == 1) {
            Message message;
            if (!this.generateSelfSignedCertificateArg.isPresent()) {
                if (this.keyStorePasswordArg.isPresent() && this.keyStorePasswordFileArg.isPresent()) {
                    message = ToolMessages.ERR_INSTALLDS_TWO_CONFLICTING_ARGUMENTS.get(this.keyStorePasswordArg.getLongIdentifier(), this.keyStorePasswordFileArg.getLongIdentifier());
                    errorMessages.add(message);
                }
                if (this.noPromptArg.isPresent() && !this.keyStorePasswordArg.isPresent() && !this.keyStorePasswordFileArg.isPresent()) {
                    message = ToolMessages.ERR_INSTALLDS_NO_KEYSTORE_PASSWORD.get(this.keyStorePasswordArg.getLongIdentifier(), this.keyStorePasswordFileArg.getLongIdentifier());
                    errorMessages.add(message);
                }
            }
            if (this.noPromptArg.isPresent() && !this.ldapsPortArg.isPresent() && !this.enableStartTLSArg.isPresent()) {
                message = ToolMessages.ERR_INSTALLDS_SSL_OR_STARTTLS_REQUIRED.get(this.ldapsPortArg.getLongIdentifier(), this.enableStartTLSArg.getLongIdentifier());
                errorMessages.add(message);
            }
        }
    }

    private String getDefaultConfigFile() {
        String a = Utils.getInstallPathFromClasspath();
        String root = Utils.getInstancePathFromInstallPath(a);
        String configDir = Utils.getPath(root, "config");
        return Utils.getPath(configDir, "config.ldif");
    }
}

