/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.util.ArrayList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.TaskMessages;
import org.opends.messages.ToolMessages;
import org.opends.server.api.Backend;
import org.opends.server.api.ClientConnection;
import org.opends.server.backends.jeb.BackendImpl;
import org.opends.server.backends.jeb.RebuildConfig;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.tasks.TaskUtils;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Operation;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebuildTask
extends Task {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    String baseDN = null;
    ArrayList<String> indexes = null;
    private String tmpDirectory = null;
    private boolean rebuildAll = false;

    @Override
    public Message getDisplayName() {
        return TaskMessages.INFO_TASK_REBUILD_NAME.get();
    }

    @Override
    public void initializeTask() throws DirectoryException {
        ClientConnection clientConnection;
        Operation operation = this.getOperation();
        if (operation != null && !(clientConnection = operation.getClientConnection()).hasPrivilege(Privilege.LDIF_IMPORT, operation)) {
            Message message = TaskMessages.ERR_TASK_INDEXREBUILD_INSUFFICIENT_PRIVILEGES.get();
            throw new DirectoryException(ResultCode.INSUFFICIENT_ACCESS_RIGHTS, message);
        }
        Entry taskEntry = this.getTaskEntry();
        AttributeType typeBaseDN = DirectoryServer.getAttributeType("ds-task-rebuild-base-dn", true);
        AttributeType typeIndex = DirectoryServer.getAttributeType("ds-task-rebuild-index", true);
        AttributeType typeTmpDirectory = DirectoryServer.getAttributeType("ds-task-rebuild-tmp-directory", true);
        List<Attribute> attrList = taskEntry.getAttribute(typeBaseDN);
        this.baseDN = TaskUtils.getSingleValueString(attrList);
        attrList = taskEntry.getAttribute(typeIndex);
        this.indexes = TaskUtils.getMultiValueString(attrList);
        if (this.isRebuildAll(this.indexes)) {
            if (this.indexes.size() != 1) {
                Message msg = TaskMessages.ERR_TASK_INDEXREBUILD_ALL_ERROR.get();
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, msg);
            }
            this.rebuildAll = true;
            this.indexes.clear();
        }
        attrList = taskEntry.getAttribute(typeTmpDirectory);
        this.tmpDirectory = TaskUtils.getSingleValueString(attrList);
    }

    private boolean isRebuildAll(List<String> indexList) {
        for (String s : indexList) {
            if (!s.equalsIgnoreCase("rebuildall")) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TaskState runTask() {
        Message message;
        Message message2;
        RebuildConfig rebuildConfig = new RebuildConfig();
        try {
            rebuildConfig.setBaseDN(DN.decode(this.baseDN));
        }
        catch (DirectoryException de) {
            Message message3 = ToolMessages.ERR_CANNOT_DECODE_BASE_DN.get(this.baseDN, de.getMessageObject());
            this.logError(message3);
            return TaskState.STOPPED_BY_ERROR;
        }
        for (String index : this.indexes) {
            rebuildConfig.addRebuildIndex(index);
        }
        Backend backend = DirectoryServer.getBackendWithBaseDN(rebuildConfig.getBaseDN());
        if (backend == null) {
            message2 = ToolMessages.ERR_NO_BACKENDS_FOR_BASE.get(this.baseDN);
            this.logError(message2);
            return TaskState.STOPPED_BY_ERROR;
        }
        if (!(backend instanceof BackendImpl)) {
            message2 = ToolMessages.ERR_REBUILDINDEX_WRONG_BACKEND_TYPE.get();
            this.logError(message2);
            return TaskState.STOPPED_BY_ERROR;
        }
        String lockFile = LockFileManager.getBackendLockFileName(backend);
        StringBuilder failureReason = new StringBuilder();
        try {
            TaskUtils.disableBackend(backend.getBackendID());
        }
        catch (DirectoryException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            this.logError(e.getMessageObject());
            return TaskState.STOPPED_BY_ERROR;
        }
        try {
            if (!LockFileManager.acquireExclusiveLock(lockFile, failureReason)) {
                Message message4 = ToolMessages.ERR_REBUILDINDEX_CANNOT_EXCLUSIVE_LOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                this.logError(message4);
                return TaskState.STOPPED_BY_ERROR;
            }
        }
        catch (Exception e) {
            Message message5 = ToolMessages.ERR_REBUILDINDEX_CANNOT_EXCLUSIVE_LOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(e));
            this.logError(message5);
            return TaskState.STOPPED_BY_ERROR;
        }
        if (this.tmpDirectory == null) {
            this.tmpDirectory = "import-tmp";
        }
        rebuildConfig.setTmpDirectory(this.tmpDirectory);
        rebuildConfig.setRebuildAll(this.rebuildAll);
        TaskState returnCode = TaskState.COMPLETED_SUCCESSFULLY;
        try {
            BackendImpl jebBackend = (BackendImpl)backend;
            jebBackend.rebuildBackend(rebuildConfig);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            message = ToolMessages.ERR_REBUILDINDEX_ERROR_DURING_REBUILD.get(e.getMessage());
            this.logError(message);
            returnCode = TaskState.STOPPED_BY_ERROR;
        }
        finally {
            try {
                lockFile = LockFileManager.getBackendLockFileName(backend);
                failureReason = new StringBuilder();
                if (!LockFileManager.releaseLock(lockFile, failureReason)) {
                    Message message6 = ToolMessages.WARN_REBUILDINDEX_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), String.valueOf(failureReason));
                    this.logError(message6);
                    returnCode = TaskState.COMPLETED_WITH_ERRORS;
                }
            }
            catch (Throwable t) {
                message = ToolMessages.WARN_REBUILDINDEX_CANNOT_UNLOCK_BACKEND.get(backend.getBackendID(), StaticUtils.getExceptionMessage(t));
                this.logError(message);
                returnCode = TaskState.COMPLETED_WITH_ERRORS;
            }
        }
        if (returnCode == TaskState.COMPLETED_SUCCESSFULLY) {
            try {
                TaskUtils.enableBackend(backend.getBackendID());
            }
            catch (DirectoryException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                this.logError(e.getMessageObject());
                returnCode = TaskState.STOPPED_BY_ERROR;
            }
        }
        return returnCode;
    }
}

