/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.util.List;
import org.opends.messages.MessageBuilder;
import org.opends.messages.TaskMessages;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.plugin.LDAPReplicationDomain;
import org.opends.server.tasks.TaskUtils;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ResultCode;

public class InitializeTargetTask
extends Task {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private String domainString = null;
    private LDAPReplicationDomain domain = null;
    private int target;
    private long total;

    public void initializeTask() throws DirectoryException {
        if (TaskState.isDone(this.getTaskState())) {
            return;
        }
        Entry taskEntry = this.getTaskEntry();
        AttributeType typeDomainBase = DirectoryServer.getAttributeType("ds-task-initialize-domain-dn", true);
        AttributeType typeScope = DirectoryServer.getAttributeType("ds-task-initialize-replica-server-id", true);
        List<Attribute> attrList = taskEntry.getAttribute(typeDomainBase);
        this.domainString = TaskUtils.getSingleValueString(attrList);
        try {
            DN dn = DN.decode(this.domainString);
            this.domain = LDAPReplicationDomain.retrievesReplicationDomain(dn);
        }
        catch (DirectoryException e) {
            MessageBuilder mb = new MessageBuilder();
            mb.append(TaskMessages.ERR_TASK_INITIALIZE_INVALID_DN.get());
            mb.append(e.getMessage());
            throw new DirectoryException(ResultCode.INVALID_DN_SYNTAX, e);
        }
        attrList = taskEntry.getAttribute(typeScope);
        String targetString = TaskUtils.getSingleValueString(attrList);
        this.target = this.domain.decodeTarget(targetString);
        this.setTotal(0L);
    }

    protected TaskState runTask() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("DebugInfoInitializeTarget Task/runTask ");
        }
        try {
            this.domain.initializeRemote(this.target, this);
        }
        catch (DirectoryException de) {
            MessageBuilder mb = new MessageBuilder();
            mb.append("Initialize Task stopped by error");
            mb.append(de.getMessageObject());
            this.logError(mb.toMessage());
            return TaskState.STOPPED_BY_ERROR;
        }
        return TaskState.COMPLETED_SUCCESSFULLY;
    }

    public void setTotal(long total) throws DirectoryException {
        this.total = total;
        this.replaceAttributeValue("ds-task-unprocessed-entry-count", String.valueOf(total));
        this.replaceAttributeValue("ds-task-processed-entry-count", String.valueOf(0));
    }

    public void setLeft(long left) throws DirectoryException {
        this.replaceAttributeValue("ds-task-unprocessed-entry-count", String.valueOf(left));
        this.replaceAttributeValue("ds-task-processed-entry-count", String.valueOf(this.total - left));
    }
}

