/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.SchemaMessages;
import org.opends.server.admin.std.server.AttributeSyntaxCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.MatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.MatchingRuleUse;
import org.opends.server.types.ResultCode;
import org.opends.server.types.Schema;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingRuleUseSyntax
extends AttributeSyntax<AttributeSyntaxCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    @Override
    public void initializeSyntax(AttributeSyntaxCfg configuration) throws ConfigException, InitializationException {
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get("2.5.13.2", "MatchingRuleUseDescription");
            throw new InitializationException(message);
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE.get("2.5.13.3", "MatchingRuleUseDescription");
            throw new InitializationException(message);
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get("2.5.13.4", "MatchingRuleUseDescription");
            throw new InitializationException(message);
        }
    }

    @Override
    public String getSyntaxName() {
        return "MatchingRuleUseDescription";
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.115.121.1.31";
    }

    @Override
    public String getDescription() {
        return "Matching Rule Use Description";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteSequence value, MessageBuilder invalidReason) {
        try {
            MatchingRuleUseSyntax.decodeMatchingRuleUse(value, DirectoryServer.getSchema(), true);
            return true;
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            invalidReason.append(de.getMessageObject());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static MatchingRuleUse decodeMatchingRuleUse(ByteSequence value, Schema schema, boolean allowUnknownElements) throws DirectoryException {
        char c;
        int pos;
        String valueStr = ((Object)value).toString();
        String lowerStr = StaticUtils.toLowerCase(valueStr);
        int length = valueStr.length();
        for (pos = 0; pos < length && valueStr.charAt(pos) == ' '; ++pos) {
        }
        if (pos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_EMPTY_VALUE.get();
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if ((c = valueStr.charAt(pos++)) != '(') {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_EXPECTED_OPEN_PARENTHESIS.get(valueStr, pos - 1, String.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        int oidStartPos = pos;
        if (!StaticUtils.isDigit(c)) {
            while (pos < length && (c = valueStr.charAt(pos++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) continue;
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_ILLEGAL_CHAR_IN_STRING_OID.get(valueStr, String.valueOf(c), pos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
        } else {
            boolean lastWasPeriod = false;
            while (pos < length && (c = valueStr.charAt(pos++)) != ' ') {
                if (c == '.') {
                    if (lastWasPeriod) {
                        Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_DOUBLE_PERIOD_IN_NUMERIC_OID.get(valueStr, pos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                    }
                    lastWasPeriod = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_ILLEGAL_CHAR_IN_NUMERIC_OID.get(valueStr, String.valueOf(c), pos - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                lastWasPeriod = false;
            }
        }
        if (pos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        String oid = lowerStr.substring(oidStartPos, pos - 1);
        MatchingRule matchingRule = schema.getMatchingRule(oid);
        if (matchingRule == null) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_UNKNOWN_MATCHING_RULE.get(valueStr, oid);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (pos < length && (c = valueStr.charAt(pos)) == ' ') {
            ++pos;
        }
        if (pos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        LinkedHashMap<String, String> names = new LinkedHashMap<String, String>();
        String description = null;
        boolean isObsolete = false;
        LinkedHashSet attributes = null;
        LinkedHashMap<String, List<String>> extraProperties = new LinkedHashMap<String, List<String>>();
        block5: while (true) {
            LinkedList<AttributeType> attrs;
            block31: {
                AttributeType attr;
                StringBuilder woidBuffer;
                block37: {
                    StringBuilder lowerBuffer;
                    StringBuilder userBuffer;
                    block35: {
                        block33: {
                            String tokenName;
                            block36: {
                                String lowerTokenName;
                                block34: {
                                    Message message;
                                    block32: {
                                        StringBuilder tokenNameBuffer = new StringBuilder();
                                        pos = MatchingRuleUseSyntax.readTokenName(valueStr, tokenNameBuffer, pos);
                                        tokenName = tokenNameBuffer.toString();
                                        lowerTokenName = StaticUtils.toLowerCase(tokenName);
                                        if (!tokenName.equals(")")) break block32;
                                        if (pos < length) {
                                            message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_UNEXPECTED_CLOSE_PARENTHESIS.get(valueStr, pos - 1);
                                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                                        }
                                        break block33;
                                    }
                                    if (!lowerTokenName.equals("name")) break block34;
                                    if ((c = valueStr.charAt(pos++)) == '\'') {
                                        userBuffer = new StringBuilder();
                                        lowerBuffer = new StringBuilder();
                                        pos = MatchingRuleUseSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos - 1);
                                        names.put(lowerBuffer.toString(), userBuffer.toString());
                                        continue;
                                    }
                                    if (c != '(') {
                                        message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_ILLEGAL_CHAR.get(valueStr, String.valueOf(c), pos - 1);
                                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                                    }
                                    break block35;
                                }
                                if (lowerTokenName.equals("desc")) {
                                    StringBuilder descriptionBuffer = new StringBuilder();
                                    pos = MatchingRuleUseSyntax.readQuotedString(valueStr, descriptionBuffer, pos);
                                    description = descriptionBuffer.toString();
                                    continue;
                                }
                                if (lowerTokenName.equals("obsolete")) {
                                    isObsolete = true;
                                    continue;
                                }
                                if (!lowerTokenName.equals("applies")) break block36;
                                attrs = new LinkedList<AttributeType>();
                                if ((c = valueStr.charAt(pos++)) == '(') break block37;
                                woidBuffer = new StringBuilder();
                                pos = MatchingRuleUseSyntax.readWOID(lowerStr, woidBuffer, pos - 1);
                                attr = schema.getAttributeType(woidBuffer.toString());
                                if (attr == null) {
                                    if (!allowUnknownElements) {
                                        Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_UNKNOWN_ATTR.get(oid, woidBuffer.toString());
                                        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                                    }
                                    attr = DirectoryServer.getDefaultAttributeType(woidBuffer.toString());
                                }
                                attrs.add(attr);
                                break block31;
                            }
                            LinkedList<String> valueList = new LinkedList<String>();
                            pos = MatchingRuleUseSyntax.readExtraParameterValues(valueStr, valueList, pos);
                            extraProperties.put(tokenName, valueList);
                            continue;
                        }
                        if (attributes == null) {
                            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_NO_ATTR.get(valueStr);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                        }
                        return new MatchingRuleUse(((Object)value).toString(), matchingRule, names, description, isObsolete, attributes, extraProperties);
                    }
                    userBuffer = new StringBuilder();
                    lowerBuffer = new StringBuilder();
                    pos = MatchingRuleUseSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos);
                    names.put(lowerBuffer.toString(), userBuffer.toString());
                    while (true) {
                        if (valueStr.charAt(pos) == ')') {
                            ++pos;
                            while (true) {
                                if (pos >= length || (c = valueStr.charAt(pos)) != ' ') continue block5;
                                ++pos;
                            }
                        }
                        userBuffer = new StringBuilder();
                        lowerBuffer = new StringBuilder();
                        pos = MatchingRuleUseSyntax.readQuotedString(valueStr, lowerStr, userBuffer, lowerBuffer, pos);
                        names.put(lowerBuffer.toString(), userBuffer.toString());
                    }
                }
                do {
                    woidBuffer = new StringBuilder();
                    pos = MatchingRuleUseSyntax.readWOID(lowerStr, woidBuffer, pos);
                    attr = schema.getAttributeType(woidBuffer.toString());
                    if (attr == null) {
                        if (!allowUnknownElements) {
                            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_UNKNOWN_ATTR.get(oid, woidBuffer.toString());
                            throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                        }
                        attr = DirectoryServer.getDefaultAttributeType(woidBuffer.toString());
                    }
                    attrs.add(attr);
                    c = valueStr.charAt(pos++);
                    if (c == ')') break block31;
                } while (c == '$');
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_ILLEGAL_CHAR.get(valueStr, String.valueOf(c), pos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            attributes = new LinkedHashSet(attrs);
        }
    }

    private static int readTokenName(String valueStr, StringBuilder tokenName, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (startPos < length && (c = valueStr.charAt(startPos++)) != ' ') {
            tokenName.append(c);
        }
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        return startPos;
    }

    private static int readQuotedString(String valueStr, StringBuilder valueBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = valueStr.length();
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (c != '\'') {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_EXPECTED_QUOTE_AT_POS.get(valueStr, startPos, String.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) != '\'') {
            valueBuffer.append(c);
            ++startPos;
        }
        ++startPos;
        while (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return startPos;
    }

    private static int readQuotedString(String valueStr, String lowerStr, StringBuilder userBuffer, StringBuilder lowerBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = lowerStr.length();
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_TRUNCATED_VALUE.get(lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (c != '\'') {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_EXPECTED_QUOTE_AT_POS.get(valueStr, startPos, String.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        ++startPos;
        while (startPos < length && (c = lowerStr.charAt(startPos)) != '\'') {
            lowerBuffer.append(c);
            userBuffer.append(valueStr.charAt(startPos));
            ++startPos;
        }
        ++startPos;
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_TRUNCATED_VALUE.get(lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return startPos;
    }

    private static int readWOID(String lowerStr, StringBuilder woidBuffer, int startPos) throws DirectoryException {
        char c = '\u0000';
        int length = lowerStr.length();
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_TRUNCATED_VALUE.get(lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        if (StaticUtils.isDigit(c)) {
            boolean lastWasPeriod = false;
            while (startPos < length && (c = lowerStr.charAt(startPos++)) != ' ') {
                if (c == '.') {
                    if (lastWasPeriod) {
                        Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_DOUBLE_PERIOD_IN_NUMERIC_OID.get(lowerStr, startPos - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                    }
                    woidBuffer.append(c);
                    lastWasPeriod = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    if (c == ')') {
                        return startPos - 1;
                    }
                    Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_ILLEGAL_CHAR_IN_NUMERIC_OID.get(lowerStr, String.valueOf(c), startPos - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                }
                woidBuffer.append(c);
                lastWasPeriod = false;
            }
        } else if (StaticUtils.isAlpha(c)) {
            while (startPos < length && (c = lowerStr.charAt(startPos++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) {
                    woidBuffer.append(c);
                    continue;
                }
                if (c == ')') {
                    return startPos - 1;
                }
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_ILLEGAL_CHAR_IN_STRING_OID.get(lowerStr, String.valueOf(c), startPos - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
        } else {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_ILLEGAL_CHAR.get(lowerStr, String.valueOf(c), startPos);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        while (startPos < length && (c = lowerStr.charAt(startPos)) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_TRUNCATED_VALUE.get(lowerStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return startPos;
    }

    private static int readExtraParameterValues(String valueStr, List<String> valueList, int startPos) throws DirectoryException {
        int length;
        block14: {
            StringBuilder valueBuffer;
            length = valueStr.length();
            char c = valueStr.charAt(startPos++);
            while (startPos < length && c == ' ') {
                c = valueStr.charAt(startPos++);
            }
            if (startPos >= length) {
                Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_TRUNCATED_VALUE.get(valueStr);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
            }
            if (c == '\'') {
                valueBuffer = new StringBuilder();
                while (startPos < length && (c = valueStr.charAt(startPos++)) != '\'') {
                    valueBuffer.append(c);
                }
                valueList.add(valueBuffer.toString());
            } else {
                if (c == '(') {
                    ++startPos;
                    while (true) {
                        if (startPos < length && (c = valueStr.charAt(startPos)) == ' ') {
                            ++startPos;
                            continue;
                        }
                        if (startPos >= length) {
                            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_TRUNCATED_VALUE.get(valueStr);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                        }
                        if (c == ')') {
                            ++startPos;
                            break block14;
                        }
                        if (c == '(') {
                            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_ILLEGAL_CHAR.get(valueStr, String.valueOf(c), startPos);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
                        }
                        startPos = MatchingRuleUseSyntax.readExtraParameterValues(valueStr, valueList, startPos);
                    }
                }
                valueBuffer = new StringBuilder();
                while (startPos < length && (c = valueStr.charAt(startPos++)) != ' ') {
                    valueBuffer.append(c);
                }
                valueList.add(valueBuffer.toString());
            }
        }
        while (startPos < length && valueStr.charAt(startPos) == ' ') {
            ++startPos;
        }
        if (startPos >= length) {
            Message message = SchemaMessages.ERR_ATTR_SYNTAX_MRUSE_TRUNCATED_VALUE.get(valueStr);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, message);
        }
        return startPos;
    }

    @Override
    public boolean isBinary() {
        return false;
    }
}

