/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Collection;
import java.util.Collections;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.schema.StringPrepProfile;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseIgnoreEqualityMatchingRule
extends EqualityMatchingRule {
    @Override
    public Collection<String> getAllNames() {
        return Collections.singleton(this.getName());
    }

    @Override
    public String getName() {
        return "caseIgnoreMatch";
    }

    @Override
    public String getOID() {
        return "2.5.13.2";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getSyntaxOID() {
        return "1.3.6.1.4.1.1466.115.121.1.15";
    }

    @Override
    public ByteString normalizeValue(ByteSequence value) throws DirectoryException {
        StringBuilder buffer = new StringBuilder();
        StringPrepProfile.prepareUnicode(buffer, value, true, true);
        int bufferLength = buffer.length();
        if (bufferLength == 0) {
            if (value.length() > 0) {
                return ServerConstants.SINGLE_SPACE_VALUE;
            }
            return ByteString.empty();
        }
        for (int pos = bufferLength - 1; pos > 0; --pos) {
            if (buffer.charAt(pos) != ' ' || buffer.charAt(pos - 1) != ' ') continue;
            buffer.delete(pos, pos + 1);
        }
        return ByteString.valueOf(buffer.toString());
    }
}

