/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.service;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.messages.ReplicationMessages;
import org.opends.server.api.DirectoryThread;
import org.opends.server.backends.task.Task;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.AssuredMode;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ChangeNumberGenerator;
import org.opends.server.replication.common.DSInfo;
import org.opends.server.replication.common.RSInfo;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.common.ServerStatus;
import org.opends.server.replication.common.StatusMachine;
import org.opends.server.replication.common.StatusMachineEvent;
import org.opends.server.replication.protocol.AckMsg;
import org.opends.server.replication.protocol.ChangeStatusMsg;
import org.opends.server.replication.protocol.DoneMsg;
import org.opends.server.replication.protocol.EntryMsg;
import org.opends.server.replication.protocol.ErrorMsg;
import org.opends.server.replication.protocol.HeartbeatMsg;
import org.opends.server.replication.protocol.InitializeRequestMsg;
import org.opends.server.replication.protocol.InitializeTargetMsg;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.replication.protocol.ReplSessionSecurity;
import org.opends.server.replication.protocol.ReplicationMsg;
import org.opends.server.replication.protocol.ResetGenerationIdMsg;
import org.opends.server.replication.protocol.RoutableMsg;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.service.ListenerThread;
import org.opends.server.replication.service.ReplInputStream;
import org.opends.server.replication.service.ReplOutputStream;
import org.opends.server.replication.service.ReplicationBroker;
import org.opends.server.replication.service.ReplicationMonitor;
import org.opends.server.tasks.InitializeTargetTask;
import org.opends.server.tasks.InitializeTask;
import org.opends.server.types.Attribute;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReplicationDomain {
    protected ServerStatus status = ServerStatus.NOT_CONNECTED_STATUS;
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final String serviceID;
    private final int serverID;
    protected ReplicationBroker broker = null;
    private final SortedMap<ChangeNumber, UpdateMsg> waitingAckMsgs = new TreeMap<ChangeNumber, UpdateMsg>();
    protected IEContext ieContext = null;
    private ListenerThread listenerThread;
    private static Map<String, ReplicationDomain> domains = new HashMap<String, ReplicationDomain>();
    private ReplicationMonitor monitor;
    private boolean assured = false;
    private AssuredMode assuredMode = AssuredMode.SAFE_DATA_MODE;
    private byte assuredSdLevel = 1;
    private long assuredTimeout = 2000L;
    private byte groupId = 1;
    private List<String> refUrls = new ArrayList<String>();
    private AtomicInteger numProcessedUpdates = new AtomicInteger(0);
    private AtomicInteger numRcvdUpdates = new AtomicInteger(0);
    private AtomicInteger numSentUpdates = new AtomicInteger(0);
    private AtomicInteger assuredSrSentUpdates = new AtomicInteger(0);
    private AtomicInteger assuredSrAcknowledgedUpdates = new AtomicInteger(0);
    private AtomicInteger assuredSrNotAcknowledgedUpdates = new AtomicInteger(0);
    private AtomicInteger assuredSrTimeoutUpdates = new AtomicInteger(0);
    private AtomicInteger assuredSrWrongStatusUpdates = new AtomicInteger(0);
    private AtomicInteger assuredSrReplayErrorUpdates = new AtomicInteger(0);
    private Map<Integer, Integer> assuredSrServerNotAcknowledgedUpdates = new HashMap<Integer, Integer>();
    private AtomicInteger assuredSrReceivedUpdates = new AtomicInteger(0);
    private AtomicInteger assuredSrReceivedUpdatesAcked = new AtomicInteger(0);
    private AtomicInteger assuredSrReceivedUpdatesNotAcked = new AtomicInteger(0);
    private AtomicInteger assuredSdSentUpdates = new AtomicInteger(0);
    private AtomicInteger assuredSdAcknowledgedUpdates = new AtomicInteger(0);
    private AtomicInteger assuredSdTimeoutUpdates = new AtomicInteger(0);
    private Map<Integer, Integer> assuredSdServerTimeoutUpdates = new HashMap<Integer, Integer>();
    private Date lastStatusChangeDate = new Date();
    private final ServerState state;
    private final ChangeNumberGenerator generator;
    Set<String> cfgEclIncludes = new HashSet<String>();
    Set<String> eClIncludes = new HashSet<String>();

    public ChangeNumberGenerator getGenerator() {
        return this.generator;
    }

    public ReplicationDomain(String serviceID, int serverID) {
        this.serviceID = serviceID;
        this.serverID = serverID;
        this.state = new ServerState();
        this.generator = new ChangeNumberGenerator(serverID, this.state);
        domains.put(serviceID, this);
    }

    public ReplicationDomain(String serviceID, int serverID, ServerState serverState) {
        this.serviceID = serviceID;
        this.serverID = serverID;
        this.state = serverState;
        this.generator = new ChangeNumberGenerator(serverID, this.state);
        domains.put(serviceID, this);
    }

    public void sessionInitiated(ServerStatus initStatus, ServerState replicationServerState, long generationID, ProtocolSession session) {
        if (!StatusMachine.isValidInitialStatus(initStatus)) {
            Message msg = ReplicationMessages.ERR_DS_INVALID_INIT_STATUS.get(initStatus.toString(), this.serviceID, Integer.toString(this.serverID));
            ErrorLogger.logError(msg);
        } else {
            this.status = initStatus;
        }
        this.generator.adjust(this.state);
        this.generator.adjust(replicationServerState);
    }

    private void receiveChangeStatus(ChangeStatusMsg csMsg) {
        ServerStatus reqStatus;
        StatusMachineEvent event;
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Replication domain " + this.serviceID + " received change status message:\n" + csMsg);
        }
        if ((event = StatusMachineEvent.statusToEvent(reqStatus = csMsg.getRequestedStatus())) == StatusMachineEvent.INVALID_EVENT) {
            Message msg = ReplicationMessages.ERR_DS_INVALID_REQUESTED_STATUS.get(reqStatus.toString(), this.serviceID, Integer.toString(this.serverID));
            ErrorLogger.logError(msg);
            return;
        }
        this.setNewStatus(event);
    }

    void toNotConnectedStatus() {
        this.setNewStatus(StatusMachineEvent.TO_NOT_CONNECTED_STATUS_EVENT);
    }

    private void updateDomainForNewStatus() {
        switch (this.status) {
            case NOT_CONNECTED_STATUS: {
                break;
            }
            case NORMAL_STATUS: {
                break;
            }
            case DEGRADED_STATUS: {
                break;
            }
            case FULL_UPDATE_STATUS: {
                this.broker.signalStatusChange(this.status);
                break;
            }
            case BAD_GEN_ID_STATUS: {
                break;
            }
            default: {
                if (!DebugLogger.debugEnabled()) break;
                TRACER.debugInfo("updateDomainForNewStatus: unexpected status: " + (Object)((Object)this.status));
            }
        }
    }

    public ServerStatus getStatus() {
        return this.status;
    }

    public String getServiceID() {
        return this.serviceID;
    }

    public int getServerId() {
        return this.serverID;
    }

    public boolean isAssured() {
        return this.assured;
    }

    public AssuredMode getAssuredMode() {
        return this.assuredMode;
    }

    public byte getAssuredSdLevel() {
        return this.assuredSdLevel;
    }

    public long getAssuredTimeout() {
        return this.assuredTimeout;
    }

    public byte getGroupId() {
        return this.groupId;
    }

    public List<String> getRefUrls() {
        return this.refUrls;
    }

    public List<DSInfo> getReplicasList() {
        return this.broker.getDsList();
    }

    public Map<Integer, ServerState> getReplicaStates() {
        return this.broker.getReplicaStates();
    }

    public List<RSInfo> getRsList() {
        return this.broker.getRsList();
    }

    public int getRsServerId() {
        return this.broker.getRsServerId();
    }

    private void incProcessedUpdates() {
        this.numProcessedUpdates.incrementAndGet();
    }

    int getNumProcessedUpdates() {
        if (this.numProcessedUpdates != null) {
            return this.numProcessedUpdates.get();
        }
        return 0;
    }

    int getNumRcvdUpdates() {
        if (this.numRcvdUpdates != null) {
            return this.numRcvdUpdates.get();
        }
        return 0;
    }

    int getNumSentUpdates() {
        if (this.numSentUpdates != null) {
            return this.numSentUpdates.get();
        }
        return 0;
    }

    public void setURLs(Set<String> referralsUrl) {
        for (String url : referralsUrl) {
            this.refUrls.add(url);
        }
    }

    public void setAssuredTimeout(long assuredTimeout) {
        this.assuredTimeout = assuredTimeout;
    }

    public void setGroupId(byte groupId) {
        this.groupId = groupId;
    }

    public void setAssuredSdLevel(byte assuredSdLevel) {
        this.assuredSdLevel = assuredSdLevel;
    }

    public void setAssuredMode(AssuredMode dataMode) {
        this.assuredMode = dataMode;
    }

    public void setAssured(boolean assured) {
        this.assured = assured;
    }

    UpdateMsg receive() {
        UpdateMsg update = null;
        while (update == null) {
            RoutableMsg initMsg = null;
            try {
                ReplicationMsg msg = this.broker.receive(true);
                if (msg == null) {
                    return null;
                }
                if (DebugLogger.debugEnabled() && !(msg instanceof HeartbeatMsg)) {
                    TRACER.debugVerbose("Message received <" + msg + ">");
                }
                if (msg instanceof AckMsg) {
                    AckMsg ack = (AckMsg)msg;
                    this.receiveAck(ack);
                } else if (msg instanceof InitializeRequestMsg) {
                    initMsg = (InitializeRequestMsg)msg;
                } else if (msg instanceof InitializeTargetMsg) {
                    InitializeTargetMsg importMsg = (InitializeTargetMsg)msg;
                    try {
                        this.initialize(importMsg);
                    }
                    catch (DirectoryException de) {
                        ErrorMsg errorMsg = new ErrorMsg(importMsg.getsenderID(), de.getMessageObject());
                        MessageBuilder mb = new MessageBuilder();
                        mb.append(de.getMessageObject());
                        TRACER.debugInfo(Message.toString(mb.toMessage()));
                        this.broker.publish(errorMsg);
                        ErrorLogger.logError(de.getMessageObject());
                    }
                } else if (msg instanceof ErrorMsg) {
                    if (this.ieContext != null) {
                        this.abandonImportExport((ErrorMsg)msg);
                    } else {
                        ErrorMsg errorMsg = (ErrorMsg)msg;
                        ErrorLogger.logError(ReplicationMessages.ERR_ERROR_MSG_RECEIVED.get(errorMsg.getDetails()));
                    }
                } else if (msg instanceof ChangeStatusMsg) {
                    ChangeStatusMsg csMsg = (ChangeStatusMsg)msg;
                    this.receiveChangeStatus(csMsg);
                } else if (msg instanceof UpdateMsg) {
                    update = (UpdateMsg)msg;
                    this.generator.adjust(update.getChangeNumber());
                }
            }
            catch (SocketTimeoutException e) {
                // empty catch block
            }
            if (initMsg == null) continue;
            ExportThread exportThread = new ExportThread(initMsg.getsenderID());
            exportThread.start();
        }
        this.numRcvdUpdates.incrementAndGet();
        byte rsGroupId = this.broker.getRsGroupId();
        if (update.isAssured() && update.getAssuredMode() == AssuredMode.SAFE_READ_MODE && rsGroupId == this.groupId) {
            this.assuredSrReceivedUpdates.incrementAndGet();
        }
        return update;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAssuredErrorsByServer(Map<Integer, Integer> errorsByServer, Integer sid) {
        Map<Integer, Integer> map = errorsByServer;
        synchronized (map) {
            Integer serverErrCount = errorsByServer.get(sid);
            if (serverErrCount == null) {
                errorsByServer.put(sid, 1);
            } else {
                int val = serverErrCount;
                errorsByServer.put(sid, ++val);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveAck(AckMsg ack) {
        block20: {
            AssuredMode updateAssuredMode;
            block21: {
                UpdateMsg update;
                ChangeNumber changeNumber = ack.getChangeNumber();
                Object object = this.waitingAckMsgs;
                synchronized (object) {
                    update = (UpdateMsg)this.waitingAckMsgs.remove(changeNumber);
                }
                if (update == null) break block20;
                object = update;
                synchronized (object) {
                    update.notify();
                }
                boolean hasTimeout = ack.hasTimeout();
                boolean hasReplayErrors = ack.hasReplayError();
                boolean hasWrongStatus = ack.hasWrongStatus();
                updateAssuredMode = update.getAssuredMode();
                if (!hasTimeout && !hasReplayErrors && !hasWrongStatus) break block21;
                Message errorMsg = ReplicationMessages.NOTE_DS_RECEIVED_ACK_ERROR.get(this.serviceID, Integer.toString(this.serverID), update.toString(), ack.errorsToString());
                ErrorLogger.logError(errorMsg);
                List<Integer> failedServers = ack.getFailedServers();
                switch (updateAssuredMode) {
                    case SAFE_READ_MODE: {
                        this.assuredSrNotAcknowledgedUpdates.incrementAndGet();
                        if (hasTimeout) {
                            this.assuredSrTimeoutUpdates.incrementAndGet();
                        }
                        if (hasReplayErrors) {
                            this.assuredSrReplayErrorUpdates.incrementAndGet();
                        }
                        if (hasWrongStatus) {
                            this.assuredSrWrongStatusUpdates.incrementAndGet();
                        }
                        if (failedServers == null) break;
                        for (Integer sid : failedServers) {
                            this.updateAssuredErrorsByServer(this.assuredSrServerNotAcknowledgedUpdates, sid);
                        }
                        break block20;
                    }
                    case SAFE_DATA_MODE: {
                        if (hasTimeout) {
                            this.assuredSdTimeoutUpdates.incrementAndGet();
                        }
                        if (failedServers == null) break;
                        for (Integer sid : failedServers) {
                            this.updateAssuredErrorsByServer(this.assuredSdServerTimeoutUpdates, sid);
                        }
                        break block20;
                    }
                }
                break block20;
            }
            switch (updateAssuredMode) {
                case SAFE_READ_MODE: {
                    this.assuredSrAcknowledgedUpdates.incrementAndGet();
                    break;
                }
                case SAFE_DATA_MODE: {
                    this.assuredSdAcknowledgedUpdates.incrementAndGet();
                    break;
                }
            }
        }
    }

    static ReplicationDomain retrievesReplicationDomain(String serviceID) throws DirectoryException {
        ReplicationDomain replicationDomain = domains.get(serviceID);
        if (replicationDomain == null) {
            throw new DirectoryException(ResultCode.OTHER, ReplicationMessages.ERR_NO_MATCHING_DOMAIN.get(serviceID));
        }
        return replicationDomain;
    }

    public int decodeTarget(String targetString) throws DirectoryException {
        int target = 0;
        if (targetString.equalsIgnoreCase("all")) {
            return -2;
        }
        try {
            target = Integer.decode(targetString);
            if (target >= 0) {
                // empty if block
            }
            return target;
        }
        catch (Exception e) {
            Exception cause = e;
            ResultCode resultCode = ResultCode.OTHER;
            Message message = ReplicationMessages.ERR_INVALID_EXPORT_TARGET.get();
            if (cause != null) {
                throw new DirectoryException(resultCode, message, cause);
            }
            throw new DirectoryException(resultCode, message);
        }
    }

    public void initializeRemote(int target, Task initTask) throws DirectoryException {
        this.initializeRemote(target, this.serverID, initTask);
        if (target == -2) {
            boolean done = true;
            block2: do {
                done = true;
                for (DSInfo dsi : this.getReplicasList()) {
                    if (dsi.getStatus() != ServerStatus.FULL_UPDATE_STATUS) continue;
                    done = false;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {}
                    continue block2;
                }
            } while (!done);
        }
    }

    protected void initializeRemote(int target, int target2, Task initTask) throws DirectoryException {
        Message msg = ReplicationMessages.NOTE_FULL_UPDATE_ENGAGED_FOR_REMOTE_START.get(Integer.toString(this.serverID), this.serviceID, Integer.toString(target2));
        ErrorLogger.logError(msg);
        boolean contextAcquired = false;
        this.acquireIEContext(false);
        contextAcquired = true;
        this.ieContext.exportTarget = target;
        if (initTask != null) {
            this.ieContext.initializeTask = initTask;
        }
        long entryCount = this.countEntries();
        this.ieContext.setCounters(entryCount, entryCount);
        InitializeTargetMsg initializeMessage = new InitializeTargetMsg(this.serviceID, this.serverID, target, target2, entryCount);
        this.broker.publish(initializeMessage);
        try {
            this.exportBackend(new BufferedOutputStream(new ReplOutputStream(this)));
            DoneMsg doneMsg = new DoneMsg(this.serverID, initializeMessage.getDestination());
            this.broker.publish(doneMsg);
            this.releaseIEContext();
        }
        catch (DirectoryException de) {
            ErrorMsg errorMsg = new ErrorMsg(target, de.getMessageObject());
            this.broker.publish(errorMsg);
            if (contextAcquired) {
                this.releaseIEContext();
            }
            throw de;
        }
        msg = ReplicationMessages.NOTE_FULL_UPDATE_ENGAGED_FOR_REMOTE_END.get(Integer.toString(this.serverID), this.serviceID, Integer.toString(target2));
        ErrorLogger.logError(msg);
    }

    public ServerState getServerState() {
        return this.state;
    }

    private synchronized void acquireIEContext(boolean importInProgress) throws DirectoryException {
        if (this.ieContext != null) {
            Message message = ReplicationMessages.ERR_SIMULTANEOUS_IMPORT_EXPORT_REJECTED.get();
            throw new DirectoryException(ResultCode.OTHER, message);
        }
        this.ieContext = new IEContext(importInProgress);
    }

    private synchronized void releaseIEContext() {
        this.ieContext = null;
    }

    void abandonImportExport(ErrorMsg errorMsg) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugVerbose(" abandonImportExport:" + this.serverID + " serviceID: " + this.serviceID + " Error Msg received: " + errorMsg);
        }
        if (this.ieContext != null) {
            this.ieContext.setException(new DirectoryException(ResultCode.OTHER, errorMsg.getDetails()));
            if (this.ieContext.initializeTask instanceof InitializeTask) {
                ((InitializeTask)this.ieContext.initializeTask).updateTaskCompletionState(this.ieContext.getException());
                this.releaseIEContext();
            }
        }
    }

    protected byte[] receiveEntryBytes() {
        while (true) {
            try {
                ReplicationMsg msg;
                do {
                    msg = this.broker.receive();
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugVerbose(" sid:" + this.serverID + " base DN:" + this.serviceID + " Import EntryBytes received " + msg);
                    }
                    if (msg == null) {
                        return null;
                    }
                    if (msg instanceof EntryMsg) {
                        EntryMsg entryMsg = (EntryMsg)msg;
                        byte[] entryBytes = entryMsg.getEntryBytes();
                        this.ieContext.updateCounters(this.countEntryLimits(entryBytes));
                        return entryBytes;
                    }
                    if (!(msg instanceof DoneMsg)) continue;
                    return null;
                } while (!(msg instanceof ErrorMsg));
                ErrorMsg errorMsg = (ErrorMsg)msg;
                this.ieContext.setException(new DirectoryException(ResultCode.OTHER, errorMsg.getDetails()));
                return null;
            }
            catch (Exception e) {
                this.ieContext.setException(new DirectoryException(ResultCode.OTHER, Message.raw("received an unexpected message type" + e.getLocalizedMessage(), new Object[0])));
                continue;
            }
            break;
        }
    }

    private int countEntryLimits(byte[] entryBytes) {
        return this.countEntryLimits(entryBytes, 0, entryBytes.length);
    }

    private int countEntryLimits(byte[] entryBytes, int pos, int length) {
        int entryCount = 0;
        for (int count = 0; count <= length - 2; ++count) {
            if (entryBytes[pos + count] != 10 || entryBytes[pos + count + 1] != 10) continue;
            ++entryCount;
            ++count;
        }
        return entryCount;
    }

    void exportLDIFEntry(byte[] lDIFEntry, int pos, int length) throws IOException {
        if (this.ieContext.getException() != null) {
            IOException ioe = new IOException(this.ieContext.getException().getMessage());
            this.ieContext = null;
            throw ioe;
        }
        EntryMsg entryMessage = new EntryMsg(this.serverID, this.ieContext.getExportTarget(), lDIFEntry, pos, length);
        this.broker.publish(entryMessage);
        try {
            this.ieContext.updateCounters(this.countEntryLimits(lDIFEntry, pos, length));
        }
        catch (DirectoryException de) {
            throw new IOException(de.getMessage());
        }
    }

    public void initializeFromRemote(int source) throws DirectoryException {
        this.initializeFromRemote(source, null);
    }

    public void initializeRemote(int target) throws DirectoryException {
        this.initializeRemote(target, null);
    }

    public void initializeFromRemote(int source, Task initTask) throws DirectoryException {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Entering initializeFromRemote");
        }
        if (!this.broker.isConnected()) {
            if (initTask instanceof InitializeTask) {
                InitializeTask task = (InitializeTask)initTask;
                task.updateTaskCompletionState(new DirectoryException(ResultCode.OTHER, ReplicationMessages.ERR_INITIALIZATION_FAILED_NOCONN.get(this.getServiceID())));
            }
            return;
        }
        this.acquireIEContext(true);
        this.ieContext.initializeTask = initTask;
        InitializeRequestMsg initializeMsg = new InitializeRequestMsg(this.serviceID, this.serverID, source);
        this.broker.publish(initializeMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize(InitializeTargetMsg initializeMessage) throws DirectoryException {
        DirectoryException de = null;
        Message msg = ReplicationMessages.NOTE_FULL_UPDATE_ENGAGED_FROM_REMOTE_START.get(Integer.toString(this.serverID), this.serviceID, Long.toString(initializeMessage.getRequestorID()));
        ErrorLogger.logError(msg);
        this.setNewStatus(StatusMachineEvent.TO_FULL_UPDATE_STATUS_EVENT);
        if (initializeMessage.getRequestorID() != (long)this.serverID) {
            this.acquireIEContext(true);
        }
        this.ieContext.importSource = initializeMessage.getsenderID();
        this.ieContext.entryLeftCount = initializeMessage.getEntryCount();
        this.ieContext.setCounters(initializeMessage.getEntryCount(), initializeMessage.getEntryCount());
        try {
            this.importBackend(new ReplInputStream(this));
            this.broker.reStart();
        }
        catch (DirectoryException e) {
            de = e;
        }
        finally {
            if (this.ieContext != null && this.ieContext.getException() != null) {
                de = this.ieContext.getException();
            }
            if (this.ieContext != null && this.ieContext.initializeTask != null) {
                ((InitializeTask)this.ieContext.initializeTask).updateTaskCompletionState(de);
            }
            this.releaseIEContext();
        }
        if (de != null) {
            throw de;
        }
        msg = ReplicationMessages.NOTE_FULL_UPDATE_ENGAGED_FROM_REMOTE_END.get(Integer.toString(this.serverID), this.serviceID, Long.toString(initializeMessage.getRequestorID()));
        ErrorLogger.logError(msg);
    }

    protected void setNewStatus(StatusMachineEvent event) {
        ServerStatus newStatus = StatusMachine.computeNewStatus(this.status, event);
        if (newStatus == ServerStatus.INVALID_STATUS) {
            Message msg = ReplicationMessages.ERR_DS_CANNOT_CHANGE_STATUS.get(this.serviceID, Integer.toString(this.serverID), this.status.toString(), event.toString());
            ErrorLogger.logError(msg);
            return;
        }
        if (newStatus != this.status) {
            this.lastStatusChangeDate = new Date();
            if (newStatus == ServerStatus.NOT_CONNECTED_STATUS) {
                this.resetMonitoringCounters();
            }
            this.status = newStatus;
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Replication domain " + this.serviceID + " new status is: " + (Object)((Object)this.status));
            }
            this.updateDomainForNewStatus();
        }
    }

    public boolean ieRunning() {
        return this.ieContext != null;
    }

    private void checkGenerationID(long generationID) throws DirectoryException {
        boolean allset = true;
        for (int i = 0; i < 10; ++i) {
            allset = true;
            for (RSInfo rsInfo : this.getRsList()) {
                if (rsInfo.getGenerationId() == generationID) continue;
                try {
                    Thread.sleep(i * 100);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                allset = false;
                break;
            }
            if (allset) break;
        }
        if (!allset) {
            ResultCode resultCode = ResultCode.OTHER;
            Message message = ReplicationMessages.ERR_RESET_GENERATION_ID_FAILED.get(this.serviceID);
            throw new DirectoryException(resultCode, message);
        }
    }

    public void resetReplicationLog() throws DirectoryException {
        this.resetGenerationId(-1L);
        this.checkGenerationID(-1L);
        this.disableService();
        this.enableService();
        int count = 0;
        while (!this.isConnected() && count < 10) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.resetGenerationId(this.getGenerationID());
        this.checkGenerationID(this.getGenerationID());
    }

    public void resetGenerationId(Long generationIdNewValue) throws DirectoryException {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Server id " + this.serverID + " and domain " + this.serviceID + "resetGenerationId" + generationIdNewValue);
        }
        if (!this.isConnected()) {
            ResultCode resultCode = ResultCode.OTHER;
            Message message = ReplicationMessages.ERR_RESET_GENERATION_CONN_ERR_ID.get(this.serviceID);
            throw new DirectoryException(resultCode, message);
        }
        ResetGenerationIdMsg genIdMessage = null;
        genIdMessage = generationIdNewValue == null ? new ResetGenerationIdMsg(this.getGenerationID()) : new ResetGenerationIdMsg(generationIdNewValue);
        this.broker.publish(genIdMessage);
        if (generationIdNewValue == null) {
            this.checkGenerationID(this.getGenerationID());
        } else {
            this.checkGenerationID(generationIdNewValue);
        }
    }

    int getMaxRcvWindow() {
        if (this.broker != null) {
            return this.broker.getMaxRcvWindow();
        }
        return 0;
    }

    int getCurrentRcvWindow() {
        if (this.broker != null) {
            return this.broker.getCurrentRcvWindow();
        }
        return 0;
    }

    int getMaxSendWindow() {
        if (this.broker != null) {
            return this.broker.getMaxSendWindow();
        }
        return 0;
    }

    int getCurrentSendWindow() {
        if (this.broker != null) {
            return this.broker.getCurrentSendWindow();
        }
        return 0;
    }

    int getNumLostConnections() {
        if (this.broker != null) {
            return this.broker.getNumLostConnections();
        }
        return 0;
    }

    boolean isSessionEncrypted() {
        if (this.broker != null) {
            return this.broker.isSessionEncrypted();
        }
        return false;
    }

    void processUpdateDoneSynchronous(UpdateMsg msg) {
        this.processUpdateDone(msg, null);
        this.state.update(msg.getChangeNumber());
    }

    public boolean isConnected() {
        if (this.broker != null) {
            return this.broker.isConnected();
        }
        return false;
    }

    public boolean hasConnectionError() {
        if (this.broker != null) {
            return this.broker.hasConnectionError();
        }
        return true;
    }

    public String getReplicationServer() {
        if (this.broker != null) {
            return this.broker.getReplicationServer();
        }
        return "Not connected";
    }

    public int getAssuredSrSentUpdates() {
        return this.assuredSrSentUpdates.get();
    }

    public int getAssuredSrAcknowledgedUpdates() {
        return this.assuredSrAcknowledgedUpdates.get();
    }

    public int getAssuredSrNotAcknowledgedUpdates() {
        return this.assuredSrNotAcknowledgedUpdates.get();
    }

    public int getAssuredSrTimeoutUpdates() {
        return this.assuredSrTimeoutUpdates.get();
    }

    public int getAssuredSrWrongStatusUpdates() {
        return this.assuredSrWrongStatusUpdates.get();
    }

    public int getAssuredSrReplayErrorUpdates() {
        return this.assuredSrReplayErrorUpdates.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Integer> getAssuredSrServerNotAcknowledgedUpdates() {
        HashMap<Integer, Integer> snapshot = new HashMap<Integer, Integer>();
        Map<Integer, Integer> map = this.assuredSrServerNotAcknowledgedUpdates;
        synchronized (map) {
            Set<Integer> keySet = this.assuredSrServerNotAcknowledgedUpdates.keySet();
            for (Integer serverId : keySet) {
                Integer i = this.assuredSrServerNotAcknowledgedUpdates.get(serverId);
                snapshot.put(serverId, i);
            }
        }
        return snapshot;
    }

    public int getAssuredSrReceivedUpdates() {
        return this.assuredSrReceivedUpdates.get();
    }

    public int getAssuredSrReceivedUpdatesAcked() {
        return this.assuredSrReceivedUpdatesAcked.get();
    }

    public int getAssuredSrReceivedUpdatesNotAcked() {
        return this.assuredSrReceivedUpdatesNotAcked.get();
    }

    public int getAssuredSdSentUpdates() {
        return this.assuredSdSentUpdates.get();
    }

    public int getAssuredSdAcknowledgedUpdates() {
        return this.assuredSdAcknowledgedUpdates.get();
    }

    public int getAssuredSdTimeoutUpdates() {
        return this.assuredSdTimeoutUpdates.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, Integer> getAssuredSdServerTimeoutUpdates() {
        HashMap<Integer, Integer> snapshot = new HashMap<Integer, Integer>();
        Map<Integer, Integer> map = this.assuredSdServerTimeoutUpdates;
        synchronized (map) {
            Set<Integer> keySet = this.assuredSdServerTimeoutUpdates.keySet();
            for (Integer serverId : keySet) {
                Integer i = this.assuredSdServerTimeoutUpdates.get(serverId);
                snapshot.put(serverId, i);
            }
        }
        return snapshot;
    }

    public Date getLastStatusChangeDate() {
        return this.lastStatusChangeDate;
    }

    private void resetMonitoringCounters() {
        this.numProcessedUpdates = new AtomicInteger(0);
        this.numRcvdUpdates = new AtomicInteger(0);
        this.numSentUpdates = new AtomicInteger(0);
        this.assuredSrSentUpdates = new AtomicInteger(0);
        this.assuredSrAcknowledgedUpdates = new AtomicInteger(0);
        this.assuredSrNotAcknowledgedUpdates = new AtomicInteger(0);
        this.assuredSrTimeoutUpdates = new AtomicInteger(0);
        this.assuredSrWrongStatusUpdates = new AtomicInteger(0);
        this.assuredSrReplayErrorUpdates = new AtomicInteger(0);
        this.assuredSrServerNotAcknowledgedUpdates = new HashMap<Integer, Integer>();
        this.assuredSrReceivedUpdates = new AtomicInteger(0);
        this.assuredSrReceivedUpdatesAcked = new AtomicInteger(0);
        this.assuredSrReceivedUpdatesNotAcked = new AtomicInteger(0);
        this.assuredSdSentUpdates = new AtomicInteger(0);
        this.assuredSdAcknowledgedUpdates = new AtomicInteger(0);
        this.assuredSdTimeoutUpdates = new AtomicInteger(0);
        this.assuredSdServerTimeoutUpdates = new HashMap<Integer, Integer>();
    }

    public void startPublishService(Collection<String> replicationServers, int window, long heartbeatInterval, long changetimeHeartbeatInterval) throws ConfigException {
        if (this.broker == null) {
            this.broker = new ReplicationBroker(this, this.state, this.serviceID, this.serverID, window, this.getGenerationID(), heartbeatInterval, new ReplSessionSecurity(), this.getGroupId(), changetimeHeartbeatInterval);
            this.broker.start(replicationServers);
            this.monitor = new ReplicationMonitor(this);
            DirectoryServer.registerMonitorProvider(this.monitor);
        }
    }

    public void startPublishService(Collection<String> replicationServers, int window, long heartbeatInterval) throws ConfigException {
        if (this.broker == null) {
            this.broker = new ReplicationBroker(this, this.state, this.serviceID, this.serverID, window, this.getGenerationID(), heartbeatInterval, new ReplSessionSecurity(), this.getGroupId(), 0L);
            this.broker.start(replicationServers);
            this.monitor = new ReplicationMonitor(this);
            DirectoryServer.registerMonitorProvider(this.monitor);
        }
    }

    public void startListenService() {
        this.listenerThread = new ListenerThread(this);
        this.listenerThread.start();
    }

    public void disableService() {
        if (this.listenerThread != null) {
            this.listenerThread.shutdown();
        }
        if (this.broker != null) {
            this.broker.stop();
        }
        if (this.listenerThread != null) {
            this.listenerThread.waitForShutdown();
        }
    }

    public void enableService() {
        this.broker.start();
        this.listenerThread = new ListenerThread(this);
        this.listenerThread.start();
    }

    public void stopDomain() {
        DirectoryServer.deregisterMonitorProvider(this.monitor.getMonitorInstanceName());
        this.disableService();
        domains.remove(this.serviceID);
    }

    public void changeConfig(Collection<String> replicationServers, int windowSize, long heartbeatInterval, byte groupId) {
        this.groupId = groupId;
        if (this.broker != null && this.broker.changeConfig(replicationServers, windowSize, heartbeatInterval, groupId)) {
            this.disableService();
            this.enableService();
        }
    }

    protected abstract void exportBackend(OutputStream var1) throws DirectoryException;

    protected abstract void importBackend(InputStream var1) throws DirectoryException;

    public abstract long countEntries() throws DirectoryException;

    public abstract boolean processUpdate(UpdateMsg var1);

    public void processUpdateDone(UpdateMsg msg, String replayErrorMsg) {
        this.broker.updateWindowAfterReplay();
        byte rsGroupId = this.broker.getRsGroupId();
        if (msg.isAssured() && this.broker.getProtocolVersion() >= 2) {
            AssuredMode msgAssuredMode = msg.getAssuredMode();
            if (msgAssuredMode == AssuredMode.SAFE_READ_MODE) {
                if (rsGroupId == this.groupId) {
                    AckMsg ackMsg = new AckMsg(msg.getChangeNumber());
                    if (replayErrorMsg != null) {
                        ackMsg.setHasReplayError(true);
                        ArrayList<Integer> idList = new ArrayList<Integer>();
                        idList.add(this.serverID);
                        ackMsg.setFailedServers(idList);
                    }
                    this.broker.publish(ackMsg);
                    if (replayErrorMsg != null) {
                        this.assuredSrReceivedUpdatesNotAcked.incrementAndGet();
                    } else {
                        this.assuredSrReceivedUpdatesAcked.incrementAndGet();
                    }
                }
            } else if (this.assuredMode != AssuredMode.SAFE_DATA_MODE) {
                Message errorMsg = ReplicationMessages.ERR_DS_UNKNOWN_ASSURED_MODE.get(Integer.toString(this.serverID), msgAssuredMode.toString(), this.serviceID, msg.toString());
                ErrorLogger.logError(errorMsg);
            }
        }
        this.incProcessedUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareWaitForAckIfAssuredEnabled(UpdateMsg msg) {
        byte rsGroupId = this.broker.getRsGroupId();
        if (this.assured && rsGroupId == this.groupId) {
            msg.setAssured(true);
            msg.setAssuredMode(this.assuredMode);
            if (this.assuredMode == AssuredMode.SAFE_DATA_MODE) {
                msg.setSafeDataLevel(this.assuredSdLevel);
            }
            SortedMap<ChangeNumber, UpdateMsg> sortedMap = this.waitingAckMsgs;
            synchronized (sortedMap) {
                this.waitingAckMsgs.put(msg.getChangeNumber(), msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForAckIfAssuredEnabled(UpdateMsg msg) throws TimeoutException {
        byte rsGroupId = this.broker.getRsGroupId();
        if (this.assured && rsGroupId == this.groupId) {
            switch (this.assuredMode) {
                case SAFE_READ_MODE: {
                    this.assuredSrSentUpdates.incrementAndGet();
                    break;
                }
                case SAFE_DATA_MODE: {
                    this.assuredSdSentUpdates.incrementAndGet();
                    break;
                }
            }
        } else {
            return;
        }
        long startTime = System.currentTimeMillis();
        UpdateMsg updateMsg = msg;
        synchronized (updateMsg) {
            ChangeNumber cn = msg.getChangeNumber();
            while (this.waitingAckMsgs.containsKey(cn)) {
                UpdateMsg update;
                try {
                    msg.wait(10L);
                }
                catch (InterruptedException e) {
                    if (!DebugLogger.debugEnabled()) break;
                    TRACER.debugInfo("waitForAck method interrupted for replication serviceID: " + this.serviceID);
                    break;
                }
                if (System.currentTimeMillis() - startTime < this.assuredTimeout) continue;
                SortedMap<ChangeNumber, UpdateMsg> sortedMap = this.waitingAckMsgs;
                synchronized (sortedMap) {
                    update = (UpdateMsg)this.waitingAckMsgs.remove(cn);
                }
                if (update == null) break;
                switch (msg.getAssuredMode()) {
                    case SAFE_READ_MODE: {
                        this.assuredSrNotAcknowledgedUpdates.incrementAndGet();
                        this.assuredSrTimeoutUpdates.incrementAndGet();
                        this.updateAssuredErrorsByServer(this.assuredSrServerNotAcknowledgedUpdates, this.broker.getRsServerId());
                        break;
                    }
                    case SAFE_DATA_MODE: {
                        this.assuredSdTimeoutUpdates.incrementAndGet();
                        this.updateAssuredErrorsByServer(this.assuredSdServerTimeoutUpdates, this.broker.getRsServerId());
                        break;
                    }
                }
                throw new TimeoutException("No ack received for message cn: " + cn + " and replication servceID: " + this.serviceID + " after " + this.assuredTimeout + " ms.");
            }
        }
    }

    public void publish(UpdateMsg msg) {
        this.broker.publish(msg);
        this.state.update(msg.getChangeNumber());
        this.numSentUpdates.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(byte[] msg) {
        UpdateMsg update;
        ReplicationDomain replicationDomain = this;
        synchronized (replicationDomain) {
            update = new UpdateMsg(this.generator.newChangeNumber(), msg);
            this.prepareWaitForAckIfAssuredEnabled(update);
            this.publish(update);
        }
        try {
            this.waitForAckIfAssuredEnabled(update);
        }
        catch (TimeoutException ex) {
            Message errorMsg = ReplicationMessages.NOTE_DS_ACK_TIMEOUT.get(this.serviceID, Long.toString(this.assuredTimeout), msg.toString());
            ErrorLogger.logError(errorMsg);
        }
    }

    public abstract long getGenerationID();

    public Collection<Attribute> getAdditionalMonitoring() {
        return new ArrayList<Attribute>();
    }

    public boolean importInProgress() {
        if (this.ieContext == null) {
            return false;
        }
        return this.ieContext.importInProgress;
    }

    public boolean exportInProgress() {
        if (this.ieContext == null) {
            return false;
        }
        return !this.ieContext.importInProgress;
    }

    long getLeftEntryCount() {
        if (this.ieContext != null) {
            return this.ieContext.entryLeftCount;
        }
        return 0L;
    }

    long getTotalEntryCount() {
        if (this.ieContext != null) {
            return this.ieContext.entryCount;
        }
        return 0L;
    }

    public synchronized void addEclInclude(String attribute) {
        this.eClIncludes.add(attribute);
    }

    public Set<String> getEclInclude() {
        return this.eClIncludes;
    }

    public ChangeNumber getLastLocalChange() {
        return this.state.getMaxChangeNumber(this.serverID);
    }

    protected class IEContext {
        Task initializeTask;
        int exportTarget = -1;
        int importSource = -1;
        long entryCount = 0L;
        long entryLeftCount = 0L;
        DirectoryException exception = null;
        boolean importInProgress;

        public IEContext(boolean importInProgress) {
            this.importInProgress = importInProgress;
        }

        public void setCounters(long total, long left) throws DirectoryException {
            this.entryCount = total;
            this.entryLeftCount = left;
            if (this.initializeTask != null) {
                if (this.initializeTask instanceof InitializeTask) {
                    ((InitializeTask)this.initializeTask).setTotal(this.entryCount);
                    ((InitializeTask)this.initializeTask).setLeft(this.entryCount);
                } else if (this.initializeTask instanceof InitializeTargetTask) {
                    ((InitializeTargetTask)this.initializeTask).setTotal(this.entryCount);
                    ((InitializeTargetTask)this.initializeTask).setLeft(this.entryCount);
                }
            }
        }

        public void updateCounters() throws DirectoryException {
            --this.entryLeftCount;
            if (this.initializeTask != null) {
                if (this.initializeTask instanceof InitializeTask) {
                    ((InitializeTask)this.initializeTask).setLeft(this.entryLeftCount);
                } else if (this.initializeTask instanceof InitializeTargetTask) {
                    ((InitializeTargetTask)this.initializeTask).setLeft(this.entryLeftCount);
                }
            }
        }

        public void updateCounters(int entriesDone) throws DirectoryException {
            this.entryLeftCount -= (long)entriesDone;
            if (this.initializeTask != null) {
                if (this.initializeTask instanceof InitializeTask) {
                    ((InitializeTask)this.initializeTask).setLeft(this.entryLeftCount);
                } else if (this.initializeTask instanceof InitializeTargetTask) {
                    ((InitializeTargetTask)this.initializeTask).setLeft(this.entryLeftCount);
                }
            }
        }

        public String toString() {
            return new String("[ Entry count=" + this.entryCount + ", Entry left count=" + this.entryLeftCount + "]");
        }

        public int getExportTarget() {
            return this.exportTarget;
        }

        public int getImportSource() {
            return this.importSource;
        }

        public DirectoryException getException() {
            return this.exception;
        }

        public void setException(DirectoryException exception) {
            this.exception = exception;
        }
    }

    private class ExportThread
    extends DirectoryThread {
        private int target;

        public ExportThread(int i) {
            super("Export thread " + ReplicationDomain.this.serverID);
            this.target = i;
        }

        public void run() {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Export thread starting.");
            }
            try {
                ReplicationDomain.this.initializeRemote(this.target, this.target, null);
            }
            catch (DirectoryException directoryException) {
                // empty catch block
            }
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo("Export thread stopping.");
            }
        }
    }
}

