/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.service;

import java.io.IOException;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.protocol.ChangeTimeHeartbeatMsg;
import org.opends.server.replication.protocol.ProtocolSession;
import org.opends.server.util.TimeThread;

public class CTHeartbeatPublisherThread
extends DirectoryThread {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static boolean heartbeatsDisabled = false;
    private ProtocolSession session;
    private long heartbeatInterval;
    private int serverId;
    private Boolean shutdown = false;
    private final Object shutdown_lock = new Object();

    public CTHeartbeatPublisherThread(String threadName, ProtocolSession session, long heartbeatInterval, int serverId2) {
        super(threadName);
        this.session = session;
        this.heartbeatInterval = heartbeatInterval;
        this.serverId = serverId2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo(this.getName() + " is starting, interval is %d", this.heartbeatInterval);
            }
            while (!this.shutdown.booleanValue()) {
                long now = System.currentTimeMillis();
                ChangeTimeHeartbeatMsg ctHeartbeatMsg = new ChangeTimeHeartbeatMsg(new ChangeNumber(TimeThread.getTime(), 0, this.serverId));
                if (now > this.session.getLastPublishTime() + this.heartbeatInterval && !heartbeatsDisabled) {
                    this.session.publish(ctHeartbeatMsg);
                }
                try {
                    long sleepTime = this.session.getLastPublishTime() + this.heartbeatInterval - now;
                    if (sleepTime <= 0L) {
                        sleepTime = this.heartbeatInterval;
                    }
                    Object object = this.shutdown_lock;
                    synchronized (object) {
                        if (!this.shutdown.booleanValue()) {
                            this.shutdown_lock.wait(sleepTime);
                        }
                    }
                }
                catch (InterruptedException e) {
                }
            }
        }
        catch (IOException e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo(this.getName() + "could not send a heartbeat." + e.getMessage() + e.toString());
            }
        }
        finally {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugInfo(this.getName() + " is exiting.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.shutdown_lock;
        synchronized (object) {
            this.shutdown = true;
            this.shutdown_lock.notifyAll();
        }
    }

    public static void setHeartbeatsDisabled(boolean heartbeatsDisabled) {
        CTHeartbeatPublisherThread.heartbeatsDisabled = heartbeatsDisabled;
    }
}

