/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.io.IOException;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.protocol.MonitorMsg;
import org.opends.server.replication.server.DataServerHandler;
import org.opends.server.replication.server.ReplicationServerDomain;

public class MonitoringPublisher
extends DirectoryThread {
    private boolean shutdown = false;
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ReplicationServerDomain replicationServerDomain;
    private long period = 3000L;
    private boolean done = false;
    private final Object sleeper = new Object();

    public MonitoringPublisher(ReplicationServerDomain replicationServerDomain, long period) {
        super("Monitoring publisher for " + replicationServerDomain.getBaseDn() + " in RS " + replicationServerDomain.getReplicationServer().getServerId());
        this.replicationServerDomain = replicationServerDomain;
        this.period = period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Monitoring publisher starting for dn " + this.replicationServerDomain.getBaseDn().toString());
        }
        while (!this.shutdown) {
            try {
                Object object = this.sleeper;
                synchronized (object) {
                    this.sleeper.wait(this.period);
                }
            }
            catch (InterruptedException ex) {
                TRACER.debugInfo("Monitoring publisher for dn " + this.replicationServerDomain.getBaseDn().toString() + " in RS " + this.replicationServerDomain.getReplicationServer().getServerId() + " has been interrupted while sleeping.");
            }
            MonitorMsg monitorMsg = this.replicationServerDomain.createGlobalTopologyMonitorMsg(0, 0);
            int localServerId = this.replicationServerDomain.getReplicationServer().getServerId();
            if (monitorMsg == null) continue;
            for (DataServerHandler serverHandler : this.replicationServerDomain.getConnectedDSs().values()) {
                monitorMsg.setSenderID(localServerId);
                monitorMsg.setDestination(serverHandler.getServerId());
                try {
                    serverHandler.send(monitorMsg);
                }
                catch (IOException e) {}
            }
        }
        this.done = true;
        TRACER.debugInfo("Monitoring publisher for dn " + this.replicationServerDomain.getBaseDn().toString() + " is terminated." + " This is in RS " + this.replicationServerDomain.getReplicationServer().getServerId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Shutting down monitoring publisher for dn " + this.replicationServerDomain.getBaseDn().toString() + " in RS " + this.replicationServerDomain.getReplicationServer().getServerId());
        }
        this.shutdown = true;
        Object object = this.sleeper;
        synchronized (object) {
            this.sleeper.notify();
        }
    }

    public void waitForShutdown() {
        try {
            int FACTOR = 40;
            int n = 0;
            while (!this.done && this.isAlive()) {
                Thread.sleep(50L);
                if (++n < FACTOR) continue;
                TRACER.debugInfo("Interrupting monitoring publisher for dn " + this.replicationServerDomain.getBaseDn().toString() + " in RS " + this.replicationServerDomain.getReplicationServer().getServerId());
                this.interrupt();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setPeriod(long period) {
        if (DebugLogger.debugEnabled()) {
            TRACER.debugInfo("Monitoring publisher for dn " + this.replicationServerDomain.getBaseDn().toString() + " changing period value to " + period);
        }
        this.period = period;
    }
}

