/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.server;

import java.util.ArrayList;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opends.messages.Message;
import org.opends.messages.ReplicationMessages;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.protocol.UpdateMsg;
import org.opends.server.replication.server.MsgQueue;
import org.opends.server.replication.server.ReplicationIterator;
import org.opends.server.replication.server.ReplicationIteratorComparator;
import org.opends.server.replication.server.ReplicationServer;
import org.opends.server.replication.server.ReplicationServerDomain;
import org.opends.server.types.Attribute;
import org.opends.server.types.Attributes;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageHandler
extends MonitorProvider<MonitorProviderCfg> {
    protected static final DebugTracer TRACER = DebugLogger.getTracer();
    private final MsgQueue msgQueue = new MsgQueue();
    protected MsgQueue lateQueue = new MsgQueue();
    protected ReplicationServer replicationServer = null;
    protected String replicationServerURL = null;
    protected int replicationServerId;
    protected ReplicationServerDomain replicationServerDomain = null;
    protected int outCount = 0;
    protected int inCount = 0;
    protected int maxQueueSize = 5000;
    protected int maxQueueBytesSize = this.maxQueueSize * 100;
    protected boolean following = false;
    private ServerState serverState;
    private String serviceId = null;
    private boolean activeConsumer = true;
    private AtomicBoolean shuttingDown = new AtomicBoolean(false);

    public MessageHandler(int queueSize, String replicationServerURL, int replicationServerId, ReplicationServer replicationServer) {
        super("Message Handler");
        this.maxQueueSize = queueSize;
        this.maxQueueBytesSize = queueSize * 100;
        this.replicationServerURL = replicationServerURL;
        this.replicationServerId = replicationServerId;
        this.replicationServer = replicationServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(UpdateMsg update, MessageHandler sourceHandler) {
        MsgQueue msgQueue = this.msgQueue;
        synchronized (msgQueue) {
            if (this.msgQueue.isEmpty()) {
                this.msgQueue.notify();
            }
            this.msgQueue.add(update);
            while (this.msgQueue.count() > this.maxQueueSize || this.msgQueue.bytesCount() > this.maxQueueBytesSize) {
                this.setFollowing(false);
                this.msgQueue.removeFirst();
            }
        }
    }

    public boolean engageShutdown() {
        return this.shuttingDown.getAndSet(true);
    }

    public long getApproxDelay() {
        long olderUpdateTime = this.getOlderUpdateTime();
        if (olderUpdateTime == 0L) {
            return 0L;
        }
        long currentTime = TimeThread.getTime();
        return (currentTime - olderUpdateTime) / 1000L;
    }

    public Long getApproxFirstMissingDate() {
        Long result = 0L;
        ChangeNumber olderUpdateCN = this.getOlderUpdateCN();
        if (olderUpdateCN != null) {
            result = olderUpdateCN.getTime();
        }
        return result;
    }

    public ReplicationServerDomain getDomain(boolean createIfNotExist) {
        return this.getDomain(createIfNotExist, false);
    }

    public ReplicationServerDomain getDomain(boolean createIfNotExist, boolean waitConnections) {
        if (this.replicationServerDomain == null) {
            this.replicationServerDomain = this.replicationServer.getReplicationServerDomain(this.serviceId, createIfNotExist, waitConnections);
        }
        return this.replicationServerDomain;
    }

    public int getInCount() {
        return this.inCount;
    }

    public ArrayList<Attribute> getMonitorData() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(Attributes.create("handler", this.getMonitorInstanceName()));
        attributes.add(Attributes.create("queue-size", String.valueOf(this.msgQueue.count())));
        attributes.add(Attributes.create("queue-size-bytes", String.valueOf(this.msgQueue.bytesCount())));
        attributes.add(Attributes.create("following", String.valueOf(this.following)));
        return attributes;
    }

    @Override
    public String getMonitorInstanceName() {
        return "Message Handler";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UpdateMsg getnextMessage(boolean synchronous) {
        while (this.activeConsumer) {
            UpdateMsg msg;
            if (!this.following) {
                if (this.lateQueue.isEmpty()) {
                    MsgQueue msgQueue;
                    ReplicationIteratorComparator comparator = new ReplicationIteratorComparator();
                    TreeSet<ReplicationIterator> iteratorSortedSet = new TreeSet<ReplicationIterator>(comparator);
                    for (int serverId : this.replicationServerDomain.getServers()) {
                        ChangeNumber lastCsn;
                        ReplicationIterator iterator = this.replicationServerDomain.getChangelogIterator(serverId, lastCsn = this.serverState.getMaxChangeNumber(serverId));
                        if (iterator == null) continue;
                        if (iterator.getChange() != null) {
                            iteratorSortedSet.add(iterator);
                            continue;
                        }
                        iterator.releaseCursor();
                    }
                    while (!iteratorSortedSet.isEmpty() && this.lateQueue.count() < 100 && this.lateQueue.bytesCount() < 50000) {
                        ReplicationIterator iterator = (ReplicationIterator)iteratorSortedSet.first();
                        iteratorSortedSet.remove(iterator);
                        this.lateQueue.add(iterator.getChange());
                        if (iterator.next()) {
                            iteratorSortedSet.add(iterator);
                            continue;
                        }
                        iterator.releaseCursor();
                    }
                    for (ReplicationIterator iterator : iteratorSortedSet) {
                        iterator.releaseCursor();
                    }
                    if (this.lateQueue.isEmpty()) {
                        msgQueue = this.msgQueue;
                        synchronized (msgQueue) {
                            if (this.msgQueue.count() < this.maxQueueSize && this.msgQueue.bytesCount() < this.maxQueueBytesSize) {
                                this.setFollowing(true);
                            }
                        }
                    } else {
                        msg = this.lateQueue.first();
                        msgQueue = this.msgQueue;
                        synchronized (msgQueue) {
                            if (this.msgQueue.contains(msg)) {
                                UpdateMsg msg1;
                                this.setFollowing(true);
                                this.lateQueue.clear();
                                do {
                                    msg1 = this.msgQueue.removeFirst();
                                } while (!msg.getChangeNumber().equals(msg1.getChangeNumber()));
                                this.updateServerState(msg);
                                return msg1;
                            }
                        }
                    }
                } else {
                    msg = this.lateQueue.removeFirst();
                    this.updateServerState(msg);
                    return msg;
                }
            }
            MsgQueue msgQueue = this.msgQueue;
            synchronized (msgQueue) {
                if (this.following) {
                    try {
                        while (this.msgQueue.isEmpty() && this.following) {
                            if (!synchronous) {
                                return null;
                            }
                            this.msgQueue.wait(500L);
                            if (this.activeConsumer) continue;
                            return null;
                        }
                    }
                    catch (InterruptedException e) {
                        return null;
                    }
                    msg = this.msgQueue.removeFirst();
                    if (this.updateServerState(msg)) {
                        return msg;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeNumber getOlderUpdateCN() {
        ChangeNumber result = null;
        MsgQueue msgQueue = this.msgQueue;
        synchronized (msgQueue) {
            if (this.isFollowing()) {
                if (this.msgQueue.isEmpty()) {
                    result = null;
                } else {
                    UpdateMsg msg = this.msgQueue.first();
                    result = msg.getChangeNumber();
                }
            } else if (this.lateQueue.isEmpty()) {
                ReplicationIteratorComparator comparator = new ReplicationIteratorComparator();
                TreeSet<ReplicationIterator> iteratorSortedSet = new TreeSet<ReplicationIterator>(comparator);
                try {
                    for (int serverId : this.replicationServerDomain.getServers()) {
                        ChangeNumber lastCsn;
                        ReplicationIterator iterator = this.replicationServerDomain.getChangelogIterator(serverId, lastCsn = this.serverState.getMaxChangeNumber(serverId));
                        if (iterator == null || iterator.getChange() == null) continue;
                        iteratorSortedSet.add(iterator);
                    }
                    UpdateMsg msg = ((ReplicationIterator)iteratorSortedSet.first()).getChange();
                    result = msg.getChangeNumber();
                }
                catch (Exception e) {
                    result = null;
                    return result;
                }
                finally {
                    for (ReplicationIterator iterator : iteratorSortedSet) {
                        iterator.releaseCursor();
                    }
                }
            } else {
                UpdateMsg msg = this.lateQueue.first();
                result = msg.getChangeNumber();
            }
        }
        return result;
    }

    public long getOlderUpdateTime() {
        ChangeNumber olderUpdateCN = this.getOlderUpdateCN();
        if (olderUpdateCN == null) {
            return 0L;
        }
        return olderUpdateCN.getTime();
    }

    public int getOutCount() {
        return this.outCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRcvMsgQueueSize() {
        MsgQueue msgQueue = this.msgQueue;
        synchronized (msgQueue) {
            if (this.isFollowing()) {
                return this.msgQueue.count();
            }
            ServerState dbState = this.replicationServerDomain.getDbServerState();
            return ServerState.diffChanges(dbState, this.serverState);
        }
    }

    public ServerState getServerState() {
        return this.serverState;
    }

    protected String getServiceId() {
        return this.serviceId;
    }

    @Override
    public long getUpdateInterval() {
        return 0L;
    }

    public void incrementInCount() {
        ++this.inCount;
    }

    public void incrementOutCount() {
        ++this.outCount;
    }

    @Override
    public void initializeMonitorProvider(MonitorProviderCfg configuration) throws ConfigException, InitializationException {
    }

    public boolean isFollowing() {
        return this.following;
    }

    public void setConsumerActive(boolean active) {
        this.activeConsumer = active;
    }

    private void setFollowing(boolean following) {
        this.following = following;
    }

    public void setInitialServerState(ServerState serverState) throws DirectoryException {
        this.serverState = serverState;
    }

    protected void setServiceIdAndDomain(String serviceId, boolean isDataServer) throws DirectoryException {
        if (this.serviceId != null) {
            if (!this.serviceId.equalsIgnoreCase(serviceId)) {
                Message message = ReplicationMessages.ERR_RS_DN_DOES_NOT_MATCH.get(this.serviceId.toString(), serviceId.toString());
                throw new DirectoryException(ResultCode.OTHER, message, null);
            }
        } else {
            this.serviceId = serviceId;
            if (!serviceId.equalsIgnoreCase("cn=changelog")) {
                this.replicationServerDomain = this.getDomain(true, isDataServer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        MsgQueue msgQueue = this.msgQueue;
        synchronized (msgQueue) {
            this.msgQueue.clear();
            this.msgQueue.notify();
            this.msgQueue.notifyAll();
        }
        DirectoryServer.deregisterMonitorProvider(this.getMonitorInstanceName());
    }

    @Override
    public void updateMonitorData() {
    }

    public boolean updateServerState(UpdateMsg msg) {
        return this.serverState.update(msg.getChangeNumber());
    }

    public byte getLocalGroupId() {
        return this.replicationServer.getGroupId();
    }

    public int getReplicationServerId() {
        return this.replicationServerId;
    }
}

