/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.replication.plugin;

import org.opends.server.replication.common.ChangeNumber;
import org.opends.server.replication.common.ServerState;
import org.opends.server.replication.protocol.LDAPUpdateMsg;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.operation.PluginOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PendingChange
implements Comparable<PendingChange> {
    private ChangeNumber changeNumber;
    private boolean committed;
    private LDAPUpdateMsg msg;
    private PluginOperation op;
    private ServerState dependencyState = null;
    private DN targetDN = null;

    public PendingChange(ChangeNumber changeNumber, PluginOperation op, LDAPUpdateMsg msg) {
        this.changeNumber = changeNumber;
        this.committed = false;
        this.op = op;
        this.msg = msg;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public ChangeNumber getChangeNumber() {
        return this.changeNumber;
    }

    public LDAPUpdateMsg getMsg() {
        return this.msg;
    }

    public void setMsg(LDAPUpdateMsg msg) {
        this.msg = msg;
    }

    public PluginOperation getOp() {
        return this.op;
    }

    public void setOp(PluginOperation op) {
        this.op = op;
    }

    public void addDependency(ChangeNumber changeNumber) {
        if (this.dependencyState == null) {
            this.dependencyState = new ServerState();
        }
        this.dependencyState.update(changeNumber);
    }

    public boolean dependenciesIsCovered(ServerState state) {
        return state.cover(this.dependencyState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DN getTargetDN() {
        PendingChange pendingChange = this;
        synchronized (pendingChange) {
            if (this.targetDN != null) {
                return this.targetDN;
            }
            try {
                this.targetDN = DN.decode(this.msg.getDn());
            }
            catch (DirectoryException directoryException) {
                // empty catch block
            }
            return this.targetDN;
        }
    }

    @Override
    public int compareTo(PendingChange o) {
        return this.getChangeNumber().compareTo(o.getChangeNumber());
    }
}

