/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.ConnectionHandlerCfg;
import org.opends.server.admin.std.server.LDAPConnectionHandlerCfg;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.KeyManagerProvider;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.api.TrustManagerProvider;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.QueueingStrategy;
import org.opends.server.core.WorkQueueStrategy;
import org.opends.server.extensions.NullKeyManagerProvider;
import org.opends.server.extensions.NullTrustManagerProvider;
import org.opends.server.extensions.TLSByteChannel;
import org.opends.server.loggers.AccessLogger;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.monitors.ClientConnectionMonitorProvider;
import org.opends.server.protocols.ldap.LDAPClientConnection;
import org.opends.server.protocols.ldap.LDAPRequestHandler;
import org.opends.server.protocols.ldap.LDAPStatistics;
import org.opends.server.types.AddressMask;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.HostPort;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SSLClientAuthPolicy;
import org.opends.server.util.SelectableCertificateKeyManager;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDAPConnectionHandler
extends ConnectionHandler<LDAPConnectionHandlerCfg>
implements ConfigurationChangeListener<LDAPConnectionHandlerCfg>,
ServerShutdownListener,
AlertGenerator {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.LDAPConnectionHandler";
    private static final String DEFAULT_FRIENDLY_NAME = "LDAP Connection Handler";
    private LDAPConnectionHandlerCfg currentConfig;
    private Set<InetAddress> listenAddresses;
    private int listenPort;
    private SSLClientAuthPolicy sslClientAuthPolicy;
    private int backlog;
    private boolean allowReuseAddress;
    private int numRequestHandlers;
    private boolean shutdownRequested;
    private boolean enabled;
    private AddressMask[] allowedClients;
    private AddressMask[] deniedClients;
    private String[] enabledSSLCipherSuites;
    private String[] enabledSSLProtocols;
    private int requestHandlerIndex;
    private LinkedList<HostPort> listeners;
    private LDAPRequestHandler[] requestHandlers;
    private LDAPStatistics statTracker;
    private ClientConnectionMonitorProvider connMonitor;
    private Selector selector;
    private String handlerName;
    private String protocol;
    private final QueueingStrategy queueingStrategy;
    private final Object waitListen = new Object();
    private String friendlyName;
    private static final String SSL_CONTEXT_INSTANCE_NAME = "TLS";
    private SSLContext sslContext;
    private boolean sslConfig = false;
    private final Object connectionFinalizerLock = new Object();
    private ScheduledExecutorService connectionFinalizer;
    private List<Runnable> connectionFinalizerActiveJobQueue;
    private List<Runnable> connectionFinalizerPendingJobQueue;

    public LDAPConnectionHandler() {
        this(new WorkQueueStrategy(), DEFAULT_FRIENDLY_NAME);
    }

    public LDAPConnectionHandler(QueueingStrategy strategy, String friendlyName) {
        super("LDAP Connection Handler Thread");
        this.friendlyName = friendlyName == null ? DEFAULT_FRIENDLY_NAME : friendlyName;
        this.queueingStrategy = strategy;
    }

    public boolean allowLDAPv2() {
        return this.currentConfig.isAllowLDAPV2();
    }

    public boolean allowStartTLS() {
        if (this.currentConfig.isAllowStartTLS()) {
            return !this.currentConfig.isUseSSL();
        }
        return false;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(LDAPConnectionHandlerCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        if (this.currentConfig.isAllowLDAPV2() != config.isAllowLDAPV2() && config.isAllowLDAPV2()) {
            this.statTracker.clearStatistics();
        }
        this.currentConfig = config;
        this.enabled = config.isEnabled();
        this.allowedClients = config.getAllowedClient().toArray(new AddressMask[0]);
        this.deniedClients = config.getDeniedClient().toArray(new AddressMask[0]);
        if (config.isUseSSL() || config.isAllowStartTLS()) {
            this.sslConfig = true;
        }
        if (config.isAllowLDAPV2()) {
            DirectoryServer.registerSupportedLDAPVersion(2, this);
        } else {
            DirectoryServer.deregisterSupportedLDAPVersion(2, this);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalizeConnectionHandler(Message finalizeReason) {
        block8: {
            String lowerName;
            this.shutdownRequested = true;
            this.currentConfig.removeLDAPChangeListener(this);
            if (this.connMonitor != null) {
                lowerName = StaticUtils.toLowerCase(this.connMonitor.getMonitorInstanceName());
                DirectoryServer.deregisterMonitorProvider(lowerName);
            }
            if (this.statTracker != null) {
                lowerName = StaticUtils.toLowerCase(this.statTracker.getMonitorInstanceName());
                DirectoryServer.deregisterMonitorProvider(lowerName);
            }
            DirectoryServer.deregisterSupportedLDAPVersion(2, this);
            DirectoryServer.deregisterSupportedLDAPVersion(3, this);
            try {
                this.selector.wakeup();
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block8;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        for (LDAPRequestHandler requestHandler : this.requestHandlers) {
            requestHandler.processServerShutdown(finalizeReason);
        }
        Object object = this.connectionFinalizerLock;
        synchronized (object) {
            this.connectionFinalizer.shutdown();
            this.connectionFinalizer = null;
            ConnectionFinalizerRunnable r = new ConnectionFinalizerRunnable();
            r.run();
            r.run();
        }
    }

    @Override
    public LinkedHashMap<String, String> getAlerts() {
        LinkedHashMap<String, String> alerts = new LinkedHashMap<String, String>();
        alerts.put("org.opends.server.LDAPHandlerDisabledByConsecutiveFailures", "This alert type will be used to notify administrators of consecutive failures that have occurred in the LDAP connection handler that have caused it to become disabled.");
        alerts.put("org.opends.server.LDAPHandlerUncaughtError", "This alert type will be used to notify administrators of uncaught errors in the LDAP connection handler that have caused it to become disabled.");
        return alerts;
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public Collection<ClientConnection> getClientConnections() {
        LinkedList<ClientConnection> connectionList = new LinkedList<ClientConnection>();
        for (LDAPRequestHandler requestHandler : this.requestHandlers) {
            connectionList.addAll(requestHandler.getClientConnections());
        }
        return connectionList;
    }

    @Override
    public DN getComponentEntryDN() {
        return this.currentConfig.dn();
    }

    @Override
    public String getConnectionHandlerName() {
        return this.handlerName;
    }

    public String[] getEnabledSSLCipherSuites() {
        return this.enabledSSLCipherSuites;
    }

    public String[] getEnabledSSLProtocols() {
        return this.enabledSSLProtocols;
    }

    @Override
    public Collection<HostPort> getListeners() {
        return this.listeners;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public long getMaxBlockedWriteTimeLimit() {
        return this.currentConfig.getMaxBlockedWriteTimeLimit();
    }

    public int getMaxRequestSize() {
        return (int)this.currentConfig.getMaxRequestSize();
    }

    public int getBufferSize() {
        return (int)this.currentConfig.getBufferSize();
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getShutdownListenerName() {
        return this.handlerName;
    }

    public SSLClientAuthPolicy getSSLClientAuthPolicy() {
        return this.sslClientAuthPolicy;
    }

    public LDAPStatistics getStatTracker() {
        return this.statTracker;
    }

    @Override
    public void initializeConnectionHandler(LDAPConnectionHandlerCfg config) throws ConfigException, InitializationException {
        int i;
        try {
            this.selector = Selector.open();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.ERR_LDAP_CONNHANDLER_OPEN_SELECTOR_FAILED.get(String.valueOf(config.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
        this.protocol = "LDAP";
        this.currentConfig = config;
        this.enabled = config.isEnabled();
        this.requestHandlerIndex = 0;
        this.allowedClients = config.getAllowedClient().toArray(new AddressMask[0]);
        this.deniedClients = config.getDeniedClient().toArray(new AddressMask[0]);
        if (config.isUseSSL() || config.isAllowStartTLS()) {
            this.sslConfig = true;
        }
        this.allowReuseAddress = config.isAllowTCPReuseAddress();
        this.backlog = config.getAcceptBacklog();
        this.listenAddresses = config.getListenAddress();
        this.listenPort = config.getListenPort();
        this.numRequestHandlers = config.getNumRequestHandlers();
        this.listeners = new LinkedList();
        StringBuilder nameBuffer = new StringBuilder();
        nameBuffer.append(this.friendlyName);
        for (InetAddress a : this.listenAddresses) {
            this.listeners.add(new HostPort(a.getHostAddress(), this.listenPort));
            nameBuffer.append(" ");
            nameBuffer.append(a.getHostAddress());
        }
        nameBuffer.append(" port ");
        nameBuffer.append(this.listenPort);
        this.handlerName = nameBuffer.toString();
        for (InetAddress a : this.listenAddresses) {
            try {
                if (!StaticUtils.isAddressInUse(a, this.listenPort, this.allowReuseAddress)) continue;
                throw new IOException(ProtocolMessages.ERR_CONNHANDLER_ADDRESS_INUSE.get().toString());
            }
            catch (IOException e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_CONNHANDLER_CANNOT_BIND.get(String.valueOf(config.dn()), a.getHostAddress(), this.listenPort, StaticUtils.getExceptionMessage(e));
                ErrorLogger.logError(message);
                throw new InitializationException(message);
            }
        }
        System.setProperty(this.protocol + "_port", String.valueOf(this.listenPort));
        this.connectionFinalizer = Executors.newSingleThreadScheduledExecutor(new DirectoryThread.Factory("LDAP Connection Finalizer for connection handler " + this.toString()));
        this.connectionFinalizerActiveJobQueue = new ArrayList<Runnable>();
        this.connectionFinalizerPendingJobQueue = new ArrayList<Runnable>();
        this.connectionFinalizer.scheduleWithFixedDelay(new ConnectionFinalizerRunnable(), 100L, 100L, TimeUnit.MILLISECONDS);
        this.requestHandlers = new LDAPRequestHandler[this.numRequestHandlers];
        for (i = 0; i < this.numRequestHandlers; ++i) {
            this.requestHandlers[i] = new LDAPRequestHandler(this, i);
        }
        for (i = 0; i < this.numRequestHandlers; ++i) {
            this.requestHandlers[i].start();
        }
        DirectoryServer.registerSupportedLDAPVersion(3, this);
        if (config.isAllowLDAPV2()) {
            DirectoryServer.registerSupportedLDAPVersion(2, this);
        }
        this.statTracker = new LDAPStatistics(this.handlerName + " Statistics");
        DirectoryServer.registerMonitorProvider(this.statTracker);
        this.connMonitor = new ClientConnectionMonitorProvider(this);
        DirectoryServer.registerMonitorProvider(this.connMonitor);
        config.addLDAPChangeListener(this);
    }

    @Override
    public boolean isConfigurationAcceptable(ConnectionHandlerCfg configuration, List<Message> unacceptableReasons) {
        LDAPConnectionHandlerCfg config = (LDAPConnectionHandlerCfg)configuration;
        if (this.currentConfig == null || !this.currentConfig.isEnabled() && config.isEnabled()) {
            for (InetAddress a : config.getListenAddress()) {
                try {
                    if (!StaticUtils.isAddressInUse(a, config.getListenPort(), config.isAllowTCPReuseAddress())) continue;
                    throw new IOException(ProtocolMessages.ERR_CONNHANDLER_ADDRESS_INUSE.get().toString());
                }
                catch (IOException e) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = ProtocolMessages.ERR_LDAP_CONNHANDLER_CANNOT_BIND.get(String.valueOf(config.dn()), a.getHostAddress(), config.getListenPort(), StaticUtils.getExceptionMessage(e));
                    unacceptableReasons.add(message);
                    return false;
                }
            }
        }
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(LDAPConnectionHandlerCfg config, List<Message> unacceptableReasons) {
        return true;
    }

    public boolean keepStats() {
        return this.currentConfig.isKeepStats();
    }

    @Override
    public void processServerShutdown(Message reason) {
        this.shutdownRequested = true;
        try {
            for (LDAPRequestHandler requestHandler : this.requestHandlers) {
                try {
                    requestHandler.processServerShutdown(reason);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.waitListen;
        synchronized (object) {
            super.start();
            try {
                this.waitListen.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName(this.handlerName);
        boolean listening = false;
        while (!this.shutdownRequested) {
            if (!this.enabled) {
                if (listening) {
                    this.cleanUpSelector();
                    listening = false;
                    ErrorLogger.logError(ProtocolMessages.NOTE_LDAP_CONNHANDLER_STOPPED_LISTENING.get(this.handlerName));
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {}
                continue;
            }
            try {
                this.cleanUpSelector();
                int numRegistered = 0;
                for (InetAddress a : this.listenAddresses) {
                    try {
                        ServerSocketChannel channel = ServerSocketChannel.open();
                        channel.socket().setReuseAddress(this.allowReuseAddress);
                        channel.socket().bind(new InetSocketAddress(a, this.listenPort), this.backlog);
                        channel.configureBlocking(false);
                        channel.register(this.selector, 16);
                        ++numRegistered;
                        ErrorLogger.logError(ProtocolMessages.NOTE_LDAP_CONNHANDLER_STARTED_LISTENING.get(this.handlerName));
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        ErrorLogger.logError(ProtocolMessages.ERR_LDAP_CONNHANDLER_CREATE_CHANNEL_FAILED.get(String.valueOf(this.currentConfig.dn()), a.getHostAddress(), this.listenPort, StaticUtils.stackTraceToSingleLineString(e)));
                    }
                }
                Object i$ = this.waitListen;
                synchronized (i$) {
                    this.waitListen.notify();
                }
                if (numRegistered == 0) {
                    ErrorLogger.logError(ProtocolMessages.ERR_LDAP_CONNHANDLER_NO_ACCEPTORS.get(String.valueOf(this.currentConfig.dn())));
                    this.enabled = false;
                    continue;
                }
                listening = true;
                boolean lastIterationFailed = false;
                while (this.enabled && !this.shutdownRequested) {
                    try {
                        int selectorState = this.selector.select();
                        Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
                        while (iterator.hasNext()) {
                            ServerSocketChannel serverChannel;
                            SocketChannel clientChannel;
                            SelectionKey key = iterator.next();
                            iterator.remove();
                            if (key.isAcceptable() && (clientChannel = (serverChannel = (ServerSocketChannel)key.channel()).accept()) != null) {
                                this.acceptConnection(clientChannel);
                            }
                            if (selectorState != 0 || !this.enabled || this.shutdownRequested || !DebugLogger.debugEnabled()) continue;
                            TRACER.debugWarning("Selector.select() returned 0. Selected Keys: %d, Interest Ops: %d, Ready Ops: %d ", this.selector.selectedKeys().size(), key.interestOps(), key.readyOps());
                        }
                        lastIterationFailed = false;
                    }
                    catch (Exception e) {
                        if (DebugLogger.debugEnabled()) {
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                        ErrorLogger.logError(ProtocolMessages.ERR_LDAP_CONNHANDLER_CANNOT_ACCEPT_CONNECTION.get(String.valueOf(this.currentConfig.dn()), StaticUtils.getExceptionMessage(e)));
                        if (lastIterationFailed) {
                            Message message = ProtocolMessages.ERR_LDAP_CONNHANDLER_CONSECUTIVE_ACCEPT_FAILURES.get(String.valueOf(this.currentConfig.dn()), StaticUtils.stackTraceToSingleLineString(e));
                            ErrorLogger.logError(message);
                            DirectoryServer.sendAlertNotification(this, "org.opends.server.LDAPHandlerDisabledByConsecutiveFailures", message);
                            this.enabled = false;
                            try {
                                this.cleanUpSelector();
                            }
                            catch (Exception e2) {}
                            continue;
                        }
                        lastIterationFailed = true;
                    }
                }
                if (!this.shutdownRequested) continue;
                this.cleanUpSelector();
                this.selector.close();
                listening = false;
                this.enabled = false;
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                Message message = ProtocolMessages.ERR_LDAP_CONNHANDLER_UNCAUGHT_ERROR.get(String.valueOf(this.currentConfig.dn()), StaticUtils.stackTraceToSingleLineString(e));
                ErrorLogger.logError(message);
                DirectoryServer.sendAlertNotification(this, "org.opends.server.LDAPHandlerUncaughtError", message);
                try {
                    this.cleanUpSelector();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                this.enabled = false;
            }
        }
    }

    private void acceptConnection(SocketChannel clientChannel) throws DirectoryException {
        try {
            clientChannel.socket().setKeepAlive(this.currentConfig.isUseTCPKeepAlive());
            clientChannel.socket().setTcpNoDelay(this.currentConfig.isUseTCPNoDelay());
        }
        catch (SocketException se) {
            try {
                clientChannel.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        LDAPClientConnection clientConnection = this.createClientConnection(clientChannel);
        if (clientConnection.getConnectionID() < 0L) {
            return;
        }
        InetAddress clientAddr = clientConnection.getRemoteAddress();
        if (this.deniedClients.length > 0 && AddressMask.maskListContains(clientAddr.getAddress(), clientAddr.getHostName(), this.deniedClients)) {
            clientConnection.disconnect(DisconnectReason.CONNECTION_REJECTED, this.currentConfig.isSendRejectionNotice(), ProtocolMessages.ERR_LDAP_CONNHANDLER_DENIED_CLIENT.get(clientConnection.getClientHostPort(), clientConnection.getServerHostPort()));
            return;
        }
        if (this.allowedClients.length > 0 && !AddressMask.maskListContains(clientAddr.getAddress(), clientAddr.getHostName(), this.allowedClients)) {
            clientConnection.disconnect(DisconnectReason.CONNECTION_REJECTED, this.currentConfig.isSendRejectionNotice(), ProtocolMessages.ERR_LDAP_CONNHANDLER_DISALLOWED_CLIENT.get(clientConnection.getClientHostPort(), clientConnection.getServerHostPort()));
            return;
        }
        try {
            PluginConfigManager pluginManager = DirectoryServer.getPluginConfigManager();
            PluginResult.PostConnect pluginResult = pluginManager.invokePostConnectPlugins(clientConnection);
            if (!pluginResult.continueProcessing()) {
                clientConnection.disconnect(pluginResult.getDisconnectReason(), pluginResult.sendDisconnectNotification(), pluginResult.getErrorMessage());
                return;
            }
            LDAPRequestHandler requestHandler = this.requestHandlers[this.requestHandlerIndex++];
            if (this.requestHandlerIndex >= this.numRequestHandlers) {
                this.requestHandlerIndex = 0;
            }
            if (requestHandler.registerClient(clientConnection)) {
                AccessLogger.logConnect(clientConnection);
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ProtocolMessages.INFO_LDAP_CONNHANDLER_UNABLE_TO_REGISTER_CLIENT.get(clientConnection.getClientHostPort(), clientConnection.getServerHostPort(), StaticUtils.getExceptionMessage(e));
            ErrorLogger.logError(message);
            clientConnection.disconnect(DisconnectReason.SERVER_ERROR, this.currentConfig.isSendRejectionNotice(), message);
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append(this.handlerName);
    }

    public boolean useSSL() {
        return this.currentConfig.isUseSSL();
    }

    private void cleanUpSelector() {
        block8: {
            try {
                for (SelectionKey key : this.selector.keys()) {
                    block7: {
                        try {
                            key.cancel();
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) break block7;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                    try {
                        key.channel().close();
                    }
                    catch (Exception e) {
                        if (!DebugLogger.debugEnabled()) continue;
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                }
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block8;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    public QueueingStrategy getQueueingStrategy() {
        return this.queueingStrategy;
    }

    private LDAPClientConnection createClientConnection(SocketChannel socketChannel) throws DirectoryException {
        if (this.sslConfig) {
            this.configSSL(this.currentConfig);
            this.sslConfig = false;
        }
        LDAPClientConnection c = new LDAPClientConnection(this, socketChannel, this.getProtocol());
        return c;
    }

    public TLSByteChannel getTLSByteChannel(LDAPClientConnection c, ByteChannel socketChannel) throws DirectoryException {
        return TLSByteChannel.getTLSByteChannel(this.currentConfig, c, this.sslContext, socketChannel);
    }

    private void configSSL(LDAPConnectionHandlerCfg config) throws DirectoryException {
        ResultCode resCode = DirectoryServer.getServerErrorResultCode();
        try {
            TrustManagerProvider trustManagerProvider;
            String alias = config.getSSLCertNickname();
            if (config.isUseSSL()) {
                this.protocol = "LDAPS";
            }
            DN keyMgrDN = config.getKeyManagerProviderDN();
            DN trustMgrDN = config.getTrustManagerProviderDN();
            KeyManagerProvider keyManagerProvider = DirectoryServer.getKeyManagerProvider(keyMgrDN);
            if (keyManagerProvider == null) {
                keyManagerProvider = new NullKeyManagerProvider();
            }
            if ((trustManagerProvider = DirectoryServer.getTrustManagerProvider(trustMgrDN)) == null) {
                trustManagerProvider = new NullTrustManagerProvider();
            }
            this.sslContext = SSLContext.getInstance(SSL_CONTEXT_INSTANCE_NAME);
            if (alias == null) {
                this.sslContext.init(keyManagerProvider.getKeyManagers(), trustManagerProvider.getTrustManagers(), null);
            } else {
                this.sslContext.init(SelectableCertificateKeyManager.wrap(keyManagerProvider.getKeyManagers(), alias), trustManagerProvider.getTrustManagers(), null);
            }
        }
        catch (NoSuchAlgorithmException nsae) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, nsae);
            }
            Message message = ProtocolMessages.ERR_CONNHANDLER_SSL_CANNOT_INITIALIZE.get(StaticUtils.getExceptionMessage(nsae));
            throw new DirectoryException(resCode, message, nsae);
        }
        catch (KeyManagementException kme) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, kme);
            }
            Message message = ProtocolMessages.ERR_CONNHANDLER_SSL_CANNOT_INITIALIZE.get(StaticUtils.getExceptionMessage(kme));
            throw new DirectoryException(resCode, message, kme);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            Message message = ProtocolMessages.ERR_CONNHANDLER_SSL_CANNOT_INITIALIZE.get(StaticUtils.getExceptionMessage(de));
            throw new DirectoryException(resCode, message, de);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerConnectionFinalizer(Runnable r) {
        Object object = this.connectionFinalizerLock;
        synchronized (object) {
            if (this.connectionFinalizer != null) {
                this.connectionFinalizerPendingJobQueue.add(r);
            } else {
                r.run();
            }
        }
    }

    private final class ConnectionFinalizerRunnable
    implements Runnable {
        private ConnectionFinalizerRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!LDAPConnectionHandler.this.connectionFinalizerActiveJobQueue.isEmpty()) {
                for (Runnable r : LDAPConnectionHandler.this.connectionFinalizerActiveJobQueue) {
                    r.run();
                }
                LDAPConnectionHandler.this.connectionFinalizerActiveJobQueue.clear();
            }
            Object object = LDAPConnectionHandler.this.connectionFinalizerLock;
            synchronized (object) {
                List tmp = LDAPConnectionHandler.this.connectionFinalizerActiveJobQueue;
                LDAPConnectionHandler.this.connectionFinalizerActiveJobQueue = LDAPConnectionHandler.this.connectionFinalizerPendingJobQueue;
                LDAPConnectionHandler.this.connectionFinalizerPendingJobQueue = tmp;
            }
        }
    }
}

