/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.io.IOException;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.ByteString;
import org.opends.server.util.ServerConstants;

public class IntermediateResponseProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ByteString value;
    private String oid;

    public IntermediateResponseProtocolOp(String oid) {
        this.oid = oid;
        this.value = null;
    }

    public IntermediateResponseProtocolOp(String oid, ByteString value) {
        this.oid = oid;
        this.value = value;
    }

    public String getOID() {
        return this.oid;
    }

    public ByteString getValue() {
        return this.value;
    }

    public byte getType() {
        return 121;
    }

    public String getProtocolOpName() {
        return "Intermediate Response";
    }

    public void write(ASN1Writer stream) throws IOException {
        stream.writeStartSequence((byte)121);
        if (this.oid != null) {
            stream.writeOctetString((byte)-128, this.oid);
        }
        if (this.value != null) {
            stream.writeOctetString((byte)-127, this.value);
        }
        stream.writeEndSequence();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("IntermediateResponse(oid=");
        buffer.append(String.valueOf(this.oid));
        if (this.value != null) {
            buffer.append(", value=");
            buffer.append(this.value.toString());
        }
        buffer.append(")");
    }

    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Intermediate Response");
        buffer.append(ServerConstants.EOL);
        if (this.oid != null) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  OID:  ");
            buffer.append(this.oid);
            buffer.append(ServerConstants.EOL);
        }
        if (this.value != null) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Value:");
            buffer.append(ServerConstants.EOL);
            this.value.toHexPlusAscii(buffer, indent + 4);
        }
    }
}

