/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.opends.messages.Message;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedResponseProtocolOp
extends ProtocolOp {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ByteString value;
    private DN matchedDN;
    private int resultCode;
    private List<String> referralURLs;
    private Message errorMessage;
    private String oid;

    public ExtendedResponseProtocolOp(int resultCode) {
        this.resultCode = resultCode;
        this.errorMessage = null;
        this.matchedDN = null;
        this.referralURLs = null;
        this.oid = null;
        this.value = null;
    }

    public ExtendedResponseProtocolOp(int resultCode, Message errorMessage) {
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.matchedDN = null;
        this.referralURLs = null;
        this.oid = null;
        this.value = null;
    }

    public ExtendedResponseProtocolOp(int resultCode, Message errorMessage, DN matchedDN, List<String> referralURLs) {
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.matchedDN = matchedDN;
        this.referralURLs = referralURLs;
        this.oid = null;
        this.value = null;
    }

    public ExtendedResponseProtocolOp(int resultCode, Message errorMessage, DN matchedDN, List<String> referralURLs, String oid, ByteString value) {
        this.resultCode = resultCode;
        this.errorMessage = errorMessage;
        this.matchedDN = matchedDN;
        this.referralURLs = referralURLs;
        this.oid = oid;
        this.value = value;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public Message getErrorMessage() {
        return this.errorMessage;
    }

    public DN getMatchedDN() {
        return this.matchedDN;
    }

    public List<String> getReferralURLs() {
        return this.referralURLs;
    }

    public String getOID() {
        return this.oid;
    }

    public ByteString getValue() {
        return this.value;
    }

    @Override
    public byte getType() {
        return 120;
    }

    @Override
    public String getProtocolOpName() {
        return "Extended Response";
    }

    @Override
    public void write(ASN1Writer stream) throws IOException {
        stream.writeStartSequence((byte)120);
        stream.writeEnumerated(this.resultCode);
        if (this.matchedDN == null) {
            stream.writeOctetString((String)null);
        } else {
            stream.writeOctetString(this.matchedDN.toString());
        }
        if (this.errorMessage == null) {
            stream.writeOctetString((String)null);
        } else {
            stream.writeOctetString(this.errorMessage.toString());
        }
        if (this.referralURLs != null && !this.referralURLs.isEmpty()) {
            stream.writeStartSequence((byte)-93);
            for (String s : this.referralURLs) {
                stream.writeOctetString(s);
            }
            stream.writeEndSequence();
        }
        if (this.oid != null && this.oid.length() > 0) {
            stream.writeOctetString((byte)-118, this.oid);
        }
        if (this.value != null) {
            stream.writeOctetString((byte)-117, this.value);
        }
        stream.writeEndSequence();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("ExtendedResponse(resultCode=");
        buffer.append(this.resultCode);
        if (this.errorMessage != null && this.errorMessage.length() > 0) {
            buffer.append(", errorMessage=");
            buffer.append(this.errorMessage);
        }
        if (this.matchedDN != null) {
            buffer.append(", matchedDN=");
            buffer.append(this.matchedDN.toString());
        }
        if (this.referralURLs != null && !this.referralURLs.isEmpty()) {
            buffer.append(", referralURLs={");
            Iterator<String> iterator = this.referralURLs.iterator();
            buffer.append(iterator.next());
            while (iterator.hasNext()) {
                buffer.append(", ");
                buffer.append(iterator.next());
            }
            buffer.append("}");
        }
        if (this.oid != null && this.oid.length() > 0) {
            buffer.append(", oid=");
            buffer.append(this.oid);
        }
        if (this.value != null) {
            buffer.append(", value=");
            buffer.append(this.value.toString());
        }
        buffer.append(")");
    }

    @Override
    public void toString(StringBuilder buffer, int indent) {
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        buffer.append((CharSequence)indentBuf);
        buffer.append("Extended Response");
        buffer.append(ServerConstants.EOL);
        buffer.append((CharSequence)indentBuf);
        buffer.append("  Result Code:  ");
        buffer.append(this.resultCode);
        buffer.append(ServerConstants.EOL);
        if (this.errorMessage != null) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Error Message:  ");
            buffer.append(this.errorMessage);
            buffer.append(ServerConstants.EOL);
        }
        if (this.matchedDN != null) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Matched DN:  ");
            this.matchedDN.toString(buffer);
            buffer.append(ServerConstants.EOL);
        }
        if (this.referralURLs != null && !this.referralURLs.isEmpty()) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Referral URLs:  ");
            buffer.append(ServerConstants.EOL);
            for (String s : this.referralURLs) {
                buffer.append((CharSequence)indentBuf);
                buffer.append("  ");
                buffer.append(s);
                buffer.append(ServerConstants.EOL);
            }
        }
        if (this.oid != null && this.oid.length() > 0) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Response OID:  ");
            buffer.append(this.oid);
            buffer.append(ServerConstants.EOL);
        }
        if (this.value != null) {
            buffer.append((CharSequence)indentBuf);
            buffer.append("  Response Value:  ");
            buffer.append(this.value.toString());
            buffer.append(ServerConstants.EOL);
        }
    }
}

