/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.AddOperationBasis;
import org.opends.server.core.BindOperationBasis;
import org.opends.server.core.CompareOperationBasis;
import org.opends.server.core.DeleteOperationBasis;
import org.opends.server.core.ExtendedOperationBasis;
import org.opends.server.core.ModifyDNOperationBasis;
import org.opends.server.core.ModifyOperationBasis;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalLDAPSocket;
import org.opends.server.protocols.internal.InternalSearchListener;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.AddRequestProtocolOp;
import org.opends.server.protocols.ldap.AddResponseProtocolOp;
import org.opends.server.protocols.ldap.BindRequestProtocolOp;
import org.opends.server.protocols.ldap.BindResponseProtocolOp;
import org.opends.server.protocols.ldap.CompareRequestProtocolOp;
import org.opends.server.protocols.ldap.CompareResponseProtocolOp;
import org.opends.server.protocols.ldap.DeleteRequestProtocolOp;
import org.opends.server.protocols.ldap.DeleteResponseProtocolOp;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.LDAPReader;
import org.opends.server.protocols.ldap.ModifyDNRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyDNResponseProtocolOp;
import org.opends.server.protocols.ldap.ModifyRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyResponseProtocolOp;
import org.opends.server.protocols.ldap.SearchRequestProtocolOp;
import org.opends.server.protocols.ldap.SearchResultDoneProtocolOp;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.protocols.ldap.SearchResultReferenceProtocolOp;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.ByteSequenceReader;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.Control;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.StabilityLevel;

@PublicAPI(stability=StabilityLevel.UNCOMMITTED, mayInstantiate=false, mayExtend=false, mayInvoke=true)
public final class InternalLDAPOutputStream
extends OutputStream
implements InternalSearchListener {
    private boolean closed;
    private final ASN1Reader reader;
    private final InternalLDAPSocket socket;
    private ByteSequenceReader byteBuffer;
    private final ByteStringBuilder saveBuffer;
    private final ByteSequenceReader saveBufferReader;

    public InternalLDAPOutputStream(InternalLDAPSocket socket) {
        this.socket = socket;
        this.closed = false;
        this.saveBuffer = new ByteStringBuilder();
        this.saveBufferReader = this.saveBuffer.asReader();
        CombinedBufferInputStream bufferStream = new CombinedBufferInputStream();
        this.reader = ASN1.getReader(bufferStream);
    }

    public void close() {
        this.socket.close();
    }

    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    void closeInternal() {
        this.closed = true;
    }

    public void flush() {
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            Message m = ProtocolMessages.ERR_INTERNALOS_CLOSED.get();
            throw new IOException(m.toString());
        }
        this.byteBuffer = ByteString.wrap(b, off, len).asReader();
        try {
            while (this.reader.elementAvailable()) {
                LDAPMessage msg = LDAPReader.readMessage(this.reader);
                this.processMessage(msg);
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        if (this.saveBufferReader.remaining() == 0) {
            this.saveBuffer.clear();
            this.saveBufferReader.rewind();
        }
        if (this.byteBuffer.remaining() > 0) {
            this.saveBuffer.append(this.byteBuffer, this.byteBuffer.remaining());
        }
    }

    public synchronized void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    private void processMessage(LDAPMessage message) throws IOException {
        switch (message.getProtocolOpType()) {
            case 80: {
                return;
            }
            case 104: {
                this.processAddOperation(message);
                break;
            }
            case 96: {
                this.processBindOperation(message);
                break;
            }
            case 110: {
                this.processCompareOperation(message);
                break;
            }
            case 74: {
                this.processDeleteOperation(message);
                break;
            }
            case 119: {
                this.processExtendedOperation(message);
                break;
            }
            case 102: {
                this.processModifyOperation(message);
                break;
            }
            case 108: {
                this.processModifyDNOperation(message);
                break;
            }
            case 99: {
                this.processSearchOperation(message);
                break;
            }
            case 66: {
                this.socket.close();
                break;
            }
            default: {
                Message m = ProtocolMessages.ERR_INTERNALOS_INVALID_REQUEST.get(message.getProtocolElementName());
                throw new IOException(m.toString());
            }
        }
    }

    private void processAddOperation(LDAPMessage message) throws IOException {
        int messageID = message.getMessageID();
        AddRequestProtocolOp request = message.getAddRequestProtocolOp();
        InternalClientConnection conn = this.socket.getConnection();
        AddOperationBasis op = new AddOperationBasis(conn, conn.nextOperationID(), messageID, message.getControls(), request.getDN(), request.getAttributes());
        op.run();
        AddResponseProtocolOp addResponse = new AddResponseProtocolOp(op.getResultCode().getIntValue(), op.getErrorMessage().toMessage(), op.getMatchedDN(), op.getReferralURLs());
        List responseControls = op.getResponseControls();
        this.socket.getInputStream().addLDAPMessage(new LDAPMessage(messageID, addResponse, responseControls));
    }

    private void processBindOperation(LDAPMessage message) throws IOException {
        int messageID = message.getMessageID();
        BindRequestProtocolOp request = message.getBindRequestProtocolOp();
        if (request.getAuthenticationType() == AuthenticationType.SASL) {
            Message m = ProtocolMessages.ERR_INTERNALOS_SASL_BIND_NOT_SUPPORTED.get();
            BindResponseProtocolOp bindResponse = new BindResponseProtocolOp(53, m);
            this.socket.getInputStream().addLDAPMessage(new LDAPMessage(messageID, bindResponse));
            return;
        }
        InternalClientConnection conn = this.socket.getConnection();
        BindOperationBasis op = new BindOperationBasis((ClientConnection)conn, conn.nextOperationID(), messageID, message.getControls(), String.valueOf(request.getProtocolVersion()), request.getDN(), request.getSimplePassword());
        op.run();
        BindResponseProtocolOp bindResponse = new BindResponseProtocolOp(op.getResultCode().getIntValue(), op.getErrorMessage().toMessage(), op.getMatchedDN(), op.getReferralURLs());
        List<Control> responseControls = op.getResponseControls();
        if (bindResponse.getResultCode() == 0) {
            this.socket.setConnection(new InternalClientConnection(op.getAuthenticationInfo()));
        }
        this.socket.getInputStream().addLDAPMessage(new LDAPMessage(messageID, bindResponse, responseControls));
    }

    private void processCompareOperation(LDAPMessage message) throws IOException {
        int messageID = message.getMessageID();
        CompareRequestProtocolOp request = message.getCompareRequestProtocolOp();
        InternalClientConnection conn = this.socket.getConnection();
        CompareOperationBasis op = new CompareOperationBasis((ClientConnection)conn, conn.nextOperationID(), messageID, message.getControls(), request.getDN(), request.getAttributeType(), request.getAssertionValue());
        op.run();
        CompareResponseProtocolOp compareResponse = new CompareResponseProtocolOp(op.getResultCode().getIntValue(), op.getErrorMessage().toMessage(), op.getMatchedDN(), op.getReferralURLs());
        List<Control> responseControls = op.getResponseControls();
        this.socket.getInputStream().addLDAPMessage(new LDAPMessage(messageID, compareResponse, responseControls));
    }

    private void processDeleteOperation(LDAPMessage message) throws IOException {
        int messageID = message.getMessageID();
        DeleteRequestProtocolOp request = message.getDeleteRequestProtocolOp();
        InternalClientConnection conn = this.socket.getConnection();
        DeleteOperationBasis op = new DeleteOperationBasis((ClientConnection)conn, conn.nextOperationID(), messageID, message.getControls(), request.getDN());
        op.run();
        DeleteResponseProtocolOp deleteResponse = new DeleteResponseProtocolOp(op.getResultCode().getIntValue(), op.getErrorMessage().toMessage(), op.getMatchedDN(), op.getReferralURLs());
        List<Control> responseControls = op.getResponseControls();
        this.socket.getInputStream().addLDAPMessage(new LDAPMessage(messageID, deleteResponse, responseControls));
    }

    private void processExtendedOperation(LDAPMessage message) throws IOException {
        int messageID = message.getMessageID();
        ExtendedRequestProtocolOp request = message.getExtendedRequestProtocolOp();
        if (request.getOID().equals("1.3.6.1.4.1.1466.20037")) {
            Message m = ProtocolMessages.ERR_INTERNALOS_STARTTLS_NOT_SUPPORTED.get();
            ExtendedResponseProtocolOp extendedResponse = new ExtendedResponseProtocolOp(53, m);
            this.socket.getInputStream().addLDAPMessage(new LDAPMessage(messageID, extendedResponse));
            return;
        }
        InternalClientConnection conn = this.socket.getConnection();
        ExtendedOperationBasis op = new ExtendedOperationBasis(conn, conn.nextOperationID(), messageID, message.getControls(), request.getOID(), request.getValue());
        op.run();
        ExtendedResponseProtocolOp extendedResponse = new ExtendedResponseProtocolOp(op.getResultCode().getIntValue(), op.getErrorMessage().toMessage(), op.getMatchedDN(), op.getReferralURLs(), op.getResponseOID(), op.getResponseValue());
        List<Control> responseControls = op.getResponseControls();
        this.socket.getInputStream().addLDAPMessage(new LDAPMessage(messageID, extendedResponse, responseControls));
    }

    private void processModifyOperation(LDAPMessage message) throws IOException {
        int messageID = message.getMessageID();
        ModifyRequestProtocolOp request = message.getModifyRequestProtocolOp();
        InternalClientConnection conn = this.socket.getConnection();
        ModifyOperationBasis op = new ModifyOperationBasis((ClientConnection)conn, conn.nextOperationID(), messageID, message.getControls(), request.getDN(), request.getModifications());
        op.run();
        ModifyResponseProtocolOp modifyResponse = new ModifyResponseProtocolOp(op.getResultCode().getIntValue(), op.getErrorMessage().toMessage(), op.getMatchedDN(), op.getReferralURLs());
        List<Control> responseControls = op.getResponseControls();
        this.socket.getInputStream().addLDAPMessage(new LDAPMessage(messageID, modifyResponse, responseControls));
    }

    private void processModifyDNOperation(LDAPMessage message) throws IOException {
        int messageID = message.getMessageID();
        ModifyDNRequestProtocolOp request = message.getModifyDNRequestProtocolOp();
        InternalClientConnection conn = this.socket.getConnection();
        ModifyDNOperationBasis op = new ModifyDNOperationBasis((ClientConnection)conn, conn.nextOperationID(), messageID, message.getControls(), request.getEntryDN(), request.getNewRDN(), request.deleteOldRDN(), request.getNewSuperior());
        op.run();
        ModifyDNResponseProtocolOp modifyDNResponse = new ModifyDNResponseProtocolOp(op.getResultCode().getIntValue(), op.getErrorMessage().toMessage(), op.getMatchedDN(), op.getReferralURLs());
        List<Control> responseControls = op.getResponseControls();
        this.socket.getInputStream().addLDAPMessage(new LDAPMessage(messageID, modifyDNResponse, responseControls));
    }

    private void processSearchOperation(LDAPMessage message) throws IOException {
        int messageID = message.getMessageID();
        SearchRequestProtocolOp request = message.getSearchRequestProtocolOp();
        InternalClientConnection conn = this.socket.getConnection();
        InternalSearchOperation op = new InternalSearchOperation((ClientConnection)conn, conn.nextOperationID(), messageID, message.getControls(), request.getBaseDN(), request.getScope(), request.getDereferencePolicy(), request.getSizeLimit(), request.getTimeLimit(), request.getTypesOnly(), request.getFilter(), request.getAttributes(), (InternalSearchListener)this);
        op.run();
        SearchResultDoneProtocolOp searchDone = new SearchResultDoneProtocolOp(op.getResultCode().getIntValue(), op.getErrorMessage().toMessage(), op.getMatchedDN(), op.getReferralURLs());
        List<Control> responseControls = op.getResponseControls();
        this.socket.getInputStream().addLDAPMessage(new LDAPMessage(messageID, searchDone, responseControls));
    }

    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public void handleInternalSearchEntry(InternalSearchOperation searchOperation, SearchResultEntry searchEntry) {
        List<Control> entryControls = searchEntry.getControls();
        SearchResultEntryProtocolOp entry = new SearchResultEntryProtocolOp(searchEntry);
        this.socket.getInputStream().addLDAPMessage(new LDAPMessage(searchOperation.getMessageID(), entry, entryControls));
    }

    @PublicAPI(stability=StabilityLevel.PRIVATE, mayInstantiate=false, mayExtend=false, mayInvoke=false)
    public void handleInternalSearchReference(InternalSearchOperation searchOperation, SearchResultReference searchReference) {
        List<Control> entryControls = searchReference.getControls();
        SearchResultReferenceProtocolOp reference = new SearchResultReferenceProtocolOp(searchReference);
        this.socket.getInputStream().addLDAPMessage(new LDAPMessage(searchOperation.getMessageID(), reference, entryControls));
    }

    public String toString() {
        return "InternalLDAPOutputStream";
    }

    private class CombinedBufferInputStream
    extends InputStream {
        private CombinedBufferInputStream() {
        }

        public int available() {
            return InternalLDAPOutputStream.this.saveBufferReader.remaining() + InternalLDAPOutputStream.this.byteBuffer.remaining();
        }

        public int read() {
            if (InternalLDAPOutputStream.this.saveBufferReader.remaining() > 0) {
                return 0xFF & InternalLDAPOutputStream.this.saveBufferReader.get();
            }
            if (InternalLDAPOutputStream.this.byteBuffer.remaining() > 0) {
                return 0xFF & InternalLDAPOutputStream.this.byteBuffer.get();
            }
            return -1;
        }

        public int read(byte[] bytes) {
            return this.read(bytes, 0, bytes.length);
        }

        public int read(byte[] value, int off, int length) {
            int len;
            int bytesCopied = 0;
            if (InternalLDAPOutputStream.this.saveBufferReader.remaining() > 0) {
                len = Math.min(InternalLDAPOutputStream.this.saveBufferReader.remaining(), length);
                InternalLDAPOutputStream.this.saveBufferReader.get(value, off, len);
                bytesCopied += len;
            }
            if (bytesCopied < length && InternalLDAPOutputStream.this.byteBuffer.remaining() > 0) {
                len = Math.min(InternalLDAPOutputStream.this.byteBuffer.remaining(), length - bytesCopied);
                InternalLDAPOutputStream.this.byteBuffer.get(value, off + bytesCopied, len);
                bytesCopied += len;
            }
            return bytesCopied;
        }

        public long skip(long length) {
            int len;
            int bytesSkipped = 0;
            if (InternalLDAPOutputStream.this.saveBufferReader.remaining() > 0) {
                len = Math.min(InternalLDAPOutputStream.this.saveBufferReader.remaining(), (int)length);
                InternalLDAPOutputStream.this.saveBufferReader.position(InternalLDAPOutputStream.this.saveBufferReader.position() + len);
                bytesSkipped += len;
            }
            if ((long)bytesSkipped < length && InternalLDAPOutputStream.this.byteBuffer.remaining() > 0) {
                len = Math.min(InternalLDAPOutputStream.this.byteBuffer.remaining(), (int)length - bytesSkipped);
                InternalLDAPOutputStream.this.byteBuffer.position(InternalLDAPOutputStream.this.byteBuffer.position() + len);
                bytesSkipped += len;
            }
            return bytesSkipped;
        }
    }
}

