/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ReadableByteChannel;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1InputStreamReader;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.types.ByteSequenceReader;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;

public final class ASN1ByteChannelReader
implements ASN1Reader {
    private final ReadableByteChannel byteChannel;
    private final ASN1InputStreamReader reader;
    private final ByteBuffer byteBuffer;
    private final ByteStringBuilder saveBuffer;
    private final ByteSequenceReader saveBufferReader;

    ASN1ByteChannelReader(ReadableByteChannel channel, int bufferSize, int maxElementSize) {
        this.byteChannel = channel;
        this.byteBuffer = ByteBuffer.allocate(bufferSize);
        this.byteBuffer.flip();
        this.saveBuffer = new ByteStringBuilder();
        this.saveBufferReader = this.saveBuffer.asReader();
        CombinedBufferInputStream bufferStream = new CombinedBufferInputStream();
        this.reader = new ASN1InputStreamReader(bufferStream, maxElementSize);
    }

    public int processChannelData() throws IOException {
        if (this.saveBufferReader.remaining() == 0) {
            this.saveBuffer.clear();
            this.saveBufferReader.rewind();
        }
        if (this.byteBuffer.remaining() > 0) {
            this.saveBuffer.append(this.byteBuffer, this.byteBuffer.remaining());
        }
        this.byteBuffer.clear();
        int read = this.byteChannel.read(this.byteBuffer);
        this.byteBuffer.flip();
        return read;
    }

    public boolean elementAvailable() throws ASN1Exception {
        return this.reader.elementAvailable();
    }

    public boolean hasNextElement() throws ASN1Exception {
        return this.reader.hasNextElement();
    }

    public int peekLength() throws ASN1Exception {
        return this.reader.peekLength();
    }

    public byte peekType() throws ASN1Exception {
        return this.reader.peekType();
    }

    public boolean readBoolean() throws ASN1Exception {
        return this.reader.readBoolean();
    }

    public void readEndSequence() throws ASN1Exception {
        this.reader.readEndSequence();
    }

    public void readEndSet() throws ASN1Exception {
        this.reader.readEndSet();
    }

    public int readEnumerated() throws ASN1Exception {
        return this.reader.readEnumerated();
    }

    public long readInteger() throws ASN1Exception {
        return this.reader.readInteger();
    }

    public void readNull() throws ASN1Exception {
        this.reader.readNull();
    }

    public ByteString readOctetString() throws ASN1Exception {
        return this.reader.readOctetString();
    }

    public void readOctetString(ByteStringBuilder buffer) throws ASN1Exception {
        this.reader.readOctetString(buffer);
    }

    public String readOctetStringAsString() throws ASN1Exception {
        return this.reader.readOctetStringAsString();
    }

    public String readOctetStringAsString(String charSet) throws ASN1Exception {
        return this.reader.readOctetStringAsString(charSet);
    }

    public void readStartSequence() throws ASN1Exception {
        this.reader.readStartSequence();
    }

    public void readStartSet() throws ASN1Exception {
        this.reader.readStartSet();
    }

    public void close() throws IOException {
        this.reader.close();
        this.byteChannel.close();
    }

    public void skipElement() throws ASN1Exception {
        this.reader.skipElement();
    }

    private final class CombinedBufferInputStream
    extends InputStream {
        private CombinedBufferInputStream() {
        }

        public int available() {
            return ASN1ByteChannelReader.this.saveBufferReader.remaining() + ASN1ByteChannelReader.this.byteBuffer.remaining();
        }

        public int read() {
            if (ASN1ByteChannelReader.this.saveBufferReader.remaining() > 0) {
                return 0xFF & ASN1ByteChannelReader.this.saveBufferReader.get();
            }
            if (ASN1ByteChannelReader.this.byteBuffer.remaining() > 0) {
                return 0xFF & ASN1ByteChannelReader.this.byteBuffer.get();
            }
            throw new IllegalBlockingModeException();
        }

        public int read(byte[] b) {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) {
            int getLen;
            if (off < 0 || len < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int bytesCopied = 0;
            if (ASN1ByteChannelReader.this.saveBufferReader.remaining() > 0) {
                getLen = Math.min(ASN1ByteChannelReader.this.saveBufferReader.remaining(), len);
                ASN1ByteChannelReader.this.saveBufferReader.get(b, off, getLen);
                bytesCopied += getLen;
            }
            if (bytesCopied < len && ASN1ByteChannelReader.this.byteBuffer.remaining() > 0) {
                getLen = Math.min(ASN1ByteChannelReader.this.byteBuffer.remaining(), len - bytesCopied);
                ASN1ByteChannelReader.this.byteBuffer.get(b, off + bytesCopied, getLen);
                bytesCopied += getLen;
            }
            if (bytesCopied < len) {
                throw new IllegalBlockingModeException();
            }
            return bytesCopied;
        }

        public long skip(long length) {
            int len;
            int bytesSkipped = 0;
            if (ASN1ByteChannelReader.this.saveBufferReader.remaining() > 0) {
                len = Math.min(ASN1ByteChannelReader.this.saveBufferReader.remaining(), (int)length);
                ASN1ByteChannelReader.this.saveBufferReader.position(ASN1ByteChannelReader.this.saveBufferReader.position() + len);
                bytesSkipped += len;
            }
            if ((long)bytesSkipped < length && ASN1ByteChannelReader.this.byteBuffer.remaining() > 0) {
                len = Math.min(ASN1ByteChannelReader.this.byteBuffer.remaining(), (int)length - bytesSkipped);
                ASN1ByteChannelReader.this.byteBuffer.position(ASN1ByteChannelReader.this.byteBuffer.position() + len);
                bytesSkipped += len;
            }
            if ((long)bytesSkipped < length) {
                throw new IllegalBlockingModeException();
            }
            return bytesSkipped;
        }
    }
}

