/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.AccessLogPublisherCfg;
import org.opends.server.admin.std.server.FileBasedAccessLogPublisherCfg;
import org.opends.server.api.AccessLogPublisher;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.AbandonOperation;
import org.opends.server.core.AddOperation;
import org.opends.server.core.BindOperation;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.UnbindOperation;
import org.opends.server.loggers.AsyncronousTextWriter;
import org.opends.server.loggers.LogPublisherErrorHandler;
import org.opends.server.loggers.MultifileTextWriter;
import org.opends.server.loggers.ParallelTextWriter;
import org.opends.server.loggers.TextWriter;
import org.opends.server.loggers.TimeStampNaming;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.FilePermission;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Operation;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextAccessLogPublisher
extends AccessLogPublisher<FileBasedAccessLogPublisherCfg>
implements ConfigurationChangeListener<FileBasedAccessLogPublisherCfg> {
    private static final String CATEGORY_RESPONSE = "RES";
    private static final String CATEGORY_REQUEST = "REQ";
    private FileBasedAccessLogPublisherCfg currentConfig;
    private boolean suppressInternalOperations = true;
    private boolean suppressSynchronizationOperations = false;
    private TextWriter writer;

    public static TextAccessLogPublisher getStartupTextAccessPublisher(TextWriter writer, boolean suppressInternal) {
        TextAccessLogPublisher startupPublisher = new TextAccessLogPublisher();
        startupPublisher.writer = writer;
        startupPublisher.suppressInternalOperations = suppressInternal;
        return startupPublisher;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(FileBasedAccessLogPublisherCfg config) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        this.suppressInternalOperations = config.isSuppressInternalOperations();
        this.suppressSynchronizationOperations = config.isSuppressSynchronizationOperations();
        File logFile = StaticUtils.getFileForPath(config.getLogFile());
        TimeStampNaming fnPolicy = new TimeStampNaming(logFile);
        try {
            boolean writerAutoFlush;
            FilePermission perm = FilePermission.decodeUNIXMode(config.getLogFilePermissions());
            boolean bl = writerAutoFlush = config.isAutoFlush() && !config.isAsynchronous();
            TextWriter currentWriter = this.writer instanceof AsyncronousTextWriter ? ((AsyncronousTextWriter)this.writer).getWrappedWriter() : (this.writer instanceof ParallelTextWriter ? ((ParallelTextWriter)this.writer).getWrappedWriter() : this.writer);
            if (currentWriter instanceof MultifileTextWriter) {
                TextWriter asyncWriter;
                MultifileTextWriter mfWriter = (MultifileTextWriter)currentWriter;
                mfWriter.setNamingPolicy(fnPolicy);
                mfWriter.setFilePermissions(perm);
                mfWriter.setAppend(config.isAppend());
                mfWriter.setAutoFlush(writerAutoFlush);
                mfWriter.setBufferSize((int)config.getBufferSize());
                mfWriter.setInterval(config.getTimeInterval());
                mfWriter.removeAllRetentionPolicies();
                mfWriter.removeAllRotationPolicies();
                for (DN dn : config.getRotationPolicyDNs()) {
                    mfWriter.addRotationPolicy(DirectoryServer.getRotationPolicy(dn));
                }
                for (DN dn : config.getRetentionPolicyDNs()) {
                    mfWriter.addRetentionPolicy(DirectoryServer.getRetentionPolicy(dn));
                }
                if (this.writer instanceof AsyncronousTextWriter && !config.isAsynchronous()) {
                    asyncWriter = (AsyncronousTextWriter)this.writer;
                    this.writer = mfWriter;
                    ((AsyncronousTextWriter)asyncWriter).shutdown(false);
                }
                if (this.writer instanceof ParallelTextWriter && !config.isAsynchronous()) {
                    asyncWriter = (ParallelTextWriter)this.writer;
                    this.writer = mfWriter;
                    ((ParallelTextWriter)asyncWriter).shutdown(false);
                }
                if (!(this.writer instanceof AsyncronousTextWriter) && config.isAsynchronous()) {
                    this.writer = asyncWriter = new AsyncronousTextWriter("Asyncronous Text Writer for " + config.dn().toNormalizedString(), config.getQueueSize(), config.isAutoFlush(), mfWriter);
                }
                if (!(this.writer instanceof ParallelTextWriter) && config.isAsynchronous()) {
                    this.writer = asyncWriter = new ParallelTextWriter("Parallel Text Writer for " + config.dn().toNormalizedString(), config.isAutoFlush(), mfWriter);
                }
                if (this.currentConfig.isAsynchronous() && config.isAsynchronous() && this.currentConfig.getQueueSize() != config.getQueueSize()) {
                    adminActionRequired = true;
                }
                this.currentConfig = config;
            }
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_CREATE_WRITER.get(config.dn().toString(), StaticUtils.stackTraceToSingleLineString(e));
            resultCode = DirectoryServer.getServerErrorResultCode();
            messages.add(message);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public void close() {
        this.writer.shutdown();
        if (this.currentConfig != null) {
            this.currentConfig.removeFileBasedAccessChangeListener(this);
        }
    }

    @Override
    public DN getDN() {
        if (this.currentConfig != null) {
            return this.currentConfig.dn();
        }
        return null;
    }

    @Override
    public void initializeAccessLogPublisher(FileBasedAccessLogPublisherCfg config) throws ConfigException, InitializationException {
        File logFile = StaticUtils.getFileForPath(config.getLogFile());
        TimeStampNaming fnPolicy = new TimeStampNaming(logFile);
        try {
            FilePermission perm = FilePermission.decodeUNIXMode(config.getLogFilePermissions());
            LogPublisherErrorHandler errorHandler = new LogPublisherErrorHandler(config.dn());
            boolean writerAutoFlush = config.isAutoFlush() && !config.isAsynchronous();
            MultifileTextWriter writer = new MultifileTextWriter("Multifile Text Writer for " + config.dn().toNormalizedString(), config.getTimeInterval(), fnPolicy, perm, errorHandler, "UTF-8", writerAutoFlush, config.isAppend(), (int)config.getBufferSize());
            for (DN dn : config.getRotationPolicyDNs()) {
                writer.addRotationPolicy(DirectoryServer.getRotationPolicy(dn));
            }
            for (DN dn : config.getRetentionPolicyDNs()) {
                writer.addRetentionPolicy(DirectoryServer.getRetentionPolicy(dn));
            }
            this.writer = config.isAsynchronous() ? (config.getQueueSize() > 0 ? new AsyncronousTextWriter("Asyncronous Text Writer for " + config.dn().toNormalizedString(), config.getQueueSize(), config.isAutoFlush(), writer) : new ParallelTextWriter("Parallel Text Writer for " + config.dn().toNormalizedString(), config.isAutoFlush(), writer)) : writer;
        }
        catch (DirectoryException e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_CREATE_WRITER.get(config.dn().toString(), String.valueOf(e));
            throw new InitializationException(message, (Throwable)e);
        }
        catch (IOException e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_CANNOT_OPEN_FILE.get(logFile.toString(), config.dn().toString(), String.valueOf(e));
            throw new InitializationException(message, (Throwable)e);
        }
        this.suppressInternalOperations = config.isSuppressInternalOperations();
        this.suppressSynchronizationOperations = config.isSuppressSynchronizationOperations();
        this.currentConfig = config;
        config.addFileBasedAccessChangeListener(this);
    }

    @Override
    public boolean isConfigurationAcceptable(AccessLogPublisherCfg configuration, List<Message> unacceptableReasons) {
        FileBasedAccessLogPublisherCfg config = (FileBasedAccessLogPublisherCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(FileBasedAccessLogPublisherCfg config, List<Message> unacceptableReasons) {
        try {
            FilePermission filePerm = FilePermission.decodeUNIXMode(config.getLogFilePermissions());
            if (!filePerm.isOwnerWritable()) {
                Message message = ConfigMessages.ERR_CONFIG_LOGGING_INSANE_MODE.get(config.getLogFilePermissions());
                unacceptableReasons.add(message);
                return false;
            }
        }
        catch (DirectoryException e) {
            Message message = ConfigMessages.ERR_CONFIG_LOGGING_MODE_INVALID.get(config.getLogFilePermissions(), String.valueOf(e));
            unacceptableReasons.add(message);
            return false;
        }
        return true;
    }

    @Override
    public void logAbandonIntermediateMessage(AbandonOperation abandonOperation, String category, Map<String, String> content) {
        this.logIntermediateMessage(abandonOperation, "ABANDON", category, content);
    }

    @Override
    public void logAbandonRequest(AbandonOperation abandonOperation) {
        if (!this.isLoggable(abandonOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(abandonOperation, "ABANDON", CATEGORY_REQUEST, buffer);
        buffer.append(" idToAbandon=");
        buffer.append(abandonOperation.getIDToAbandon());
        if (abandonOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logAbandonResult(AbandonOperation abandonOperation) {
        if (!this.isLoggable(abandonOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(abandonOperation, "ABANDON", CATEGORY_RESPONSE, buffer);
        buffer.append(" result=");
        buffer.append(abandonOperation.getResultCode().getIntValue());
        MessageBuilder msg = abandonOperation.getErrorMessage();
        if (msg != null && msg.length() > 0) {
            buffer.append(" message=\"");
            buffer.append(msg);
            buffer.append('\"');
        }
        if ((msg = abandonOperation.getAdditionalLogMessage()) != null && msg.length() > 0) {
            buffer.append(" additionalInfo=\"");
            buffer.append(msg);
            buffer.append('\"');
        }
        buffer.append(" etime=");
        buffer.append(abandonOperation.getProcessingTime());
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logAddIntermediateMessage(AddOperation addOperation, String category, Map<String, String> content) {
        this.logIntermediateMessage(addOperation, "ADD", category, content);
    }

    @Override
    public void logAddRequest(AddOperation addOperation) {
        if (!this.isLoggable(addOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(addOperation, "ADD", CATEGORY_REQUEST, buffer);
        buffer.append(" dn=\"");
        buffer.append(addOperation.getRawEntryDN().toString());
        buffer.append("\"");
        if (addOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logAddResponse(AddOperation addOperation) {
        DN proxiedAuthDN;
        if (!this.isLoggable(addOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(addOperation, "ADD", CATEGORY_RESPONSE, buffer);
        buffer.append(" result=");
        buffer.append(addOperation.getResultCode().getIntValue());
        MessageBuilder msg = addOperation.getErrorMessage();
        if (msg != null && msg.length() > 0) {
            buffer.append(" message=\"");
            buffer.append(msg);
            buffer.append('\"');
        }
        if ((msg = addOperation.getAdditionalLogMessage()) != null && msg.length() > 0) {
            buffer.append(" additionalInfo=\"");
            buffer.append(msg);
            buffer.append('\"');
        }
        if ((proxiedAuthDN = addOperation.getProxiedAuthorizationDN()) != null) {
            buffer.append(" authzDN=\"");
            proxiedAuthDN.toString(buffer);
            buffer.append('\"');
        }
        buffer.append(" etime=");
        long etime = addOperation.getProcessingNanoTime();
        if (etime <= -1L) {
            etime = addOperation.getProcessingTime();
        }
        buffer.append(etime);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logBindIntermediateMessage(BindOperation bindOperation, String category, Map<String, String> content) {
        this.logIntermediateMessage(bindOperation, "BIND", category, content);
    }

    @Override
    public void logBindRequest(BindOperation bindOperation) {
        if (!this.isLoggable(bindOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(bindOperation, "BIND", CATEGORY_REQUEST, buffer);
        switch (bindOperation.getAuthenticationType()) {
            case SIMPLE: {
                buffer.append(" type=SIMPLE");
                break;
            }
            case SASL: {
                buffer.append(" type=SASL mechanism=");
                buffer.append(bindOperation.getSASLMechanism());
                break;
            }
            default: {
                buffer.append(" type=");
                buffer.append((Object)bindOperation.getAuthenticationType());
            }
        }
        buffer.append(" dn=\"");
        buffer.append(bindOperation.getRawBindDN().toString());
        buffer.append("\"");
        if (bindOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logBindResponse(BindOperation bindOperation) {
        AuthenticationInfo authInfo;
        Message failureMessage;
        if (!this.isLoggable(bindOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(bindOperation, "BIND", CATEGORY_RESPONSE, buffer);
        buffer.append(" result=");
        buffer.append(bindOperation.getResultCode().getIntValue());
        MessageBuilder msg = bindOperation.getErrorMessage();
        if (msg != null && msg.length() > 0) {
            buffer.append(" message=\"");
            buffer.append(msg);
            buffer.append('\"');
        }
        if ((failureMessage = bindOperation.getAuthFailureReason()) != null) {
            buffer.append(" authFailureID=");
            buffer.append(failureMessage.getDescriptor().getId());
            buffer.append(" authFailureReason=\"");
            buffer.append(failureMessage);
            buffer.append('\"');
        }
        if ((msg = bindOperation.getAdditionalLogMessage()) != null && msg.length() > 0) {
            buffer.append(" additionalInfo=\"");
            buffer.append(msg);
            buffer.append('\"');
        }
        if (bindOperation.getResultCode() == ResultCode.SUCCESS && (authInfo = bindOperation.getAuthenticationInfo()) != null) {
            DN authDN = authInfo.getAuthenticationDN();
            if (authDN != null) {
                buffer.append(" authDN=\"");
                authDN.toString(buffer);
                buffer.append('\"');
                DN authzDN = authInfo.getAuthorizationDN();
                if (!authDN.equals(authzDN)) {
                    buffer.append(" authzDN=\"");
                    if (authzDN != null) {
                        authzDN.toString(buffer);
                    }
                    buffer.append('\"');
                }
            } else {
                buffer.append(" authDN=\"\"");
            }
        }
        buffer.append(" etime=");
        long etime = bindOperation.getProcessingNanoTime();
        if (etime <= -1L) {
            etime = bindOperation.getProcessingTime();
        }
        buffer.append(etime);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logCompareIntermediateMessage(CompareOperation compareOperation, String category, Map<String, String> content) {
        this.logIntermediateMessage(compareOperation, "COMPARE", category, content);
    }

    @Override
    public void logCompareRequest(CompareOperation compareOperation) {
        if (!this.isLoggable(compareOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(compareOperation, "COMPARE", CATEGORY_REQUEST, buffer);
        buffer.append(" dn=\"");
        buffer.append(compareOperation.getRawEntryDN().toString());
        buffer.append("\" attr=");
        buffer.append(compareOperation.getAttributeType());
        if (compareOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logCompareResponse(CompareOperation compareOperation) {
        DN proxiedAuthDN;
        if (!this.isLoggable(compareOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(compareOperation, "COMPARE", CATEGORY_RESPONSE, buffer);
        buffer.append(" result=");
        buffer.append(compareOperation.getResultCode().getIntValue());
        MessageBuilder msg = compareOperation.getErrorMessage();
        if (msg != null && msg.length() > 0) {
            buffer.append(" message=\"");
            buffer.append(msg);
            buffer.append('\"');
        }
        if ((msg = compareOperation.getAdditionalLogMessage()) != null && msg.length() > 0) {
            buffer.append(" additionalInfo=\"");
            buffer.append(msg);
            buffer.append('\"');
        }
        if ((proxiedAuthDN = compareOperation.getProxiedAuthorizationDN()) != null) {
            buffer.append(" authzDN=\"");
            proxiedAuthDN.toString(buffer);
            buffer.append('\"');
        }
        buffer.append(" etime=");
        long etime = compareOperation.getProcessingNanoTime();
        if (etime <= -1L) {
            etime = compareOperation.getProcessingTime();
        }
        buffer.append(etime);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logConnect(ClientConnection clientConnection) {
        long connectionID = clientConnection.getConnectionID();
        if (connectionID < 0L && this.suppressInternalOperations) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" CONNECT conn=");
        buffer.append(connectionID);
        buffer.append(" from=");
        buffer.append(clientConnection.getClientHostPort());
        buffer.append(" to=");
        buffer.append(clientConnection.getServerHostPort());
        buffer.append(" protocol=");
        buffer.append(clientConnection.getProtocol());
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logConnectIntermediateMessage(ClientConnection clientConnection, String category, Map<String, String> content) {
        this.logIntermediateMessage(clientConnection, "CONNECT", category, content);
    }

    @Override
    public void logDeleteIntermediateMessage(DeleteOperation deleteOperation, String category, Map<String, String> content) {
        this.logIntermediateMessage(deleteOperation, "DELETE", category, content);
    }

    @Override
    public void logDeleteRequest(DeleteOperation deleteOperation) {
        if (!this.isLoggable(deleteOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(deleteOperation, "DELETE", CATEGORY_REQUEST, buffer);
        buffer.append(" dn=\"");
        buffer.append(deleteOperation.getRawEntryDN().toString());
        buffer.append("\"");
        if (deleteOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logDeleteResponse(DeleteOperation deleteOperation) {
        DN proxiedAuthDN;
        if (!this.isLoggable(deleteOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(deleteOperation, "DELETE", CATEGORY_RESPONSE, buffer);
        buffer.append(" result=");
        buffer.append(deleteOperation.getResultCode().getIntValue());
        MessageBuilder msg = deleteOperation.getErrorMessage();
        if (msg != null && msg.length() > 0) {
            buffer.append(" message=\"");
            buffer.append(msg);
            buffer.append('\"');
        }
        if ((msg = deleteOperation.getAdditionalLogMessage()) != null && msg.length() > 0) {
            buffer.append(" additionalInfo=\"");
            buffer.append(msg);
            buffer.append('\"');
        }
        if ((proxiedAuthDN = deleteOperation.getProxiedAuthorizationDN()) != null) {
            buffer.append(" authzDN=\"");
            proxiedAuthDN.toString(buffer);
            buffer.append('\"');
        }
        buffer.append(" etime=");
        long etime = deleteOperation.getProcessingNanoTime();
        if (etime <= -1L) {
            etime = deleteOperation.getProcessingTime();
        }
        buffer.append(etime);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logDisconnect(ClientConnection clientConnection, DisconnectReason disconnectReason, Message message) {
        long connectionID = clientConnection.getConnectionID();
        if (connectionID < 0L && this.suppressInternalOperations) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        buffer.append("[");
        buffer.append(TimeThread.getLocalTime());
        buffer.append("]");
        buffer.append(" DISCONNECT conn=");
        buffer.append(connectionID);
        buffer.append(" reason=\"");
        buffer.append((Object)disconnectReason);
        if (message != null) {
            buffer.append("\" msg=\"");
            buffer.append(message);
        }
        buffer.append("\"");
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logDisconnectIntermediateMessage(ClientConnection clientConnection, String category, Map<String, String> content) {
        this.logIntermediateMessage(clientConnection, "DISCONNECT", category, content);
    }

    @Override
    public void logExtendedIntermediateMessage(ExtendedOperation extendedOperation, String category, Map<String, String> content) {
        this.logIntermediateMessage(extendedOperation, "EXTENDED", category, content);
    }

    @Override
    public void logExtendedRequest(ExtendedOperation extendedOperation) {
        if (!this.isLoggable(extendedOperation)) {
            return;
        }
        String name = null;
        String oid = extendedOperation.getRequestOID();
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(extendedOperation, "EXTENDED", CATEGORY_REQUEST, buffer);
        ExtendedOperationHandler extOpHandler = DirectoryServer.getExtendedOperationHandler(oid);
        if (extOpHandler != null && (name = extOpHandler.getExtendedOperationName()) != null) {
            buffer.append(" name=\"");
            buffer.append(name);
            buffer.append("\"");
        }
        buffer.append(" oid=\"");
        buffer.append(oid);
        buffer.append("\"");
        if (extendedOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logExtendedResponse(ExtendedOperation extendedOperation) {
        if (!this.isLoggable(extendedOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(extendedOperation, "EXTENDED", CATEGORY_RESPONSE, buffer);
        String name = null;
        String oid = extendedOperation.getResponseOID();
        if (oid != null) {
            ExtendedOperationHandler extOpHandler = DirectoryServer.getExtendedOperationHandler(oid);
            if (extOpHandler != null && (name = extOpHandler.getExtendedOperationName()) != null) {
                buffer.append(" name=\"");
                buffer.append(name);
                buffer.append("\"");
            }
            buffer.append(" oid=\"");
            buffer.append(oid);
            buffer.append('\"');
        }
        buffer.append(" result=");
        buffer.append(extendedOperation.getResultCode().getIntValue());
        MessageBuilder msg = extendedOperation.getErrorMessage();
        if (msg != null && msg.length() > 0) {
            buffer.append(" message=\"");
            buffer.append(msg);
            buffer.append('\"');
        }
        if ((msg = extendedOperation.getAdditionalLogMessage()) != null && msg.length() > 0) {
            buffer.append(" additionalInfo=\"");
            buffer.append(msg);
            buffer.append('\"');
        }
        buffer.append(" etime=");
        long etime = extendedOperation.getProcessingNanoTime();
        if (etime <= -1L) {
            etime = extendedOperation.getProcessingTime();
        }
        buffer.append(etime);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logModifyDNIntermediateMessage(ModifyDNOperation modifyDNOperation, String category, Map<String, String> content) {
        this.logIntermediateMessage(modifyDNOperation, "MODIFY", category, content);
    }

    @Override
    public void logModifyDNRequest(ModifyDNOperation modifyDNOperation) {
        if (!this.isLoggable(modifyDNOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(modifyDNOperation, "MODIFYDN", CATEGORY_REQUEST, buffer);
        buffer.append(" dn=\"");
        buffer.append(modifyDNOperation.getRawEntryDN().toString());
        buffer.append("\" newRDN=\"");
        buffer.append(modifyDNOperation.getRawNewRDN().toString());
        buffer.append("\" deleteOldRDN=");
        buffer.append(modifyDNOperation.deleteOldRDN());
        ByteString newSuperior = modifyDNOperation.getRawNewSuperior();
        if (newSuperior != null) {
            buffer.append(" newSuperior=\"");
            buffer.append(newSuperior.toString());
        }
        if (modifyDNOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logModifyDNResponse(ModifyDNOperation modifyDNOperation) {
        DN proxiedAuthDN;
        if (!this.isLoggable(modifyDNOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(modifyDNOperation, "MODIFYDN", CATEGORY_RESPONSE, buffer);
        buffer.append(" result=");
        buffer.append(modifyDNOperation.getResultCode().getIntValue());
        MessageBuilder msg = modifyDNOperation.getErrorMessage();
        if (msg != null && msg.length() > 0) {
            buffer.append(" message=\"");
            buffer.append(msg);
            buffer.append('\"');
        }
        if ((msg = modifyDNOperation.getAdditionalLogMessage()) != null && msg.length() > 0) {
            buffer.append(" additionalInfo=\"");
            buffer.append(msg);
            buffer.append('\"');
        }
        if ((proxiedAuthDN = modifyDNOperation.getProxiedAuthorizationDN()) != null) {
            buffer.append(" authzDN=\"");
            proxiedAuthDN.toString(buffer);
            buffer.append('\"');
        }
        buffer.append(" etime=");
        long etime = modifyDNOperation.getProcessingNanoTime();
        if (etime <= -1L) {
            etime = modifyDNOperation.getProcessingTime();
        }
        buffer.append(etime);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logModifyIntermediateMessage(ModifyOperation modifyOperation, String category, Map<String, String> content) {
        this.logIntermediateMessage(modifyOperation, "MODIFY", category, content);
    }

    @Override
    public void logModifyRequest(ModifyOperation modifyOperation) {
        if (!this.isLoggable(modifyOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(modifyOperation, "MODIFY", CATEGORY_REQUEST, buffer);
        buffer.append(" dn=\"");
        buffer.append(modifyOperation.getRawEntryDN().toString());
        buffer.append("\"");
        if (modifyOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logModifyResponse(ModifyOperation modifyOperation) {
        DN proxiedAuthDN;
        if (!this.isLoggable(modifyOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(modifyOperation, "MODIFY", CATEGORY_RESPONSE, buffer);
        buffer.append(" result=");
        buffer.append(modifyOperation.getResultCode().getIntValue());
        MessageBuilder msg = modifyOperation.getErrorMessage();
        if (msg != null && msg.length() > 0) {
            buffer.append(" message=\"");
            buffer.append(msg);
            buffer.append('\"');
        }
        if ((msg = modifyOperation.getAdditionalLogMessage()) != null && msg.length() > 0) {
            buffer.append(" additionalInfo=\"");
            buffer.append(msg);
            buffer.append('\"');
        }
        if ((proxiedAuthDN = modifyOperation.getProxiedAuthorizationDN()) != null) {
            buffer.append(" authzDN=\"");
            proxiedAuthDN.toString(buffer);
            buffer.append('\"');
        }
        buffer.append(" etime=");
        long etime = modifyOperation.getProcessingNanoTime();
        if (etime <= -1L) {
            etime = modifyOperation.getProcessingTime();
        }
        buffer.append(etime);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logSearchIntermediateMessage(SearchOperation searchOperation, String category, Map<String, String> content) {
        this.logIntermediateMessage(searchOperation, "SEARCH", category, content);
    }

    @Override
    public void logSearchRequest(SearchOperation searchOperation) {
        if (!this.isLoggable(searchOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(searchOperation, "SEARCH", CATEGORY_REQUEST, buffer);
        buffer.append(" base=\"");
        buffer.append(searchOperation.getRawBaseDN().toString());
        buffer.append("\" scope=");
        buffer.append((Object)searchOperation.getScope());
        buffer.append(" filter=\"");
        searchOperation.getRawFilter().toString(buffer);
        LinkedHashSet<String> attrs = searchOperation.getAttributes();
        if (attrs == null || attrs.isEmpty()) {
            buffer.append("\" attrs=\"ALL\"");
        } else {
            buffer.append("\" attrs=\"");
            Iterator iterator = attrs.iterator();
            buffer.append((String)iterator.next());
            while (iterator.hasNext()) {
                buffer.append(",");
                buffer.append((String)iterator.next());
            }
            buffer.append("\"");
        }
        if (searchOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logSearchResultDone(SearchOperation searchOperation) {
        DN proxiedAuthDN;
        if (!this.isLoggable(searchOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(searchOperation, "SEARCH", CATEGORY_RESPONSE, buffer);
        buffer.append(" result=");
        buffer.append(searchOperation.getResultCode().getIntValue());
        MessageBuilder msg = searchOperation.getErrorMessage();
        if (msg != null && msg.length() > 0) {
            buffer.append(" message=\"");
            buffer.append(msg);
            buffer.append('\"');
        }
        buffer.append(" nentries=");
        buffer.append(searchOperation.getEntriesSent());
        msg = searchOperation.getAdditionalLogMessage();
        if (msg != null && msg.length() > 0) {
            buffer.append(" additionalInfo=\"");
            buffer.append(msg);
            buffer.append('\"');
        }
        if ((proxiedAuthDN = searchOperation.getProxiedAuthorizationDN()) != null) {
            buffer.append(" authzDN=\"");
            proxiedAuthDN.toString(buffer);
            buffer.append('\"');
        }
        buffer.append(" etime=");
        long etime = searchOperation.getProcessingNanoTime();
        if (etime <= -1L) {
            etime = searchOperation.getProcessingTime();
        }
        buffer.append(etime);
        this.writer.writeRecord(buffer.toString());
    }

    @Override
    public void logUnbind(UnbindOperation unbindOperation) {
        if (!this.isLoggable(unbindOperation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(unbindOperation, "UNBIND", CATEGORY_REQUEST, buffer);
        if (unbindOperation.isSynchronizationOperation()) {
            buffer.append(" type=synchronization");
        }
        this.writer.writeRecord(buffer.toString());
    }

    private void appendHeader(Operation operation, String opType, String category, StringBuilder buffer) {
        buffer.append('[');
        buffer.append(TimeThread.getLocalTime());
        buffer.append("] ");
        buffer.append(opType);
        buffer.append(' ');
        buffer.append(category);
        buffer.append(" conn=");
        buffer.append(operation.getConnectionID());
        buffer.append(" op=");
        buffer.append(operation.getOperationID());
        buffer.append(" msgID=");
        buffer.append(operation.getMessageID());
    }

    private boolean isLoggable(Operation operation) {
        long connectionID = operation.getConnectionID();
        return connectionID >= 0L || !(operation.isSynchronizationOperation() ? this.suppressSynchronizationOperations : this.suppressInternalOperations);
    }

    private void logIntermediateMessage(Operation operation, String opType, String category, Map<String, String> content) {
        if (!this.isLoggable(operation)) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        this.appendHeader(operation, opType, category, buffer);
        for (Map.Entry<String, String> entry : content.entrySet()) {
            buffer.append(' ');
            buffer.append(entry.getKey());
            buffer.append('=');
            buffer.append(entry.getValue());
        }
        this.writer.writeRecord(buffer.toString());
    }

    private void logIntermediateMessage(ClientConnection clientConnection, String type, String category, Map<String, String> content) {
        long connectionID = clientConnection.getConnectionID();
        if (connectionID < 0L && this.suppressInternalOperations) {
            return;
        }
        StringBuilder buffer = new StringBuilder(100);
        buffer.append('[');
        buffer.append(TimeThread.getLocalTime());
        buffer.append("] ");
        buffer.append(type);
        buffer.append(' ');
        buffer.append(category);
        buffer.append(" conn=");
        buffer.append(connectionID);
        for (Map.Entry<String, String> entry : content.entrySet()) {
            buffer.append(' ');
            buffer.append(entry.getKey());
            buffer.append('=');
            buffer.append(entry.getValue());
        }
        this.writer.writeRecord(buffer.toString());
    }
}

