/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.messages.MessageBuilder;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.EntryCacheCfg;
import org.opends.server.admin.std.server.SoftReferenceEntryCacheCfg;
import org.opends.server.api.Backend;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.EntryCache;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.EntryCacheCommon;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.Attribute;
import org.opends.server.types.CacheEntry;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftReferenceEntryCache
extends EntryCache<SoftReferenceEntryCacheCfg>
implements ConfigurationChangeListener<SoftReferenceEntryCacheCfg>,
Runnable {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ConcurrentHashMap<DN, SoftReference<CacheEntry>> dnMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Backend, ConcurrentHashMap<Long, SoftReference<CacheEntry>>> idMap = new ConcurrentHashMap();
    private ReferenceQueue<CacheEntry> referenceQueue;
    private SoftReferenceEntryCacheCfg registeredConfiguration;
    private Thread cleanerThread;
    private volatile boolean shutdown = false;

    public SoftReferenceEntryCache() {
        this.setExcludeFilters(new HashSet<SearchFilter>());
        this.setIncludeFilters(new HashSet<SearchFilter>());
        this.setLockTimeout(3000L);
        this.referenceQueue = new ReferenceQueue();
    }

    @Override
    public void initializeEntryCache(SoftReferenceEntryCacheCfg configuration) throws ConfigException, InitializationException {
        this.cleanerThread = new DirectoryThread(this, "Soft Reference Entry Cache Cleaner");
        this.cleanerThread.setDaemon(true);
        this.cleanerThread.start();
        this.registeredConfiguration = configuration;
        configuration.addSoftReferenceChangeListener(this);
        this.dnMap.clear();
        this.idMap.clear();
        boolean applyChanges = true;
        ArrayList<Message> errorMessages = new ArrayList<Message>();
        EntryCacheCommon.ConfigErrorHandler errorHandler = EntryCacheCommon.getConfigErrorHandler(EntryCacheCommon.ConfigPhase.PHASE_INIT, null, errorMessages);
        if (!this.processEntryCacheConfig(configuration, applyChanges, errorHandler)) {
            MessageBuilder buffer = new MessageBuilder();
            if (!errorMessages.isEmpty()) {
                Iterator<Message> iterator = errorMessages.iterator();
                buffer.append(iterator.next());
                while (iterator.hasNext()) {
                    buffer.append(".  ");
                    buffer.append(iterator.next());
                }
            }
            Message message = ExtensionMessages.ERR_SOFTREFCACHE_CANNOT_INITIALIZE.get(buffer.toString());
            throw new ConfigException(message);
        }
    }

    @Override
    public synchronized void finalizeEntryCache() {
        this.registeredConfiguration.removeSoftReferenceChangeListener(this);
        this.shutdown = true;
        this.dnMap.clear();
        this.idMap.clear();
        if (this.cleanerThread != null) {
            for (int i = 0; this.cleanerThread.isAlive() && i < 5; ++i) {
                this.cleanerThread.interrupt();
                try {
                    this.cleanerThread.join(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.cleanerThread = null;
        }
    }

    @Override
    public boolean containsEntry(DN entryDN) {
        if (entryDN == null) {
            return false;
        }
        return this.dnMap.containsKey(entryDN);
    }

    @Override
    public Entry getEntry(DN entryDN) {
        SoftReference<CacheEntry> ref = this.dnMap.get(entryDN);
        if (ref == null) {
            this.cacheMisses.getAndIncrement();
            return null;
        }
        CacheEntry cacheEntry = ref.get();
        if (cacheEntry == null) {
            this.cacheMisses.getAndIncrement();
            return null;
        }
        this.cacheHits.getAndIncrement();
        return cacheEntry.getEntry();
    }

    @Override
    public long getEntryID(DN entryDN) {
        SoftReference<CacheEntry> ref = this.dnMap.get(entryDN);
        if (ref == null) {
            return -1L;
        }
        CacheEntry cacheEntry = ref.get();
        if (cacheEntry == null) {
            return -1L;
        }
        return cacheEntry.getEntryID();
    }

    @Override
    public DN getEntryDN(Backend backend, long entryID) {
        CacheEntry cacheEntry;
        SoftReference<CacheEntry> ref;
        ConcurrentHashMap<Long, SoftReference<CacheEntry>> backendMap = this.idMap.get(backend);
        if (backendMap != null && (ref = backendMap.get(entryID)) != null && (cacheEntry = ref.get()) != null) {
            return cacheEntry.getDN();
        }
        return null;
    }

    @Override
    public void putEntry(Entry entry, Backend backend, long entryID) {
        ConcurrentHashMap<Long, SoftReference<CacheEntry>> map;
        CacheEntry cacheEntry = new CacheEntry(entry, backend, entryID);
        SoftReference<CacheEntry> ref = new SoftReference<CacheEntry>(cacheEntry, this.referenceQueue);
        SoftReference<CacheEntry> oldRef = this.dnMap.put(entry.getDN(), ref);
        if (oldRef != null) {
            oldRef.clear();
        }
        if ((map = this.idMap.get(backend)) == null) {
            map = new ConcurrentHashMap();
            map.put(entryID, ref);
            this.idMap.put(backend, map);
        } else {
            oldRef = map.put(entryID, ref);
            if (oldRef != null) {
                oldRef.clear();
            }
        }
    }

    @Override
    public boolean putEntryIfAbsent(Entry entry, Backend backend, long entryID) {
        if (this.dnMap.containsKey(entry.getDN())) {
            return false;
        }
        CacheEntry cacheEntry = new CacheEntry(entry, backend, entryID);
        SoftReference<CacheEntry> ref = new SoftReference<CacheEntry>(cacheEntry, this.referenceQueue);
        this.dnMap.put(entry.getDN(), ref);
        ConcurrentHashMap<Long, SoftReference<CacheEntry>> map = this.idMap.get(backend);
        if (map == null) {
            map = new ConcurrentHashMap();
            map.put(entryID, ref);
            this.idMap.put(backend, map);
        } else {
            map.put(entryID, ref);
        }
        return true;
    }

    @Override
    public void removeEntry(DN entryDN) {
        SoftReference<CacheEntry> ref = this.dnMap.remove(entryDN);
        if (ref != null) {
            Backend backend;
            ConcurrentHashMap<Long, SoftReference<CacheEntry>> map;
            ref.clear();
            CacheEntry cacheEntry = ref.get();
            if (cacheEntry != null && (map = this.idMap.get(backend = cacheEntry.getBackend())) != null) {
                ref = map.remove(cacheEntry.getEntryID());
                if (ref != null) {
                    ref.clear();
                }
                if (map.isEmpty()) {
                    this.idMap.remove(backend);
                }
            }
        }
    }

    @Override
    public void clear() {
        this.dnMap.clear();
        this.idMap.clear();
    }

    @Override
    public void clearBackend(Backend backend) {
        ConcurrentHashMap<Long, SoftReference<CacheEntry>> map = this.idMap.remove(backend);
        if (map != null) {
            for (SoftReference<CacheEntry> ref : map.values()) {
                CacheEntry cacheEntry = ref.get();
                if (cacheEntry != null) {
                    this.dnMap.remove(cacheEntry.getDN());
                }
                ref.clear();
            }
            map.clear();
        }
    }

    @Override
    public void clearSubtree(DN baseDN) {
        Backend backend = DirectoryServer.getBackend(baseDN);
        if (backend == null) {
            return;
        }
        this.clearBackend(backend);
    }

    @Override
    public void handleLowMemory() {
    }

    @Override
    public boolean isConfigurationAcceptable(EntryCacheCfg configuration, List<Message> unacceptableReasons) {
        SoftReferenceEntryCacheCfg config = (SoftReferenceEntryCacheCfg)configuration;
        return this.isConfigurationChangeAcceptable(config, unacceptableReasons);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(SoftReferenceEntryCacheCfg configuration, List<Message> unacceptableReasons) {
        boolean applyChanges = false;
        EntryCacheCommon.ConfigErrorHandler errorHandler = EntryCacheCommon.getConfigErrorHandler(EntryCacheCommon.ConfigPhase.PHASE_ACCEPTABLE, unacceptableReasons, null);
        this.processEntryCacheConfig(configuration, applyChanges, errorHandler);
        return errorHandler.getIsAcceptable();
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(SoftReferenceEntryCacheCfg configuration) {
        boolean applyChanges = true;
        ArrayList<Message> errorMessages = new ArrayList<Message>();
        EntryCacheCommon.ConfigErrorHandler errorHandler = EntryCacheCommon.getConfigErrorHandler(EntryCacheCommon.ConfigPhase.PHASE_APPLY, null, errorMessages);
        if (configuration.isEnabled()) {
            this.processEntryCacheConfig(configuration, applyChanges, errorHandler);
        }
        boolean adminActionRequired = errorHandler.getIsAdminActionRequired();
        ConfigChangeResult changeResult = new ConfigChangeResult(errorHandler.getResultCode(), adminActionRequired, errorHandler.getErrorMessages());
        return changeResult;
    }

    public boolean processEntryCacheConfig(SoftReferenceEntryCacheCfg configuration, boolean applyChanges, EntryCacheCommon.ConfigErrorHandler errorHandler) {
        HashSet<SearchFilter> newIncludeFilters = null;
        HashSet<SearchFilter> newExcludeFilters = null;
        DN newConfigEntryDN = configuration.dn();
        long newLockTimeout = configuration.getLockTimeout();
        switch (errorHandler.getConfigPhase()) {
            case PHASE_INIT: 
            case PHASE_ACCEPTABLE: 
            case PHASE_APPLY: {
                newIncludeFilters = EntryCacheCommon.getFilters(configuration.getIncludeFilter(), ExtensionMessages.ERR_CACHE_INVALID_INCLUDE_FILTER, errorHandler, newConfigEntryDN);
                newExcludeFilters = EntryCacheCommon.getFilters(configuration.getExcludeFilter(), ExtensionMessages.ERR_CACHE_INVALID_EXCLUDE_FILTER, errorHandler, newConfigEntryDN);
            }
        }
        if (applyChanges && errorHandler.getIsAcceptable()) {
            this.setLockTimeout(newLockTimeout);
            this.setIncludeFilters(newIncludeFilters);
            this.setExcludeFilters(newExcludeFilters);
            this.registeredConfiguration = configuration;
        }
        return errorHandler.getIsAcceptable();
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                SoftReference<CacheEntry> ref;
                CacheEntry freedEntry = this.referenceQueue.remove().get();
                if (freedEntry == null || (ref = this.dnMap.remove(freedEntry.getDN())) == null) continue;
                CacheEntry removedEntry = ref.get();
                if (removedEntry != freedEntry) {
                    this.dnMap.putIfAbsent(freedEntry.getDN(), ref);
                    continue;
                }
                ref.clear();
                Backend backend = freedEntry.getBackend();
                ConcurrentHashMap<Long, SoftReference<CacheEntry>> map = this.idMap.get(backend);
                if (map == null) continue;
                ref = map.remove(freedEntry.getEntryID());
                if (ref != null) {
                    ref.clear();
                }
                if (!map.isEmpty()) continue;
                this.idMap.remove(backend);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    @Override
    public ArrayList<Attribute> getMonitorData() {
        ArrayList<Attribute> attrs;
        block2: {
            attrs = new ArrayList<Attribute>();
            try {
                attrs = EntryCacheCommon.getGenericMonitorData(new Long(this.cacheHits.longValue()), DirectoryServer.getEntryCache().getCacheMisses(), null, null, new Long(this.dnMap.size()), null);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        return attrs;
    }

    @Override
    public Long getCacheCount() {
        return new Long(this.dnMap.size());
    }

    private String toVerboseString() {
        String verboseString = new String();
        StringBuilder sb = new StringBuilder();
        for (SoftReference<CacheEntry> ce : this.dnMap.values()) {
            sb.append(ce.get().getDN().toString());
            sb.append(":");
            sb.append(Long.toString(ce.get().getEntryID()));
            sb.append(":");
            sb.append(ce.get().getBackend().getBackendID());
            sb.append(ServerConstants.EOL);
        }
        verboseString = sb.toString();
        return verboseString.length() > 0 ? verboseString : null;
    }
}

