/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.HashSet;
import java.util.Set;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.PasswordPolicySubentryVirtualAttributeCfg;
import org.opends.server.api.VirtualAttributeProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.VirtualAttributeRule;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordPolicySubentryVirtualAttributeProvider
extends VirtualAttributeProvider<PasswordPolicySubentryVirtualAttributeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public void initializeVirtualAttributeProvider(PasswordPolicySubentryVirtualAttributeCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public Set<AttributeValue> getValues(Entry entry, VirtualAttributeRule rule) {
        HashSet<AttributeValue> valueSet = new HashSet<AttributeValue>();
        if (!entry.isSubentry() && !entry.isLDAPSubentry()) {
            PasswordPolicy policy;
            block6: {
                policy = null;
                try {
                    policy = PasswordPolicyState.getPasswordPolicy(entry, false);
                }
                catch (DirectoryException de) {
                    ErrorLogger.logError(de.getMessageObject());
                    if (!DebugLogger.debugEnabled()) break block6;
                    TRACER.debugError("Failed to retrieve password policy for user %s: %s", entry.getDN().toString(), StaticUtils.stackTraceToSingleLineString(de));
                }
            }
            if (policy != null) {
                AttributeType dnAttrType = DirectoryServer.getAttributeType("1.3.6.1.4.1.42.2.27.8.1.23");
                DN policyDN = policy.getConfigEntryDN();
                AttributeValue value = AttributeValues.create(dnAttrType, policyDN.toString());
                valueSet.add(value);
            } else if (DebugLogger.debugEnabled()) {
                TRACER.debugError("No applicable password policy for user %s" + entry.getDN().toString());
            }
        }
        return valueSet;
    }

    @Override
    public boolean isSearchable(VirtualAttributeRule rule, SearchOperation searchOperation) {
        return false;
    }

    @Override
    public void processSearch(VirtualAttributeRule rule, SearchOperation searchOperation) {
        searchOperation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
        Message message = ExtensionMessages.ERR_PASSWORDPOLICYSUBENTRY_VATTR_NOT_SEARCHABLE.get(rule.getAttributeType().getNameOrOID());
        searchOperation.appendErrorMessage(message);
    }
}

