/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.messages.ExtensionMessages;
import org.opends.messages.Message;
import org.opends.server.admin.std.server.PasswordPolicyStateExtendedOperationHandlerCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.schema.GeneralizedTimeSyntax;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringBuilder;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Modification;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordPolicyStateExtendedOperation
extends ExtendedOperationHandler<PasswordPolicyStateExtendedOperationHandlerCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    public static final int OP_GET_PASSWORD_POLICY_DN = 0;
    public static final int OP_GET_ACCOUNT_DISABLED_STATE = 1;
    public static final int OP_SET_ACCOUNT_DISABLED_STATE = 2;
    public static final int OP_CLEAR_ACCOUNT_DISABLED_STATE = 3;
    public static final int OP_GET_ACCOUNT_EXPIRATION_TIME = 4;
    public static final int OP_SET_ACCOUNT_EXPIRATION_TIME = 5;
    public static final int OP_CLEAR_ACCOUNT_EXPIRATION_TIME = 6;
    public static final int OP_GET_SECONDS_UNTIL_ACCOUNT_EXPIRATION = 7;
    public static final int OP_GET_PASSWORD_CHANGED_TIME = 8;
    public static final int OP_SET_PASSWORD_CHANGED_TIME = 9;
    public static final int OP_CLEAR_PASSWORD_CHANGED_TIME = 10;
    public static final int OP_GET_PASSWORD_EXPIRATION_WARNED_TIME = 11;
    public static final int OP_SET_PASSWORD_EXPIRATION_WARNED_TIME = 12;
    public static final int OP_CLEAR_PASSWORD_EXPIRATION_WARNED_TIME = 13;
    public static final int OP_GET_SECONDS_UNTIL_PASSWORD_EXPIRATION = 14;
    public static final int OP_GET_SECONDS_UNTIL_PASSWORD_EXPIRATION_WARNING = 15;
    public static final int OP_GET_AUTHENTICATION_FAILURE_TIMES = 16;
    public static final int OP_ADD_AUTHENTICATION_FAILURE_TIME = 17;
    public static final int OP_SET_AUTHENTICATION_FAILURE_TIMES = 18;
    public static final int OP_CLEAR_AUTHENTICATION_FAILURE_TIMES = 19;
    public static final int OP_GET_SECONDS_UNTIL_AUTHENTICATION_FAILURE_UNLOCK = 20;
    public static final int OP_GET_REMAINING_AUTHENTICATION_FAILURE_COUNT = 21;
    public static final int OP_GET_LAST_LOGIN_TIME = 22;
    public static final int OP_SET_LAST_LOGIN_TIME = 23;
    public static final int OP_CLEAR_LAST_LOGIN_TIME = 24;
    public static final int OP_GET_SECONDS_UNTIL_IDLE_LOCKOUT = 25;
    public static final int OP_GET_PASSWORD_RESET_STATE = 26;
    public static final int OP_SET_PASSWORD_RESET_STATE = 27;
    public static final int OP_CLEAR_PASSWORD_RESET_STATE = 28;
    public static final int OP_GET_SECONDS_UNTIL_PASSWORD_RESET_LOCKOUT = 29;
    public static final int OP_GET_GRACE_LOGIN_USE_TIMES = 30;
    public static final int OP_ADD_GRACE_LOGIN_USE_TIME = 31;
    public static final int OP_SET_GRACE_LOGIN_USE_TIMES = 32;
    public static final int OP_CLEAR_GRACE_LOGIN_USE_TIMES = 33;
    public static final int OP_GET_REMAINING_GRACE_LOGIN_COUNT = 34;
    public static final int OP_GET_PASSWORD_CHANGED_BY_REQUIRED_TIME = 35;
    public static final int OP_SET_PASSWORD_CHANGED_BY_REQUIRED_TIME = 36;
    public static final int OP_CLEAR_PASSWORD_CHANGED_BY_REQUIRED_TIME = 37;
    public static final int OP_GET_SECONDS_UNTIL_REQUIRED_CHANGE_TIME = 38;
    public static final int OP_GET_PASSWORD_HISTORY = 39;
    public static final int OP_CLEAR_PASSWORD_HISTORY = 40;
    private LinkedHashSet<String> requestAttributes;
    private SearchFilter userFilter;

    @Override
    public void initializeExtendedOperationHandler(PasswordPolicyStateExtendedOperationHandlerCfg config) throws ConfigException, InitializationException {
        block2: {
            try {
                this.userFilter = SearchFilter.createFilterFromString("(objectClass=*)");
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block2;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        this.requestAttributes = new LinkedHashSet(2);
        this.requestAttributes.add("*");
        this.requestAttributes.add("+");
        DirectoryServer.registerSupportedExtension("1.3.6.1.4.1.26027.1.6.1", this);
    }

    @Override
    public void finalizeExtendedOperationHandler() {
        DirectoryServer.deregisterSupportedExtension("1.3.6.1.4.1.26027.1.6.1");
        this.deregisterControlsAndFeatures();
    }

    @Override
    public void processExtendedOperation(ExtendedOperation operation) {
        boolean returnAll;
        PasswordPolicy policy;
        PasswordPolicyState pwpState;
        InternalClientConnection conn;
        InternalSearchOperation internalSearch;
        DN targetDN;
        ByteString dnString;
        operation.setResultCode(ResultCode.UNDEFINED);
        ClientConnection clientConnection = operation.getClientConnection();
        if (!clientConnection.hasPrivilege(Privilege.PASSWORD_RESET, operation)) {
            Message message = ExtensionMessages.ERR_PWPSTATE_EXTOP_NO_PRIVILEGE.get();
            operation.appendErrorMessage(message);
            operation.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
            return;
        }
        ByteString requestValue = operation.getRequestValue();
        if (requestValue == null) {
            Message message = ExtensionMessages.ERR_PWPSTATE_EXTOP_NO_REQUEST_VALUE.get();
            operation.appendErrorMessage(message);
            operation.setResultCode(ResultCode.PROTOCOL_ERROR);
            return;
        }
        ASN1Reader reader = ASN1.getReader(requestValue);
        try {
            reader.readStartSequence();
            dnString = reader.readOctetString();
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_PWPSTATE_EXTOP_DECODE_FAILURE.get(StaticUtils.getExceptionMessage(e));
            operation.appendErrorMessage(message);
            operation.setResultCode(ResultCode.PROTOCOL_ERROR);
            return;
        }
        try {
            targetDN = DN.decode(dnString);
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            operation.setResponseData(de);
            return;
        }
        DN rootDN = DirectoryServer.getActualRootBindDN(targetDN);
        if (rootDN != null) {
            targetDN = rootDN;
        }
        if ((internalSearch = (conn = new InternalClientConnection(clientConnection.getAuthenticationInfo())).processSearch(targetDN, SearchScope.BASE_OBJECT, DereferencePolicy.NEVER_DEREF_ALIASES, 1, 0, false, this.userFilter, this.requestAttributes, null)).getResultCode() != ResultCode.SUCCESS) {
            operation.setResultCode(internalSearch.getResultCode());
            operation.setErrorMessage(internalSearch.getErrorMessage());
            operation.setMatchedDN(internalSearch.getMatchedDN());
            operation.setReferralURLs(internalSearch.getReferralURLs());
            return;
        }
        LinkedList<SearchResultEntry> matchingEntries = internalSearch.getSearchEntries();
        if (matchingEntries.isEmpty()) {
            operation.setResultCode(ResultCode.INSUFFICIENT_ACCESS_RIGHTS);
            return;
        }
        if (matchingEntries.size() > 1) {
            Message message = ExtensionMessages.ERR_PWPSTATE_EXTOP_MULTIPLE_ENTRIES.get(String.valueOf(targetDN));
            operation.appendErrorMessage(message);
            operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
            return;
        }
        Entry userEntry = (Entry)matchingEntries.get(0);
        try {
            pwpState = new PasswordPolicyState(userEntry, false);
            policy = pwpState.getPolicy();
        }
        catch (DirectoryException de) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, de);
            }
            operation.setResponseData(de);
            return;
        }
        LinkedHashSet<Integer> returnTypes = new LinkedHashSet<Integer>();
        try {
            ModifyOperation modifyOperation;
            if (!reader.hasNextElement()) {
                returnAll = true;
            } else if (reader.peekLength() <= 0) {
                returnAll = true;
                reader.readStartSequence();
                reader.readEndSequence();
            } else {
                returnAll = false;
                reader.readStartSequence();
                while (reader.hasNextElement()) {
                    ArrayList<String> opValues;
                    reader.readStartSequence();
                    int opType = (int)reader.readInteger();
                    if (!reader.hasNextElement()) {
                        opValues = null;
                    } else if (reader.peekLength() <= 0) {
                        opValues = null;
                        reader.readStartSequence();
                        reader.readEndSequence();
                    } else {
                        reader.readStartSequence();
                        opValues = new ArrayList<String>();
                        while (reader.hasNextElement()) {
                            opValues.add(reader.readOctetStringAsString());
                        }
                        reader.readEndSequence();
                    }
                    reader.readEndSequence();
                    if (this.processOp(opType, opValues, operation, returnTypes, pwpState, policy)) continue;
                    return;
                }
                reader.readEndSequence();
            }
            reader.readEndSequence();
            List<Modification> stateMods = pwpState.getModifications();
            if (stateMods != null && !stateMods.isEmpty() && (modifyOperation = conn.processModify(targetDN, stateMods)).getResultCode() != ResultCode.SUCCESS) {
                operation.setResultCode(modifyOperation.getResultCode());
                operation.setErrorMessage(modifyOperation.getErrorMessage());
                operation.setMatchedDN(modifyOperation.getMatchedDN());
                operation.setReferralURLs(modifyOperation.getReferralURLs());
                return;
            }
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            Message message = ExtensionMessages.ERR_PWPSTATE_EXTOP_INVALID_OP_ENCODING.get(e.getLocalizedMessage());
            operation.appendErrorMessage(message);
            operation.setResultCode(ResultCode.PROTOCOL_ERROR);
            return;
        }
        try {
            ByteString responseValue = this.encodeResponse(dnString, returnAll, returnTypes, pwpState, policy);
            operation.setResponseOID("1.3.6.1.4.1.26027.1.6.1");
            operation.setResponseValue(responseValue);
            operation.setResultCode(ResultCode.SUCCESS);
        }
        catch (Exception e) {
            Message message = ExtensionMessages.ERR_PWPSTATE_EXTOP_INVALID_OP_ENCODING.get(e.getLocalizedMessage());
            operation.appendErrorMessage(message);
            operation.setResultCode(ResultCode.PROTOCOL_ERROR);
        }
    }

    public static void encode(ASN1Writer writer, int opType, String value) throws IOException {
        writer.writeStartSequence();
        writer.writeEnumerated(opType);
        if (value != null) {
            writer.writeStartSequence();
            writer.writeOctetString(value);
            writer.writeEndSequence();
        }
        writer.writeEndSequence();
    }

    public static void encode(ASN1Writer writer, int opType, String[] values) throws IOException {
        writer.writeStartSequence();
        writer.writeEnumerated(opType);
        if (values != null && values.length > 0) {
            writer.writeStartSequence();
            for (int i = 0; i < values.length; ++i) {
                writer.writeOctetString(values[i]);
            }
            writer.writeEndSequence();
        }
        writer.writeEndSequence();
    }

    public static void encode(ASN1Writer writer, int opType, List<Long> values) throws IOException {
        writer.writeStartSequence();
        writer.writeEnumerated(opType);
        if (values != null && values.size() > 0) {
            writer.writeStartSequence();
            for (long l : values) {
                writer.writeOctetString(GeneralizedTimeSyntax.format(l));
            }
            writer.writeEndSequence();
        }
        writer.writeEndSequence();
    }

    private ByteString encodeResponse(ByteString dnString, boolean returnAll, LinkedHashSet<Integer> returnTypes, PasswordPolicyState pwpState, PasswordPolicy policy) throws IOException {
        String timeStr;
        Object secondsStr;
        long expTime;
        ByteStringBuilder builder = new ByteStringBuilder();
        ASN1Writer writer = ASN1.getWriter(builder);
        writer.writeStartSequence();
        writer.writeOctetString(dnString);
        writer.writeStartSequence();
        if (returnAll || returnTypes.contains(0)) {
            PasswordPolicyStateExtendedOperation.encode(writer, 0, policy.getConfigEntryDN().toString());
        }
        if (returnAll || returnTypes.contains(1)) {
            PasswordPolicyStateExtendedOperation.encode(writer, 1, String.valueOf(pwpState.isDisabled()));
        }
        if (returnAll || returnTypes.contains(4)) {
            expTime = pwpState.getAccountExpirationTime();
            String expTimeStr = expTime < 0L ? null : GeneralizedTimeSyntax.format(expTime);
            PasswordPolicyStateExtendedOperation.encode(writer, 4, expTimeStr);
        }
        if (returnAll || returnTypes.contains(7)) {
            expTime = pwpState.getAccountExpirationTime();
            secondsStr = expTime < 0L ? null : String.valueOf((expTime - pwpState.getCurrentTime()) / 1000L);
            PasswordPolicyStateExtendedOperation.encode(writer, 7, secondsStr);
        }
        if (returnAll || returnTypes.contains(8)) {
            long changedTime = pwpState.getPasswordChangedTime();
            timeStr = changedTime < 0L ? null : GeneralizedTimeSyntax.format(changedTime);
            PasswordPolicyStateExtendedOperation.encode(writer, 8, timeStr);
        }
        if (returnAll || returnTypes.contains(11)) {
            long warnedTime = pwpState.getWarnedTime();
            timeStr = warnedTime < 0L ? null : GeneralizedTimeSyntax.format(warnedTime);
            PasswordPolicyStateExtendedOperation.encode(writer, 11, timeStr);
        }
        if (returnAll || returnTypes.contains(14)) {
            int secondsUntilExp = pwpState.getSecondsUntilExpiration();
            secondsStr = secondsUntilExp < 0 ? null : String.valueOf(secondsUntilExp);
            PasswordPolicyStateExtendedOperation.encode(writer, 14, (String)secondsStr);
        }
        if (returnAll || returnTypes.contains(15)) {
            int secondsUntilWarning;
            int secondsUntilExp = pwpState.getSecondsUntilExpiration();
            secondsStr = secondsUntilExp < 0 ? null : ((secondsUntilWarning = secondsUntilExp - policy.getWarningInterval()) <= 0 ? "0" : String.valueOf(secondsUntilWarning));
            PasswordPolicyStateExtendedOperation.encode(writer, 15, (String)secondsStr);
        }
        if (returnAll || returnTypes.contains(16)) {
            PasswordPolicyStateExtendedOperation.encode(writer, 16, pwpState.getAuthFailureTimes());
        }
        if (returnAll || returnTypes.contains(20)) {
            int seconds;
            secondsStr = pwpState.lockedDueToFailures() ? ((seconds = pwpState.getSecondsUntilUnlock()) <= 0 ? null : String.valueOf(seconds)) : null;
            PasswordPolicyStateExtendedOperation.encode(writer, 20, (String)secondsStr);
        }
        if (returnAll || returnTypes.contains(21)) {
            String remainingFailuresStr;
            int allowedFailureCount = policy.getLockoutFailureCount();
            if (allowedFailureCount > 0) {
                int remainingFailures = allowedFailureCount - pwpState.getAuthFailureTimes().size();
                if (remainingFailures < 0) {
                    remainingFailures = 0;
                }
                remainingFailuresStr = String.valueOf(remainingFailures);
            } else {
                remainingFailuresStr = null;
            }
            PasswordPolicyStateExtendedOperation.encode(writer, 21, remainingFailuresStr);
        }
        if (returnAll || returnTypes.contains(22)) {
            long lastLoginTime = pwpState.getLastLoginTime();
            timeStr = lastLoginTime < 0L ? null : GeneralizedTimeSyntax.format(lastLoginTime);
            PasswordPolicyStateExtendedOperation.encode(writer, 22, timeStr);
        }
        if (returnAll || returnTypes.contains(25)) {
            long currentTime;
            long lockoutTime;
            int secondsUntilLockout;
            long lastLoginTime;
            int lockoutInterval = policy.getIdleLockoutInterval();
            secondsStr = lockoutInterval > 0 ? ((lastLoginTime = pwpState.getLastLoginTime()) < 0L ? "0" : ((secondsUntilLockout = (int)(((lockoutTime = lastLoginTime + (long)(lockoutInterval * 1000)) - (currentTime = pwpState.getCurrentTime())) / 1000L)) <= 0 ? "0" : String.valueOf(secondsUntilLockout))) : null;
            PasswordPolicyStateExtendedOperation.encode(writer, 25, (String)secondsStr);
        }
        if (returnAll || returnTypes.contains(26)) {
            PasswordPolicyStateExtendedOperation.encode(writer, 26, String.valueOf(pwpState.mustChangePassword()));
        }
        if (returnAll || returnTypes.contains(29)) {
            long changedTime;
            long currentTime;
            int changeAge;
            int timeToLockout;
            int maxAge;
            secondsStr = pwpState.mustChangePassword() ? ((maxAge = policy.getMaximumPasswordResetAge()) > 0 ? ((timeToLockout = maxAge - (changeAge = (int)(((currentTime = pwpState.getCurrentTime()) - (changedTime = pwpState.getPasswordChangedTime())) / 1000L))) <= 0 ? "0" : String.valueOf(timeToLockout)) : null) : null;
            PasswordPolicyStateExtendedOperation.encode(writer, 29, (String)secondsStr);
        }
        if (returnAll || returnTypes.contains(30)) {
            PasswordPolicyStateExtendedOperation.encode(writer, 30, pwpState.getGraceLoginTimes());
        }
        if (returnAll || returnTypes.contains(34)) {
            int remainingGraceLogins = pwpState.getGraceLoginsRemaining();
            String remainingStr = remainingGraceLogins <= 0 ? "0" : String.valueOf(remainingGraceLogins);
            PasswordPolicyStateExtendedOperation.encode(writer, 34, remainingStr);
        }
        if (returnAll || returnTypes.contains(35)) {
            long requiredChangeTime = pwpState.getRequiredChangeTime();
            timeStr = requiredChangeTime < 0L ? null : GeneralizedTimeSyntax.format(requiredChangeTime);
            PasswordPolicyStateExtendedOperation.encode(writer, 35, timeStr);
        }
        if (returnAll || returnTypes.contains(38)) {
            long currentTime;
            long accountRequiredChangeTime;
            long policyRequiredChangeTime = policy.getRequireChangeByTime();
            secondsStr = policyRequiredChangeTime > 0L ? ((accountRequiredChangeTime = pwpState.getRequiredChangeTime()) >= policyRequiredChangeTime ? null : ((currentTime = pwpState.getCurrentTime()) >= policyRequiredChangeTime ? "0" : String.valueOf((policyRequiredChangeTime - currentTime) / 1000L))) : null;
            PasswordPolicyStateExtendedOperation.encode(writer, 38, (String)secondsStr);
        }
        if (returnAll || returnTypes.contains(39)) {
            PasswordPolicyStateExtendedOperation.encode(writer, 39, pwpState.getPasswordHistoryValues());
        }
        writer.writeEndSequence();
        writer.writeEndSequence();
        return builder.toByteString();
    }

    private boolean processOp(int opType, ArrayList<String> opValues, ExtendedOperation operation, LinkedHashSet<Integer> returnTypes, PasswordPolicyState pwpState, PasswordPolicy policy) {
        switch (opType) {
            case 0: {
                returnTypes.add(0);
                break;
            }
            case 1: {
                returnTypes.add(1);
                break;
            }
            case 2: {
                if (opValues == null) {
                    operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_NO_DISABLED_VALUE.get());
                    operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                    return false;
                }
                if (opValues.size() != 1) {
                    operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_DISABLED_VALUE_COUNT.get());
                    operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                    return false;
                }
                String value = opValues.get(0);
                if (value.equalsIgnoreCase("true")) {
                    pwpState.setDisabled(true);
                } else if (value.equalsIgnoreCase("false")) {
                    pwpState.setDisabled(false);
                } else {
                    operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_DISABLED_VALUE.get());
                    operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                    return false;
                }
                returnTypes.add(1);
                break;
            }
            case 3: {
                pwpState.setDisabled(false);
                returnTypes.add(1);
                break;
            }
            case 4: {
                returnTypes.add(4);
                break;
            }
            case 5: {
                if (opValues == null) {
                    pwpState.setAccountExpirationTime(pwpState.getCurrentTime());
                } else {
                    if (opValues.size() != 1) {
                        operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_ACCT_EXP_VALUE_COUNT.get());
                        operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                        return false;
                    }
                    try {
                        ByteString valueString = ByteString.valueOf(opValues.get(0));
                        long time = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(valueString);
                        pwpState.setAccountExpirationTime(time);
                    }
                    catch (DirectoryException de) {
                        operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_ACCT_EXP_VALUE.get(opValues.get(0), de.getMessageObject()));
                        operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                        return false;
                    }
                }
                returnTypes.add(4);
                break;
            }
            case 6: {
                pwpState.clearAccountExpirationTime();
                returnTypes.add(4);
                break;
            }
            case 7: {
                returnTypes.add(7);
                break;
            }
            case 8: {
                returnTypes.add(8);
                break;
            }
            case 9: {
                if (opValues == null) {
                    pwpState.setPasswordChangedTime();
                } else {
                    if (opValues.size() != 1) {
                        operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_PWCHANGETIME_VALUE_COUNT.get());
                        operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                        return false;
                    }
                    try {
                        ByteString valueString = ByteString.valueOf(opValues.get(0));
                        long time = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(valueString);
                        pwpState.setPasswordChangedTime(time);
                    }
                    catch (DirectoryException de) {
                        operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_PWCHANGETIME_VALUE.get(opValues.get(0), de.getMessageObject()));
                        operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                        return false;
                    }
                }
                returnTypes.add(8);
                break;
            }
            case 10: {
                pwpState.clearPasswordChangedTime();
                returnTypes.add(8);
                break;
            }
            case 11: {
                returnTypes.add(11);
                break;
            }
            case 12: {
                if (opValues == null) {
                    pwpState.setWarnedTime();
                } else {
                    if (opValues.size() != 1) {
                        operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_PWWARNEDTIME_VALUE_COUNT.get());
                        operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                        return false;
                    }
                    try {
                        ByteString valueString = ByteString.valueOf(opValues.get(0));
                        long time = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(valueString);
                        pwpState.setWarnedTime(time);
                    }
                    catch (DirectoryException de) {
                        operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_PWWARNEDTIME_VALUE.get(opValues.get(0), de.getMessageObject()));
                        operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                        return false;
                    }
                }
                returnTypes.add(11);
                break;
            }
            case 13: {
                pwpState.clearWarnedTime();
                returnTypes.add(11);
                break;
            }
            case 14: {
                returnTypes.add(14);
                break;
            }
            case 15: {
                returnTypes.add(15);
                break;
            }
            case 16: {
                returnTypes.add(16);
                break;
            }
            case 17: {
                if (opValues == null) {
                    if (policy.getLockoutFailureCount() == 0) {
                        returnTypes.add(16);
                        break;
                    }
                    pwpState.updateAuthFailureTimes();
                } else {
                    if (opValues.size() != 1) {
                        operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_ADD_FAILURE_TIME_COUNT.get());
                        operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                        return false;
                    }
                    try {
                        ByteString valueString = ByteString.valueOf(opValues.get(0));
                        long time = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(valueString);
                        List<Long> authFailureTimes = pwpState.getAuthFailureTimes();
                        ArrayList<Long> newFailureTimes = new ArrayList<Long>(authFailureTimes.size() + 1);
                        newFailureTimes.addAll(authFailureTimes);
                        newFailureTimes.add(time);
                        pwpState.setAuthFailureTimes(newFailureTimes);
                    }
                    catch (DirectoryException de) {
                        Message message = ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_AUTH_FAILURE_TIME.get(opValues.get(0), de.getMessageObject());
                        operation.setResultCode(de.getResultCode());
                        operation.appendErrorMessage(message);
                        return false;
                    }
                }
                returnTypes.add(16);
                break;
            }
            case 18: {
                if (opValues == null) {
                    ArrayList<Long> valueList = new ArrayList<Long>(1);
                    valueList.add(pwpState.getCurrentTime());
                    pwpState.setAuthFailureTimes(valueList);
                } else {
                    ArrayList<Long> valueList = new ArrayList<Long>(opValues.size());
                    for (String s : opValues) {
                        try {
                            valueList.add(GeneralizedTimeSyntax.decodeGeneralizedTimeValue(ByteString.valueOf(s)));
                        }
                        catch (DirectoryException de) {
                            Message message = ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_AUTH_FAILURE_TIME.get(s, de.getMessageObject());
                            operation.setResultCode(de.getResultCode());
                            operation.appendErrorMessage(message);
                            return false;
                        }
                    }
                    pwpState.setAuthFailureTimes(valueList);
                }
                returnTypes.add(16);
                break;
            }
            case 19: {
                pwpState.clearFailureLockout();
                returnTypes.add(16);
                break;
            }
            case 20: {
                returnTypes.add(20);
                break;
            }
            case 21: {
                returnTypes.add(21);
                break;
            }
            case 22: {
                returnTypes.add(22);
                break;
            }
            case 23: {
                if (opValues == null) {
                    pwpState.setLastLoginTime();
                } else {
                    if (opValues.size() != 1) {
                        operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_LAST_LOGIN_TIME_COUNT.get());
                        operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                        return false;
                    }
                    try {
                        ByteString valueString = ByteString.valueOf(opValues.get(0));
                        long time = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(valueString);
                        pwpState.setLastLoginTime(time);
                    }
                    catch (DirectoryException de) {
                        operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_LAST_LOGIN_TIME.get(opValues.get(0), de.getMessageObject()));
                        operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                        return false;
                    }
                }
                returnTypes.add(22);
                break;
            }
            case 24: {
                pwpState.clearLastLoginTime();
                returnTypes.add(22);
                break;
            }
            case 25: {
                returnTypes.add(25);
                break;
            }
            case 26: {
                returnTypes.add(26);
                break;
            }
            case 27: {
                if (opValues == null) {
                    operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_NO_RESET_STATE_VALUE.get());
                    operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                    return false;
                }
                if (opValues.size() != 1) {
                    operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_RESET_STATE_VALUE_COUNT.get());
                    operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                    return false;
                }
                String value = opValues.get(0);
                if (value.equalsIgnoreCase("true")) {
                    pwpState.setMustChangePassword(true);
                } else if (value.equalsIgnoreCase("false")) {
                    pwpState.setMustChangePassword(false);
                } else {
                    operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_RESET_STATE_VALUE.get());
                    operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                    return false;
                }
                returnTypes.add(26);
                break;
            }
            case 28: {
                pwpState.setMustChangePassword(false);
                returnTypes.add(26);
                break;
            }
            case 29: {
                returnTypes.add(29);
                break;
            }
            case 30: {
                returnTypes.add(30);
                break;
            }
            case 31: {
                if (opValues == null) {
                    pwpState.updateGraceLoginTimes();
                } else {
                    if (opValues.size() != 1) {
                        operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_ADD_GRACE_LOGIN_TIME_COUNT.get());
                        operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                        return false;
                    }
                    try {
                        ByteString valueString = ByteString.valueOf(opValues.get(0));
                        long time = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(valueString);
                        List<Long> authFailureTimes = pwpState.getGraceLoginTimes();
                        ArrayList<Long> newGraceTimes = new ArrayList<Long>(authFailureTimes.size() + 1);
                        newGraceTimes.addAll(authFailureTimes);
                        newGraceTimes.add(time);
                        pwpState.setGraceLoginTimes(newGraceTimes);
                    }
                    catch (DirectoryException de) {
                        Message message = ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_GRACE_LOGIN_TIME.get(opValues.get(0), de.getMessageObject());
                        operation.setResultCode(de.getResultCode());
                        operation.appendErrorMessage(message);
                        return false;
                    }
                }
                returnTypes.add(30);
                break;
            }
            case 32: {
                if (opValues == null) {
                    ArrayList<Long> valueList = new ArrayList<Long>(1);
                    valueList.add(pwpState.getCurrentTime());
                    pwpState.setGraceLoginTimes(valueList);
                } else {
                    ArrayList<Long> valueList = new ArrayList<Long>(opValues.size());
                    for (String s : opValues) {
                        try {
                            valueList.add(GeneralizedTimeSyntax.decodeGeneralizedTimeValue(ByteString.valueOf(s)));
                        }
                        catch (DirectoryException de) {
                            Message message = ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_GRACE_LOGIN_TIME.get(s, de.getMessageObject());
                            operation.setResultCode(de.getResultCode());
                            operation.appendErrorMessage(message);
                            return false;
                        }
                    }
                    pwpState.setGraceLoginTimes(valueList);
                }
                returnTypes.add(30);
                break;
            }
            case 33: {
                pwpState.clearGraceLoginTimes();
                returnTypes.add(30);
                break;
            }
            case 34: {
                returnTypes.add(34);
                break;
            }
            case 35: {
                returnTypes.add(35);
                break;
            }
            case 36: {
                if (opValues == null) {
                    pwpState.setRequiredChangeTime();
                } else {
                    if (opValues.size() != 1) {
                        operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_REQUIRED_CHANGE_TIME_COUNT.get());
                        operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                        return false;
                    }
                    try {
                        ByteString valueString = ByteString.valueOf(opValues.get(0));
                        long time = GeneralizedTimeSyntax.decodeGeneralizedTimeValue(valueString);
                        pwpState.setRequiredChangeTime(time);
                    }
                    catch (DirectoryException de) {
                        operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_BAD_REQUIRED_CHANGE_TIME.get(opValues.get(0), de.getMessageObject()));
                        operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                        return false;
                    }
                }
                returnTypes.add(35);
                break;
            }
            case 37: {
                pwpState.clearRequiredChangeTime();
                returnTypes.add(35);
                break;
            }
            case 38: {
                returnTypes.add(38);
                break;
            }
            case 39: {
                returnTypes.add(39);
                break;
            }
            case 40: {
                pwpState.clearPasswordHistory();
                returnTypes.add(39);
                break;
            }
            default: {
                operation.appendErrorMessage(ExtensionMessages.ERR_PWPSTATE_EXTOP_UNKNOWN_OP_TYPE.get(String.valueOf(opType)));
                operation.setResultCode(ResultCode.CONSTRAINT_VIOLATION);
                return false;
            }
        }
        return true;
    }

    @Override
    public String getExtendedOperationName() {
        return "Password Policy State";
    }
}

