/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opends.server.admin.std.server.IsMemberOfVirtualAttributeCfg;
import org.opends.server.api.Group;
import org.opends.server.api.VirtualAttributeProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.MemberList;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.types.VirtualAttributeRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsMemberOfVirtualAttributeProvider
extends VirtualAttributeProvider<IsMemberOfVirtualAttributeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public void initializeVirtualAttributeProvider(IsMemberOfVirtualAttributeCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public boolean isMultiValued() {
        return true;
    }

    @Override
    public Set<AttributeValue> getValues(Entry entry, VirtualAttributeRule rule) {
        HashSet<AttributeValue> values = new HashSet<AttributeValue>();
        for (Group g : DirectoryServer.getGroupManager().getGroupInstances()) {
            try {
                if (!g.isMember(entry)) continue;
                values.add(AttributeValues.create(rule.getAttributeType(), g.getGroupDN().toString()));
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        return Collections.unmodifiableSet(values);
    }

    @Override
    public boolean hasValue(Entry entry, VirtualAttributeRule rule) {
        for (Group g : DirectoryServer.getGroupManager().getGroupInstances()) {
            try {
                if (!g.isMember(entry)) continue;
                return true;
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        return false;
    }

    @Override
    public boolean hasValue(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        try {
            DN groupDN = DN.decode(value.getValue());
            Group g = DirectoryServer.getGroupManager().getGroupInstance(groupDN);
            if (g == null) {
                return false;
            }
            return g.isMember(entry);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
    }

    @Override
    public boolean hasAnyValue(Entry entry, VirtualAttributeRule rule, Collection<AttributeValue> values) {
        for (AttributeValue value : values) {
            if (!this.hasValue(entry, rule, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ConditionResult matchesSubstring(Entry entry, VirtualAttributeRule rule, ByteString subInitial, List<ByteString> subAny, ByteString subFinal) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult greaterThanOrEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult lessThanOrEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult approximatelyEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public boolean isSearchable(VirtualAttributeRule rule, SearchOperation searchOperation) {
        return this.isSearchable(rule.getAttributeType(), searchOperation.getFilter(), 0);
    }

    private boolean isSearchable(AttributeType attributeType, SearchFilter filter, int depth) {
        switch (filter.getFilterType()) {
            case AND: {
                if (depth >= 100) {
                    return false;
                }
                for (SearchFilter f : filter.getFilterComponents()) {
                    if (!this.isSearchable(attributeType, f, depth + 1)) continue;
                    return true;
                }
                return false;
            }
            case EQUALITY: {
                return filter.getAttributeType().equals(attributeType);
            }
        }
        return false;
    }

    @Override
    public void processSearch(VirtualAttributeRule rule, SearchOperation searchOperation) {
        SearchFilter filter = searchOperation.getFilter();
        Group group = this.extractGroup(rule.getAttributeType(), filter);
        if (group == null) {
            return;
        }
        DN baseDN = searchOperation.getBaseDN();
        SearchScope scope = searchOperation.getScope();
        try {
            MemberList memberList = group.getMembers();
            while (memberList.hasMoreMembers()) {
                try {
                    Entry e = memberList.nextMemberEntry();
                    if (!e.matchesBaseAndScope(baseDN, scope) || !filter.matchesEntry(e)) continue;
                    searchOperation.returnEntry(e, null);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        catch (DirectoryException de) {
            searchOperation.setResponseData(de);
        }
    }

    private Group extractGroup(AttributeType attributeType, SearchFilter filter) {
        switch (filter.getFilterType()) {
            case AND: {
                for (SearchFilter f : filter.getFilterComponents()) {
                    Group g = this.extractGroup(attributeType, f);
                    if (g == null) continue;
                    return g;
                }
                break;
            }
            case EQUALITY: {
                if (!filter.getAttributeType().equals(attributeType)) break;
                try {
                    DN dn = DN.decode(filter.getAssertionValue().getValue());
                    return DirectoryServer.getGroupManager().getGroupInstance(dn);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        return null;
    }
}

