/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opends.server.admin.std.server.EntryDNVirtualAttributeCfg;
import org.opends.server.api.VirtualAttributeProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.types.VirtualAttributeRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryDNVirtualAttributeProvider
extends VirtualAttributeProvider<EntryDNVirtualAttributeCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    @Override
    public void initializeVirtualAttributeProvider(EntryDNVirtualAttributeCfg configuration) throws ConfigException, InitializationException {
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public Set<AttributeValue> getValues(Entry entry, VirtualAttributeRule rule) {
        String normDNString = entry.getDN().toNormalizedString();
        AttributeValue value = AttributeValues.create(ByteString.valueOf(normDNString), ByteString.valueOf(normDNString));
        return Collections.singleton(value);
    }

    @Override
    public boolean hasValue(Entry entry, VirtualAttributeRule rule) {
        return true;
    }

    @Override
    public boolean hasValue(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        try {
            String normalizedDN = entry.getDN().toNormalizedString();
            String normalizedValue = value.getNormalizedValue().toString();
            return normalizedDN.equals(normalizedValue);
        }
        catch (Exception e) {
            if (DebugLogger.debugEnabled()) {
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
            return false;
        }
    }

    @Override
    public boolean hasAnyValue(Entry entry, VirtualAttributeRule rule, Collection<AttributeValue> values) {
        String ndnString = entry.getDN().toNormalizedString();
        AttributeValue v = AttributeValues.create(ByteString.valueOf(ndnString), ByteString.valueOf(ndnString));
        return values.contains(v);
    }

    @Override
    public ConditionResult matchesSubstring(Entry entry, VirtualAttributeRule rule, ByteString subInitial, List<ByteString> subAny, ByteString subFinal) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult greaterThanOrEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult lessThanOrEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public ConditionResult approximatelyEqualTo(Entry entry, VirtualAttributeRule rule, AttributeValue value) {
        return ConditionResult.UNDEFINED;
    }

    @Override
    public boolean isSearchable(VirtualAttributeRule rule, SearchOperation searchOperation) {
        return this.isSearchable(rule.getAttributeType(), searchOperation.getFilter(), 0);
    }

    private boolean isSearchable(AttributeType attributeType, SearchFilter filter, int depth) {
        switch (filter.getFilterType()) {
            case AND: {
                if (depth >= 100) {
                    return false;
                }
                for (SearchFilter f : filter.getFilterComponents()) {
                    if (!this.isSearchable(attributeType, f, depth + 1)) continue;
                    return true;
                }
                return false;
            }
            case OR: {
                if (depth >= 100) {
                    return false;
                }
                for (SearchFilter f : filter.getFilterComponents()) {
                    if (this.isSearchable(attributeType, f, depth + 1)) continue;
                    return false;
                }
                return true;
            }
            case EQUALITY: {
                return filter.getAttributeType().equals(attributeType);
            }
        }
        return false;
    }

    @Override
    public void processSearch(VirtualAttributeRule rule, SearchOperation searchOperation) {
        SearchFilter filter = searchOperation.getFilter();
        LinkedHashSet<DN> dnSet = new LinkedHashSet<DN>();
        this.extractDNs(rule.getAttributeType(), filter, dnSet);
        if (dnSet.isEmpty()) {
            return;
        }
        DN baseDN = searchOperation.getBaseDN();
        SearchScope scope = searchOperation.getScope();
        for (DN dn : dnSet) {
            if (!dn.matchesBaseAndScope(baseDN, scope)) continue;
            try {
                Entry entry = DirectoryServer.getEntry(dn);
                if (entry == null || !filter.matchesEntry(entry)) continue;
                searchOperation.returnEntry(entry, null);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
    }

    private void extractDNs(AttributeType attributeType, SearchFilter filter, LinkedHashSet<DN> dnSet) {
        switch (filter.getFilterType()) {
            case AND: 
            case OR: {
                for (SearchFilter f : filter.getFilterComponents()) {
                    this.extractDNs(attributeType, f, dnSet);
                }
                break;
            }
            case EQUALITY: {
                if (!filter.getAttributeType().equals(attributeType)) break;
                try {
                    dnSet.add(DN.decode(filter.getAssertionValue().getValue()));
                    break;
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }
}

