/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core.networkgroups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.server.ResourceLimitsQOSPolicyCfg;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.QOSPolicyFactory;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.networkgroups.ResourceLimitsPolicy;
import org.opends.server.core.networkgroups.ResourceLimitsPolicyStatistics;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.InitializationException;
import org.opends.server.types.RawFilter;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PreParseOperation;
import org.opends.server.types.operation.PreParseSearchOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceLimitsPolicyFactory
implements QOSPolicyFactory<ResourceLimitsQOSPolicyCfg> {
    private static boolean validateConfiguration(ResourceLimitsQOSPolicyCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    public ResourceLimitsPolicy createQOSPolicy(ResourceLimitsQOSPolicyCfg configuration) throws ConfigException, InitializationException {
        Policy policy = new Policy();
        policy.updateConfiguration(configuration);
        configuration.addResourceLimitsChangeListener(policy);
        return policy;
    }

    @Override
    public boolean isConfigurationAcceptable(ResourceLimitsQOSPolicyCfg configuration, List<Message> unacceptableReasons) {
        return ResourceLimitsPolicyFactory.validateConfiguration(configuration, unacceptableReasons);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Policy
    extends ResourceLimitsPolicy
    implements ConfigurationChangeListener<ResourceLimitsQOSPolicyCfg> {
        private final HashMap<String, Integer> connectionsPerIPMap = new HashMap();
        private int maxConcurrentOpsPerConnection;
        private int maxConnections;
        private int maxConnectionsFromSameIP;
        private int maxOpsPerConnection;
        private int minSearchSubstringLength;
        private final Object mutex = new Object();
        private int sizeLimit;
        private final ResourceLimitsPolicyStatistics statistics = new ResourceLimitsPolicyStatistics();
        private int timeLimit;

        @Override
        public ConfigChangeResult applyConfigurationChange(ResourceLimitsQOSPolicyCfg configuration) {
            ResultCode resultCode = ResultCode.SUCCESS;
            boolean adminActionRequired = false;
            ArrayList<Message> messages = new ArrayList<Message>();
            this.updateConfiguration(configuration);
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }

        @Override
        public boolean isConfigurationChangeAcceptable(ResourceLimitsQOSPolicyCfg configuration, List<Message> unacceptableReasons) {
            return ResourceLimitsPolicyFactory.validateConfiguration(configuration, unacceptableReasons);
        }

        private Policy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void addConnection(ClientConnection connection) {
            Object object = this.mutex;
            synchronized (object) {
                this.statistics.addClientConnection();
                String ip = connection.getClientAddress();
                Integer currentCount = this.connectionsPerIPMap.get(ip);
                if (currentCount == null) {
                    this.connectionsPerIPMap.put(ip, 1);
                } else {
                    this.connectionsPerIPMap.put(ip, currentCount + 1);
                }
            }
        }

        @Override
        int getMinSubstring() {
            return this.minSearchSubstringLength;
        }

        @Override
        int getSizeLimit() {
            return this.sizeLimit;
        }

        @Override
        ResourceLimitsPolicyStatistics getStatistics() {
            return this.statistics;
        }

        @Override
        int getTimeLimit() {
            return this.timeLimit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean isAllowed(ClientConnection connection, PreParseOperation operation, boolean fullCheck, List<Message> messages) {
            boolean result = true;
            if (fullCheck) {
                Object object = this.mutex;
                synchronized (object) {
                    if (this.maxConnections > 0 && this.statistics.getClientConnections() > (long)this.maxConnections) {
                        messages.add(CoreMessages.INFO_ERROR_MAX_CONNECTIONS_LIMIT_EXCEEDED.get());
                        result = false;
                    }
                }
                if (!result) {
                    return result;
                }
                object = this.mutex;
                synchronized (object) {
                    String ip = connection.getClientAddress();
                    Integer currentCount = this.connectionsPerIPMap.get(ip);
                    if (currentCount == null) {
                        currentCount = new Integer(0);
                    }
                    if (this.maxConnectionsFromSameIP > 0 && currentCount > this.maxConnectionsFromSameIP) {
                        messages.add(CoreMessages.INFO_ERROR_MAX_CONNECTIONS_FROM_SAME_IP_LIMIT_EXCEEDED.get());
                        result = false;
                    }
                }
                if (!result) {
                    return result;
                }
            }
            if (this.maxOpsPerConnection > 0 && connection.getNumberOfOperations() > (long)this.maxOpsPerConnection) {
                messages.add(CoreMessages.INFO_ERROR_MAX_OPERATIONS_PER_CONNECTION_LIMIT_EXCEEDED.get());
                return false;
            }
            if (this.maxConcurrentOpsPerConnection > 0 && connection.getOperationsInProgress().size() > this.maxConcurrentOpsPerConnection) {
                messages.add(CoreMessages.INFO_ERROR_MAX_CONCURRENT_OPERATIONS_PER_CONNECTION_LIMIT_EXCEEDED.get());
                return false;
            }
            if (operation != null && operation instanceof PreParseSearchOperation && !this.checkSubstringFilter(((PreParseSearchOperation)operation).getRawFilter())) {
                messages.add(CoreMessages.INFO_ERROR_MIN_SEARCH_SUBSTRING_LENGTH_LIMIT_EXCEEDED.get());
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void removeConnection(ClientConnection connection) {
            Object object = this.mutex;
            synchronized (object) {
                this.statistics.removeClientConnection();
                String ip = connection.getClientAddress();
                Integer currentCount = this.connectionsPerIPMap.get(ip);
                if (currentCount != null) {
                    if (currentCount == 1) {
                        this.connectionsPerIPMap.remove(ip);
                    } else {
                        this.connectionsPerIPMap.put(ip, currentCount - 1);
                    }
                }
            }
        }

        private boolean checkSubstringFilter(RawFilter filter) {
            switch (filter.getFilterType()) {
                case AND: 
                case OR: {
                    ArrayList<RawFilter> filterComponents = filter.getFilterComponents();
                    if (filterComponents != null) {
                        for (RawFilter element : filterComponents) {
                            if (this.checkSubstringFilter(element)) continue;
                            return false;
                        }
                    }
                    return true;
                }
                case NOT: {
                    return this.checkSubstringFilter(filter.getNOTComponent());
                }
                case SUBSTRING: {
                    ByteString subFinalElement;
                    ArrayList<ByteString> subAnyElements;
                    int length = 0;
                    ByteString subInitialElement = filter.getSubInitialElement();
                    if (subInitialElement != null) {
                        length += subInitialElement.length();
                    }
                    if ((subAnyElements = filter.getSubAnyElements()) != null) {
                        for (ByteString element : subAnyElements) {
                            length += element.length();
                        }
                    }
                    if ((subFinalElement = filter.getSubFinalElement()) != null) {
                        length += subFinalElement.length();
                    }
                    return length >= this.minSearchSubstringLength;
                }
            }
            return true;
        }

        private void updateConfiguration(ResourceLimitsQOSPolicyCfg configuration) {
            this.maxConnections = configuration.getMaxConnections();
            this.maxConnectionsFromSameIP = configuration.getMaxConnectionsFromSameIP();
            this.maxOpsPerConnection = configuration.getMaxOpsPerConnection();
            this.maxConcurrentOpsPerConnection = configuration.getMaxConcurrentOpsPerConnection();
            Integer tmpSizeLimit = configuration.getSizeLimit();
            this.sizeLimit = tmpSizeLimit != null ? tmpSizeLimit : DirectoryServer.getSizeLimit();
            Long tmpTimeLimit = configuration.getTimeLimit();
            this.timeLimit = tmpTimeLimit != null ? tmpTimeLimit.intValue() : DirectoryServer.getTimeLimit();
            this.minSearchSubstringLength = configuration.getMinSubstringLength();
        }
    }
}

