/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core.networkgroups;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.opends.messages.ConfigMessages;
import org.opends.messages.CoreMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.std.meta.RequestFilteringQOSPolicyCfgDefn;
import org.opends.server.admin.std.server.RequestFilteringQOSPolicyCfg;
import org.opends.server.api.QOSPolicyFactory;
import org.opends.server.config.ConfigException;
import org.opends.server.core.networkgroups.RequestFilteringPolicy;
import org.opends.server.core.networkgroups.RequestFilteringPolicyStatistics;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.OperationType;
import org.opends.server.types.RawFilter;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PreParseAddOperation;
import org.opends.server.types.operation.PreParseCompareOperation;
import org.opends.server.types.operation.PreParseDeleteOperation;
import org.opends.server.types.operation.PreParseModifyDNOperation;
import org.opends.server.types.operation.PreParseModifyOperation;
import org.opends.server.types.operation.PreParseOperation;
import org.opends.server.types.operation.PreParseSearchOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequestFilteringPolicyFactory
implements QOSPolicyFactory<RequestFilteringQOSPolicyCfg> {
    private static boolean validateConfiguration(RequestFilteringQOSPolicyCfg configuration, List<Message> unacceptableReasons) {
        for (String allowedAttr : configuration.getAllowedAttributes()) {
            if (!configuration.getProhibitedAttributes().contains(allowedAttr)) continue;
            unacceptableReasons.add(ConfigMessages.ERR_CONFIG_NETWORKGROUPREQUESTFILTERINGPOLICY_INVALID_ATTRIBUTE.get(allowedAttr, configuration.dn().toString()));
            return false;
        }
        for (DN allowedSubtree : configuration.getAllowedSubtrees()) {
            if (!configuration.getProhibitedSubtrees().contains(allowedSubtree)) continue;
            unacceptableReasons.add(ConfigMessages.ERR_CONFIG_NETWORKGROUPREQUESTFILTERINGPOLICY_INVALID_SUBTREE.get(allowedSubtree.toString(), configuration.dn().toString()));
            return false;
        }
        return true;
    }

    public RequestFilteringPolicy createQOSPolicy(RequestFilteringQOSPolicyCfg configuration) throws ConfigException, InitializationException {
        Policy policy = new Policy();
        policy.updateConfiguration(configuration);
        configuration.addRequestFilteringChangeListener(policy);
        return policy;
    }

    @Override
    public boolean isConfigurationAcceptable(RequestFilteringQOSPolicyCfg configuration, List<Message> unacceptableReasons) {
        return RequestFilteringPolicyFactory.validateConfiguration(configuration, unacceptableReasons);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Policy
    extends RequestFilteringPolicy
    implements ConfigurationChangeListener<RequestFilteringQOSPolicyCfg> {
        private Set<String> allowedAttributes = null;
        private Set<RequestFilteringQOSPolicyCfgDefn.AllowedOperations> allowedOperations = null;
        private Set<RequestFilteringQOSPolicyCfgDefn.AllowedSearchScopes> allowedSearchScopes = null;
        private Set<DN> allowedSubtrees = null;
        private Set<String> prohibitedAttributes = null;
        private Set<DN> prohibitedSubtrees = null;
        private final RequestFilteringPolicyStatistics statistics = new RequestFilteringPolicyStatistics();

        private Policy() {
        }

        @Override
        public ConfigChangeResult applyConfigurationChange(RequestFilteringQOSPolicyCfg configuration) {
            ResultCode resultCode = ResultCode.SUCCESS;
            boolean adminActionRequired = false;
            ArrayList<Message> messages = new ArrayList<Message>();
            this.updateConfiguration(configuration);
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }

        @Override
        public boolean isConfigurationChangeAcceptable(RequestFilteringQOSPolicyCfg configuration, List<Message> unacceptableReasons) {
            return RequestFilteringPolicyFactory.validateConfiguration(configuration, unacceptableReasons);
        }

        @Override
        RequestFilteringPolicyStatistics getStatistics() {
            return this.statistics;
        }

        @Override
        boolean isAllowed(PreParseOperation operation, List<Message> messages) {
            boolean allowRequest = true;
            if (!this.allowedOperations.isEmpty()) {
                switch (operation.getOperationType()) {
                    case ABANDON: {
                        allowRequest = true;
                        break;
                    }
                    case ADD: {
                        allowRequest = this.allowedOperations.contains((Object)RequestFilteringQOSPolicyCfgDefn.AllowedOperations.ADD);
                        break;
                    }
                    case BIND: {
                        allowRequest = this.allowedOperations.contains((Object)RequestFilteringQOSPolicyCfgDefn.AllowedOperations.BIND);
                        break;
                    }
                    case COMPARE: {
                        allowRequest = this.allowedOperations.contains((Object)RequestFilteringQOSPolicyCfgDefn.AllowedOperations.COMPARE);
                        break;
                    }
                    case DELETE: {
                        allowRequest = this.allowedOperations.contains((Object)RequestFilteringQOSPolicyCfgDefn.AllowedOperations.DELETE);
                        break;
                    }
                    case EXTENDED: {
                        allowRequest = this.allowedOperations.contains((Object)RequestFilteringQOSPolicyCfgDefn.AllowedOperations.EXTENDED);
                        break;
                    }
                    case MODIFY: {
                        allowRequest = this.allowedOperations.contains((Object)RequestFilteringQOSPolicyCfgDefn.AllowedOperations.MODIFY);
                        break;
                    }
                    case MODIFY_DN: {
                        allowRequest = this.allowedOperations.contains((Object)RequestFilteringQOSPolicyCfgDefn.AllowedOperations.RENAME);
                        break;
                    }
                    case SEARCH: {
                        allowRequest = this.allowedOperations.contains((Object)RequestFilteringQOSPolicyCfgDefn.AllowedOperations.SEARCH);
                        if (!allowRequest || this.allowedOperations.contains((Object)RequestFilteringQOSPolicyCfgDefn.AllowedOperations.INEQUALITY_SEARCH)) break;
                        RawFilter flt = ((PreParseSearchOperation)operation).getRawFilter();
                        allowRequest = !this.containsInequalitySearch(flt);
                        break;
                    }
                    case UNBIND: {
                        allowRequest = true;
                    }
                }
                if (!allowRequest) {
                    this.statistics.updateRejectedOperations();
                    messages.add(CoreMessages.INFO_ERROR_OPERATION_NOT_ALLOWED.get());
                    return allowRequest;
                }
            }
            if (operation.getOperationType().equals((Object)OperationType.SEARCH)) {
                PreParseSearchOperation searchOp = (PreParseSearchOperation)operation;
                if (!this.prohibitedAttributes.isEmpty()) {
                    boolean bl = allowRequest = !this.containsProhibitedAttribute(searchOp.getRawFilter());
                }
                if (!allowRequest) {
                    this.statistics.updateRejectedAttributes();
                    messages.add(CoreMessages.INFO_ERROR_ATTRIBUTE_NOT_ALLOWED.get());
                    return allowRequest;
                }
                if (!this.allowedAttributes.isEmpty()) {
                    allowRequest = this.containsOnlyAllowedAttributes(searchOp.getRawFilter());
                }
                if (!allowRequest) {
                    this.statistics.updateRejectedAttributes();
                    messages.add(CoreMessages.INFO_ERROR_ATTRIBUTE_NOT_ALLOWED.get());
                    return allowRequest;
                }
                if (!this.allowedSearchScopes.isEmpty()) {
                    switch (searchOp.getScope()) {
                        case BASE_OBJECT: {
                            allowRequest = this.allowedSearchScopes.contains((Object)RequestFilteringQOSPolicyCfgDefn.AllowedSearchScopes.BASE);
                            break;
                        }
                        case SINGLE_LEVEL: {
                            allowRequest = this.allowedSearchScopes.contains((Object)RequestFilteringQOSPolicyCfgDefn.AllowedSearchScopes.ONE);
                            break;
                        }
                        case WHOLE_SUBTREE: {
                            allowRequest = this.allowedSearchScopes.contains((Object)RequestFilteringQOSPolicyCfgDefn.AllowedSearchScopes.SUB);
                            break;
                        }
                        case SUBORDINATE_SUBTREE: {
                            allowRequest = this.allowedSearchScopes.contains((Object)RequestFilteringQOSPolicyCfgDefn.AllowedSearchScopes.CHILDREN);
                        }
                    }
                    if (!allowRequest) {
                        this.statistics.updateRejectedScopes();
                        messages.add(CoreMessages.INFO_ERROR_SEARCH_SCOPE_NOT_ALLOWED.get());
                        return allowRequest;
                    }
                }
            }
            if (operation.getOperationType().equals((Object)OperationType.COMPARE)) {
                PreParseCompareOperation compareOp = (PreParseCompareOperation)operation;
                if (!this.prohibitedAttributes.isEmpty()) {
                    boolean bl = allowRequest = !this.prohibitedAttributes.contains(compareOp.getRawAttributeType());
                }
                if (!allowRequest) {
                    this.statistics.updateRejectedAttributes();
                    messages.add(CoreMessages.INFO_ERROR_ATTRIBUTE_NOT_ALLOWED.get());
                    return allowRequest;
                }
                if (!this.allowedAttributes.isEmpty()) {
                    allowRequest = this.allowedAttributes.contains(compareOp.getRawAttributeType());
                }
                if (!allowRequest) {
                    this.statistics.updateRejectedAttributes();
                    messages.add(CoreMessages.INFO_ERROR_ATTRIBUTE_NOT_ALLOWED.get());
                    return allowRequest;
                }
            }
            DN entryDN = null;
            DN newEntryDN = null;
            try {
                switch (operation.getOperationType()) {
                    case ADD: {
                        entryDN = DN.decode(((PreParseAddOperation)operation).getRawEntryDN());
                        break;
                    }
                    case COMPARE: {
                        entryDN = DN.decode(((PreParseCompareOperation)operation).getRawEntryDN());
                        break;
                    }
                    case DELETE: {
                        entryDN = DN.decode(((PreParseDeleteOperation)operation).getRawEntryDN());
                        break;
                    }
                    case EXTENDED: {
                        break;
                    }
                    case MODIFY: {
                        entryDN = DN.decode(((PreParseModifyOperation)operation).getRawEntryDN());
                        break;
                    }
                    case MODIFY_DN: {
                        entryDN = DN.decode(((PreParseModifyDNOperation)operation).getRawEntryDN());
                        newEntryDN = DN.decode(((PreParseModifyDNOperation)operation).getRawNewRDN());
                        break;
                    }
                    case SEARCH: {
                        entryDN = DN.decode(((PreParseSearchOperation)operation).getRawBaseDN());
                        break;
                    }
                }
                if (entryDN != null) {
                    boolean bl = allowRequest = this.isInAllowedSubtrees(entryDN) && !this.isInProhibitedSubtrees(entryDN);
                }
                if (newEntryDN != null) {
                    allowRequest = this.isInAllowedSubtrees(newEntryDN) && !this.isInProhibitedSubtrees(newEntryDN);
                }
            }
            catch (DirectoryException e) {
                allowRequest = true;
            }
            if (!allowRequest) {
                this.statistics.updateRejectedSubtrees();
                messages.add(CoreMessages.INFO_ERROR_SUBTREE_NOT_ALLOWED.get());
                return allowRequest;
            }
            return true;
        }

        private boolean containsInequalitySearch(RawFilter filter) {
            switch (filter.getFilterType()) {
                case AND: 
                case OR: {
                    ArrayList<RawFilter> filterComponents = filter.getFilterComponents();
                    if (filterComponents != null) {
                        for (RawFilter element : filterComponents) {
                            if (!this.containsInequalitySearch(element)) continue;
                            return true;
                        }
                    }
                    return false;
                }
                case NOT: {
                    return this.containsInequalitySearch(filter.getNOTComponent());
                }
                case GREATER_OR_EQUAL: 
                case LESS_OR_EQUAL: {
                    return true;
                }
            }
            return false;
        }

        private boolean containsOnlyAllowedAttributes(RawFilter filter) {
            switch (filter.getFilterType()) {
                case AND: 
                case OR: {
                    ArrayList<RawFilter> filterComponents = filter.getFilterComponents();
                    if (filterComponents != null) {
                        for (RawFilter element : filterComponents) {
                            if (this.containsOnlyAllowedAttributes(element)) continue;
                            return false;
                        }
                    }
                    return true;
                }
                case NOT: {
                    return this.containsOnlyAllowedAttributes(filter.getNOTComponent());
                }
            }
            return this.allowedAttributes.contains(filter.getAttributeType());
        }

        private boolean containsProhibitedAttribute(RawFilter filter) {
            switch (filter.getFilterType()) {
                case AND: 
                case OR: {
                    ArrayList<RawFilter> filterComponents = filter.getFilterComponents();
                    if (filterComponents != null) {
                        for (RawFilter element : filterComponents) {
                            if (!this.containsProhibitedAttribute(element)) continue;
                            return true;
                        }
                    }
                    return false;
                }
                case NOT: {
                    return this.containsProhibitedAttribute(filter.getNOTComponent());
                }
            }
            return this.prohibitedAttributes.contains(filter.getAttributeType());
        }

        private boolean isInAllowedSubtrees(DN dn) {
            boolean result = false;
            if (this.allowedSubtrees.isEmpty()) {
                return true;
            }
            for (DN branch : this.allowedSubtrees) {
                if (!dn.isDescendantOf(branch)) continue;
                result = true;
                break;
            }
            return result;
        }

        private boolean isInProhibitedSubtrees(DN dn) {
            boolean result = false;
            for (DN branch : this.prohibitedSubtrees) {
                if (!dn.isDescendantOf(branch)) continue;
                result = true;
                break;
            }
            return result;
        }

        private void updateConfiguration(RequestFilteringQOSPolicyCfg configuration) {
            this.allowedOperations = configuration.getAllowedOperations();
            this.allowedAttributes = configuration.getAllowedAttributes();
            this.prohibitedAttributes = configuration.getProhibitedAttributes();
            this.allowedSearchScopes = configuration.getAllowedSearchScopes();
            this.allowedSubtrees = configuration.getAllowedSubtrees();
            this.prohibitedSubtrees = configuration.getProhibitedSubtrees();
        }
    }
}

