/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opends.messages.CoreMessages;
import org.opends.server.api.Backend;
import org.opends.server.api.BackendInitializationListener;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.SubentryChangeListener;
import org.opends.server.api.plugin.InternalDirectoryServerPlugin;
import org.opends.server.api.plugin.PluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.controls.SubentriesControl;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.RFC3672SubtreeSpecification;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.types.SubEntry;
import org.opends.server.types.operation.PostOperationAddOperation;
import org.opends.server.types.operation.PostOperationDeleteOperation;
import org.opends.server.types.operation.PostOperationModifyDNOperation;
import org.opends.server.types.operation.PostOperationModifyOperation;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.types.operation.PreOperationDeleteOperation;
import org.opends.server.types.operation.PreOperationModifyDNOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;
import org.opends.server.workflowelement.localbackend.LocalBackendSearchOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubentryManager
extends InternalDirectoryServerPlugin
implements BackendInitializationListener {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private HashMap<DN, List<SubEntry>> dn2SubEntry;
    private HashMap<DN, List<SubEntry>> dn2CollectiveSubEntry;
    private LinkedHashSet<String> requestAttrs;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private CopyOnWriteArrayList<SubentryChangeListener> changeListeners;
    private static final String CONFIG_DN = "cn=Subentry Manager,cn=config";

    public SubentryManager() throws DirectoryException {
        super(DN.decode(CONFIG_DN), EnumSet.of(PluginType.PRE_OPERATION_ADD, new PluginType[]{PluginType.PRE_OPERATION_DELETE, PluginType.PRE_OPERATION_MODIFY, PluginType.PRE_OPERATION_MODIFY_DN, PluginType.POST_OPERATION_ADD, PluginType.POST_OPERATION_DELETE, PluginType.POST_OPERATION_MODIFY, PluginType.POST_OPERATION_MODIFY_DN}), true);
        this.dn2SubEntry = new HashMap();
        this.dn2CollectiveSubEntry = new HashMap();
        this.changeListeners = new CopyOnWriteArrayList();
        this.requestAttrs = new LinkedHashSet();
        this.requestAttrs.add("*");
        this.requestAttrs.add("+");
        DirectoryServer.registerInternalPlugin(this);
        DirectoryServer.registerBackendInitializationListener(this);
    }

    public void finalizeSubentryManager() {
        DirectoryServer.deregisterInternalPlugin(this);
        DirectoryServer.deregisterBackendInitializationListener(this);
    }

    public void registerChangeListener(SubentryChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void deregisterChangeListener(SubentryChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSubEntry(Entry entry) throws DirectoryException {
        SubEntry subEntry = new SubEntry(entry);
        RFC3672SubtreeSpecification subSpec = subEntry.getSubTreeSpecification();
        DN subDN = subSpec.getBaseDN();
        List<SubEntry> subList = null;
        this.lock.writeLock().lock();
        try {
            subList = subEntry.isCollective() ? this.dn2CollectiveSubEntry.get(subDN) : this.dn2SubEntry.get(subDN);
            if (subList == null) {
                subList = new ArrayList<SubEntry>();
                if (subEntry.isCollective()) {
                    this.dn2CollectiveSubEntry.put(subDN, subList);
                } else {
                    this.dn2SubEntry.put(subDN, subList);
                }
            }
            subList.add(subEntry);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSubEntry(Entry entry) {
        this.lock.writeLock().lock();
        try {
            SubEntry subEntry;
            Iterator<SubEntry> listIterator;
            List<SubEntry> subList;
            Map.Entry<DN, List<SubEntry>> mapEntry;
            boolean removed = false;
            Iterator<Map.Entry<DN, List<SubEntry>>> setIterator = this.dn2SubEntry.entrySet().iterator();
            while (setIterator.hasNext()) {
                mapEntry = setIterator.next();
                subList = mapEntry.getValue();
                listIterator = subList.iterator();
                while (listIterator.hasNext()) {
                    subEntry = listIterator.next();
                    if (!subEntry.getDN().equals(entry.getDN())) continue;
                    listIterator.remove();
                    removed = true;
                    break;
                }
                if (subList.isEmpty()) {
                    setIterator.remove();
                }
                if (!removed) continue;
                return;
            }
            setIterator = this.dn2CollectiveSubEntry.entrySet().iterator();
            while (setIterator.hasNext()) {
                mapEntry = setIterator.next();
                subList = mapEntry.getValue();
                listIterator = subList.iterator();
                while (listIterator.hasNext()) {
                    subEntry = listIterator.next();
                    if (!subEntry.getDN().equals(entry.getDN())) continue;
                    listIterator.remove();
                    removed = true;
                    break;
                }
                if (subList.isEmpty()) {
                    setIterator.remove();
                }
                if (!removed) continue;
                return;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public void performBackendInitializationProcessing(Backend backend) {
        SearchFilter filter;
        LinkedList<Control> requestControls;
        InternalClientConnection conn;
        block12: {
            conn = InternalClientConnection.getRootConnection();
            requestControls = new LinkedList<Control>();
            requestControls.add(new SubentriesControl(true, true));
            filter = null;
            try {
                filter = SearchFilter.createFilterFromString("(|(objectClass=subentry)(objectClass=ldapSubentry))");
                if (backend.getEntryCount() > 0L && !backend.isIndexed(filter)) {
                    ErrorLogger.logError(CoreMessages.WARN_SUBENTRY_FILTER_NOT_INDEXED.get(String.valueOf(filter), backend.getBackendID()));
                }
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) break block12;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
            }
        }
        for (DN baseDN : backend.getBaseDNs()) {
            block13: {
                try {
                    if (!backend.entryExists(baseDN)) {
                    }
                    break block13;
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                continue;
            }
            InternalSearchOperation internalSearch = new InternalSearchOperation((ClientConnection)conn, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), requestControls, baseDN, SearchScope.WHOLE_SUBTREE, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, filter, this.requestAttrs, null);
            LocalBackendSearchOperation localSearch = new LocalBackendSearchOperation(internalSearch);
            try {
                backend.search(localSearch);
            }
            catch (Exception e) {
                if (!DebugLogger.debugEnabled()) continue;
                TRACER.debugCaught(DebugLogLevel.ERROR, e);
                continue;
            }
            for (SearchResultEntry entry : internalSearch.getSearchEntries()) {
                if (!entry.isSubentry() && !entry.isLDAPSubentry()) continue;
                try {
                    this.addSubEntry(entry);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SubEntry> getSubentries() {
        if (this.dn2SubEntry.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SubEntry> subentries = new ArrayList<SubEntry>();
        this.lock.readLock().lock();
        try {
            for (List<SubEntry> subList : this.dn2SubEntry.values()) {
                subentries.addAll(subList);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return subentries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SubEntry> getSubentries(DN dn) {
        if (this.dn2SubEntry.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SubEntry> subentries = new ArrayList<SubEntry>();
        this.lock.readLock().lock();
        try {
            for (DN subDN = dn; subDN != null; subDN = subDN.getParent()) {
                List<SubEntry> subList = this.dn2SubEntry.get(subDN);
                if (subList == null) continue;
                for (SubEntry subEntry : subList) {
                    RFC3672SubtreeSpecification subSpec = subEntry.getSubTreeSpecification();
                    if (!subSpec.isDNWithinScope(dn)) continue;
                    subentries.add(subEntry);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return subentries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SubEntry> getSubentries(Entry entry) {
        if (this.dn2SubEntry.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SubEntry> subentries = new ArrayList<SubEntry>();
        this.lock.readLock().lock();
        try {
            for (DN subDN = entry.getDN(); subDN != null; subDN = subDN.getParent()) {
                List<SubEntry> subList = this.dn2SubEntry.get(subDN);
                if (subList == null) continue;
                for (SubEntry subEntry : subList) {
                    RFC3672SubtreeSpecification subSpec = subEntry.getSubTreeSpecification();
                    if (!subSpec.isWithinScope(entry)) continue;
                    subentries.add(subEntry);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return subentries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SubEntry> getCollectiveSubentries(DN dn) {
        if (this.dn2CollectiveSubEntry.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SubEntry> subentries = new ArrayList<SubEntry>();
        this.lock.readLock().lock();
        try {
            for (DN subDN = dn; subDN != null; subDN = subDN.getParent()) {
                List<SubEntry> subList = this.dn2CollectiveSubEntry.get(subDN);
                if (subList == null) continue;
                for (SubEntry subEntry : subList) {
                    RFC3672SubtreeSpecification subSpec = subEntry.getSubTreeSpecification();
                    if (!subSpec.isDNWithinScope(dn)) continue;
                    subentries.add(subEntry);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return subentries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SubEntry> getCollectiveSubentries(Entry entry) {
        if (this.dn2CollectiveSubEntry.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SubEntry> subentries = new ArrayList<SubEntry>();
        this.lock.readLock().lock();
        try {
            for (DN subDN = entry.getDN(); subDN != null; subDN = subDN.getParent()) {
                List<SubEntry> subList = this.dn2CollectiveSubEntry.get(subDN);
                if (subList == null) continue;
                for (SubEntry subEntry : subList) {
                    RFC3672SubtreeSpecification subSpec = subEntry.getSubTreeSpecification();
                    if (!subSpec.isWithinScope(entry)) continue;
                    subentries.add(subEntry);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return subentries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performBackendFinalizationProcessing(Backend backend) {
        this.lock.writeLock().lock();
        try {
            SubEntry subEntry;
            Iterator<SubEntry> listIterator;
            List<SubEntry> subList;
            Map.Entry<DN, List<SubEntry>> mapEntry;
            Iterator<Map.Entry<DN, List<SubEntry>>> setIterator = this.dn2SubEntry.entrySet().iterator();
            while (setIterator.hasNext()) {
                mapEntry = setIterator.next();
                subList = mapEntry.getValue();
                listIterator = subList.iterator();
                while (listIterator.hasNext()) {
                    subEntry = listIterator.next();
                    if (!backend.handlesEntry(subEntry.getDN())) continue;
                    listIterator.remove();
                }
                if (!subList.isEmpty()) continue;
                setIterator.remove();
            }
            setIterator = this.dn2CollectiveSubEntry.entrySet().iterator();
            while (setIterator.hasNext()) {
                mapEntry = setIterator.next();
                subList = mapEntry.getValue();
                listIterator = subList.iterator();
                while (listIterator.hasNext()) {
                    subEntry = listIterator.next();
                    if (!backend.handlesEntry(subEntry.getDN())) continue;
                    listIterator.remove();
                }
                if (!subList.isEmpty()) continue;
                setIterator.remove();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public PluginResult.PreOperation doPreOperation(PreOperationAddOperation addOperation) {
        Entry entry = addOperation.getEntryToAdd();
        if (entry.isSubentry() || entry.isLDAPSubentry()) {
            for (SubentryChangeListener changeListener : this.changeListeners) {
                try {
                    changeListener.checkSubentryAddAcceptable(entry);
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    return PluginResult.PreOperation.stopProcessing(de.getResultCode(), de.getMessageObject());
                }
            }
        }
        return PluginResult.PreOperation.continueOperationProcessing();
    }

    @Override
    public PluginResult.PreOperation doPreOperation(PreOperationDeleteOperation deleteOperation) {
        Entry entry = deleteOperation.getEntryToDelete();
        if (entry.isSubentry() || entry.isLDAPSubentry()) {
            for (SubentryChangeListener changeListener : this.changeListeners) {
                try {
                    changeListener.checkSubentryDeleteAcceptable(entry);
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    return PluginResult.PreOperation.stopProcessing(de.getResultCode(), de.getMessageObject());
                }
            }
        }
        return PluginResult.PreOperation.continueOperationProcessing();
    }

    @Override
    public PluginResult.PreOperation doPreOperation(PreOperationModifyOperation modifyOperation) {
        Entry oldEntry = modifyOperation.getCurrentEntry();
        Entry newEntry = modifyOperation.getModifiedEntry();
        if (newEntry.isSubentry() || newEntry.isLDAPSubentry() || oldEntry.isSubentry() || oldEntry.isLDAPSubentry()) {
            for (SubentryChangeListener changeListener : this.changeListeners) {
                try {
                    changeListener.checkSubentryModifyAcceptable(oldEntry, newEntry);
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    return PluginResult.PreOperation.stopProcessing(de.getResultCode(), de.getMessageObject());
                }
            }
        }
        return PluginResult.PreOperation.continueOperationProcessing();
    }

    @Override
    public PluginResult.PreOperation doPreOperation(PreOperationModifyDNOperation modifyDNOperation) {
        Entry oldEntry = modifyDNOperation.getOriginalEntry();
        Entry newEntry = modifyDNOperation.getUpdatedEntry();
        if (oldEntry.isSubentry() || oldEntry.isLDAPSubentry()) {
            for (SubentryChangeListener changeListener : this.changeListeners) {
                try {
                    changeListener.checkSubentryModifyAcceptable(oldEntry, newEntry);
                }
                catch (DirectoryException de) {
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, de);
                    }
                    return PluginResult.PreOperation.stopProcessing(de.getResultCode(), de.getMessageObject());
                }
            }
        }
        return PluginResult.PreOperation.continueOperationProcessing();
    }

    @Override
    public PluginResult.PostOperation doPostOperation(PostOperationAddOperation addOperation) {
        block6: {
            Entry entry = addOperation.getEntryToAdd();
            if (entry.isSubentry() || entry.isLDAPSubentry()) {
                try {
                    this.addSubEntry(entry);
                    for (SubentryChangeListener changeListener : this.changeListeners) {
                        try {
                            changeListener.handleSubentryAdd(entry);
                        }
                        catch (Exception e) {
                            if (!DebugLogger.debugEnabled()) continue;
                            TRACER.debugCaught(DebugLogLevel.ERROR, e);
                        }
                    }
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block6;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        return PluginResult.PostOperation.continueOperationProcessing();
    }

    @Override
    public PluginResult.PostOperation doPostOperation(PostOperationDeleteOperation deleteOperation) {
        Entry entry = deleteOperation.getEntryToDelete();
        if (entry.isSubentry() || entry.isLDAPSubentry()) {
            this.removeSubEntry(entry);
            for (SubentryChangeListener changeListener : this.changeListeners) {
                try {
                    changeListener.handleSubentryDelete(entry);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        return PluginResult.PostOperation.continueOperationProcessing();
    }

    @Override
    public PluginResult.PostOperation doPostOperation(PostOperationModifyOperation modifyOperation) {
        boolean notify;
        Entry newEntry;
        Entry oldEntry;
        block8: {
            oldEntry = modifyOperation.getCurrentEntry();
            newEntry = modifyOperation.getModifiedEntry();
            notify = false;
            if (oldEntry.isSubentry() || oldEntry.isLDAPSubentry()) {
                this.removeSubEntry(oldEntry);
                notify = true;
            }
            if (newEntry.isSubentry() || newEntry.isLDAPSubentry()) {
                try {
                    this.addSubEntry(newEntry);
                    notify = true;
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block8;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        if (notify) {
            for (SubentryChangeListener changeListener : this.changeListeners) {
                try {
                    changeListener.handleSubentryModify(oldEntry, newEntry);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        return PluginResult.PostOperation.continueOperationProcessing();
    }

    @Override
    public PluginResult.PostOperation doPostOperation(PostOperationModifyDNOperation modifyDNOperation) {
        Entry oldEntry = modifyDNOperation.getOriginalEntry();
        Entry newEntry = modifyDNOperation.getUpdatedEntry();
        if (oldEntry.isSubentry() || oldEntry.isLDAPSubentry()) {
            block6: {
                this.removeSubEntry(oldEntry);
                try {
                    this.addSubEntry(newEntry);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block6;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
            for (SubentryChangeListener changeListener : this.changeListeners) {
                try {
                    changeListener.handleSubentryModify(oldEntry, newEntry);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
        return PluginResult.PostOperation.continueOperationProcessing();
    }
}

