/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.admin.std.server.RootDNCfg;
import org.opends.server.admin.std.server.RootDNUserCfg;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.RootPrivilegeChangeListener;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.Privilege;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootDNConfigManager
implements ConfigurationChangeListener<RootDNUserCfg>,
ConfigurationAddListener<RootDNUserCfg>,
ConfigurationDeleteListener<RootDNUserCfg> {
    private ConcurrentHashMap<DN, HashSet<DN>> alternateBindDNs = new ConcurrentHashMap();
    private RootPrivilegeChangeListener rootPrivilegeChangeListener = new RootPrivilegeChangeListener();

    public void initializeRootDNs() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        RootDNCfg rootDNCfg = rootConfiguration.getRootDN();
        this.rootPrivilegeChangeListener.setDefaultRootPrivileges(rootDNCfg);
        rootDNCfg.addChangeListener(this.rootPrivilegeChangeListener);
        rootDNCfg.addRootDNUserAddListener(this);
        rootDNCfg.addRootDNUserDeleteListener(this);
        for (String name : rootDNCfg.listRootDNUsers()) {
            RootDNUserCfg rootUserCfg = rootDNCfg.getRootDNUser(name);
            rootUserCfg.addChangeListener(this);
            DirectoryServer.registerRootDN(rootUserCfg.dn());
            HashSet<DN> altBindDNs = new HashSet<DN>();
            for (DN alternateBindDN : rootUserCfg.getAlternateBindDN()) {
                try {
                    altBindDNs.add(alternateBindDN);
                    DirectoryServer.registerAlternateRootDN(rootUserCfg.dn(), alternateBindDN);
                }
                catch (DirectoryException de) {
                    throw new InitializationException(de.getMessageObject());
                }
            }
            this.alternateBindDNs.put(rootUserCfg.dn(), altBindDNs);
        }
    }

    public Set<Privilege> getRootPrivileges() {
        return this.rootPrivilegeChangeListener.getDefaultRootPrivileges();
    }

    @Override
    public boolean isConfigurationAddAcceptable(RootDNUserCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        for (DN altBindDN : configuration.getAlternateBindDN()) {
            DN existingRootDN = DirectoryServer.getActualRootBindDN(altBindDN);
            if (existingRootDN == null) continue;
            Message message = ConfigMessages.ERR_CONFIG_ROOTDN_CONFLICTING_MAPPING.get(String.valueOf(altBindDN), String.valueOf(configuration.dn()), String.valueOf(existingRootDN));
            unacceptableReasons.add(message);
            configAcceptable = false;
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(RootDNUserCfg configuration) {
        configuration.addChangeListener(this);
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        HashSet<DN> altBindDNs = new HashSet<DN>();
        for (DN altBindDN : configuration.getAlternateBindDN()) {
            try {
                DirectoryServer.registerAlternateRootDN(configuration.dn(), altBindDN);
                altBindDNs.add(altBindDN);
            }
            catch (DirectoryException de) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(de.getMessageObject());
                for (DN dn : altBindDNs) {
                    DirectoryServer.deregisterAlternateRootBindDN(dn);
                }
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            DirectoryServer.registerRootDN(configuration.dn());
            this.alternateBindDNs.put(configuration.dn(), altBindDNs);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(RootDNUserCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(RootDNUserCfg configuration) {
        DirectoryServer.deregisterRootDN(configuration.dn());
        configuration.removeChangeListener(this);
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        HashSet<DN> altBindDNs = this.alternateBindDNs.remove(configuration.dn());
        if (altBindDNs != null) {
            for (DN dn : altBindDNs) {
                DirectoryServer.deregisterAlternateRootBindDN(dn);
            }
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(RootDNUserCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        for (DN altBindDN : configuration.getAlternateBindDN()) {
            DN existingRootDN = DirectoryServer.getActualRootBindDN(altBindDN);
            if (existingRootDN == null || existingRootDN.equals(configuration.dn())) continue;
            Message message = ConfigMessages.ERR_CONFIG_ROOTDN_CONFLICTING_MAPPING.get(String.valueOf(altBindDN), String.valueOf(configuration.dn()), String.valueOf(existingRootDN));
            unacceptableReasons.add(message);
            configAcceptable = false;
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(RootDNUserCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        HashSet<DN> setDNs = new HashSet<DN>();
        HashSet<DN> addDNs = new HashSet<DN>();
        HashSet delDNs = new HashSet(this.alternateBindDNs.get(configuration.dn()));
        for (DN altBindDN : configuration.getAlternateBindDN()) {
            setDNs.add(altBindDN);
            if (delDNs.remove(altBindDN)) continue;
            addDNs.add(altBindDN);
        }
        for (DN dn : delDNs) {
            DirectoryServer.deregisterAlternateRootBindDN(dn);
        }
        HashSet<DN> addedDNs = new HashSet<DN>(addDNs.size());
        for (DN dn : addDNs) {
            try {
                DirectoryServer.registerAlternateRootDN(configuration.dn(), dn);
                addedDNs.add(dn);
            }
            catch (DirectoryException de) {
                resultCode = DirectoryServer.getServerErrorResultCode();
                messages.add(de.getMessageObject());
                for (DN addedDN : addedDNs) {
                    DirectoryServer.deregisterAlternateRootBindDN(addedDN);
                }
                for (DN deletedDN : delDNs) {
                    try {
                        DirectoryServer.registerAlternateRootDN(configuration.dn(), deletedDN);
                    }
                    catch (Exception e) {
                        this.alternateBindDNs.get(configuration.dn()).remove(deletedDN);
                    }
                }
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.alternateBindDNs.put(configuration.dn(), setDNs);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }
}

