/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.server.controls.EntryChangeNotificationControl;
import org.opends.server.controls.PersistentSearchChangeType;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.CancelResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PersistentSearch {
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private final DN baseDN;
    private final List<CancellationCallback> cancellationCallbacks = new CopyOnWriteArrayList<CancellationCallback>();
    private final Set<PersistentSearchChangeType> changeTypes;
    private final SearchFilter filter;
    private boolean isCancelled = false;
    private final boolean returnECs;
    private final SearchScope scope;
    private final SearchOperation searchOperation;

    private static synchronized void cancel(PersistentSearch psearch) {
        if (!psearch.isCancelled) {
            psearch.isCancelled = true;
            psearch.searchOperation.getClientConnection().deregisterPersistentSearch(psearch);
            for (CancellationCallback callback : psearch.cancellationCallbacks) {
                try {
                    callback.persistentSearchCancelled(psearch);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) continue;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
            }
        }
    }

    public PersistentSearch(SearchOperation searchOperation, Set<PersistentSearchChangeType> changeTypes, boolean returnECs) {
        this.searchOperation = searchOperation;
        this.changeTypes = changeTypes;
        this.returnECs = returnECs;
        this.baseDN = searchOperation.getBaseDN();
        this.scope = searchOperation.getScope();
        this.filter = searchOperation.getFilter();
    }

    public synchronized CancelResult cancel() {
        if (!this.isCancelled) {
            PersistentSearch.cancel(this);
            for (PersistentSearch psearch : this.searchOperation.getClientConnection().getPersistentSearches()) {
                if (psearch.getMessageID() != this.getMessageID()) continue;
                PersistentSearch.cancel(psearch);
            }
        }
        return new CancelResult(ResultCode.CANCELED, null);
    }

    public int getMessageID() {
        return this.searchOperation.getMessageID();
    }

    public SearchOperation getSearchOperation() {
        return this.searchOperation;
    }

    public void processAdd(Entry entry, long changeNumber) {
        block18: {
            if (!this.changeTypes.contains((Object)PersistentSearchChangeType.ADD)) {
                return;
            }
            switch (this.scope) {
                case BASE_OBJECT: {
                    if (this.baseDN.equals(entry.getDN())) break;
                    return;
                }
                case SINGLE_LEVEL: {
                    if (this.baseDN.equals(entry.getDN().getParentDNInSuffix())) break;
                    return;
                }
                case WHOLE_SUBTREE: {
                    if (this.baseDN.isAncestorOf(entry.getDN())) break;
                    return;
                }
                case SUBORDINATE_SUBTREE: {
                    if (!this.baseDN.equals(entry.getDN()) && this.baseDN.isAncestorOf(entry.getDN())) break;
                    return;
                }
                default: {
                    return;
                }
            }
            try {
                TRACER.debugInfo(this + " " + entry + " +filter=" + this.filter.matchesEntry(entry));
                if (!this.filter.matchesEntry(entry)) {
                    return;
                }
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                return;
            }
            ArrayList<Control> entryControls = new ArrayList<Control>(1);
            if (this.returnECs) {
                entryControls.add(new EntryChangeNotificationControl(PersistentSearchChangeType.ADD, changeNumber));
            }
            try {
                if (!this.searchOperation.returnEntry(entry, entryControls)) {
                    this.cancel();
                    this.searchOperation.sendSearchResultDone();
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                this.cancel();
                try {
                    this.searchOperation.sendSearchResultDone();
                }
                catch (Exception e2) {
                    if (!DebugLogger.debugEnabled()) break block18;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                }
            }
        }
    }

    public void processDelete(Entry entry, long changeNumber) {
        block18: {
            if (!this.changeTypes.contains((Object)PersistentSearchChangeType.DELETE)) {
                return;
            }
            switch (this.scope) {
                case BASE_OBJECT: {
                    if (this.baseDN.equals(entry.getDN())) break;
                    return;
                }
                case SINGLE_LEVEL: {
                    if (this.baseDN.equals(entry.getDN().getParentDNInSuffix())) break;
                    return;
                }
                case WHOLE_SUBTREE: {
                    if (this.baseDN.isAncestorOf(entry.getDN())) break;
                    return;
                }
                case SUBORDINATE_SUBTREE: {
                    if (!this.baseDN.equals(entry.getDN()) && this.baseDN.isAncestorOf(entry.getDN())) break;
                    return;
                }
                default: {
                    return;
                }
            }
            try {
                if (!this.filter.matchesEntry(entry)) {
                    return;
                }
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                return;
            }
            ArrayList<Control> entryControls = new ArrayList<Control>(1);
            if (this.returnECs) {
                entryControls.add(new EntryChangeNotificationControl(PersistentSearchChangeType.DELETE, changeNumber));
            }
            try {
                if (!this.searchOperation.returnEntry(entry, entryControls)) {
                    this.cancel();
                    this.searchOperation.sendSearchResultDone();
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                this.cancel();
                try {
                    this.searchOperation.sendSearchResultDone();
                }
                catch (Exception e2) {
                    if (!DebugLogger.debugEnabled()) break block18;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                }
            }
        }
    }

    public void processModify(Entry entry, long changeNumber) {
        this.processModify(entry, changeNumber, entry);
    }

    public void processModify(Entry entry, long changeNumber, Entry oldEntry) {
        block18: {
            if (!this.changeTypes.contains((Object)PersistentSearchChangeType.MODIFY)) {
                return;
            }
            switch (this.scope) {
                case BASE_OBJECT: {
                    if (this.baseDN.equals(oldEntry.getDN())) break;
                    return;
                }
                case SINGLE_LEVEL: {
                    if (this.baseDN.equals(oldEntry.getDN().getParent())) break;
                    return;
                }
                case WHOLE_SUBTREE: {
                    if (this.baseDN.isAncestorOf(oldEntry.getDN())) break;
                    return;
                }
                case SUBORDINATE_SUBTREE: {
                    if (!this.baseDN.equals(oldEntry.getDN()) && this.baseDN.isAncestorOf(oldEntry.getDN())) break;
                    return;
                }
                default: {
                    return;
                }
            }
            try {
                if (!this.filter.matchesEntry(oldEntry) && !this.filter.matchesEntry(entry)) {
                    return;
                }
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                return;
            }
            ArrayList<Control> entryControls = new ArrayList<Control>(1);
            if (this.returnECs) {
                entryControls.add(new EntryChangeNotificationControl(PersistentSearchChangeType.MODIFY, changeNumber));
            }
            try {
                if (!this.searchOperation.returnEntry(entry, entryControls)) {
                    this.cancel();
                    this.searchOperation.sendSearchResultDone();
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                this.cancel();
                try {
                    this.searchOperation.sendSearchResultDone();
                }
                catch (Exception e2) {
                    if (!DebugLogger.debugEnabled()) break block18;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                }
            }
        }
    }

    public void processModifyDN(Entry entry, long changeNumber, DN oldDN) {
        block18: {
            if (!this.changeTypes.contains((Object)PersistentSearchChangeType.MODIFY_DN)) {
                return;
            }
            boolean oldMatches = false;
            boolean newMatches = false;
            switch (this.scope) {
                case BASE_OBJECT: {
                    oldMatches = this.baseDN.equals(oldDN);
                    newMatches = this.baseDN.equals(entry.getDN());
                    if (oldMatches || newMatches) break;
                    return;
                }
                case SINGLE_LEVEL: {
                    oldMatches = this.baseDN.equals(oldDN.getParent());
                    newMatches = this.baseDN.equals(entry.getDN().getParent());
                    if (oldMatches || newMatches) break;
                    return;
                }
                case WHOLE_SUBTREE: {
                    oldMatches = this.baseDN.isAncestorOf(oldDN);
                    newMatches = this.baseDN.isAncestorOf(entry.getDN());
                    if (oldMatches || newMatches) break;
                    return;
                }
                case SUBORDINATE_SUBTREE: {
                    oldMatches = !this.baseDN.equals(oldDN) && this.baseDN.isAncestorOf(oldDN);
                    boolean bl = newMatches = !this.baseDN.equals(entry.getDN()) && this.baseDN.isAncestorOf(entry.getDN());
                    if (oldMatches || newMatches) break;
                    return;
                }
                default: {
                    return;
                }
            }
            try {
                if (!(oldMatches || newMatches || this.filter.matchesEntry(entry))) {
                    return;
                }
            }
            catch (DirectoryException de) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, de);
                }
                return;
            }
            ArrayList<Control> entryControls = new ArrayList<Control>(1);
            if (this.returnECs) {
                entryControls.add(new EntryChangeNotificationControl(PersistentSearchChangeType.MODIFY_DN, oldDN, changeNumber));
            }
            try {
                if (!this.searchOperation.returnEntry(entry, entryControls)) {
                    this.cancel();
                    this.searchOperation.sendSearchResultDone();
                }
            }
            catch (Exception e) {
                if (DebugLogger.debugEnabled()) {
                    TRACER.debugCaught(DebugLogLevel.ERROR, e);
                }
                this.cancel();
                try {
                    this.searchOperation.sendSearchResultDone();
                }
                catch (Exception e2) {
                    if (!DebugLogger.debugEnabled()) break block18;
                    TRACER.debugCaught(DebugLogLevel.ERROR, e2);
                }
            }
        }
    }

    public void registerCancellationCallback(CancellationCallback callback) {
        this.cancellationCallbacks.add(callback);
    }

    public void enable() {
        this.searchOperation.getClientConnection().registerPersistentSearch(this);
        this.searchOperation.setSendResponse(false);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("PersistentSearch(connID=");
        buffer.append(this.searchOperation.getConnectionID());
        buffer.append(",opID=");
        buffer.append(this.searchOperation.getOperationID());
        buffer.append(",baseDN=\"");
        this.searchOperation.getBaseDN().toString(buffer);
        buffer.append("\",scope=");
        buffer.append(this.scope.toString());
        buffer.append(",filter=\"");
        this.filter.toString(buffer);
        buffer.append("\")");
    }

    public static interface CancellationCallback {
        public void persistentSearchCancelled(PersistentSearch var1);
    }
}

