/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.List;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.server.PasswordPolicyCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.SubentryChangeListener;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.core.PasswordPolicyConfig;
import org.opends.server.core.SubentryPasswordPolicy;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SubEntry;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordPolicyConfigManager
implements SubentryChangeListener,
ConfigurationAddListener<PasswordPolicyCfg>,
ConfigurationDeleteListener<PasswordPolicyCfg> {
    private static final DebugTracer TRACER = DebugLogger.getTracer();

    private PasswordPolicyConfig createPasswordPolicyConfig(SubEntry subEntry) throws InitializationException {
        try {
            SubentryPasswordPolicy subentryPolicy = new SubentryPasswordPolicy(subEntry);
            PasswordPolicy passwordPolicy = new PasswordPolicy(subentryPolicy);
            PasswordPolicyConfig config = new PasswordPolicyConfig(passwordPolicy);
            return config;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(subEntry.getDN()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }

    public void initializePasswordPolicies() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addPasswordPolicyAddListener(this);
        rootConfiguration.addPasswordPolicyDeleteListener(this);
        String[] passwordPoliciesName = rootConfiguration.listPasswordPolicies();
        if (passwordPoliciesName.length == 0) {
            Message message = ConfigMessages.ERR_CONFIG_PWPOLICY_NO_POLICIES.get();
            throw new ConfigException(message);
        }
        if (null == DirectoryServer.getDefaultPasswordPolicyDN()) {
            Message message = ConfigMessages.ERR_CONFIG_PWPOLICY_NO_DEFAULT_POLICY.get();
            throw new ConfigException(message);
        }
        for (String passwordPolicyName : passwordPoliciesName) {
            Message message;
            PasswordPolicyCfg passwordPolicyConfiguration = rootConfiguration.getPasswordPolicy(passwordPolicyName);
            try {
                PasswordPolicy policy = new PasswordPolicy(passwordPolicyConfiguration);
                PasswordPolicyConfig config = new PasswordPolicyConfig(policy);
                DirectoryServer.registerPasswordPolicy(passwordPolicyConfiguration.dn(), config);
                passwordPolicyConfiguration.addChangeListener(config);
            }
            catch (ConfigException ce) {
                message = ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(passwordPolicyConfiguration.dn()), ce.getMessage());
                throw new ConfigException(message, (Throwable)ce);
            }
            catch (InitializationException ie) {
                message = ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(passwordPolicyConfiguration.dn()), ie.getMessage());
                throw new InitializationException(message, (Throwable)ie);
            }
            catch (Exception e) {
                message = ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(passwordPolicyConfiguration.dn()), StaticUtils.stackTraceToSingleLineString(e));
                throw new InitializationException(message, (Throwable)e);
            }
        }
        if (null == DirectoryServer.getDefaultPasswordPolicy()) {
            DN defaultPolicyDN = DirectoryServer.getDefaultPasswordPolicyDN();
            Message message = ConfigMessages.ERR_CONFIG_PWPOLICY_MISSING_DEFAULT_POLICY.get(String.valueOf(defaultPolicyDN));
            throw new ConfigException(message);
        }
        List<SubEntry> pwpSubEntries = DirectoryServer.getSubentryManager().getSubentries();
        if (pwpSubEntries != null && !pwpSubEntries.isEmpty()) {
            for (SubEntry subentry : pwpSubEntries) {
                if (!subentry.getEntry().isPasswordPolicySubentry()) continue;
                PasswordPolicyConfig config = this.createPasswordPolicyConfig(subentry);
                DirectoryServer.registerPasswordPolicy(subentry.getDN(), config);
            }
        }
        DirectoryServer.getSubentryManager().registerChangeListener(this);
    }

    public void finalizePasswordPolicies() {
        DirectoryServer.getSubentryManager().deregisterChangeListener(this);
    }

    @Override
    public boolean isConfigurationAddAcceptable(PasswordPolicyCfg configuration, List<Message> unacceptableReason) {
        try {
            new PasswordPolicy(configuration);
        }
        catch (ConfigException ce) {
            Message message = ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(configuration.dn()), ce.getMessage());
            unacceptableReason.add(message);
            return false;
        }
        catch (InitializationException ie) {
            Message message = ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(configuration.dn()), ie.getMessage());
            unacceptableReason.add(message);
            return false;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            unacceptableReason.add(message);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(PasswordPolicyCfg configuration) {
        DN configEntryDN = configuration.dn();
        ArrayList<Message> messages = new ArrayList<Message>();
        try {
            PasswordPolicy policy = new PasswordPolicy(configuration);
            PasswordPolicyConfig config = new PasswordPolicyConfig(policy);
            DirectoryServer.registerPasswordPolicy(configEntryDN, config);
            configuration.addChangeListener(config);
            return new ConfigChangeResult(ResultCode.SUCCESS, false, messages);
        }
        catch (ConfigException ce) {
            messages.add(ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(configuration.dn()), ce.getMessage()));
            return new ConfigChangeResult(ResultCode.CONSTRAINT_VIOLATION, false, messages);
        }
        catch (InitializationException ie) {
            messages.add(ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(configuration.dn()), ie.getMessage()));
            return new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false, messages);
        }
        catch (Exception e) {
            messages.add(ConfigMessages.ERR_CONFIG_PWPOLICY_INVALID_POLICY_CONFIG.get(String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e)));
            return new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false, messages);
        }
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(PasswordPolicyCfg configuration, List<Message> unacceptableReason) {
        DN defaultPolicyDN = DirectoryServer.getDefaultPasswordPolicyDN();
        if (defaultPolicyDN != null && defaultPolicyDN.equals(configuration.dn())) {
            Message message = ConfigMessages.WARN_CONFIG_PWPOLICY_CANNOT_DELETE_DEFAULT_POLICY.get(String.valueOf(defaultPolicyDN));
            unacceptableReason.add(message);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(PasswordPolicyCfg configuration) {
        ArrayList<Message> messages = new ArrayList<Message>(1);
        DN policyDN = configuration.dn();
        DN defaultPolicyDN = DirectoryServer.getDefaultPasswordPolicyDN();
        if (defaultPolicyDN != null && defaultPolicyDN.equals(policyDN)) {
            messages.add(ConfigMessages.WARN_CONFIG_PWPOLICY_CANNOT_DELETE_DEFAULT_POLICY.get(String.valueOf(defaultPolicyDN)));
            return new ConfigChangeResult(ResultCode.CONSTRAINT_VIOLATION, false, messages);
        }
        DirectoryServer.deregisterPasswordPolicy(policyDN);
        PasswordPolicyConfig config = DirectoryServer.getPasswordPolicyConfig(policyDN);
        if (config != null) {
            configuration.removeChangeListener(config);
        }
        messages.add(ConfigMessages.INFO_CONFIG_PWPOLICY_REMOVED_POLICY.get(String.valueOf(policyDN)));
        return new ConfigChangeResult(ResultCode.SUCCESS, false, messages);
    }

    private void checkSubentryAcceptable(Entry entry) throws DirectoryException {
        SubEntry subentry = new SubEntry(entry);
        SubentryPasswordPolicy subentryPolicy = new SubentryPasswordPolicy(subentry);
        try {
            new PasswordPolicy(subentryPolicy);
        }
        catch (ConfigException ex) {
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, ex.getMessageObject());
        }
        catch (InitializationException ex) {
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, ex.getMessageObject());
        }
    }

    @Override
    public void checkSubentryAddAcceptable(Entry entry) throws DirectoryException {
        if (entry.isPasswordPolicySubentry()) {
            this.checkSubentryAcceptable(entry);
        }
    }

    @Override
    public void checkSubentryDeleteAcceptable(Entry entry) throws DirectoryException {
    }

    @Override
    public void checkSubentryModifyAcceptable(Entry oldEntry, Entry newEntry) throws DirectoryException {
        if (newEntry.isPasswordPolicySubentry()) {
            this.checkSubentryAcceptable(newEntry);
        }
    }

    @Override
    public void checkSubentryModifyDNAcceptable(Entry oldEntry, Entry newEntry) throws DirectoryException {
    }

    @Override
    public void handleSubentryAdd(Entry entry) {
        block3: {
            if (entry.isPasswordPolicySubentry()) {
                try {
                    SubEntry subentry = new SubEntry(entry);
                    PasswordPolicyConfig config = this.createPasswordPolicyConfig(subentry);
                    DirectoryServer.registerPasswordPolicy(subentry.getDN(), config);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block3;
                    TRACER.debugError("Could not create password policy subentry DN %s: %s", entry.getDN().toString(), StaticUtils.stackTraceToSingleLineString(e));
                }
            }
        }
    }

    @Override
    public void handleSubentryDelete(Entry entry) {
        if (entry.isPasswordPolicySubentry()) {
            DirectoryServer.deregisterPasswordPolicy(entry.getDN());
        }
    }

    @Override
    public void handleSubentryModify(Entry oldEntry, Entry newEntry) {
        block4: {
            if (oldEntry.isPasswordPolicySubentry()) {
                DirectoryServer.deregisterPasswordPolicy(oldEntry.getDN());
            }
            if (newEntry.isPasswordPolicySubentry()) {
                try {
                    SubEntry subentry = new SubEntry(newEntry);
                    PasswordPolicyConfig config = this.createPasswordPolicyConfig(subentry);
                    DirectoryServer.registerPasswordPolicy(subentry.getDN(), config);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block4;
                    TRACER.debugError("Could not create password policy subentry DN %s: %s", newEntry.getDN().toString(), StaticUtils.stackTraceToSingleLineString(e));
                }
            }
        }
    }

    @Override
    public void handleSubentryModifyDN(Entry oldEntry, Entry newEntry) {
        block4: {
            if (oldEntry.isPasswordPolicySubentry()) {
                DirectoryServer.deregisterPasswordPolicy(oldEntry.getDN());
            }
            if (newEntry.isPasswordPolicySubentry()) {
                try {
                    SubEntry subentry = new SubEntry(newEntry);
                    PasswordPolicyConfig config = this.createPasswordPolicyConfig(subentry);
                    DirectoryServer.registerPasswordPolicy(subentry.getDN(), config);
                }
                catch (Exception e) {
                    if (!DebugLogger.debugEnabled()) break block4;
                    TRACER.debugError("Could not create password policy subentry DN %s: %s", newEntry.getDN().toString(), StaticUtils.stackTraceToSingleLineString(e));
                }
            }
        }
    }
}

