/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.MonitorProviderCfgDefn;
import org.opends.server.admin.std.server.MonitorProviderCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorConfigManager
implements ConfigurationChangeListener<MonitorProviderCfg>,
ConfigurationAddListener<MonitorProviderCfg>,
ConfigurationDeleteListener<MonitorProviderCfg> {
    private ConcurrentHashMap<DN, MonitorProvider> monitors = new ConcurrentHashMap();

    public void initializeMonitorProviders() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addMonitorProviderAddListener(this);
        rootConfiguration.addMonitorProviderDeleteListener(this);
        for (String name : rootConfiguration.listMonitorProviders()) {
            MonitorProviderCfg monitorConfig = rootConfiguration.getMonitorProvider(name);
            monitorConfig.addChangeListener(this);
            if (!monitorConfig.isEnabled()) continue;
            String className = monitorConfig.getJavaClass();
            try {
                MonitorProvider<? extends MonitorProviderCfg> monitor = this.loadMonitor(className, monitorConfig);
                this.monitors.put(monitorConfig.dn(), monitor);
                if (monitor.getUpdateInterval() > 0L) {
                    monitor.start();
                }
                DirectoryServer.registerMonitorProvider(monitor);
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ie.getMessageObject());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(MonitorProviderCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadMonitor(className, null);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(MonitorProviderCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (!configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        MonitorProvider<? extends MonitorProviderCfg> monitor = null;
        String className = configuration.getJavaClass();
        try {
            monitor = this.loadMonitor(className, configuration);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.monitors.put(configuration.dn(), monitor);
            if (monitor.getUpdateInterval() > 0L) {
                monitor.start();
            }
            DirectoryServer.registerMonitorProvider(monitor);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(MonitorProviderCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(MonitorProviderCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        MonitorProvider monitor = this.monitors.remove(configuration.dn());
        if (monitor != null) {
            String lowerName = StaticUtils.toLowerCase(monitor.getMonitorInstanceName());
            DirectoryServer.deregisterMonitorProvider(lowerName);
            monitor.finalizeMonitorProvider();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(MonitorProviderCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadMonitor(className, null);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(MonitorProviderCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        MonitorProvider existingMonitor = this.monitors.get(configuration.dn());
        if (!configuration.isEnabled()) {
            if (existingMonitor != null) {
                String lowerName = StaticUtils.toLowerCase(existingMonitor.getMonitorInstanceName());
                DirectoryServer.deregisterMonitorProvider(lowerName);
                MonitorProvider monitor = this.monitors.remove(configuration.dn());
                if (monitor != null) {
                    monitor.finalizeMonitorProvider();
                }
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        String className = configuration.getJavaClass();
        if (existingMonitor != null) {
            if (!className.equals(existingMonitor.getClass().getName())) {
                adminActionRequired = true;
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        MonitorProvider<? extends MonitorProviderCfg> monitor = null;
        try {
            monitor = this.loadMonitor(className, configuration);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.monitors.put(configuration.dn(), monitor);
            if (monitor.getUpdateInterval() > 0L) {
                monitor.start();
            }
            DirectoryServer.registerMonitorProvider(monitor);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private MonitorProvider<? extends MonitorProviderCfg> loadMonitor(String className, MonitorProviderCfg configuration) throws InitializationException {
        try {
            MonitorProviderCfgDefn definition = MonitorProviderCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getJavaClassPropertyDefinition();
            Class<MonitorProvider> providerClass = propertyDefinition.loadClass(className, MonitorProvider.class);
            MonitorProvider monitor = providerClass.newInstance();
            if (configuration != null) {
                Method method = monitor.getClass().getMethod("initializeMonitorProvider", configuration.configurationClass());
                method.invoke((Object)monitor, configuration);
            }
            return monitor;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_MONITOR_INITIALIZATION_FAILED.get(className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }
}

