/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.MatchingRuleCfgDefn;
import org.opends.server.admin.std.server.MatchingRuleCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.MatchingRule;
import org.opends.server.api.MatchingRuleFactory;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.MatchingRuleUse;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingRuleConfigManager
implements ConfigurationChangeListener<MatchingRuleCfg>,
ConfigurationAddListener<MatchingRuleCfg>,
ConfigurationDeleteListener<MatchingRuleCfg> {
    private ConcurrentHashMap<DN, MatchingRuleFactory> matchingRuleFactories = new ConcurrentHashMap();

    public void initializeMatchingRules() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addMatchingRuleAddListener(this);
        rootConfiguration.addMatchingRuleDeleteListener(this);
        for (String name : rootConfiguration.listMatchingRules()) {
            MatchingRuleCfg mrConfiguration = rootConfiguration.getMatchingRule(name);
            mrConfiguration.addChangeListener(this);
            if (!mrConfiguration.isEnabled()) continue;
            String className = mrConfiguration.getJavaClass();
            try {
                MatchingRuleFactory factory = this.loadMatchingRuleFactory(className, mrConfiguration, true);
                try {
                    for (MatchingRule matchingRule : factory.getMatchingRules()) {
                        DirectoryServer.registerMatchingRule(matchingRule, false);
                    }
                    this.matchingRuleFactories.put(mrConfiguration.dn(), factory);
                }
                catch (DirectoryException de) {
                    Message message = ConfigMessages.WARN_CONFIG_SCHEMA_MR_CONFLICTING_MR.get(String.valueOf(mrConfiguration.dn()), de.getMessageObject());
                    ErrorLogger.logError(message);
                }
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ie.getMessageObject());
            }
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(MatchingRuleCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadMatchingRuleFactory(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(MatchingRuleCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (!configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        MatchingRuleFactory factory = null;
        String className = configuration.getJavaClass();
        try {
            factory = this.loadMatchingRuleFactory(className, configuration, true);
            try {
                for (MatchingRule matchingRule : factory.getMatchingRules()) {
                    DirectoryServer.registerMatchingRule(matchingRule, false);
                }
                this.matchingRuleFactories.put(configuration.dn(), factory);
            }
            catch (DirectoryException de) {
                Message message = ConfigMessages.WARN_CONFIG_SCHEMA_MR_CONFLICTING_MR.get(String.valueOf(configuration.dn()), de.getMessageObject());
                messages.add(message);
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(MatchingRuleCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        MatchingRuleFactory factory = this.matchingRuleFactories.get(configuration.dn());
        for (MatchingRule matchingRule : factory.getMatchingRules()) {
            if (matchingRule == null) continue;
            String oid = matchingRule.getOID();
            for (AttributeType at : DirectoryServer.getAttributeTypes().values()) {
                ApproximateMatchingRule amr = at.getApproximateMatchingRule();
                if (amr != null && oid.equals(amr.getOID())) {
                    Message message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_DELETE_MR_IN_USE_BY_AT.get(matchingRule.getName(), at.getNameOrOID());
                    unacceptableReasons.add(message);
                    configAcceptable = false;
                    continue;
                }
                EqualityMatchingRule emr = at.getEqualityMatchingRule();
                if (emr != null && oid.equals(emr.getOID())) {
                    Message message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_DELETE_MR_IN_USE_BY_AT.get(matchingRule.getName(), at.getNameOrOID());
                    unacceptableReasons.add(message);
                    configAcceptable = false;
                    continue;
                }
                OrderingMatchingRule omr = at.getOrderingMatchingRule();
                if (omr != null && oid.equals(omr.getOID())) {
                    Message message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_DELETE_MR_IN_USE_BY_AT.get(matchingRule.getName(), at.getNameOrOID());
                    unacceptableReasons.add(message);
                    configAcceptable = false;
                    continue;
                }
                SubstringMatchingRule smr = at.getSubstringMatchingRule();
                if (smr == null || !oid.equals(smr.getOID())) continue;
                Message message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_DELETE_MR_IN_USE_BY_AT.get(matchingRule.getName(), at.getNameOrOID());
                unacceptableReasons.add(message);
                configAcceptable = false;
            }
            for (MatchingRuleUse mru : DirectoryServer.getMatchingRuleUses().values()) {
                if (!oid.equals(mru.getMatchingRule().getOID())) continue;
                Message message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_DELETE_MR_IN_USE_BY_MRU.get(matchingRule.getName(), mru.getName());
                unacceptableReasons.add(message);
                configAcceptable = false;
            }
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(MatchingRuleCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        MatchingRuleFactory factory = this.matchingRuleFactories.remove(configuration.dn());
        if (factory != null) {
            for (MatchingRule matchingRule : factory.getMatchingRules()) {
                DirectoryServer.deregisterMatchingRule(matchingRule);
            }
            factory.finalizeMatchingRule();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(MatchingRuleCfg configuration, List<Message> unacceptableReasons) {
        boolean configAcceptable = true;
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadMatchingRuleFactory(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                configAcceptable = false;
            }
        } else {
            MatchingRuleFactory factory = this.matchingRuleFactories.get(configuration.dn());
            if (factory == null) {
                return configAcceptable;
            }
            for (MatchingRule matchingRule : factory.getMatchingRules()) {
                if (matchingRule == null) continue;
                String oid = matchingRule.getOID();
                for (AttributeType at : DirectoryServer.getAttributeTypes().values()) {
                    ApproximateMatchingRule amr = at.getApproximateMatchingRule();
                    if (amr != null && oid.equals(amr.getOID())) {
                        Message message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_DISABLE_MR_IN_USE_BY_AT.get(matchingRule.getName(), at.getNameOrOID());
                        unacceptableReasons.add(message);
                        configAcceptable = false;
                        continue;
                    }
                    EqualityMatchingRule emr = at.getEqualityMatchingRule();
                    if (emr != null && oid.equals(emr.getOID())) {
                        Message message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_DISABLE_MR_IN_USE_BY_AT.get(matchingRule.getName(), at.getNameOrOID());
                        unacceptableReasons.add(message);
                        configAcceptable = false;
                        continue;
                    }
                    OrderingMatchingRule omr = at.getOrderingMatchingRule();
                    if (omr != null && oid.equals(omr.getOID())) {
                        Message message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_DISABLE_MR_IN_USE_BY_AT.get(matchingRule.getName(), at.getNameOrOID());
                        unacceptableReasons.add(message);
                        configAcceptable = false;
                        continue;
                    }
                    SubstringMatchingRule smr = at.getSubstringMatchingRule();
                    if (smr == null || !oid.equals(smr.getOID())) continue;
                    Message message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_DISABLE_MR_IN_USE_BY_AT.get(matchingRule.getName(), at.getNameOrOID());
                    unacceptableReasons.add(message);
                    configAcceptable = false;
                }
                for (MatchingRuleUse mru : DirectoryServer.getMatchingRuleUses().values()) {
                    if (!oid.equals(mru.getMatchingRule().getOID())) continue;
                    Message message = ConfigMessages.WARN_CONFIG_SCHEMA_CANNOT_DISABLE_MR_IN_USE_BY_MRU.get(matchingRule.getName(), mru.getName());
                    unacceptableReasons.add(message);
                    configAcceptable = false;
                }
            }
        }
        return configAcceptable;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(MatchingRuleCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        MatchingRuleFactory existingFactory = this.matchingRuleFactories.get(configuration.dn());
        if (!configuration.isEnabled()) {
            if (existingFactory != null) {
                for (MatchingRule existingRule : existingFactory.getMatchingRules()) {
                    DirectoryServer.deregisterMatchingRule(existingRule);
                }
                this.matchingRuleFactories.remove(configuration.dn());
                existingFactory.finalizeMatchingRule();
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        String className = configuration.getJavaClass();
        if (existingFactory != null) {
            if (!className.equals(existingFactory.getClass().getName())) {
                adminActionRequired = true;
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        MatchingRuleFactory factory = null;
        try {
            factory = this.loadMatchingRuleFactory(className, configuration, true);
            try {
                for (MatchingRule matchingRule : factory.getMatchingRules()) {
                    DirectoryServer.registerMatchingRule(matchingRule, false);
                }
                this.matchingRuleFactories.put(configuration.dn(), factory);
            }
            catch (DirectoryException de) {
                Message message = ConfigMessages.WARN_CONFIG_SCHEMA_MR_CONFLICTING_MR.get(String.valueOf(configuration.dn()), de.getMessageObject());
                messages.add(message);
                if (resultCode == ResultCode.SUCCESS) {
                    resultCode = DirectoryServer.getServerErrorResultCode();
                }
            }
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private MatchingRuleFactory loadMatchingRuleFactory(String className, MatchingRuleCfg configuration, boolean initialize) throws InitializationException {
        try {
            MatchingRuleFactory factory = null;
            MatchingRuleCfgDefn definition = MatchingRuleCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getJavaClassPropertyDefinition();
            Class<MatchingRuleFactory> matchingRuleFactoryClass = propertyDefinition.loadClass(className, MatchingRuleFactory.class);
            factory = matchingRuleFactoryClass.newInstance();
            if (initialize) {
                Method method = factory.getClass().getMethod("initializeMatchingRule", configuration.configurationClass());
                method.invoke((Object)factory, configuration);
            } else {
                Method method = factory.getClass().getMethod("isConfigurationAcceptable", MatchingRuleCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)factory, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((CharSequence)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((CharSequence)iterator.next());
                        }
                    }
                    Message message = ConfigMessages.ERR_CONFIG_SCHEMA_MR_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(message);
                }
            }
            return factory;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_SCHEMA_MR_CANNOT_INITIALIZE.get(className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }
}

