/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.admin.ClassPropertyDefinition;
import org.opends.server.admin.server.ConfigurationAddListener;
import org.opends.server.admin.server.ConfigurationChangeListener;
import org.opends.server.admin.server.ConfigurationDeleteListener;
import org.opends.server.admin.server.ServerManagementContext;
import org.opends.server.admin.std.meta.IdentityMapperCfgDefn;
import org.opends.server.admin.std.server.IdentityMapperCfg;
import org.opends.server.admin.std.server.RootCfg;
import org.opends.server.api.IdentityMapper;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.ErrorLogger;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityMapperConfigManager
implements ConfigurationChangeListener<IdentityMapperCfg>,
ConfigurationAddListener<IdentityMapperCfg>,
ConfigurationDeleteListener<IdentityMapperCfg> {
    private ConcurrentHashMap<DN, IdentityMapper> identityMappers = new ConcurrentHashMap();

    public void initializeIdentityMappers() throws ConfigException, InitializationException {
        ServerManagementContext managementContext = ServerManagementContext.getInstance();
        RootCfg rootConfiguration = managementContext.getRootConfiguration();
        rootConfiguration.addIdentityMapperAddListener(this);
        rootConfiguration.addIdentityMapperDeleteListener(this);
        for (String mapperName : rootConfiguration.listIdentityMappers()) {
            IdentityMapperCfg mapperConfiguration = rootConfiguration.getIdentityMapper(mapperName);
            mapperConfiguration.addChangeListener(this);
            if (!mapperConfiguration.isEnabled()) continue;
            String className = mapperConfiguration.getJavaClass();
            try {
                IdentityMapper mapper = this.loadMapper(className, mapperConfiguration, true);
                this.identityMappers.put(mapperConfiguration.dn(), mapper);
                DirectoryServer.registerIdentityMapper(mapperConfiguration.dn(), mapper);
            }
            catch (InitializationException ie) {
                ErrorLogger.logError(ie.getMessageObject());
            }
        }
        DN mapperDN = DirectoryServer.getProxiedAuthorizationIdentityMapperDN();
        if (mapperDN == null) {
            ErrorLogger.logError(ConfigMessages.ERR_CONFIG_IDMAPPER_NO_PROXY_MAPPER_DN.get());
        } else if (!this.identityMappers.containsKey(mapperDN)) {
            ErrorLogger.logError(ConfigMessages.ERR_CONFIG_IDMAPPER_INVALID_PROXY_MAPPER_DN.get(String.valueOf(mapperDN)));
        }
    }

    @Override
    public boolean isConfigurationAddAcceptable(IdentityMapperCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadMapper(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(IdentityMapperCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        configuration.addChangeListener(this);
        if (!configuration.isEnabled()) {
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        IdentityMapper identityMapper = null;
        String className = configuration.getJavaClass();
        try {
            identityMapper = this.loadMapper(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.identityMappers.put(configuration.dn(), identityMapper);
            DirectoryServer.registerIdentityMapper(configuration.dn(), identityMapper);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationDeleteAcceptable(IdentityMapperCfg configuration, List<Message> unacceptableReasons) {
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(IdentityMapperCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        DirectoryServer.deregisterIdentityMapper(configuration.dn());
        IdentityMapper identityMapper = this.identityMappers.remove(configuration.dn());
        if (identityMapper != null) {
            identityMapper.finalizeIdentityMapper();
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    @Override
    public boolean isConfigurationChangeAcceptable(IdentityMapperCfg configuration, List<Message> unacceptableReasons) {
        if (configuration.isEnabled()) {
            String className = configuration.getJavaClass();
            try {
                this.loadMapper(className, configuration, false);
            }
            catch (InitializationException ie) {
                unacceptableReasons.add(ie.getMessageObject());
                return false;
            }
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(IdentityMapperCfg configuration) {
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean adminActionRequired = false;
        ArrayList<Message> messages = new ArrayList<Message>();
        IdentityMapper existingMapper = this.identityMappers.get(configuration.dn());
        if (!configuration.isEnabled()) {
            if (existingMapper != null) {
                DirectoryServer.deregisterIdentityMapper(configuration.dn());
                IdentityMapper identityMapper = this.identityMappers.remove(configuration.dn());
                if (identityMapper != null) {
                    identityMapper.finalizeIdentityMapper();
                }
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        String className = configuration.getJavaClass();
        if (existingMapper != null) {
            if (!className.equals(existingMapper.getClass().getName())) {
                adminActionRequired = true;
            }
            return new ConfigChangeResult(resultCode, adminActionRequired, messages);
        }
        IdentityMapper identityMapper = null;
        try {
            identityMapper = this.loadMapper(className, configuration, true);
        }
        catch (InitializationException ie) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            messages.add(ie.getMessageObject());
        }
        if (resultCode == ResultCode.SUCCESS) {
            this.identityMappers.put(configuration.dn(), identityMapper);
            DirectoryServer.registerIdentityMapper(configuration.dn(), identityMapper);
        }
        return new ConfigChangeResult(resultCode, adminActionRequired, messages);
    }

    private IdentityMapper loadMapper(String className, IdentityMapperCfg configuration, boolean initialize) throws InitializationException {
        try {
            IdentityMapperCfgDefn definition = IdentityMapperCfgDefn.getInstance();
            ClassPropertyDefinition propertyDefinition = definition.getJavaClassPropertyDefinition();
            Class<IdentityMapper> mapperClass = propertyDefinition.loadClass(className, IdentityMapper.class);
            IdentityMapper mapper = mapperClass.newInstance();
            if (initialize) {
                Method method = mapper.getClass().getMethod("initializeIdentityMapper", configuration.configurationClass());
                method.invoke((Object)mapper, configuration);
            } else {
                Method method = mapper.getClass().getMethod("isConfigurationAcceptable", IdentityMapperCfg.class, List.class);
                ArrayList unacceptableReasons = new ArrayList();
                Boolean acceptable = (Boolean)method.invoke((Object)mapper, configuration, unacceptableReasons);
                if (!acceptable.booleanValue()) {
                    StringBuilder buffer = new StringBuilder();
                    if (!unacceptableReasons.isEmpty()) {
                        Iterator iterator = unacceptableReasons.iterator();
                        buffer.append((CharSequence)iterator.next());
                        while (iterator.hasNext()) {
                            buffer.append(".  ");
                            buffer.append((CharSequence)iterator.next());
                        }
                    }
                    Message message = ConfigMessages.ERR_CONFIG_IDMAPPER_CONFIG_NOT_ACCEPTABLE.get(String.valueOf(configuration.dn()), buffer.toString());
                    throw new InitializationException(message);
                }
            }
            return mapper;
        }
        catch (Exception e) {
            Message message = ConfigMessages.ERR_CONFIG_IDMAPPER_INITIALIZATION_FAILED.get(className, String.valueOf(configuration.dn()), StaticUtils.stackTraceToSingleLineString(e));
            throw new InitializationException(message, (Throwable)e);
        }
    }
}

