/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import org.opends.messages.Message;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.OperationWrapper;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;

public abstract class BindOperationWrapper
extends OperationWrapper
implements BindOperation {
    private BindOperation bind;

    protected BindOperationWrapper(BindOperation bind) {
        super(bind);
        this.bind = bind;
    }

    public AuthenticationInfo getAuthenticationInfo() {
        return this.bind.getAuthenticationInfo();
    }

    public AuthenticationType getAuthenticationType() {
        return this.bind.getAuthenticationType();
    }

    public Message getAuthFailureReason() {
        return this.bind.getAuthFailureReason();
    }

    public DN getBindDN() {
        return this.bind.getBindDN();
    }

    public ByteString getRawBindDN() {
        return this.bind.getRawBindDN();
    }

    public Entry getSASLAuthUserEntry() {
        return this.bind.getSASLAuthUserEntry();
    }

    public ByteString getSASLCredentials() {
        return this.bind.getSASLCredentials();
    }

    public String getSASLMechanism() {
        return this.bind.getSASLMechanism();
    }

    public ByteString getServerSASLCredentials() {
        return this.bind.getServerSASLCredentials();
    }

    public ByteString getSimplePassword() {
        return this.bind.getSimplePassword();
    }

    public DN getUserEntryDN() {
        return this.bind.getUserEntryDN();
    }

    public void setAuthenticationInfo(AuthenticationInfo authInfo) {
        this.bind.setAuthenticationInfo(authInfo);
    }

    public void setAuthFailureReason(Message reason) {
        if (DirectoryServer.returnBindErrorMessages()) {
            this.bind.appendErrorMessage(reason);
        } else {
            this.bind.setAuthFailureReason(reason);
        }
    }

    public void setRawBindDN(ByteString rawBindDN) {
        this.bind.setRawBindDN(rawBindDN);
    }

    public void setSASLAuthUserEntry(Entry saslAuthUserEntry) {
        this.bind.setSASLAuthUserEntry(saslAuthUserEntry);
    }

    public void setSASLCredentials(String saslMechanism, ByteString saslCredentials) {
        this.bind.setSASLCredentials(saslMechanism, saslCredentials);
    }

    public void setServerSASLCredentials(ByteString serverSASLCredentials) {
        this.bind.setServerSASLCredentials(serverSASLCredentials);
    }

    public void setSimplePassword(ByteString simplePassword) {
        this.bind.setSimplePassword(simplePassword);
    }

    public void setUserEntryDN(DN userEntryDN) {
        this.bind.setUserEntryDN(userEntryDN);
    }

    public String toString() {
        return this.bind.toString();
    }

    public void setProtocolVersion(String protocolVersion) {
        this.bind.setProtocolVersion(protocolVersion);
    }

    public String getProtocolVersion() {
        return this.bind.getProtocolVersion();
    }
}

