/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.core.DirectoryServer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.LDAPException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SortKey;
import org.opends.server.types.SortOrder;
import org.opends.server.util.StaticUtils;

public class ServerSideSortRequestControl
extends Control {
    private static final byte TYPE_ORDERING_RULE_ID = -128;
    private static final byte TYPE_REVERSE_ORDER = -127;
    public static final ControlDecoder<ServerSideSortRequestControl> DECODER = new Decoder();
    private ArrayList<String[]> decodedKeyList;
    private SortOrder sortOrder;

    public ServerSideSortRequestControl(String sortOrderString) throws LDAPException {
        this(false, sortOrderString);
    }

    public ServerSideSortRequestControl(boolean isCritical, String sortOrderString) throws LDAPException {
        super("1.2.840.113556.1.4.473", isCritical);
        StringTokenizer tokenizer = new StringTokenizer(sortOrderString, ",");
        this.decodedKeyList = new ArrayList();
        while (tokenizer.hasMoreTokens()) {
            Message message;
            String token = tokenizer.nextToken().trim();
            boolean reverseOrder = false;
            if (token.startsWith("-")) {
                reverseOrder = true;
                token = token.substring(1);
            } else if (token.startsWith("+")) {
                token = token.substring(1);
            }
            int colonPos = token.indexOf(58);
            if (colonPos < 0) {
                if (token.length() == 0) {
                    message = ProtocolMessages.INFO_SORTREQ_CONTROL_NO_ATTR_NAME.get(sortOrderString);
                    throw new LDAPException(2, message);
                }
                if (reverseOrder) {
                    this.decodedKeyList.add(new String[]{token, null, "r"});
                    continue;
                }
                this.decodedKeyList.add(new String[]{token, null, null});
                continue;
            }
            if (colonPos == 0) {
                message = ProtocolMessages.INFO_SORTREQ_CONTROL_NO_ATTR_NAME.get(sortOrderString);
                throw new LDAPException(2, message);
            }
            if (colonPos == token.length() - 1) {
                message = ProtocolMessages.INFO_SORTREQ_CONTROL_NO_MATCHING_RULE.get(sortOrderString);
                throw new LDAPException(2, message);
            }
            String attrName = token.substring(0, colonPos);
            String ruleID = token.substring(colonPos + 1);
            if (reverseOrder) {
                this.decodedKeyList.add(new String[]{attrName, ruleID, "r"});
                continue;
            }
            this.decodedKeyList.add(new String[]{attrName, ruleID, null});
        }
        if (this.decodedKeyList.isEmpty()) {
            Message message = ProtocolMessages.INFO_SORTREQ_CONTROL_NO_SORT_KEYS.get();
            throw new LDAPException(2, message);
        }
    }

    public ServerSideSortRequestControl(SortOrder sortOrder) {
        this(false, sortOrder);
    }

    public ServerSideSortRequestControl(boolean isCritical, SortOrder sortOrder) {
        super("1.2.840.113556.1.4.473", isCritical);
        this.sortOrder = sortOrder;
    }

    public SortOrder getSortOrder() throws DirectoryException {
        if (this.sortOrder == null) {
            this.sortOrder = this.decodeSortOrderFromString();
        }
        return this.sortOrder;
    }

    public boolean containsSortKeys() throws DirectoryException {
        return this.getSortOrder().getSortKeys().length != 0;
    }

    protected void writeValue(ASN1Writer writer) throws IOException {
        if (this.decodedKeyList != null) {
            this.writeValueFromString(writer);
        } else {
            this.writeValueFromSortOrder(writer);
        }
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ServerSideSortRequestControl(");
        if (this.sortOrder == null) {
            buffer.append("SortOrder(");
            if (this.decodedKeyList.size() > 0) {
                this.decodedKeyToString(this.decodedKeyList.get(0), buffer);
                for (int i = 1; i < this.decodedKeyList.size(); ++i) {
                    buffer.append(",");
                    this.decodedKeyToString(this.decodedKeyList.get(i), buffer);
                }
            }
            buffer.append(")");
        } else {
            buffer.append(this.sortOrder);
        }
        buffer.append(")");
    }

    private void decodedKeyToString(String[] decodedKey, StringBuilder buffer) {
        buffer.append("SortKey(");
        if (decodedKey[2] == null) {
            buffer.append("+");
        } else {
            buffer.append("-");
        }
        buffer.append(decodedKey[0]);
        if (decodedKey[1] != null) {
            buffer.append(":");
            buffer.append(decodedKey[1]);
        }
        buffer.append(")");
    }

    private SortOrder decodeSortOrderFromString() throws DirectoryException {
        ArrayList<SortKey> sortKeys = new ArrayList<SortKey>();
        for (String[] decodedKey : this.decodedKeyList) {
            AttributeType attrType = DirectoryServer.getAttributeType(decodedKey[0].toLowerCase(), false);
            if (attrType == null) {
                return new SortOrder(sortKeys.toArray(new SortKey[0]));
            }
            OrderingMatchingRule orderingRule = null;
            if (decodedKey[1] != null && (orderingRule = DirectoryServer.getOrderingMatchingRule(decodedKey[1].toLowerCase())) == null) {
                Message message = ProtocolMessages.INFO_SORTREQ_CONTROL_UNDEFINED_ORDERING_RULE.get(decodedKey[1]);
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            boolean ascending = true;
            if (decodedKey[2] != null && decodedKey[2].equals("r")) {
                ascending = false;
            }
            if (orderingRule == null && attrType.getOrderingMatchingRule() == null) {
                Message message = ProtocolMessages.INFO_SORTREQ_CONTROL_NO_ORDERING_RULE_FOR_ATTR.get(decodedKey[0]);
                throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
            }
            sortKeys.add(new SortKey(attrType, ascending, orderingRule));
        }
        return new SortOrder(sortKeys.toArray(new SortKey[0]));
    }

    private void writeValueFromString(ASN1Writer writer) throws IOException {
        writer.writeStartSequence((byte)4);
        writer.writeStartSequence();
        for (String[] strs : this.decodedKeyList) {
            writer.writeStartSequence();
            writer.writeOctetString(strs[0]);
            if (strs[1] != null) {
                writer.writeOctetString((byte)-128, strs[1]);
            }
            if (strs[2] != null) {
                writer.writeBoolean((byte)-127, true);
            }
            writer.writeEndSequence();
        }
        writer.writeEndSequence();
        writer.writeEndSequence();
    }

    private void writeValueFromSortOrder(ASN1Writer writer) throws IOException {
        writer.writeStartSequence((byte)4);
        writer.writeStartSequence();
        for (SortKey sortKey : this.sortOrder.getSortKeys()) {
            writer.writeStartSequence();
            writer.writeOctetString(sortKey.getAttributeType().getNameOrOID());
            if (sortKey.getOrderingRule() != null) {
                writer.writeOctetString((byte)-128, sortKey.getOrderingRule().getNameOrOID());
            }
            if (!sortKey.ascending()) {
                writer.writeBoolean((byte)-127, true);
            }
            writer.writeEndSequence();
        }
        writer.writeEndSequence();
        writer.writeEndSequence();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Decoder
    implements ControlDecoder<ServerSideSortRequestControl> {
        private Decoder() {
        }

        @Override
        public ServerSideSortRequestControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            if (value == null) {
                Message message = ProtocolMessages.INFO_SORTREQ_CONTROL_NO_VALUE.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            ASN1Reader reader = ASN1.getReader(value);
            try {
                reader.readStartSequence();
                if (!reader.hasNextElement()) {
                    Message message = ProtocolMessages.INFO_SORTREQ_CONTROL_NO_SORT_KEYS.get();
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                }
                ArrayList<SortKey> sortKeys = new ArrayList<SortKey>();
                while (reader.hasNextElement()) {
                    String orderingRuleID;
                    reader.readStartSequence();
                    String attrName = StaticUtils.toLowerCase(reader.readOctetStringAsString());
                    AttributeType attrType = DirectoryServer.getAttributeType(attrName, false);
                    if (attrType == null) {
                        return new ServerSideSortRequestControl(isCritical, new SortOrder(sortKeys.toArray(new SortKey[0])));
                    }
                    OrderingMatchingRule orderingRule = null;
                    boolean ascending = true;
                    if (reader.hasNextElement() && reader.peekType() == -128 && (orderingRule = DirectoryServer.getOrderingMatchingRule(orderingRuleID = StaticUtils.toLowerCase(reader.readOctetStringAsString()))) == null) {
                        Message message = ProtocolMessages.INFO_SORTREQ_CONTROL_UNDEFINED_ORDERING_RULE.get(orderingRuleID);
                        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                    }
                    if (reader.hasNextElement() && reader.peekType() == -127) {
                        ascending = !reader.readBoolean();
                    }
                    reader.readEndSequence();
                    if (orderingRule == null && attrType.getOrderingMatchingRule() == null) {
                        Message message = ProtocolMessages.INFO_SORTREQ_CONTROL_NO_ORDERING_RULE_FOR_ATTR.get(attrName);
                        throw new DirectoryException(ResultCode.CONSTRAINT_VIOLATION, message);
                    }
                    sortKeys.add(new SortKey(attrType, ascending, orderingRule));
                }
                reader.readEndSequence();
                return new ServerSideSortRequestControl(isCritical, new SortOrder(sortKeys.toArray(new SortKey[0])));
            }
            catch (DirectoryException de) {
                throw de;
            }
            catch (Exception e) {
                Message message = ProtocolMessages.INFO_SORTREQ_CONTROL_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, e);
            }
        }

        @Override
        public String getOID() {
            return "1.2.840.113556.1.4.473";
        }
    }
}

