/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.api.IdentityMapper;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.loggers.debug.DebugLogger;
import org.opends.server.loggers.debug.DebugTracer;
import org.opends.server.protocols.asn1.ASN1;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogLevel;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.LockManager;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.Validator;

public class ProxiedAuthV2Control
extends Control {
    public static final ControlDecoder<ProxiedAuthV2Control> DECODER = new Decoder();
    private static final DebugTracer TRACER = DebugLogger.getTracer();
    private ByteString authorizationID;

    public ProxiedAuthV2Control(ByteString authorizationID) {
        this(true, authorizationID);
    }

    public ProxiedAuthV2Control(boolean isCritical, ByteString authorizationID) {
        super("2.16.840.1.113730.3.4.18", isCritical);
        Validator.ensureNotNull(authorizationID);
        this.authorizationID = authorizationID;
    }

    protected void writeValue(ASN1Writer writer) throws IOException {
        writer.writeOctetString(this.authorizationID);
    }

    public ByteString getAuthorizationID() {
        return this.authorizationID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getAuthorizationEntry() throws DirectoryException {
        if (this.authorizationID.length() == 0) {
            return null;
        }
        String lowerAuthzID = StaticUtils.toLowerCase(this.authorizationID.toString());
        if (lowerAuthzID.startsWith("dn:")) {
            DN authzDN = DN.decode(lowerAuthzID.substring(3));
            if (authzDN.isNullDN()) {
                return null;
            }
            DN actualDN = DirectoryServer.getActualRootBindDN(authzDN);
            if (actualDN != null) {
                authzDN = actualDN;
            }
            Lock entryLock = null;
            for (int i = 0; i < 3 && (entryLock = LockManager.lockRead(authzDN)) == null; ++i) {
            }
            if (entryLock == null) {
                Message message = ProtocolMessages.ERR_PROXYAUTH2_CANNOT_LOCK_USER.get(String.valueOf(authzDN));
                throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, message);
            }
            try {
                Entry userEntry = DirectoryServer.getEntry(authzDN);
                if (userEntry == null) {
                    Message message = ProtocolMessages.ERR_PROXYAUTH2_NO_SUCH_USER.get(lowerAuthzID);
                    throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, message);
                }
                PasswordPolicyState pwpState = new PasswordPolicyState(userEntry, false);
                if (pwpState.isDisabled() || pwpState.isAccountExpired() || pwpState.lockedDueToFailures() || pwpState.lockedDueToIdleInterval() || pwpState.lockedDueToMaximumResetAge() || pwpState.isPasswordExpired()) {
                    Message message = ProtocolMessages.ERR_PROXYAUTH2_UNUSABLE_ACCOUNT.get(String.valueOf(authzDN));
                    throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, message);
                }
                Entry entry = userEntry;
                return entry;
            }
            finally {
                LockManager.unlock(authzDN, entryLock);
            }
        }
        if (lowerAuthzID.startsWith("u:")) {
            if (lowerAuthzID.length() == 2) {
                return null;
            }
            IdentityMapper proxyMapper = DirectoryServer.getProxiedAuthorizationIdentityMapper();
            if (proxyMapper == null) {
                Message message = ProtocolMessages.ERR_PROXYAUTH2_NO_IDENTITY_MAPPER.get();
                throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, message);
            }
            Entry userEntry = proxyMapper.getEntryForID(lowerAuthzID.substring(2));
            if (userEntry == null) {
                Message message = ProtocolMessages.ERR_PROXYAUTH2_NO_SUCH_USER.get(lowerAuthzID);
                throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, message);
            }
            PasswordPolicyState pwpState = new PasswordPolicyState(userEntry, false);
            if (pwpState.isDisabled() || pwpState.isAccountExpired() || pwpState.lockedDueToFailures() || pwpState.lockedDueToIdleInterval() || pwpState.lockedDueToMaximumResetAge() || pwpState.isPasswordExpired()) {
                Message message = ProtocolMessages.ERR_PROXYAUTH2_UNUSABLE_ACCOUNT.get(String.valueOf(userEntry.getDN()));
                throw new DirectoryException(ResultCode.AUTHORIZATION_DENIED, message);
            }
            return userEntry;
        }
        Message message = ProtocolMessages.ERR_PROXYAUTH2_INVALID_AUTHZID.get(lowerAuthzID);
        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ProxiedAuthorizationV2Control(authzID=\"");
        buffer.append(this.authorizationID);
        buffer.append("\")");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Decoder
    implements ControlDecoder<ProxiedAuthV2Control> {
        private Decoder() {
        }

        @Override
        public ProxiedAuthV2Control decode(boolean isCritical, ByteString value) throws DirectoryException {
            ByteString authorizationID;
            block5: {
                if (!isCritical) {
                    Message message = ProtocolMessages.ERR_PROXYAUTH2_CONTROL_NOT_CRITICAL.get();
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                }
                if (value == null) {
                    Message message = ProtocolMessages.ERR_PROXYAUTH2_NO_CONTROL_VALUE.get();
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
                }
                ASN1Reader reader = ASN1.getReader(value);
                try {
                    authorizationID = reader.readOctetString();
                }
                catch (Exception e) {
                    authorizationID = value;
                    String lowerAuthZIDStr = StaticUtils.toLowerCase(authorizationID.toString());
                    if (lowerAuthZIDStr.startsWith("dn:") || lowerAuthZIDStr.startsWith("u:")) break block5;
                    if (DebugLogger.debugEnabled()) {
                        TRACER.debugCaught(DebugLogLevel.ERROR, e);
                    }
                    Message message = ProtocolMessages.ERR_PROXYAUTH2_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e));
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message, e);
                }
            }
            return new ProxiedAuthV2Control(isCritical, authorizationID);
        }

        @Override
        public String getOID() {
            return "2.16.840.1.113730.3.4.18";
        }
    }
}

