/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.io.IOException;
import org.opends.messages.Message;
import org.opends.messages.ProtocolMessages;
import org.opends.server.controls.ControlDecoder;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;

public class AccountUsableRequestControl
extends Control {
    public static final ControlDecoder<AccountUsableRequestControl> DECODER = new Decoder();

    public AccountUsableRequestControl() {
        this(false);
    }

    public AccountUsableRequestControl(boolean isCritical) {
        super("1.3.6.1.4.1.42.2.27.9.5.8", isCritical);
    }

    protected void writeValue(ASN1Writer writer) throws IOException {
    }

    public void toString(StringBuilder buffer) {
        buffer.append("AccountUsableRequestControl()");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Decoder
    implements ControlDecoder<AccountUsableRequestControl> {
        private Decoder() {
        }

        @Override
        public AccountUsableRequestControl decode(boolean isCritical, ByteString value) throws DirectoryException {
            if (value != null) {
                Message message = ProtocolMessages.ERR_ACCTUSABLEREQ_CONTROL_HAS_VALUE.get();
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, message);
            }
            return new AccountUsableRequestControl(isCritical);
        }

        @Override
        public String getOID() {
            return "1.3.6.1.4.1.42.2.27.9.5.8";
        }
    }
}

