/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.config;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanParameterInfo;
import org.opends.messages.ConfigMessages;
import org.opends.messages.Message;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigConstants;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AttributeValues;
import org.opends.server.types.ByteString;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=true, mayExtend=false, mayInvoke=true)
public final class ReadOnlyConfigAttribute
extends ConfigAttribute {
    private List<String> values;

    public ReadOnlyConfigAttribute(String name, Message description, boolean isMultiValued) {
        super(name, description, false, isMultiValued, false);
        this.values = new ArrayList<String>();
    }

    public ReadOnlyConfigAttribute(String name, Message description, String value) {
        super(name, description, false, false, false, ReadOnlyConfigAttribute.getValueSet(value));
        if (value == null) {
            this.values = new ArrayList<String>(0);
        } else {
            this.values = new ArrayList<String>(1);
            this.values.add(value);
        }
    }

    public ReadOnlyConfigAttribute(String name, Message description, List<String> values) {
        super(name, description, false, true, false, ReadOnlyConfigAttribute.getValueSet(values));
        this.values = values == null ? new ArrayList<String>() : values;
    }

    @Override
    public String getDataType() {
        return "ReadOnly";
    }

    @Override
    public AttributeSyntax<?> getSyntax() {
        return DirectoryServer.getDefaultStringSyntax();
    }

    public String activeValue() throws ConfigException {
        if (this.values == null || this.values.isEmpty()) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_NO_STRING_VALUE.get(this.getName());
            throw new ConfigException(message);
        }
        if (this.values.size() > 1) {
            Message message = ConfigMessages.ERR_CONFIG_ATTR_MULTIPLE_STRING_VALUES.get(this.getName());
            throw new ConfigException(message);
        }
        return this.values.get(0);
    }

    public List<String> activeValues() {
        return this.values;
    }

    public String pendingValue() throws ConfigException {
        return this.activeValue();
    }

    public List<String> pendingValues() {
        return this.activeValues();
    }

    public void setValue(String value) throws ConfigException {
        Message message = ConfigMessages.ERR_CONFIG_ATTR_READ_ONLY.get(this.getName());
        throw new ConfigException(message);
    }

    public void setValues(List<String> values) throws ConfigException {
        Message message = ConfigMessages.ERR_CONFIG_ATTR_READ_ONLY.get(this.getName());
        throw new ConfigException(message);
    }

    private static LinkedHashSet<AttributeValue> getValueSet(String value) {
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(1);
        valueSet.add(AttributeValues.create(ByteString.valueOf(value), ByteString.valueOf(value)));
        return valueSet;
    }

    private static LinkedHashSet<AttributeValue> getValueSet(List<String> values) {
        if (values == null) {
            return null;
        }
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(values.size());
        for (String value : values) {
            valueSet.add(AttributeValues.create(ByteString.valueOf(value), ByteString.valueOf(value)));
        }
        return valueSet;
    }

    @Override
    public void applyPendingValues() {
    }

    @Override
    public boolean valueIsAcceptable(AttributeValue value, StringBuilder rejectReason) {
        rejectReason.append(ConfigMessages.ERR_CONFIG_ATTR_READ_ONLY.get(this.getName()));
        return false;
    }

    @Override
    public LinkedHashSet<AttributeValue> stringsToValues(List<String> valueStrings, boolean allowFailures) throws ConfigException {
        if (valueStrings == null || valueStrings.isEmpty()) {
            return new LinkedHashSet<AttributeValue>();
        }
        int numValues = valueStrings.size();
        LinkedHashSet<AttributeValue> valueSet = new LinkedHashSet<AttributeValue>(numValues);
        for (String valueString : valueStrings) {
            valueSet.add(AttributeValues.create(ByteString.valueOf(valueString), ByteString.valueOf(valueString)));
        }
        return valueSet;
    }

    @Override
    public List<String> activeValuesToStrings() {
        return this.values;
    }

    @Override
    public List<String> pendingValuesToStrings() {
        return this.activeValuesToStrings();
    }

    @Override
    public ConfigAttribute getConfigAttribute(List<Attribute> attributeList) throws ConfigException {
        return this.duplicate();
    }

    @Override
    public javax.management.Attribute toJMXAttribute() {
        if (this.isMultiValued()) {
            String[] valueArray = new String[this.values.size()];
            this.values.toArray(valueArray);
            return new javax.management.Attribute(this.getName(), valueArray);
        }
        if (this.values.isEmpty()) {
            return null;
        }
        return new javax.management.Attribute(this.getName(), this.values.get(0));
    }

    @Override
    public javax.management.Attribute toJMXAttributePending() {
        return this.toJMXAttribute();
    }

    @Override
    public void toJMXAttribute(AttributeList attributeList) {
        javax.management.Attribute jmxAttr = this.toJMXAttribute();
        attributeList.add(jmxAttr);
    }

    @Override
    public void toJMXAttributeInfo(List<MBeanAttributeInfo> attributeInfoList) {
        if (this.isMultiValued()) {
            attributeInfoList.add(new MBeanAttributeInfo(this.getName(), ConfigConstants.JMX_TYPE_STRING_ARRAY, String.valueOf(this.getDescription()), true, false, false));
        } else {
            attributeInfoList.add(new MBeanAttributeInfo(this.getName(), String.class.getName(), String.valueOf(this.getDescription()), true, false, false));
        }
    }

    @Override
    public MBeanParameterInfo toJMXParameterInfo() {
        if (this.isMultiValued()) {
            return new MBeanParameterInfo(this.getName(), ConfigConstants.JMX_TYPE_STRING_ARRAY, String.valueOf(this.getDescription()));
        }
        return new MBeanParameterInfo(this.getName(), String.class.getName(), String.valueOf(this.getDescription()));
    }

    @Override
    public void setValue(javax.management.Attribute jmxAttribute) throws ConfigException {
        Message message = ConfigMessages.ERR_CONFIG_ATTR_READ_ONLY.get(this.getName());
        throw new ConfigException(message);
    }

    @Override
    public ConfigAttribute duplicate() {
        return new ReadOnlyConfigAttribute(this.getName(), this.getDescription(), this.activeValues());
    }
}

