/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import java.util.Collection;
import java.util.Map;
import org.opends.server.api.IndexQueryFactory;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.IndexQuery;
import org.opends.server.types.ByteSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndexQueryFactoryImpl
implements IndexQueryFactory<IndexQuery> {
    private Map<String, Index> indexMap;

    public IndexQueryFactoryImpl(Map<String, Index> indexMap) {
        this.indexMap = indexMap;
    }

    @Override
    public IndexQuery createExactMatchQuery(final String indexID, final ByteSequence value) {
        return new IndexQuery(){

            public EntryIDSet evaluate() {
                DatabaseEntry key = new DatabaseEntry(value.toByteArray());
                Index index = (Index)IndexQueryFactoryImpl.this.indexMap.get(indexID);
                EntryIDSet entrySet = index.readKey(key, null, LockMode.DEFAULT);
                return entrySet;
            }
        };
    }

    @Override
    public IndexQuery createRangeMatchQuery(final String indexID, final ByteSequence lowerBound, final ByteSequence upperBound, final boolean includeLowerBound, final boolean includeUpperBound) {
        return new IndexQuery(){

            public EntryIDSet evaluate() {
                Index index = (Index)IndexQueryFactoryImpl.this.indexMap.get(indexID);
                EntryIDSet entrySet = index.readRange(lowerBound.toByteArray(), upperBound.toByteArray(), includeLowerBound, includeUpperBound);
                return entrySet;
            }
        };
    }

    @Override
    public IndexQuery createIntersectionQuery(Collection<IndexQuery> subqueries) {
        return IndexQuery.createIntersectionIndexQuery(subqueries);
    }

    @Override
    public IndexQuery createUnionQuery(Collection<IndexQuery> subqueries) {
        return IndexQuery.createUnionIndexQuery(subqueries);
    }

    @Override
    public IndexQuery createMatchAllQuery() {
        return new IndexQuery(){

            public EntryIDSet evaluate() {
                return new EntryIDSet();
            }
        };
    }
}

