/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.util.Collection;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=true, mayInvoke=false)
public abstract class IndexQuery {
    public abstract EntryIDSet evaluate();

    public static IndexQuery createIntersectionIndexQuery(Collection<IndexQuery> subIndexQueries) {
        return new IntersectionIndexQuery(subIndexQueries);
    }

    public static IndexQuery createUnionIndexQuery(Collection<IndexQuery> subIndexQueries) {
        return new UnionIndexQuery(subIndexQueries);
    }

    public static IndexQuery createNullIndexQuery() {
        return new NullIndexQuery();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnionIndexQuery
    extends IndexQuery {
        private final Collection<IndexQuery> subIndexQueries;

        private UnionIndexQuery(Collection<IndexQuery> subIndexQueries) {
            this.subIndexQueries = subIndexQueries;
        }

        @Override
        public EntryIDSet evaluate() {
            EntryIDSet entryIDs = null;
            for (IndexQuery query : this.subIndexQueries) {
                if (entryIDs == null) {
                    entryIDs = query.evaluate();
                } else {
                    entryIDs.addAll(query.evaluate());
                }
                if (!entryIDs.isDefined() || entryIDs.size() > 10L) continue;
                break;
            }
            return entryIDs;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IntersectionIndexQuery
    extends IndexQuery {
        private final Collection<IndexQuery> subIndexQueries;

        private IntersectionIndexQuery(Collection<IndexQuery> subIndexQueries) {
            this.subIndexQueries = subIndexQueries;
        }

        @Override
        public EntryIDSet evaluate() {
            EntryIDSet entryIDs = null;
            for (IndexQuery query : this.subIndexQueries) {
                if (entryIDs == null) {
                    entryIDs = query.evaluate();
                } else {
                    entryIDs.retainAll(query.evaluate());
                }
                if (!entryIDs.isDefined() || entryIDs.size() > 10L) continue;
                break;
            }
            return entryIDs;
        }
    }

    private static final class NullIndexQuery
    extends IndexQuery {
        private NullIndexQuery() {
        }

        public EntryIDSet evaluate() {
            return new EntryIDSet();
        }
    }
}

