/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.api;

import java.util.Collection;
import org.opends.server.api.MatchingRule;
import org.opends.server.types.ByteSequence;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.PublicAPI;
import org.opends.server.types.StabilityLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PublicAPI(stability=StabilityLevel.VOLATILE, mayInstantiate=false, mayExtend=true, mayInvoke=false)
public abstract class AbstractMatchingRule
implements MatchingRule {
    @Override
    public abstract String getName();

    @Override
    public abstract Collection<String> getAllNames();

    @Override
    public abstract String getOID();

    @Override
    public ByteString normalizeAssertionValue(ByteSequence value) throws DirectoryException {
        return this.normalizeValue(value);
    }

    @Override
    public final String getNameOrOID() {
        String name = this.getName();
        if (name == null || name.length() == 0) {
            return this.getOID();
        }
        return name;
    }

    @Override
    public abstract String getDescription();

    @Override
    public abstract String getSyntaxOID();

    @Override
    public boolean isObsolete() {
        return false;
    }

    @Override
    public abstract ByteString normalizeValue(ByteSequence var1) throws DirectoryException;

    @Override
    public ConditionResult valuesMatch(ByteSequence attributeValue, ByteSequence assertionValue) {
        return ConditionResult.UNDEFINED;
    }

    public final int hashCode() {
        int hashCode = 0;
        String oidString = this.getOID();
        int oidLength = oidString.length();
        for (int i = 0; i < oidLength; ++i) {
            hashCode += oidString.charAt(i);
        }
        return hashCode;
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatchingRule)) {
            return false;
        }
        return this.getOID().equals(((MatchingRule)o).getOID());
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    @Override
    public final void toString(StringBuilder buffer) {
        buffer.append("( ");
        buffer.append(this.getOID());
        buffer.append(" NAME ");
        Collection<String> names = this.getAllNames();
        if (names.size() > 1) {
            buffer.append("(");
            for (String name : names) {
                buffer.append(" '");
                buffer.append(name);
                buffer.append('\'');
            }
            buffer.append(" )");
        } else {
            buffer.append('\'');
            buffer.append(this.getName());
            buffer.append('\'');
        }
        String description = this.getDescription();
        if (description != null && description.length() > 0) {
            buffer.append(" DESC '");
            buffer.append(description);
            buffer.append('\'');
        }
        if (this.isObsolete()) {
            buffer.append("' OBSOLETE SYNTAX ");
        } else {
            buffer.append(" SYNTAX ");
        }
        buffer.append(this.getSyntaxOID());
        buffer.append(" )");
    }
}

